/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementDefinitionImpl;
import org.apache.xerces.dom.EntityImpl;
import org.apache.xerces.dom.EntityReferenceImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.NotationImpl;
import org.apache.xerces.dom.TextImpl;
import org.apache.xerces.parsers.AbstractXMLDocumentParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.apache.xerces.xni.psvi.AttributePSVI;
import org.apache.xerces.xni.psvi.ElementPSVI;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class AbstractDOMParser
extends AbstractXMLDocumentParser {
    protected static final String CREATE_ENTITY_REF_NODES = "http://apache.org/xml/features/dom/create-entity-ref-nodes";
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String INCLUDE_COMMENTS_FEATURE = "http://apache.org/xml/features/include-comments";
    protected static final String CREATE_CDATA_NODES_FEATURE = "http://apache.org/xml/features/create-cdata-nodes";
    protected static final String INCLUDE_IGNORABLE_WHITESPACE = "http://apache.org/xml/features/dom/include-ignorable-whitespace";
    protected static final String DEFER_NODE_EXPANSION = "http://apache.org/xml/features/dom/defer-node-expansion";
    protected static final String NORMALIZE_DATA = "http://apache.org/xml/features/validation/schema/normalized-value";
    protected static final String DOCUMENT_CLASS_NAME = "http://apache.org/xml/properties/dom/document-class-name";
    protected static final String DEFAULT_DOCUMENT_CLASS_NAME = "org.apache.xerces.dom.DocumentImpl";
    protected static final String CURRENT_ELEMENT_NODE = "http://apache.org/xml/features/dom/current-element-node";
    private static final boolean DEBUG_ENTITY_REF = false;
    private static final boolean DEBUG_EVENTS = false;
    protected boolean fCreateEntityRefNodes;
    protected boolean fIncludeIgnorableWhitespace;
    protected boolean fIncludeComments;
    protected boolean fCreateCDATANodes;
    protected boolean fNormalizeData = true;
    protected Document fDocument;
    protected DocumentImpl fDocumentImpl;
    protected String fDocumentClassName;
    protected DocumentType fDocumentType;
    protected Node fCurrentNode;
    protected CDATASection fCurrentCDATASection;
    protected StringBuffer fInternalSubset;
    protected boolean fDeferNodeExpansion;
    protected boolean fNamespaceAware;
    protected DeferredDocumentImpl fDeferredDocumentImpl;
    protected int fDocumentIndex;
    protected int fDocumentTypeIndex;
    protected int fCurrentNodeIndex;
    protected int fCurrentCDATASectionIndex;
    protected boolean fInDTDExternalSubset;
    protected boolean fInDocument;
    protected boolean fInCDATASection;
    private QName fAttrQName = new QName();
    static /* synthetic */ Class class$org$w3c$dom$Document;

    protected AbstractDOMParser(XMLParserConfiguration config) {
        super(config);
        String[] recognizedFeatures = new String[]{CREATE_ENTITY_REF_NODES, INCLUDE_IGNORABLE_WHITESPACE, DEFER_NODE_EXPANSION, INCLUDE_COMMENTS_FEATURE, CREATE_CDATA_NODES_FEATURE};
        this.fConfiguration.addRecognizedFeatures(recognizedFeatures);
        this.fConfiguration.setFeature(CREATE_ENTITY_REF_NODES, true);
        this.fConfiguration.setFeature(INCLUDE_IGNORABLE_WHITESPACE, true);
        this.fConfiguration.setFeature(DEFER_NODE_EXPANSION, true);
        this.fConfiguration.setFeature(INCLUDE_COMMENTS_FEATURE, true);
        this.fConfiguration.setFeature(CREATE_CDATA_NODES_FEATURE, true);
        String[] recognizedProperties = new String[]{DOCUMENT_CLASS_NAME};
        this.fConfiguration.addRecognizedProperties(recognizedProperties);
        this.fConfiguration.setProperty(DOCUMENT_CLASS_NAME, DEFAULT_DOCUMENT_CLASS_NAME);
    }

    protected String getDocumentClassName() {
        return this.fDocumentClassName;
    }

    protected void setDocumentClassName(String documentClassName) {
        if (documentClassName == null) {
            documentClassName = DEFAULT_DOCUMENT_CLASS_NAME;
        }
        try {
            Class<?> _class = Class.forName(documentClassName);
            if (!(class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = AbstractDOMParser.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document).isAssignableFrom(_class)) {
                throw new IllegalArgumentException("PAR002 Class, \"" + documentClassName + "\", is not of type org.w3c.dom.Document.\n" + documentClassName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("PAR003 Class, \"" + documentClassName + "\", not found.\n" + documentClassName);
        }
        this.fDocumentClassName = documentClassName;
        if (!documentClassName.equals(DEFAULT_DOCUMENT_CLASS_NAME)) {
            this.fDeferNodeExpansion = false;
        }
    }

    public Document getDocument() {
        return this.fDocument;
    }

    public void reset() throws XNIException {
        super.reset();
        this.fCreateEntityRefNodes = this.fConfiguration.getFeature(CREATE_ENTITY_REF_NODES);
        this.fIncludeIgnorableWhitespace = this.fConfiguration.getFeature(INCLUDE_IGNORABLE_WHITESPACE);
        this.fDeferNodeExpansion = this.fConfiguration.getFeature(DEFER_NODE_EXPANSION);
        this.fNamespaceAware = this.fConfiguration.getFeature(NAMESPACES);
        this.fIncludeComments = this.fConfiguration.getFeature(INCLUDE_COMMENTS_FEATURE);
        this.fCreateCDATANodes = this.fConfiguration.getFeature(CREATE_CDATA_NODES_FEATURE);
        this.fNormalizeData = this.fConfiguration.getFeature(NORMALIZE_DATA);
        this.setDocumentClassName((String)this.fConfiguration.getProperty(DOCUMENT_CLASS_NAME));
        this.fDocument = null;
        this.fDocumentImpl = null;
        this.fDocumentType = null;
        this.fDocumentTypeIndex = -1;
        this.fDeferredDocumentImpl = null;
        this.fCurrentNode = null;
        this.fInDocument = false;
        this.fInDTD = false;
        this.fInDTDExternalSubset = false;
        this.fInCDATASection = false;
        this.fCurrentCDATASection = null;
        this.fCurrentCDATASectionIndex = -1;
    }

    public void startGeneralEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
        if (this.fCreateEntityRefNodes) {
            if (!this.fDeferNodeExpansion) {
                EntityReference er = this.fDocument.createEntityReference(name);
                ((EntityReferenceImpl)er).needsSyncChildren(false);
                this.fCurrentNode.appendChild(er);
                this.fCurrentNode = er;
            } else {
                int er = this.fDeferredDocumentImpl.createDeferredEntityReference(name);
                this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, er);
                this.fCurrentNodeIndex = er;
            }
        }
    }

    public void textDecl(String version2, String encoding, Augmentations augs) throws XNIException {
        if (!this.fDeferNodeExpansion) {
            String name;
            NamedNodeMap entities;
            EntityImpl entity;
            if (this.fDocumentType != null && (entity = (EntityImpl)(entities = this.fDocumentType.getEntities()).getNamedItem(name = this.fCurrentNode.getNodeName())) != null) {
                entity.setVersion(version2);
                entity.setEncoding(encoding);
            }
        } else {
            String name = this.fDeferredDocumentImpl.getNodeName(this.fCurrentNodeIndex, false);
            if (this.fDocumentTypeIndex != -1 && name != null) {
                boolean found = false;
                int node = this.fDeferredDocumentImpl.getLastChild(this.fDocumentTypeIndex, false);
                while (node != -1) {
                    String nodeName;
                    short nodeType = this.fDeferredDocumentImpl.getNodeType(node, false);
                    if (nodeType == 6 && (nodeName = this.fDeferredDocumentImpl.getNodeName(node, false)).equals(name)) {
                        found = true;
                        break;
                    }
                    node = this.fDeferredDocumentImpl.getRealPrevSibling(node, false);
                }
                if (found) {
                    this.fDeferredDocumentImpl.setEntityInfo(node, version2, encoding);
                }
            }
        }
    }

    public void comment(XMLString text, Augmentations augs) throws XNIException {
        if (!this.fIncludeComments) {
            return;
        }
        if (!this.fDeferNodeExpansion) {
            Comment comment = this.fDocument.createComment(text.toString());
            this.fCurrentNode.appendChild(comment);
        } else {
            int comment = this.fDeferredDocumentImpl.createDeferredComment(text.toString());
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, comment);
        }
    }

    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
        if (!this.fDeferNodeExpansion) {
            ProcessingInstruction pi = this.fDocument.createProcessingInstruction(target, data.toString());
            this.fCurrentNode.appendChild(pi);
        } else {
            int pi = this.fDeferredDocumentImpl.createDeferredProcessingInstruction(target, data.toString());
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, pi);
        }
    }

    public void startDocument(XMLLocator locator, String encoding, Augmentations augs) throws XNIException {
        this.fInDocument = true;
        if (!this.fDeferNodeExpansion) {
            if (this.fDocumentClassName.equals(DEFAULT_DOCUMENT_CLASS_NAME)) {
                this.fDocument = new DocumentImpl();
                this.fDocumentImpl = (DocumentImpl)this.fDocument;
                this.fDocumentImpl.setStrictErrorChecking(false);
                this.fDocumentImpl.setActualEncoding(encoding);
            } else {
                try {
                    Class<?> documentClass = Class.forName(this.fDocumentClassName);
                    this.fDocument = (Document)documentClass.newInstance();
                    Class<?> defaultDocClass = Class.forName(DEFAULT_DOCUMENT_CLASS_NAME);
                    if (defaultDocClass.isAssignableFrom(documentClass)) {
                        this.fDocumentImpl = (DocumentImpl)this.fDocument;
                        this.fDocumentImpl.setStrictErrorChecking(false);
                    }
                }
                catch (ClassNotFoundException e) {
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create document object of class: " + this.fDocumentClassName);
                }
            }
            this.fCurrentNode = this.fDocument;
        } else {
            this.fDeferredDocumentImpl = new DeferredDocumentImpl(this.fNamespaceAware);
            this.fDocument = this.fDeferredDocumentImpl;
            this.fCurrentNodeIndex = this.fDocumentIndex = this.fDeferredDocumentImpl.createDeferredDocument();
        }
    }

    public void xmlDecl(String version2, String encoding, String standalone, Augmentations augs) throws XNIException {
        if (!this.fDeferNodeExpansion) {
            if (this.fDocumentImpl != null) {
                this.fDocumentImpl.setVersion(version2);
                this.fDocumentImpl.setEncoding(encoding);
                this.fDocumentImpl.setStandalone("true".equals(standalone));
            }
        } else {
            this.fDeferredDocumentImpl.setVersion(version2);
            this.fDeferredDocumentImpl.setEncoding(encoding);
            this.fDeferredDocumentImpl.setStandalone("true".equals(standalone));
        }
    }

    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
        if (!this.fDeferNodeExpansion) {
            if (this.fDocumentImpl != null) {
                this.fDocumentType = this.fDocumentImpl.createDocumentType(rootElement, publicId, systemId);
                this.fCurrentNode.appendChild(this.fDocumentType);
            }
        } else {
            this.fDocumentTypeIndex = this.fDeferredDocumentImpl.createDeferredDocumentType(rootElement, publicId, systemId);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, this.fDocumentTypeIndex);
        }
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        if (!this.fDeferNodeExpansion) {
            Element el = this.fNamespaceAware ? (this.fDocumentImpl != null ? this.fDocumentImpl.createElementNS(element.uri, element.rawname, element.localpart) : this.fDocument.createElementNS(element.uri, element.rawname)) : this.fDocument.createElement(element.rawname);
            int attrCount = attributes.getLength();
            int i = 0;
            while (i < attrCount) {
                AttributePSVI attrPSVI;
                attributes.getName(i, this.fAttrQName);
                String attributeName = this.fAttrQName.rawname;
                if (attributeName != null && (attributeName.startsWith("xmlns:") || attributeName.equals("xmlns"))) {
                    this.fAttrQName.uri = "http://www.w3.org/2000/xmlns/";
                }
                Attr attr = this.fNamespaceAware ? (this.fDocumentImpl != null ? this.fDocumentImpl.createAttributeNS(this.fAttrQName.uri, this.fAttrQName.rawname, this.fAttrQName.localpart) : this.fDocument.createAttributeNS(this.fAttrQName.uri, this.fAttrQName.rawname)) : this.fDocument.createAttribute(this.fAttrQName.rawname);
                String attrValue = attributes.getValue(i);
                if (this.fNormalizeData && (attrPSVI = (AttributePSVI)attributes.getAugmentations(i).getItem("ATTRIBUTE_PSVI")) != null) {
                    attrValue = attrPSVI.getSchemaNormalizedValue();
                }
                attr.setValue(attrValue);
                el.setAttributeNode(attr);
                if (this.fDocumentImpl != null) {
                    AttrImpl attrImpl = (AttrImpl)attr;
                    boolean specified = attributes.isSpecified(i);
                    attrImpl.setSpecified(specified);
                    if (attributes.getType(i).equals("ID")) {
                        this.fDocumentImpl.putIdentifier(attrValue, el);
                    }
                }
                ++i;
            }
            this.fCurrentNode.appendChild(el);
            this.fCurrentNode = el;
        } else {
            int el = this.fDeferredDocumentImpl.createDeferredElement(this.fNamespaceAware ? element.uri : null, element.rawname);
            int attrCount = attributes.getLength();
            int i = 0;
            while (i < attrCount) {
                AttributePSVI attrPSVI;
                String attrValue = attributes.getValue(i);
                if (this.fNormalizeData && (attrPSVI = (AttributePSVI)attributes.getAugmentations(i).getItem("ATTRIBUTE_PSVI")) != null) {
                    attrValue = attrPSVI.getSchemaNormalizedValue();
                }
                this.fDeferredDocumentImpl.setDeferredAttribute(el, attributes.getQName(i), attributes.getURI(i), attrValue, attributes.isSpecified(i));
                if (attributes.getType(i).equals("ID")) {
                    this.fDeferredDocumentImpl.putIdentifier(attrValue, el);
                }
                ++i;
            }
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, el);
            this.fCurrentNodeIndex = el;
        }
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (!this.fDeferNodeExpansion) {
            if (this.fInCDATASection && this.fCreateCDATANodes) {
                if (this.fCurrentCDATASection == null) {
                    this.fCurrentCDATASection = this.fDocument.createCDATASection(text.toString());
                    this.fCurrentNode.appendChild(this.fCurrentCDATASection);
                    this.fCurrentNode = this.fCurrentCDATASection;
                } else {
                    this.fCurrentCDATASection.appendData(text.toString());
                }
            } else if (!this.fInDTD) {
                Node child;
                ElementPSVI elemPSVI;
                if (text.length == 0) {
                    return;
                }
                String value = null;
                if (this.fNormalizeData && augs != null && (elemPSVI = (ElementPSVI)augs.getItem("ELEMENT_PSVI")) != null) {
                    value = elemPSVI.getSchemaNormalizedValue();
                }
                if (value == null) {
                    value = text.toString();
                }
                if ((child = this.fCurrentNode.getLastChild()) != null && child.getNodeType() == 3) {
                    Text textNode = (Text)child;
                    textNode.appendData(value);
                } else {
                    Text textNode = this.fDocument.createTextNode(value);
                    this.fCurrentNode.appendChild(textNode);
                }
            }
        } else if (this.fInCDATASection && this.fCreateCDATANodes) {
            if (this.fCurrentCDATASectionIndex == -1) {
                int cs = this.fDeferredDocumentImpl.createDeferredCDATASection(text.toString());
                this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, cs);
                this.fCurrentCDATASectionIndex = cs;
                this.fCurrentNodeIndex = cs;
            } else {
                int txt = this.fDeferredDocumentImpl.createDeferredTextNode(text.toString(), false);
                this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, txt);
            }
        } else if (!this.fInDTD) {
            ElementPSVI elemPSVI;
            if (text.length == 0) {
                return;
            }
            String value = null;
            if (this.fNormalizeData && augs != null && (elemPSVI = (ElementPSVI)augs.getItem("ELEMENT_PSVI")) != null) {
                value = elemPSVI.getSchemaNormalizedValue();
            }
            if (value == null) {
                value = text.toString();
            }
            int txt = this.fDeferredDocumentImpl.createDeferredTextNode(value, false);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, txt);
        }
    }

    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        if (!this.fIncludeIgnorableWhitespace) {
            return;
        }
        if (!this.fDeferNodeExpansion) {
            Node child = this.fCurrentNode.getLastChild();
            if (child != null && child.getNodeType() == 3) {
                Text textNode = (Text)child;
                textNode.appendData(text.toString());
            } else {
                Text textNode = this.fDocument.createTextNode(text.toString());
                if (this.fDocumentImpl != null) {
                    TextImpl textNodeImpl = (TextImpl)textNode;
                    textNodeImpl.setIgnorableWhitespace(true);
                }
                this.fCurrentNode.appendChild(textNode);
            }
        } else {
            int txt = this.fDeferredDocumentImpl.createDeferredTextNode(text.toString(), true);
            this.fDeferredDocumentImpl.appendChild(this.fCurrentNodeIndex, txt);
        }
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        if (!this.fDeferNodeExpansion) {
            this.fCurrentNode = this.fCurrentNode.getParentNode();
        } else {
            this.fCurrentNodeIndex = this.fDeferredDocumentImpl.getParentNode(this.fCurrentNodeIndex, false);
        }
    }

    public void endPrefixMapping(String prefix, Augmentations augs) throws XNIException {
    }

    public void startCDATA(Augmentations augs) throws XNIException {
        this.fInCDATASection = true;
    }

    public void endCDATA(Augmentations augs) throws XNIException {
        this.fInCDATASection = false;
        if (!this.fDeferNodeExpansion) {
            if (this.fCurrentCDATASection != null) {
                this.fCurrentNode = this.fCurrentNode.getParentNode();
                this.fCurrentCDATASection = null;
            }
        } else if (this.fCurrentCDATASectionIndex != -1) {
            this.fCurrentNodeIndex = this.fDeferredDocumentImpl.getParentNode(this.fCurrentNodeIndex, false);
            this.fCurrentCDATASectionIndex = -1;
        }
    }

    public void endDocument(Augmentations augs) throws XNIException {
        this.fInDocument = false;
        if (!this.fDeferNodeExpansion) {
            if (this.fDocumentImpl != null) {
                this.fDocumentImpl.setStrictErrorChecking(true);
            }
            this.fCurrentNode = null;
        } else {
            this.fCurrentNodeIndex = -1;
        }
    }

    public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
        if (this.fCreateEntityRefNodes) {
            if (!this.fDeferNodeExpansion) {
                NamedNodeMap entities;
                NodeImpl entity;
                if (this.fDocumentType != null && (entity = (NodeImpl)(entities = this.fDocumentType.getEntities()).getNamedItem(name)) != null && entity.getFirstChild() == null) {
                    entity.setReadOnly(false, true);
                    Node child = this.fCurrentNode.getFirstChild();
                    while (child != null) {
                        Node copy = child.cloneNode(true);
                        entity.appendChild(copy);
                        child = child.getNextSibling();
                    }
                    entity.setReadOnly(true, true);
                    entities.setNamedItem(entity);
                }
                ((NodeImpl)this.fCurrentNode).setReadOnly(true, true);
                this.fCurrentNode = this.fCurrentNode.getParentNode();
            } else {
                int entityIndex = -1;
                int dtChildIndex = this.fDeferredDocumentImpl.getLastChild(this.fDocumentTypeIndex, false);
                while (dtChildIndex != -1) {
                    String nodeName;
                    short nodeType = this.fDeferredDocumentImpl.getNodeType(dtChildIndex, false);
                    if (nodeType == 6 && (nodeName = this.fDeferredDocumentImpl.getNodeName(dtChildIndex, false)).equals(name)) {
                        if (this.fDeferredDocumentImpl.getLastChild(dtChildIndex, false) != -1) break;
                        entityIndex = dtChildIndex;
                        break;
                    }
                    dtChildIndex = this.fDeferredDocumentImpl.getRealPrevSibling(dtChildIndex, false);
                }
                if (entityIndex != -1) {
                    int prevIndex = -1;
                    int childIndex = this.fDeferredDocumentImpl.getLastChild(this.fCurrentNodeIndex, false);
                    while (childIndex != -1) {
                        int cloneIndex = this.fDeferredDocumentImpl.cloneNode(childIndex, true);
                        this.fDeferredDocumentImpl.insertBefore(entityIndex, cloneIndex, prevIndex);
                        prevIndex = cloneIndex;
                        childIndex = this.fDeferredDocumentImpl.getRealPrevSibling(childIndex, false);
                    }
                }
                this.fCurrentNodeIndex = this.fDeferredDocumentImpl.getParentNode(this.fCurrentNodeIndex, false);
            }
        }
    }

    public void startDTD(XMLLocator locator, Augmentations augs) throws XNIException {
        super.startDTD(locator, augs);
        if (this.fDeferNodeExpansion || this.fDocumentImpl != null) {
            this.fInternalSubset = new StringBuffer(1024);
        }
    }

    public void endDTD(Augmentations augs) throws XNIException {
        String internalSubset;
        super.endDTD(augs);
        String string = internalSubset = this.fInternalSubset != null && this.fInternalSubset.length() > 0 ? this.fInternalSubset.toString() : null;
        if (this.fDeferNodeExpansion) {
            if (internalSubset != null) {
                this.fDeferredDocumentImpl.setInternalSubset(this.fDocumentTypeIndex, internalSubset);
            }
        } else if (this.fDocumentImpl != null && internalSubset != null) {
            ((DocumentTypeImpl)this.fDocumentType).setInternalSubset(internalSubset);
        }
    }

    public void startExternalSubset(Augmentations augs) throws XNIException {
        this.fInDTDExternalSubset = true;
    }

    public void endExternalSubset(Augmentations augs) throws XNIException {
        this.fInDTDExternalSubset = false;
    }

    public void internalEntityDecl(String name, XMLString text, XMLString nonNormalizedText, Augmentations augs) throws XNIException {
        NamedNodeMap entities;
        EntityImpl entity;
        if (this.fInternalSubset != null && !this.fInDTDExternalSubset) {
            this.fInternalSubset.append("<!ENTITY ");
            if (name.startsWith("%")) {
                this.fInternalSubset.append("% ");
                this.fInternalSubset.append(name.substring(1));
            } else {
                this.fInternalSubset.append(name);
            }
            this.fInternalSubset.append(' ');
            String value = nonNormalizedText.toString();
            boolean singleQuote = value.indexOf(39) == -1;
            this.fInternalSubset.append(singleQuote ? (char)'\'' : '\"');
            this.fInternalSubset.append(value);
            this.fInternalSubset.append(singleQuote ? (char)'\'' : '\"');
            this.fInternalSubset.append(">\n");
        }
        if (name.startsWith("%")) {
            return;
        }
        if (this.fDocumentType != null && (entity = (EntityImpl)(entities = this.fDocumentType.getEntities()).getNamedItem(name)) == null) {
            entity = (EntityImpl)this.fDocumentImpl.createEntity(name);
            entities.setNamedItem(entity);
        }
        if (this.fDocumentTypeIndex != -1) {
            boolean found = false;
            int node = this.fDeferredDocumentImpl.getLastChild(this.fDocumentTypeIndex, false);
            while (node != -1) {
                String nodeName;
                short nodeType = this.fDeferredDocumentImpl.getNodeType(node, false);
                if (nodeType == 6 && (nodeName = this.fDeferredDocumentImpl.getNodeName(node, false)).equals(name)) {
                    found = true;
                    break;
                }
                node = this.fDeferredDocumentImpl.getRealPrevSibling(node, false);
            }
            if (!found) {
                int entityIndex = this.fDeferredDocumentImpl.createDeferredEntity(name, null, null, null);
                this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, entityIndex);
            }
        }
    }

    public void externalEntityDecl(String name, XMLResourceIdentifier identifier, Augmentations augs) throws XNIException {
        NamedNodeMap entities;
        EntityImpl entity;
        String publicId = identifier.getPublicId();
        String literalSystemId = identifier.getLiteralSystemId();
        if (this.fInternalSubset != null && !this.fInDTDExternalSubset) {
            this.fInternalSubset.append("<!ENTITY ");
            if (name.startsWith("%")) {
                this.fInternalSubset.append("% ");
                this.fInternalSubset.append(name.substring(1));
            } else {
                this.fInternalSubset.append(name);
            }
            this.fInternalSubset.append(' ');
            if (publicId != null) {
                this.fInternalSubset.append("PUBLIC '");
                this.fInternalSubset.append(publicId);
                this.fInternalSubset.append("' '");
            } else {
                this.fInternalSubset.append("SYSTEM '");
            }
            this.fInternalSubset.append(literalSystemId);
            this.fInternalSubset.append("'>\n");
        }
        if (name.startsWith("%")) {
            return;
        }
        if (this.fDocumentType != null && (entity = (EntityImpl)(entities = this.fDocumentType.getEntities()).getNamedItem(name)) == null) {
            entity = (EntityImpl)this.fDocumentImpl.createEntity(name);
            entity.setPublicId(publicId);
            entity.setSystemId(literalSystemId);
            entities.setNamedItem(entity);
        }
        if (this.fDocumentTypeIndex != -1) {
            boolean found = false;
            int nodeIndex = this.fDeferredDocumentImpl.getLastChild(this.fDocumentTypeIndex, false);
            while (nodeIndex != -1) {
                String nodeName;
                short nodeType = this.fDeferredDocumentImpl.getNodeType(nodeIndex, false);
                if (nodeType == 6 && (nodeName = this.fDeferredDocumentImpl.getNodeName(nodeIndex, false)).equals(name)) {
                    found = true;
                    break;
                }
                nodeIndex = this.fDeferredDocumentImpl.getRealPrevSibling(nodeIndex, false);
            }
            if (!found) {
                int entityIndex = this.fDeferredDocumentImpl.createDeferredEntity(name, publicId, literalSystemId, null);
                this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, entityIndex);
            }
        }
    }

    public void unparsedEntityDecl(String name, XMLResourceIdentifier identifier, String notation, Augmentations augs) throws XNIException {
        NamedNodeMap entities;
        EntityImpl entity;
        String publicId = identifier.getPublicId();
        String literalSystemId = identifier.getLiteralSystemId();
        if (this.fInternalSubset != null && !this.fInDTDExternalSubset) {
            this.fInternalSubset.append("<!ENTITY ");
            this.fInternalSubset.append(name);
            this.fInternalSubset.append(' ');
            if (publicId != null) {
                this.fInternalSubset.append("PUBLIC '");
                this.fInternalSubset.append(publicId);
                if (literalSystemId != null) {
                    this.fInternalSubset.append("' '");
                    this.fInternalSubset.append(literalSystemId);
                }
            } else {
                this.fInternalSubset.append("SYSTEM '");
                this.fInternalSubset.append(literalSystemId);
            }
            this.fInternalSubset.append("' NDATA ");
            this.fInternalSubset.append(notation);
            this.fInternalSubset.append(">\n");
        }
        if (this.fDocumentType != null && (entity = (EntityImpl)(entities = this.fDocumentType.getEntities()).getNamedItem(name)) == null) {
            entity = (EntityImpl)this.fDocumentImpl.createEntity(name);
            entity.setPublicId(publicId);
            entity.setSystemId(literalSystemId);
            entity.setNotationName(notation);
            entities.setNamedItem(entity);
        }
        if (this.fDocumentTypeIndex != -1) {
            boolean found = false;
            int nodeIndex = this.fDeferredDocumentImpl.getLastChild(this.fDocumentTypeIndex, false);
            while (nodeIndex != -1) {
                String nodeName;
                short nodeType = this.fDeferredDocumentImpl.getNodeType(nodeIndex, false);
                if (nodeType == 6 && (nodeName = this.fDeferredDocumentImpl.getNodeName(nodeIndex, false)).equals(name)) {
                    found = true;
                    break;
                }
                nodeIndex = this.fDeferredDocumentImpl.getRealPrevSibling(nodeIndex, false);
            }
            if (!found) {
                int entityIndex = this.fDeferredDocumentImpl.createDeferredEntity(name, publicId, literalSystemId, notation);
                this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, entityIndex);
            }
        }
    }

    public void notationDecl(String name, XMLResourceIdentifier identifier, Augmentations augs) throws XNIException {
        NamedNodeMap notations;
        String publicId = identifier.getPublicId();
        String literalSystemId = identifier.getLiteralSystemId();
        if (this.fInternalSubset != null && !this.fInDTDExternalSubset) {
            this.fInternalSubset.append("<!NOTATION ");
            if (publicId != null) {
                this.fInternalSubset.append("PUBLIC '");
                this.fInternalSubset.append(publicId);
                if (literalSystemId != null) {
                    this.fInternalSubset.append("' '");
                    this.fInternalSubset.append(literalSystemId);
                }
            } else {
                this.fInternalSubset.append("SYSTEM '");
                this.fInternalSubset.append(literalSystemId);
            }
            this.fInternalSubset.append("'>\n");
        }
        if (this.fDocumentType != null && (notations = this.fDocumentType.getNotations()).getNamedItem(name) == null) {
            NotationImpl notation = (NotationImpl)this.fDocumentImpl.createNotation(name);
            notation.setPublicId(publicId);
            notation.setSystemId(literalSystemId);
            notations.setNamedItem(notation);
        }
        if (this.fDocumentTypeIndex != -1) {
            boolean found = false;
            int nodeIndex = this.fDeferredDocumentImpl.getLastChild(this.fDocumentTypeIndex, false);
            while (nodeIndex != -1) {
                String nodeName;
                short nodeType = this.fDeferredDocumentImpl.getNodeType(nodeIndex, false);
                if (nodeType == 12 && (nodeName = this.fDeferredDocumentImpl.getNodeName(nodeIndex, false)).equals(name)) {
                    found = true;
                    break;
                }
                nodeIndex = this.fDeferredDocumentImpl.getPrevSibling(nodeIndex, false);
            }
            if (!found) {
                int notationIndex = this.fDeferredDocumentImpl.createDeferredNotation(name, publicId, literalSystemId);
                this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, notationIndex);
            }
        }
    }

    public void elementDecl(String name, String contentModel, Augmentations augs) throws XNIException {
        if (this.fInternalSubset != null && !this.fInDTDExternalSubset) {
            this.fInternalSubset.append("<!ELEMENT ");
            this.fInternalSubset.append(name);
            this.fInternalSubset.append(' ');
            this.fInternalSubset.append(contentModel);
            this.fInternalSubset.append(">\n");
        }
    }

    public void attributeDecl(String elementName, String attributeName, String type, String[] enumeration, String defaultType, XMLString defaultValue, XMLString nonNormalizedDefaultValue, Augmentations augs) throws XNIException {
        if (this.fInternalSubset != null && !this.fInDTDExternalSubset) {
            int i;
            this.fInternalSubset.append("<!ATTLIST ");
            this.fInternalSubset.append(elementName);
            this.fInternalSubset.append(' ');
            this.fInternalSubset.append(attributeName);
            this.fInternalSubset.append(' ');
            if (type.equals("ENUMERATION")) {
                this.fInternalSubset.append('(');
                i = 0;
                while (i < enumeration.length) {
                    if (i > 0) {
                        this.fInternalSubset.append('|');
                    }
                    this.fInternalSubset.append(enumeration[i]);
                    ++i;
                }
                this.fInternalSubset.append(')');
            } else {
                this.fInternalSubset.append(type);
            }
            if (defaultType != null) {
                this.fInternalSubset.append(' ');
                this.fInternalSubset.append(defaultType);
            }
            if (defaultValue != null) {
                this.fInternalSubset.append(" '");
                i = 0;
                while (i < defaultValue.length) {
                    char c = defaultValue.ch[defaultValue.offset + i];
                    if (c == '\'') {
                        this.fInternalSubset.append("&apos;");
                    } else {
                        this.fInternalSubset.append(c);
                    }
                    ++i;
                }
                this.fInternalSubset.append('\'');
            }
            this.fInternalSubset.append(">\n");
        }
        if (this.fDeferredDocumentImpl != null) {
            if (defaultValue != null) {
                int elementDefIndex = this.fDeferredDocumentImpl.lookupElementDefinition(elementName);
                if (elementDefIndex == -1) {
                    elementDefIndex = this.fDeferredDocumentImpl.createDeferredElementDefinition(elementName);
                    this.fDeferredDocumentImpl.appendChild(this.fDocumentTypeIndex, elementDefIndex);
                }
                int attrIndex = this.fDeferredDocumentImpl.createDeferredAttribute(attributeName, defaultValue.toString(), false);
                this.fDeferredDocumentImpl.appendChild(elementDefIndex, attrIndex);
            }
        } else if (this.fDocumentImpl != null && defaultValue != null) {
            AttrImpl attr;
            boolean nsEnabled;
            NamedNodeMap elements = ((DocumentTypeImpl)this.fDocumentType).getElements();
            ElementDefinitionImpl elementDef = (ElementDefinitionImpl)elements.getNamedItem(elementName);
            if (elementDef == null) {
                elementDef = this.fDocumentImpl.createElementDefinition(elementName);
                ((DocumentTypeImpl)this.fDocumentType).getElements().setNamedItem(elementDef);
            }
            if (nsEnabled = this.fNamespaceAware) {
                String namespaceURI = null;
                if (attributeName.startsWith("xmlns:") || attributeName.equals("xmlns")) {
                    namespaceURI = "http://www.w3.org/2000/xmlns/";
                }
                attr = (AttrImpl)this.fDocumentImpl.createAttributeNS(namespaceURI, attributeName);
            } else {
                attr = (AttrImpl)this.fDocumentImpl.createAttribute(attributeName);
            }
            attr.setValue(defaultValue.toString());
            attr.setSpecified(false);
            if (nsEnabled) {
                elementDef.getAttributes().setNamedItemNS(attr);
            } else {
                elementDef.getAttributes().setNamedItem(attr);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

