/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.trax;

import java.io.IOException;
import org.apache.xalan.xsltc.runtime.AttributeList;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

class DOM2SAX
implements XMLReader,
Locator {
    private Document _dom = null;
    private ContentHandler _sax = null;

    public DOM2SAX(Node root) {
        this._dom = (Document)root;
    }

    public ContentHandler getContentHandler() {
        return this._sax;
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public void parse(InputSource unused) throws IOException, SAXException {
        Document currNode = this._dom;
        this.parse(currNode);
    }

    private void parse(Node node) throws IOException, SAXException {
        Object first = null;
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 9: {
                this._sax.setDocumentLocator(this);
                this._sax.startDocument();
                Node next = node.getFirstChild();
                while (next != null) {
                    this.parse(next);
                    next = next.getNextSibling();
                }
                this._sax.endDocument();
                break;
            }
            case 1: {
                AttributeList attrs = new AttributeList();
                NamedNodeMap map = node.getAttributes();
                int length = map.getLength();
                int i = 0;
                while (i < length) {
                    Node attr = map.item(i);
                    attrs.add(attr.getNodeName(), attr.getNodeValue());
                    ++i;
                }
                this._sax.startElement(node.getNamespaceURI(), node.getLocalName(), node.getNodeName(), attrs);
                Node next = node.getFirstChild();
                while (next != null) {
                    this.parse(next);
                    next = next.getNextSibling();
                }
                this._sax.endElement(node.getNamespaceURI(), node.getLocalName(), node.getNodeName());
                break;
            }
            case 7: {
                this._sax.processingInstruction(node.getNodeName(), node.getNodeValue());
                break;
            }
            case 3: {
                String data = node.getNodeValue();
                this._sax.characters(data.toCharArray(), 0, data.length());
            }
        }
    }

    public void parse(String sysId) throws IOException, SAXException {
        throw new IOException("This method is not yet implemented.");
    }

    public void setContentHandler(ContentHandler handler) throws NullPointerException {
        if (handler == null) {
            throw new NullPointerException();
        }
        this._sax = handler;
    }

    public void setDTDHandler(DTDHandler handler) throws NullPointerException {
        if (handler == null) {
            throw new NullPointerException();
        }
    }

    public void setEntityResolver(EntityResolver resolver) throws NullPointerException {
        if (resolver == null) {
            throw new NullPointerException();
        }
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setErrorHandler(ErrorHandler handler) throws NullPointerException {
        if (handler == null) {
            throw new NullPointerException();
        }
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public int getColumnNumber() {
        return 0;
    }

    public int getLineNumber() {
        return 0;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return null;
    }

    private String getNodeTypeFromCode(short code) {
        String retval = null;
        switch (code) {
            case 2: {
                retval = "ATTRIBUTE_NODE";
                break;
            }
            case 4: {
                retval = "CDATA_SECTION_NODE";
                break;
            }
            case 8: {
                retval = "COMMENT_NODE";
                break;
            }
            case 11: {
                retval = "DOCUMENT_FRAGMENT_NODE";
                break;
            }
            case 9: {
                retval = "DOCUMENT_NODE";
                break;
            }
            case 10: {
                retval = "DOCUMENT_TYPE_NODE";
                break;
            }
            case 1: {
                retval = "ELEMENT_NODE";
                break;
            }
            case 6: {
                retval = "ENTITY_NODE";
                break;
            }
            case 5: {
                retval = "ENTITY_REFERENCE_NODE";
                break;
            }
            case 12: {
                retval = "NOTATION_NODE";
                break;
            }
            case 7: {
                retval = "PROCESSING_INSTRUCTION_NODE";
                break;
            }
            case 3: {
                retval = "TEXT_NODE";
            }
        }
        return retval;
    }
}

