/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.runtime;

import java.io.IOException;
import java.util.Stack;
import org.apache.xalan.xsltc.TransletException;
import org.apache.xalan.xsltc.TransletOutputHandler;
import org.apache.xalan.xsltc.runtime.AttributeList;
import org.apache.xalan.xsltc.runtime.BasisLibrary;
import org.apache.xalan.xsltc.runtime.DefaultSAXOutputHandler;
import org.apache.xalan.xsltc.runtime.Hashtable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public final class TextOutput
implements TransletOutputHandler {
    public static final int UNKNOWN = 0;
    public static final int XML = 1;
    public static final int HTML = 2;
    public static final int TEXT = 3;
    public static final int QNAME = 4;
    private int _outputType = 0;
    private String _encoding;
    private String _mediaType = "text/html";
    private String _doctypeSystem = null;
    private String _doctypePublic = null;
    private boolean _escapeChars = false;
    private boolean _startTagOpen = false;
    private boolean _headTagOpen = false;
    private boolean _cdataTagOpen = false;
    private Hashtable _cdata = null;
    private static final String XML_PREFIX = "xml";
    private static final char[] AMP = "&amp;".toCharArray();
    private static final char[] LT = "&lt;".toCharArray();
    private static final char[] GT = "&gt;".toCharArray();
    private static final char[] CRLF = "&#xA;".toCharArray();
    private static final char[] QUOTE = "&quot;".toCharArray();
    private static final char[] NBSP = "&nbsp;".toCharArray();
    private static final char[] BEGCDATA = "<![CDATA[".toCharArray();
    private static final char[] ENDCDATA = "]]>".toCharArray();
    private static final char[] CNTCDATA = "]]]]><![CDATA[>".toCharArray();
    private static final char[] BEGCOMM = "<!--".toCharArray();
    private static final char[] ENDCOMM = "-->".toCharArray();
    private static final int AMP_length = AMP.length;
    private static final int LT_length = LT.length;
    private static final int GT_length = GT.length;
    private static final int CRLF_length = CRLF.length;
    private static final int QUOTE_length = QUOTE.length;
    private static final int NBSP_length = NBSP.length;
    private static final int BEGCOMM_length = BEGCOMM.length;
    private static final int ENDCOMM_length = ENDCOMM.length;
    private static final String EMPTYSTRING = "";
    private static final String HREF_STR = "href";
    private static final String SRC_STR = "str";
    private static final String CHAR_ESC_START = "&#";
    private static final String CDATA_ESC_START = "]]>&#";
    private static final String CDATA_ESC_END = ";<![CDATA[";
    private AttributeList _attributes = new AttributeList();
    private String _elementName = null;
    private Hashtable _namespaces;
    private Stack _nodeStack;
    private Stack _prefixStack;
    private Stack _qnameStack;
    private Stack _cdataStack;
    private int _depth = 0;
    private ContentHandler _saxHandler;
    private LexicalHandler _lexHandler;

    public TextOutput(ContentHandler handler) throws IOException {
        this._saxHandler = handler;
        this.init();
    }

    public TextOutput(ContentHandler handler, String encoding) throws IOException {
        this._saxHandler = handler;
        this.init();
        this._encoding = encoding;
    }

    public TextOutput(ContentHandler sax, LexicalHandler lex, String encoding) throws IOException {
        this._saxHandler = sax;
        this._lexHandler = lex;
        this.init();
        this._encoding = encoding;
    }

    private void init() throws IOException {
        this._outputType = 0;
        this._encoding = "UTF-8";
        this._mediaType = "text/html";
        this._escapeChars = false;
        this._startTagOpen = false;
        this._cdataTagOpen = false;
        this._qnameStack = new Stack();
        this._cdataStack = new Stack();
        this._cdataStack.push(new Integer(-1));
        this.initNamespaces();
    }

    public void close() {
        if (this._saxHandler != null && this._saxHandler instanceof DefaultSAXOutputHandler) {
            ((DefaultSAXOutputHandler)this._saxHandler).close();
        }
    }

    private void setTypeInternal(int type) {
        if (type == 1) {
            this._escapeChars = true;
        } else if (type == 2) {
            this.setIndent(true);
            this._escapeChars = true;
        }
        this.setType(type);
    }

    private void emitHeader() throws SAXException {
        if (this._outputType == 2) {
            AttributeList attrs = new AttributeList();
            attrs.add("http-equiv", "Content-Type");
            attrs.add("content", this._mediaType + "; charset=" + this._encoding);
            this._saxHandler.startElement(null, null, "meta", attrs);
            this._saxHandler.endElement(null, null, "meta");
        }
    }

    public void closeStartTag() throws TransletException {
        try {
            this._startTagOpen = false;
            int col = this._elementName.lastIndexOf(58);
            if (col > 0) {
                String prefix = this._elementName.substring(0, col);
                String localname = this._elementName.substring(col + 1);
                String uri = this.lookupNamespace(prefix);
                if (uri == null) {
                    BasisLibrary.runTimeError(12, prefix);
                }
                if (uri.equals(EMPTYSTRING)) {
                    this._elementName = localname;
                }
                this._saxHandler.startElement(uri, localname, this._elementName, this._attributes);
            } else {
                String uri = this.lookupNamespace(EMPTYSTRING);
                this._saxHandler.startElement(uri, this._elementName, this._elementName, this._attributes);
            }
            if (this._headTagOpen) {
                this.emitHeader();
                this._headTagOpen = false;
            }
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public boolean setEscaping(boolean escape) throws TransletException {
        if (this._outputType == 0) {
            this.setTypeInternal(1);
        }
        boolean oldSetting = this._escapeChars;
        this._escapeChars = escape;
        if (this._outputType == 3) {
            this._escapeChars = false;
        }
        return oldSetting;
    }

    public void startDocument() throws TransletException {
        try {
            this._saxHandler.startDocument();
            if (this._outputType == 1) {
                this._escapeChars = true;
            }
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void endDocument() throws TransletException {
        try {
            if (this._outputType == 0) {
                this.setTypeInternal(1);
            }
            if (this._startTagOpen) {
                this.closeStartTag();
            }
            if (this._cdataTagOpen) {
                this.closeCDATA();
            }
            this._saxHandler.endDocument();
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    private void characters(String str) throws SAXException {
        char[] ch = str.toCharArray();
        this.characters(ch, 0, ch.length);
    }

    private void characters(char[] ch) throws SAXException {
        this.characters(ch, 0, ch.length);
    }

    private void startCDATA(char[] ch, int off, int len) throws SAXException {
        int limit = off + len;
        int offset = off;
        this._saxHandler.characters(BEGCDATA, 0, BEGCDATA.length);
        int i = offset;
        while (i < limit - 2) {
            if (ch[i] == ']' && ch[i + 1] == ']' && ch[i + 2] == '>') {
                this._saxHandler.characters(ch, offset, i - offset);
                this._saxHandler.characters(CNTCDATA, 0, CNTCDATA.length);
                offset = i + 3;
                i += 2;
            }
            ++i;
        }
        if (offset < limit) {
            this._saxHandler.characters(ch, offset, limit - offset);
        }
        this._cdataTagOpen = true;
    }

    private void closeCDATA() throws SAXException {
        this._saxHandler.characters(ENDCDATA, 0, ENDCDATA.length);
        this._cdataTagOpen = false;
    }

    public void characters(char[] ch, int off, int len) throws TransletException {
        try {
            switch (this._outputType) {
                case 0: {
                    this.setTypeInternal(1);
                }
                case 1: {
                    Integer I;
                    if (this._startTagOpen) {
                        this.closeStartTag();
                    }
                    if ((I = (Integer)this._cdataStack.peek()) == this._depth && !this._cdataTagOpen) {
                        this.startCDATA(ch, off, len);
                    } else if (this._escapeChars) {
                        if (this._cdataTagOpen) {
                            this.escapeCDATA(ch, off, len);
                        } else {
                            this.escapeCharacters(ch, off, len);
                        }
                    } else {
                        this._saxHandler.characters(ch, off, len);
                    }
                    return;
                }
                case 2: {
                    if (this._startTagOpen) {
                        this.closeStartTag();
                    }
                    if (this._escapeChars) {
                        if (!this._qnameStack.isEmpty()) {
                            String qname = (String)this._qnameStack.peek();
                            if ((qname = qname.toLowerCase()).equals("style") || qname.equals("script")) {
                                this._saxHandler.characters(ch, off, len);
                                return;
                            }
                        }
                        this.escapeCharacters(ch, off, len);
                    } else {
                        this._saxHandler.characters(ch, off, len);
                    }
                    return;
                }
                case 3: {
                    this._saxHandler.characters(ch, off, len);
                    return;
                }
            }
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void startElement(String elementName) throws TransletException {
        try {
            switch (this._outputType) {
                case 0: {
                    if (elementName.toLowerCase().equals("html")) {
                        this.setTypeInternal(2);
                    } else {
                        this.setTypeInternal(1);
                    }
                    this.startElement(elementName);
                    return;
                }
                case 1: {
                    if (this._startTagOpen) {
                        this.closeStartTag();
                    }
                    if (this._cdataTagOpen) {
                        this.closeCDATA();
                    }
                    if (this._lexHandler != null) {
                        if (this._doctypeSystem != null) {
                            this._lexHandler.startDTD(elementName, this._doctypePublic, this._doctypeSystem);
                        }
                        this._lexHandler = null;
                    }
                    ++this._depth;
                    this._elementName = elementName;
                    this._attributes.clear();
                    this._startTagOpen = true;
                    this._qnameStack.push(elementName);
                    if (this._cdata != null && this._cdata.get(elementName) != null) {
                        this._cdataStack.push(new Integer(this._depth));
                    }
                    return;
                }
                case 2: {
                    if (this._startTagOpen) {
                        this.closeStartTag();
                    }
                    if (this._lexHandler != null) {
                        if (this._doctypeSystem != null || this._doctypePublic != null) {
                            this._lexHandler.startDTD(elementName, this._doctypePublic, this._doctypeSystem);
                        }
                        this._lexHandler = null;
                    }
                    ++this._depth;
                    this._elementName = elementName;
                    this._attributes.clear();
                    this._startTagOpen = true;
                    this._qnameStack.push(elementName);
                    if (elementName.toLowerCase().equals("head")) {
                        this._headTagOpen = true;
                    }
                    return;
                }
                case 3: {
                    return;
                }
            }
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    private void escapeCharacters(char[] ch, int off, int len) throws SAXException {
        int limit = off + len;
        int offset = off;
        if (limit > ch.length) {
            limit = ch.length;
        }
        int i = off;
        while (i < limit) {
            switch (ch[i]) {
                case '&': {
                    this._saxHandler.characters(ch, offset, i - offset);
                    this._saxHandler.characters(AMP, 0, AMP_length);
                    offset = i + 1;
                    break;
                }
                case '<': {
                    this._saxHandler.characters(ch, offset, i - offset);
                    this._saxHandler.characters(LT, 0, LT_length);
                    offset = i + 1;
                    break;
                }
                case '>': {
                    this._saxHandler.characters(ch, offset, i - offset);
                    this._saxHandler.characters(GT, 0, GT_length);
                    offset = i + 1;
                    break;
                }
                case '\u00a0': {
                    this._saxHandler.characters(ch, offset, i - offset);
                    this._saxHandler.characters(NBSP, 0, NBSP_length);
                    offset = i + 1;
                    break;
                }
                default: {
                    if (ch[i] <= '\u007f') break;
                    StringBuffer buf = new StringBuffer(CHAR_ESC_START);
                    buf.append(Integer.toString(ch[i]));
                    buf.append(';');
                    String esc = buf.toString();
                    char[] chars = esc.toCharArray();
                    int strlen = esc.length();
                    this._saxHandler.characters(ch, offset, i - offset);
                    this._saxHandler.characters(chars, 0, strlen);
                    offset = i + 1;
                }
            }
            ++i;
        }
        if (offset < limit) {
            this._saxHandler.characters(ch, offset, limit - offset);
        }
    }

    private void escapeCDATA(char[] ch, int off, int len) throws SAXException {
        int limit = off + len;
        int offset = off;
        if (limit > ch.length) {
            limit = ch.length;
        }
        int i = off;
        while (i < limit) {
            if (ch[i] > '\u00ff') {
                StringBuffer buf = new StringBuffer(CDATA_ESC_START);
                buf.append(Integer.toString(ch[i]));
                buf.append(CDATA_ESC_END);
                String esc = buf.toString();
                char[] chars = esc.toCharArray();
                int strlen = esc.length();
                this._saxHandler.characters(ch, offset, i - offset);
                this._saxHandler.characters(chars, 0, strlen);
                offset = i + 1;
            }
            ++i;
        }
        if (offset < limit) {
            this._saxHandler.characters(ch, offset, limit - offset);
        }
    }

    private String escapeString(String value) {
        char[] ch = value.toCharArray();
        int limit = ch.length;
        int offset = 0;
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < limit) {
            switch (ch[i]) {
                case '&': {
                    buf.append(ch, offset, i - offset);
                    buf.append(AMP);
                    offset = i + 1;
                    break;
                }
                case '\"': {
                    buf.append(ch, offset, i - offset);
                    buf.append(QUOTE);
                    offset = i + 1;
                    break;
                }
                case '<': {
                    buf.append(ch, offset, i - offset);
                    buf.append(LT);
                    offset = i + 1;
                    break;
                }
                case '>': {
                    buf.append(ch, offset, i - offset);
                    buf.append(GT);
                    offset = i + 1;
                    break;
                }
                case '\n': {
                    buf.append(ch, offset, i - offset);
                    buf.append(CRLF);
                    offset = i + 1;
                }
            }
            ++i;
        }
        if (offset < limit) {
            buf.append(ch, offset, limit - offset);
        }
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String escapeAttr(String base) {
        int pos;
        int len = base.length() - 1;
        String str = "&quot;";
        char[] ch = base.toCharArray();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < base.length()) {
            if (ch[i] > '\u007f') {
                buf.append('%');
                buf.append(Integer.toHexString(ch[i]));
            } else {
                switch (ch[i]) {
                    case '\t': 
                    case '\"': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '`': 
                    case '{': 
                    case '|': 
                    case '}': 
                    case '~': 
                    case '\u007f': {
                        buf.append('%');
                        buf.append(Integer.toHexString(ch[i]));
                        break;
                    }
                    case '&': {
                        buf.append("&amp;");
                        break;
                    }
                    default: {
                        buf.append(ch[i]);
                    }
                }
            }
            ++i;
        }
        base = buf.toString();
        while ((pos = base.indexOf(34)) > -1) {
            String before;
            void var4_7;
            if (var4_7 == false) {
                String after = base.substring(1);
                base = "&quot;" + after;
                continue;
            }
            if (var4_7 == len) {
                before = base.substring(0, (int)var4_7);
                base = before + "&quot;";
                continue;
            }
            before = base.substring(0, (int)var4_7);
            String after = base.substring((int)(var4_7 + true));
            base = before + "&quot;" + after;
        }
        return base;
    }

    /*
     * WARNING - void declaration
     */
    private String quickAndDirtyUrlEncode(String base) {
        int pos;
        String pst20 = "%20";
        int len = base.length() - 1;
        while ((pos = base.indexOf(32)) > -1) {
            String before;
            void var4_4;
            if (var4_4 == false) {
                String after = base.substring(1);
                base = "%20" + after;
                continue;
            }
            if (var4_4 == len) {
                before = base.substring(0, (int)var4_4);
                base = before + "%20";
                continue;
            }
            before = base.substring(0, (int)var4_4);
            String after = base.substring((int)(var4_4 + true));
            base = before + "%20" + after;
        }
        return base;
    }

    private String expandAttribute(String qname) throws TransletException {
        int endcol = qname.lastIndexOf(58);
        if (endcol > 0) {
            int startcol = qname.indexOf(58);
            String localname = qname.substring(endcol + 1);
            String prefix = qname.substring(0, startcol);
            String uri = this.lookupNamespace(prefix);
            if (uri == null) {
                BasisLibrary.runTimeError(12, prefix);
            }
            if (uri.equals(EMPTYSTRING)) {
                return localname;
            }
            if (endcol != startcol) {
                return prefix + ':' + localname;
            }
        }
        return qname;
    }

    public void attribute(String name, String value) throws TransletException {
        switch (this._outputType) {
            case 3: {
                return;
            }
            case 1: {
                if (!this._startTagOpen) {
                    BasisLibrary.runTimeError(10, name);
                }
                if (name.startsWith(XML_PREFIX)) {
                    if (name.startsWith("xmlns")) {
                        if (name.length() == 5) {
                            this.namespace(EMPTYSTRING, value);
                        } else {
                            this.namespace(name.substring(6), value);
                        }
                        return;
                    }
                    this._attributes.add(name, value);
                } else {
                    this._attributes.add(this.expandAttribute(name), this.escapeString(value));
                }
                return;
            }
            case 2: {
                String tmp;
                if (!this._startTagOpen) {
                    BasisLibrary.runTimeError(10, name);
                }
                if ((tmp = name.toLowerCase()).equals(HREF_STR) || tmp.equals(SRC_STR)) {
                    this._attributes.add(name, this.quickAndDirtyUrlEncode(this.escapeAttr(value)));
                } else {
                    this._attributes.add(this.expandAttribute(name), this.escapeAttr(value));
                }
                return;
            }
        }
    }

    public void endElement(String elementName) throws TransletException {
        try {
            switch (this._outputType) {
                case 3: {
                    return;
                }
                case 1: {
                    if (this._startTagOpen) {
                        this.closeStartTag();
                    }
                    if (this._cdataTagOpen) {
                        this.closeCDATA();
                    }
                    this._saxHandler.endElement(null, null, (String)this._qnameStack.pop());
                    this.popNamespaces();
                    if ((Integer)this._cdataStack.peek() == this._depth) {
                        this._cdataStack.pop();
                    }
                    --this._depth;
                    return;
                }
                case 2: {
                    if (this._startTagOpen) {
                        this.closeStartTag();
                    }
                    this._saxHandler.endElement(null, null, (String)this._qnameStack.pop());
                    this.popNamespaces();
                    --this._depth;
                    return;
                }
            }
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void comment(String comment) throws TransletException {
        try {
            if (this._startTagOpen) {
                this.closeStartTag();
            }
            if (this._cdataTagOpen) {
                this.closeCDATA();
            }
            if (this._outputType == 0) {
                this.setTypeInternal(1);
            }
            this._saxHandler.characters(BEGCOMM, 0, BEGCOMM_length);
            this.characters(comment);
            this._saxHandler.characters(ENDCOMM, 0, ENDCOMM_length);
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void processingInstruction(String target, String data) throws TransletException {
        try {
            if (this._startTagOpen) {
                this.closeStartTag();
            }
            if (this._cdataTagOpen) {
                this.closeCDATA();
            }
            if (this._lexHandler != null && this._outputType == 2) {
                if (this._doctypeSystem != null || this._doctypePublic != null) {
                    this._lexHandler.startDTD("HTML", this._doctypePublic, this._doctypeSystem);
                }
                this._lexHandler = null;
            }
            this._saxHandler.processingInstruction(target, data);
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    private void initNamespaces() {
        this._namespaces = new Hashtable();
        this._nodeStack = new Stack();
        this._prefixStack = new Stack();
        Stack<String> stack = new Stack<String>();
        this._namespaces.put(EMPTYSTRING, stack);
        stack.push(EMPTYSTRING);
        this._prefixStack.push(EMPTYSTRING);
        this._nodeStack.push(new Integer(-1));
        this._depth = 0;
    }

    private void pushNamespace(String prefix, String uri) throws SAXException {
        if (prefix.equals(XML_PREFIX)) {
            return;
        }
        Stack<String> stack = (Stack<String>)this._namespaces.get(prefix);
        if (stack == null) {
            stack = new Stack<String>();
            this._namespaces.put(prefix, stack);
        }
        if (!stack.empty() && uri.equals(stack.peek())) {
            return;
        }
        stack.push(uri);
        this._prefixStack.push(prefix);
        this._nodeStack.push(new Integer(this._depth));
        if (!prefix.equals(EMPTYSTRING) && uri.equals(EMPTYSTRING)) {
            return;
        }
        this._saxHandler.startPrefixMapping(prefix, uri);
    }

    private void popNamespace(String prefix) throws SAXException {
        if (prefix.equals(XML_PREFIX)) {
            return;
        }
        Stack stack = (Stack)this._namespaces.get(prefix);
        if (stack != null) {
            stack.pop();
            this._saxHandler.endPrefixMapping(prefix);
        }
    }

    private void popNamespaces() throws TransletException {
        try {
            while (true) {
                if (this._nodeStack.isEmpty()) {
                    return;
                }
                Integer i = (Integer)this._nodeStack.peek();
                if (i != this._depth) {
                    return;
                }
                this._nodeStack.pop();
                this.popNamespace((String)this._prefixStack.pop());
            }
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    private String lookupNamespace(String prefix) {
        Stack stack = (Stack)this._namespaces.get(prefix);
        return stack != null && !stack.isEmpty() ? (String)stack.peek() : null;
    }

    public void namespace(String prefix, String uri) throws TransletException {
        try {
            if (this._startTagOpen) {
                this.pushNamespace(prefix, uri);
            } else {
                if (prefix == EMPTYSTRING && uri == EMPTYSTRING) {
                    return;
                }
                BasisLibrary.runTimeError(11, prefix, uri);
            }
        }
        catch (SAXException e) {
            throw new TransletException(e);
        }
    }

    public void setType(int type) {
        try {
            this._outputType = type;
            if (this._outputType == 2 || this._outputType == 1) {
                this._escapeChars = true;
            }
            if (this._encoding == null) {
                this._encoding = "UTF-8";
            }
            if (this._saxHandler instanceof DefaultSAXOutputHandler) {
                ((DefaultSAXOutputHandler)this._saxHandler).setOutputType(type);
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void setIndent(boolean indent) {
        if (this._saxHandler instanceof DefaultSAXOutputHandler) {
            ((DefaultSAXOutputHandler)this._saxHandler).setIndent(indent);
        }
    }

    public void omitHeader(boolean value) {
        if (this._saxHandler instanceof DefaultSAXOutputHandler) {
            ((DefaultSAXOutputHandler)this._saxHandler).omitHeader(value);
        }
    }

    public void setVersion(String version2) {
        if (this._saxHandler instanceof DefaultSAXOutputHandler) {
            ((DefaultSAXOutputHandler)this._saxHandler).setVersion(version2);
        }
    }

    public void setStandalone(String standalone) {
        if (this._saxHandler instanceof DefaultSAXOutputHandler) {
            ((DefaultSAXOutputHandler)this._saxHandler).setStandalone(standalone);
        }
    }

    public void setDoctype(String system, String pub) {
        this._doctypeSystem = system;
        this._doctypePublic = pub;
    }

    public void setMediaType(String mediaType) {
        this._mediaType = mediaType;
    }

    public void setCdataElements(Hashtable elements) {
        this._cdata = elements;
    }
}

