/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.PUSH;
import org.apache.xalan.xsltc.compiler.AttributeValue;
import org.apache.xalan.xsltc.compiler.AttributeValueTemplate;
import org.apache.xalan.xsltc.compiler.Instruction;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.SimpleAttributeValue;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.UseAttributeSets;
import org.apache.xalan.xsltc.compiler.XslAttribute;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;
import org.apache.xalan.xsltc.compiler.util.Util;

final class XslElement
extends Instruction {
    private AttributeValue _name;
    private AttributeValueTemplate _namespace = null;
    private String _prefix;
    private boolean _ignore = false;

    XslElement() {
    }

    public void display(int indent) {
        this.indent(indent);
        Util.println("Element " + this._name);
        this.displayContents(indent + 4);
    }

    public void parseContents(Parser parser2) {
        SymbolTable stable = parser2.getSymbolTable();
        String name = this.getAttribute("name");
        if (name == null || name.equals("")) {
            ErrorMsg msg = new ErrorMsg(36, (Object)name, this);
            parser2.reportError(4, msg);
            this._ignore = true;
            return;
        }
        QName qname = parser2.getQNameSafe(name);
        String prefix = qname.getPrefix();
        String local = qname.getLocalPart();
        String namespace = this.getAttribute("namespace");
        if (!this.hasAttribute("namespace")) {
            if (prefix == null) {
                prefix = "";
            }
            if ((namespace = this.lookupNamespace(prefix)) == null) {
                ErrorMsg err = new ErrorMsg(12, (Object)prefix, this);
                parser2.reportError(4, err);
                this.parseChildren(parser2);
                this._ignore = true;
                return;
            }
            this._namespace = new AttributeValueTemplate(namespace, parser2);
            this._prefix = prefix;
        } else {
            this._namespace = new AttributeValueTemplate(namespace, parser2);
            this._prefix = this.lookupPrefix(namespace);
            this._prefix = prefix;
            if (this._prefix == null) {
                this._prefix = "";
            }
            name = this._prefix == "" ? qname.getLocalPart() : this._prefix + ":" + qname.getLocalPart();
        }
        this._name = AttributeValue.create(this, name, parser2);
        if (this._name instanceof SimpleAttributeValue && (local.equals("") || local.indexOf(32) > -1)) {
            ErrorMsg err = new ErrorMsg(36, (Object)local, this);
            parser2.reportError(4, err);
            this.parseChildren(parser2);
            this._ignore = true;
            return;
        }
        String useSets = this.getAttribute("use-attribute-sets");
        if (useSets.length() > 0) {
            this.setFirstElement(new UseAttributeSets(useSets, parser2));
        }
        this.parseChildren(parser2);
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        if (!this._ignore) {
            this._name.typeCheck(stable);
            if (this._namespace != null) {
                this._namespace.typeCheck(stable);
            }
        }
        this.typeCheckContents(stable);
        return Type.Void;
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        if (!this._ignore) {
            il.append(methodGen.loadHandler());
            this._name.translate(classGen, methodGen);
            il.append(InstructionConstants.DUP2);
            il.append(methodGen.startElement());
            if (this._namespace != null) {
                il.append(methodGen.loadHandler());
                il.append(new PUSH(cpg, this._prefix));
                this._namespace.translate(classGen, methodGen);
                il.append(methodGen.namespace());
            }
        }
        this.translateContents(classGen, methodGen);
        if (!this._ignore) {
            il.append(methodGen.endElement());
        }
    }

    public void translateContents(ClassGenerator classGen, MethodGenerator methodGen) {
        int n = this.elementCount();
        int i = 0;
        while (i < n) {
            SyntaxTreeNode item = (SyntaxTreeNode)this.getContents().elementAt(i);
            if (!this._ignore || !(item instanceof XslAttribute)) {
                item.translate(classGen, methodGen);
            }
            ++i;
        }
    }
}

