/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.jmdns.DNSCache;
import javax.jmdns.DNSConstants;
import javax.jmdns.DNSIncoming;
import javax.jmdns.DNSOutgoing;
import javax.jmdns.DNSQuestion;
import javax.jmdns.DNSRecord;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.ServiceTypeListener;

public class JmDNS
extends DNSConstants {
    public static String VERSION = "0.2";
    static int debug = Integer.parseInt(System.getProperty("jmdns.debug", "0"));
    InetAddress group;
    MulticastSocket socket;
    Vector listeners;
    Vector browsers;
    Vector typeListeners;
    DNSCache cache;
    Hashtable services;
    Thread shutdown;
    boolean done;
    boolean linklocal;
    boolean loopback;
    DNSRecord.Address host;
    Hashtable serviceTypes;

    public JmDNS() throws IOException {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this.init(JmDNS.isLoopback(inetAddress) ? null : inetAddress, inetAddress.getHostName());
        }
        catch (IOException iOException) {
            this.init(null, "computer");
        }
    }

    public JmDNS(InetAddress inetAddress) throws IOException {
        this.init(inetAddress, inetAddress.getHostName());
    }

    void init(InetAddress inetAddress, String string) throws IOException {
        long l;
        if (!string.endsWith(".")) {
            string = string + ".local.";
        }
        this.group = InetAddress.getByName("224.0.0.251");
        this.socket = new MulticastSocket(5353);
        if (inetAddress != null) {
            this.socket.setInterface(inetAddress);
        }
        this.socket.setTimeToLive(255);
        this.socket.joinGroup(this.group);
        this.loopback = JmDNS.isLoopback(inetAddress);
        this.linklocal = JmDNS.isLinkLocal(inetAddress);
        this.cache = new DNSCache(100);
        this.listeners = new Vector();
        this.browsers = new Vector();
        this.typeListeners = new Vector();
        this.services = new Hashtable(20);
        this.serviceTypes = new Hashtable(20);
        new Thread((Runnable)new SocketListener(), "JmDNS.SocketListener").start();
        new Thread((Runnable)new RecordReaper(), "JmDNS.RecordReaper").start();
        this.shutdown = new Thread((Runnable)new Shutdown(), "JmDNS.Shutdown");
        Runtime.getRuntime().addShutdownHook(this.shutdown);
        byte[] byArray = inetAddress.getAddress();
        int n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        DNSRecord.Address address = new DNSRecord.Address(string, 1, 1, 3600, n);
        long l2 = l = System.currentTimeMillis();
        for (int i = 0; i < 3; ++i) {
            Object object = this.cache.find(address.name);
            while (object.hasNext()) {
                DNSRecord dNSRecord = (DNSRecord)object.next();
                if (dNSRecord.type != 1 || dNSRecord.isExpired(l) || ((DNSRecord.Address)dNSRecord).addr == n) continue;
                String string2 = address.name.substring(0, string.indexOf(46));
                try {
                    int n2 = string2.lastIndexOf(45);
                    int n3 = string2.lastIndexOf(46);
                    string2 = n2 >= 0 && n2 < n3 ? string2.substring(0, n2) + "-" + (Integer.parseInt(string2.substring(n2 + 1)) + 1) : string2 + "-1";
                }
                catch (NumberFormatException numberFormatException) {
                    string2 = string2 + "-1";
                }
                address.name = string2 + address.name.substring(string.indexOf(46));
                i = 0;
                break;
            }
            object = new DNSOutgoing(0);
            ((DNSOutgoing)object).addQuestion(new DNSQuestion(address.name, 1, 1));
            ((DNSOutgoing)object).addAuthorativeAnswer(address);
            this.send((DNSOutgoing)object);
            if (l >= (l2 += 175L)) continue;
            try {
                Thread.sleep(l2 - l);
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("init interrupted");
            }
            l = System.currentTimeMillis();
        }
        this.host = address;
    }

    static boolean isLoopback(InetAddress inetAddress) {
        return inetAddress != null && inetAddress.getHostAddress().startsWith("127.0.0.1");
    }

    static boolean isLinkLocal(InetAddress inetAddress) {
        return inetAddress != null && inetAddress.getHostAddress().startsWith("169.254.");
    }

    public InetAddress getInterface() throws IOException {
        return this.socket.getInterface();
    }

    public ServiceInfo getServiceInfo(String string, String string2) {
        return this.getServiceInfo(string, string2, 3000);
    }

    public ServiceInfo getServiceInfo(String string, String string2, int n) {
        ServiceInfo serviceInfo = new ServiceInfo(string, string2);
        return serviceInfo.request(this, n) ? serviceInfo : null;
    }

    public void requestServiceInfo(String string, String string2) {
        this.requestServiceInfo(string, string2, 3000);
    }

    public void requestServiceInfo(String string, String string2, int n) {
        this.registerServiceType(string);
        new Thread((Runnable)new ServiceResolver(new ServiceInfo(string, string2), n), "JmDNS.ServiceResolver").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceTypeListener(ServiceTypeListener serviceTypeListener) throws IOException {
        JmDNS jmDNS = this;
        synchronized (jmDNS) {
            this.removeServiceTypeListener(serviceTypeListener);
            this.typeListeners.addElement(serviceTypeListener);
            Enumeration enumeration = this.serviceTypes.elements();
            while (enumeration.hasMoreElements()) {
                serviceTypeListener.addServiceType(this, (String)enumeration.nextElement());
            }
        }
        try {
            long l;
            long l2 = l = System.currentTimeMillis();
            int n = 0;
            while (n < 3) {
                if (l < l2) {
                    Thread.sleep(l2 - l);
                    l = System.currentTimeMillis();
                    continue;
                }
                DNSOutgoing dNSOutgoing = new DNSOutgoing(0);
                dNSOutgoing.addQuestion(new DNSQuestion("_services._mdns._udp.local.", 12, 1));
                Enumeration enumeration = this.serviceTypes.elements();
                while (enumeration.hasMoreElements()) {
                    dNSOutgoing.addAnswer(new DNSRecord.Pointer("_services._mdns._udp.local.", 12, 1, 3600, (String)enumeration.nextElement()), 0L);
                }
                this.send(dNSOutgoing);
                ++n;
                l2 += 225L;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("interrupted I/O");
        }
    }

    public synchronized void removeServiceTypeListener(ServiceTypeListener serviceTypeListener) {
        this.typeListeners.removeElement(serviceTypeListener);
    }

    public synchronized void addServiceListener(String string, ServiceListener serviceListener) {
        this.removeServiceListener(serviceListener);
        this.browsers.addElement(new ServiceBrowser(string, serviceListener));
    }

    public synchronized void removeServiceListener(ServiceListener serviceListener) {
        int n = this.browsers.size();
        while (n-- > 0) {
            ServiceBrowser serviceBrowser = (ServiceBrowser)this.browsers.elementAt(n);
            if (serviceBrowser.listener != serviceListener) continue;
            this.browsers.removeElementAt(n);
            serviceBrowser.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerService(ServiceInfo serviceInfo) throws IOException {
        this.registerServiceType(serviceInfo.type);
        serviceInfo.server = this.host.name;
        serviceInfo.addr = this.host.getInetAddress();
        try {
            long l;
            JmDNS jmDNS = this;
            synchronized (jmDNS) {
                this.checkService(serviceInfo);
                this.services.put(serviceInfo.name.toLowerCase(), serviceInfo);
            }
            long l2 = l = System.currentTimeMillis();
            int n = 0;
            while (n < 3) {
                if (l < l2) {
                    Thread.sleep(l2 - l);
                    l = System.currentTimeMillis();
                    continue;
                }
                DNSOutgoing dNSOutgoing = new DNSOutgoing(33792);
                dNSOutgoing.addAnswer(new DNSRecord.Pointer(serviceInfo.type, 12, 1, 3600, serviceInfo.name), 0L);
                dNSOutgoing.addAnswer(new DNSRecord.Service(serviceInfo.name, 33, 1, 3600, serviceInfo.priority, serviceInfo.weight, serviceInfo.port, this.host.name), 0L);
                dNSOutgoing.addAnswer(new DNSRecord.Text(serviceInfo.name, 16, 1, 3600, serviceInfo.text), 0L);
                dNSOutgoing.addAnswer(this.host, 0L);
                this.send(dNSOutgoing);
                ++n;
                l2 += 225L;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("interrupted I/O");
        }
    }

    public void unregisterService(ServiceInfo serviceInfo) {
        try {
            long l;
            this.services.remove(serviceInfo.name.toLowerCase());
            long l2 = l = System.currentTimeMillis();
            int n = 0;
            while (n < 3) {
                if (l < l2) {
                    Thread.sleep(l2 - l);
                    l = System.currentTimeMillis();
                    continue;
                }
                DNSOutgoing dNSOutgoing = new DNSOutgoing(33792);
                dNSOutgoing.addAnswer(new DNSRecord.Pointer(serviceInfo.type, 12, 1, 0, serviceInfo.name), 0L);
                dNSOutgoing.addAnswer(new DNSRecord.Service(serviceInfo.name, 33, 1, 0, serviceInfo.priority, serviceInfo.weight, serviceInfo.port, this.host.name), 0L);
                dNSOutgoing.addAnswer(new DNSRecord.Text(serviceInfo.name, 16, 1, 0, serviceInfo.text), 0L);
                this.send(dNSOutgoing);
                ++n;
                l2 += 125L;
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void unregisterAllServices() {
        if (this.services.size() == 0) {
            return;
        }
        try {
            long l;
            long l2 = l = System.currentTimeMillis();
            int n = 0;
            while (n < 3) {
                if (l < l2) {
                    Thread.sleep(l2 - l);
                    l = System.currentTimeMillis();
                    continue;
                }
                DNSOutgoing dNSOutgoing = new DNSOutgoing(33792);
                Enumeration enumeration = this.services.elements();
                while (enumeration.hasMoreElements()) {
                    ServiceInfo serviceInfo = (ServiceInfo)enumeration.nextElement();
                    dNSOutgoing.addAnswer(new DNSRecord.Pointer(serviceInfo.type, 12, 1, 0, serviceInfo.name), 0L);
                    dNSOutgoing.addAnswer(new DNSRecord.Service(serviceInfo.name, 33, 1, 0, serviceInfo.priority, serviceInfo.weight, serviceInfo.port, this.host.name), 0L);
                    dNSOutgoing.addAnswer(new DNSRecord.Text(serviceInfo.name, 16, 1, 0, serviceInfo.text), 0L);
                }
                this.send(dNSOutgoing);
                ++n;
                l2 += 125L;
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public synchronized void registerServiceType(String string) {
        String string2 = string.toLowerCase();
        if (this.serviceTypes.get(string2) == null && string.indexOf("._mdns._udp.") < 0 && !string.endsWith(".in-addr.arpa.")) {
            this.serviceTypes.put(string2, string);
            Enumeration enumeration = this.typeListeners.elements();
            while (enumeration.hasMoreElements()) {
                ((ServiceTypeListener)enumeration.nextElement()).addServiceType(this, string);
            }
        }
    }

    void checkService(ServiceInfo serviceInfo) throws IOException, InterruptedException {
        long l;
        long l2 = l = System.currentTimeMillis();
        for (int i = 0; i < 3; ++i) {
            Object object = this.cache.find(serviceInfo.type);
            while (object.hasNext()) {
                DNSRecord dNSRecord = (DNSRecord)object.next();
                if (dNSRecord.type != 12 || dNSRecord.isExpired(l) || !serviceInfo.name.equals(((DNSRecord.Pointer)dNSRecord).alias)) continue;
                String string = serviceInfo.getName();
                try {
                    int n = string.lastIndexOf(91);
                    int n2 = string.lastIndexOf(93);
                    string = n >= 0 && n < n2 ? string.substring(0, n) + "[" + (Integer.parseInt(string.substring(n + 1, n2)) + 1) + "]" : string + " [1]";
                }
                catch (NumberFormatException numberFormatException) {
                    string = string + " [1]";
                }
                serviceInfo.name = string + "." + serviceInfo.type;
                i = 0;
                break;
            }
            object = new DNSOutgoing(1024);
            ((DNSOutgoing)object).addQuestion(new DNSQuestion(serviceInfo.type, 12, 1));
            ((DNSOutgoing)object).addAuthorativeAnswer(new DNSRecord.Pointer(serviceInfo.type, 12, 1, 3600, serviceInfo.name));
            this.send((DNSOutgoing)object);
            if (l >= (l2 += 175L)) continue;
            this.wait(l2 - l);
            l = System.currentTimeMillis();
        }
    }

    synchronized void addListener(Listener listener, DNSQuestion dNSQuestion) {
        long l = System.currentTimeMillis();
        this.listeners.addElement(listener);
        if (dNSQuestion != null) {
            Iterator iterator = this.cache.find(dNSQuestion.name);
            while (iterator.hasNext()) {
                DNSRecord dNSRecord = (DNSRecord)iterator.next();
                if (!dNSQuestion.answeredBy(dNSRecord) || dNSRecord.isExpired(l)) continue;
                listener.updateRecord(this, l, dNSRecord);
            }
        }
        this.notifyAll();
    }

    synchronized void removeListener(Listener listener) {
        this.listeners.removeElement(listener);
        this.notifyAll();
    }

    synchronized void updateRecord(long l, DNSRecord dNSRecord) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            Listener listener = (Listener)enumeration.nextElement();
            listener.updateRecord(this, l, dNSRecord);
        }
        this.notifyAll();
    }

    synchronized void handleResponse(DNSIncoming dNSIncoming) throws IOException {
        long l = System.currentTimeMillis();
        Enumeration enumeration = dNSIncoming.answers.elements();
        block3: while (enumeration.hasMoreElements()) {
            DNSRecord dNSRecord = (DNSRecord)enumeration.nextElement();
            boolean bl = dNSRecord.isExpired(l);
            DNSRecord dNSRecord2 = (DNSRecord)this.cache.get(dNSRecord);
            if (dNSRecord2 != null) {
                if (bl) {
                    this.cache.remove(dNSRecord2);
                } else {
                    dNSRecord2.resetTTL(dNSRecord);
                    dNSRecord = dNSRecord2;
                }
            } else if (!bl) {
                this.cache.add(dNSRecord);
            }
            switch (dNSRecord.type) {
                case 12: {
                    if (dNSRecord.name.indexOf("._mdns._udp.") >= 0) {
                        if (bl || !dNSRecord.name.startsWith("_services._mdns._udp.")) continue block3;
                        this.registerServiceType(((DNSRecord.Pointer)dNSRecord).alias);
                        continue block3;
                    }
                    this.registerServiceType(dNSRecord.name);
                }
            }
            this.updateRecord(l, dNSRecord);
        }
    }

    DNSOutgoing addAnswer(DNSIncoming dNSIncoming, InetAddress inetAddress, int n, DNSOutgoing dNSOutgoing, DNSRecord dNSRecord) throws IOException {
        if (dNSOutgoing == null) {
            dNSOutgoing = new DNSOutgoing(33792);
        }
        try {
            dNSOutgoing.addAnswer(dNSIncoming, dNSRecord);
        }
        catch (IOException iOException) {
            dNSOutgoing.flags |= 0x200;
            dNSOutgoing.id = dNSIncoming.id;
            dNSOutgoing.finish();
            this.socket.send(new DatagramPacket(dNSOutgoing.data, dNSOutgoing.off, inetAddress, n));
            dNSOutgoing = new DNSOutgoing(33792);
            dNSOutgoing.addAnswer(dNSIncoming, dNSRecord);
        }
        return dNSOutgoing;
    }

    synchronized void handleQuery(DNSIncoming dNSIncoming, InetAddress inetAddress, int n) throws IOException {
        Enumeration enumeration;
        DNSOutgoing dNSOutgoing = null;
        Vector<DNSRecord.Service> vector = null;
        if (n != 5353) {
            dNSOutgoing = new DNSOutgoing(33792, false);
            enumeration = dNSIncoming.questions.elements();
            while (enumeration.hasMoreElements()) {
                dNSOutgoing.addQuestion((DNSQuestion)enumeration.nextElement());
            }
        }
        enumeration = dNSIncoming.questions.elements();
        block5: while (enumeration.hasMoreElements()) {
            Object object;
            DNSQuestion dNSQuestion = (DNSQuestion)enumeration.nextElement();
            switch (dNSQuestion.type) {
                case 1: {
                    if (this.host == null || !dNSQuestion.name.equals(this.host.name)) continue block5;
                    dNSOutgoing = this.addAnswer(dNSIncoming, inetAddress, n, dNSOutgoing, this.host);
                    continue block5;
                }
                case 12: {
                    this.registerServiceType(dNSQuestion.name);
                    object = this.services.elements();
                    while (object.hasMoreElements()) {
                        ServiceInfo serviceInfo = (ServiceInfo)object.nextElement();
                        if (!dNSQuestion.name.equals(serviceInfo.type)) continue;
                        dNSOutgoing = this.addAnswer(dNSIncoming, inetAddress, n, dNSOutgoing, new DNSRecord.Pointer(serviceInfo.type, 12, 1, 3600, serviceInfo.name));
                        if (vector == null) {
                            vector = new Vector<DNSRecord.Service>();
                            vector.addElement((DNSRecord.Service)((Object)this.host));
                        }
                        vector.addElement(new DNSRecord.Service(serviceInfo.name, 33, 32769, 3600, serviceInfo.priority, serviceInfo.weight, serviceInfo.port, this.host.name));
                        vector.addElement((DNSRecord.Service)((Object)new DNSRecord.Text(serviceInfo.name, 16, 32769, 3600, serviceInfo.text)));
                    }
                    if (!dNSQuestion.name.equals("_services._mdns._udp.local.")) continue block5;
                    object = this.serviceTypes.elements();
                    while (object.hasMoreElements()) {
                        dNSOutgoing = this.addAnswer(dNSIncoming, inetAddress, n, dNSOutgoing, new DNSRecord.Pointer("_services._mdns._udp.local.", 12, 1, 3600, (String)object.nextElement()));
                    }
                    continue block5;
                }
            }
            object = (ServiceInfo)this.services.get(dNSQuestion.name.toLowerCase());
            if (object == null) continue;
            if (dNSQuestion.type == 33 || dNSQuestion.type == 255) {
                dNSOutgoing = this.addAnswer(dNSIncoming, inetAddress, n, dNSOutgoing, new DNSRecord.Service(dNSQuestion.name, 33, 32769, 3600, ((ServiceInfo)object).priority, ((ServiceInfo)object).weight, ((ServiceInfo)object).port, this.host.name));
            }
            if (dNSQuestion.type != 16 && dNSQuestion.type != 255) continue;
            dNSOutgoing = this.addAnswer(dNSIncoming, inetAddress, n, dNSOutgoing, new DNSRecord.Text(dNSQuestion.name, 16, 32769, 3600, ((ServiceInfo)object).text));
        }
        if (dNSOutgoing != null && dNSOutgoing.numAnswers > 0) {
            if (vector != null) {
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    dNSOutgoing.addAdditionalAnswer(dNSIncoming, (DNSRecord)enumeration.nextElement());
                }
            }
            dNSOutgoing.id = dNSIncoming.id;
            dNSOutgoing.finish();
            this.socket.send(new DatagramPacket(dNSOutgoing.data, dNSOutgoing.off, inetAddress, n));
        }
    }

    synchronized void send(DNSOutgoing dNSOutgoing) throws IOException {
        dNSOutgoing.finish();
        this.socket.send(new DatagramPacket(dNSOutgoing.data, dNSOutgoing.off, this.group, 5353));
    }

    public synchronized void close() {
        if (!this.done) {
            this.done = true;
            this.notifyAll();
            if (this.shutdown != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdown);
            }
            this.unregisterAllServices();
            try {
                this.socket.leaveGroup(this.group);
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    void print() {
        if (this.cache.count > 0) {
            System.out.println("---- cache ----");
            this.cache.print();
            System.out.println();
        }
    }

    class Shutdown
    implements Runnable {
        Shutdown() {
        }

        public void run() {
            JmDNS.this.shutdown = null;
            JmDNS.this.close();
        }
    }

    class ServiceResolver
    implements Runnable {
        ServiceInfo info;
        int timeout;

        ServiceResolver(ServiceInfo serviceInfo, int n) {
            this.info = serviceInfo;
            this.timeout = n;
        }

        public void run() {
            ServiceInfo serviceInfo = this.info;
            if (!this.info.request(JmDNS.this, this.timeout)) {
                serviceInfo = null;
            }
            Enumeration enumeration = JmDNS.this.browsers.elements();
            while (enumeration.hasMoreElements()) {
                ServiceBrowser serviceBrowser = (ServiceBrowser)enumeration.nextElement();
                if (!serviceBrowser.type.equalsIgnoreCase(this.info.type)) continue;
                serviceBrowser.listener.resolveService(JmDNS.this, this.info.type, this.info.name, serviceInfo);
            }
        }
    }

    class ServiceBrowser
    extends Listener
    implements Runnable {
        String type;
        ServiceListener listener;
        Hashtable services;
        long nextTime;
        int delay;
        boolean done;
        LinkedList list;

        ServiceBrowser(String string, ServiceListener serviceListener) {
            this.type = string;
            this.listener = serviceListener;
            this.services = new Hashtable();
            this.nextTime = System.currentTimeMillis();
            this.delay = 500;
            this.list = new LinkedList();
            JmDNS.this.addListener(this, new DNSQuestion(string, 12, 1));
            new Thread((Runnable)this, "JmDNS.ServiceBrowser: " + string).start();
        }

        void updateRecord(JmDNS jmDNS, long l, DNSRecord dNSRecord) {
            if (dNSRecord.type == 12 && dNSRecord.name.equals(this.type)) {
                boolean bl = dNSRecord.isExpired(l);
                String string = ((DNSRecord.Pointer)dNSRecord).alias;
                DNSRecord dNSRecord2 = (DNSRecord)this.services.get(string.toLowerCase());
                if (dNSRecord2 == null && !bl) {
                    this.services.put(string.toLowerCase(), dNSRecord);
                    this.list.addLast(new Event(this, string){
                        private final /* synthetic */ ServiceBrowser this$1;
                        {
                            this.this$1 = serviceBrowser;
                        }

                        void send() {
                            this.this$1.listener.addService(ServiceBrowser.access$000(this.this$1), this.this$1.type, this.name);
                        }
                    });
                } else if (dNSRecord2 != null && !bl) {
                    dNSRecord2.resetTTL(dNSRecord);
                } else if (dNSRecord2 != null && bl) {
                    this.services.remove(string.toLowerCase());
                    this.list.addLast(new Event(this, string){
                        private final /* synthetic */ ServiceBrowser this$1;
                        {
                            this.this$1 = serviceBrowser;
                        }

                        void send() {
                            this.this$1.listener.removeService(ServiceBrowser.access$000(this.this$1), this.this$1.type, this.name);
                        }
                    });
                    return;
                }
                long l2 = dNSRecord.getExpirationTime(75);
                if (l2 < this.nextTime) {
                    this.nextTime = dNSRecord.getExpirationTime(75);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (true) {
                    Event event = null;
                    JmDNS jmDNS = JmDNS.this;
                    synchronized (jmDNS) {
                        long l = System.currentTimeMillis();
                        if (this.list.size() == 0 && this.nextTime > l) {
                            JmDNS.this.wait(this.nextTime - l);
                        }
                        if (this.done) {
                            return;
                        }
                        l = System.currentTimeMillis();
                        if (this.nextTime <= l) {
                            DNSOutgoing dNSOutgoing = new DNSOutgoing(0);
                            dNSOutgoing.addQuestion(new DNSQuestion(this.type, 12, 1));
                            Enumeration enumeration = this.services.elements();
                            while (enumeration.hasMoreElements()) {
                                DNSRecord dNSRecord = (DNSRecord)enumeration.nextElement();
                                if (dNSRecord.isExpired(l)) continue;
                                try {
                                    dNSOutgoing.addAnswer(dNSRecord, l);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                    break;
                                }
                            }
                            JmDNS.this.send(dNSOutgoing);
                            this.nextTime = l + (long)this.delay;
                            this.delay = Math.min(20000, this.delay * 2);
                        }
                        if (this.list.size() > 0) {
                            event = (Event)this.list.removeFirst();
                        }
                    }
                    if (event == null) continue;
                    event.send();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            JmDNS jmDNS = JmDNS.this;
            synchronized (jmDNS) {
                if (!this.done) {
                    this.done = true;
                    JmDNS.this.removeListener(this);
                }
            }
        }

        static /* synthetic */ JmDNS access$000(ServiceBrowser serviceBrowser) {
            return serviceBrowser.JmDNS.this;
        }

        abstract class Event {
            String name;

            Event(String string) {
                this.name = string;
            }

            abstract void send();
        }
    }

    class RecordReaper
    implements Runnable {
        RecordReaper() {
        }

        public void run() {
            try {
                JmDNS jmDNS = JmDNS.this;
                synchronized (jmDNS) {
                    block5: while (true) {
                        JmDNS.this.wait(10000L);
                        if (JmDNS.this.done) {
                            return;
                        }
                        long l = System.currentTimeMillis();
                        Iterator iterator = JmDNS.this.cache.all();
                        while (true) {
                            if (!iterator.hasNext()) continue block5;
                            DNSRecord dNSRecord = (DNSRecord)iterator.next();
                            if (!dNSRecord.isExpired(l)) continue;
                            JmDNS.this.updateRecord(l, dNSRecord);
                            iterator.remove();
                        }
                        break;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                return;
            }
        }
    }

    class SocketListener
    implements Runnable {
        SocketListener() {
        }

        public void run() {
            block9: {
                try {
                    byte[] byArray = new byte[8972];
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                    while (!JmDNS.this.done) {
                        datagramPacket.setLength(byArray.length);
                        JmDNS.this.socket.receive(datagramPacket);
                        if (!JmDNS.this.done) {
                            try {
                                InetAddress inetAddress = datagramPacket.getAddress();
                                if (JmDNS.this.linklocal != JmDNS.isLinkLocal(inetAddress) || JmDNS.this.loopback != JmDNS.isLoopback(inetAddress)) continue;
                                DNSIncoming dNSIncoming = new DNSIncoming(datagramPacket);
                                if (debug > 0) {
                                    dNSIncoming.print(debug > 1);
                                    System.out.println();
                                }
                                if (dNSIncoming.isQuery()) {
                                    if (datagramPacket.getPort() != 5353) {
                                        JmDNS.this.handleQuery(dNSIncoming, datagramPacket.getAddress(), datagramPacket.getPort());
                                    }
                                    JmDNS.this.handleQuery(dNSIncoming, JmDNS.this.group, 5353);
                                    continue;
                                }
                                JmDNS.this.handleResponse(dNSIncoming);
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    if (JmDNS.this.done) break block9;
                    iOException.printStackTrace();
                }
            }
        }
    }

    static abstract class Listener
    extends DNSConstants {
        Listener() {
        }

        abstract void updateRecord(JmDNS var1, long var2, DNSRecord var4);
    }
}

