/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns;

import java.io.IOException;
import java.util.Hashtable;
import javax.jmdns.DNSConstants;
import javax.jmdns.DNSIncoming;
import javax.jmdns.DNSQuestion;
import javax.jmdns.DNSRecord;

final class DNSOutgoing
extends DNSConstants {
    int id;
    int flags;
    boolean multicast;
    int numQuestions;
    int numAnswers;
    int numAuthorities;
    int numAdditionals;
    Hashtable names;
    byte[] data;
    int off;
    int len;

    DNSOutgoing(int n) {
        this(n, true);
    }

    DNSOutgoing(int n, boolean bl) {
        this.flags = n;
        this.multicast = bl;
        this.names = new Hashtable();
        this.data = new byte[1460];
        this.off = 12;
    }

    void addQuestion(DNSQuestion dNSQuestion) throws IOException {
        ++this.numQuestions;
        this.writeQuestion(dNSQuestion);
    }

    void addAnswer(DNSIncoming dNSIncoming, DNSRecord dNSRecord) throws IOException {
        if (!dNSRecord.suppressedBy(dNSIncoming)) {
            this.addAnswer(dNSRecord, 0L);
        }
    }

    void addAdditionalAnswer(DNSIncoming dNSIncoming, DNSRecord dNSRecord) throws IOException {
        if (this.off < 1260 && !dNSRecord.suppressedBy(dNSIncoming)) {
            this.writeRecord(dNSRecord, 0L);
            ++this.numAdditionals;
        }
    }

    void addAnswer(DNSRecord dNSRecord, long l) throws IOException {
        if (!(dNSRecord == null || l != 0L && dNSRecord.isExpired(l))) {
            this.writeRecord(dNSRecord, l);
            ++this.numAnswers;
        }
    }

    void addAuthorativeAnswer(DNSRecord dNSRecord) throws IOException {
        this.writeRecord(dNSRecord, 0L);
        ++this.numAuthorities;
    }

    void writeByte(int n) throws IOException {
        if (this.off >= this.data.length) {
            throw new IOException("buffer full");
        }
        this.data[this.off++] = (byte)n;
    }

    void writeBytes(String string, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.writeByte(string.charAt(n + i));
        }
    }

    void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            this.writeByte(byArray[n + i]);
        }
    }

    void writeShort(int n) throws IOException {
        this.writeByte(n >> 8);
        this.writeByte(n);
    }

    void writeInt(int n) throws IOException {
        this.writeShort(n >> 16);
        this.writeShort(n);
    }

    void writeUTF(String string, int n, int n2) throws IOException {
        char c;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < n2; ++n3) {
            c = string.charAt(n + n3);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n4;
                continue;
            }
            if (c > '\u07ff') {
                n4 += 3;
                continue;
            }
            n4 += 2;
        }
        this.writeByte(n4);
        for (n3 = 0; n3 < n2; ++n3) {
            c = string.charAt(n + n3);
            if (c >= '\u0001' && c <= '\u007f') {
                this.writeByte(c);
                continue;
            }
            if (c > '\u07ff') {
                this.writeByte(0xE0 | c >> 12 & 0xF);
                this.writeByte(0x80 | c >> 6 & 0x3F);
                this.writeByte(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.writeByte(0xC0 | c >> 6 & 0x1F);
            this.writeByte(0x80 | c >> 0 & 0x3F);
        }
    }

    void writeName(String string) throws IOException {
        while (true) {
            int n;
            if ((n = string.indexOf(46)) < 0) {
                n = string.length();
            }
            if (n <= 0) {
                this.writeByte(0);
                return;
            }
            Integer n2 = (Integer)this.names.get(string);
            if (n2 != null) {
                int n3 = n2;
                this.writeByte(n3 >> 8 | 0xC0);
                this.writeByte(n3);
                return;
            }
            this.names.put(string, new Integer(this.off));
            this.writeUTF(string, 0, n);
            if (!(string = string.substring(n)).startsWith(".")) continue;
            string = string.substring(1);
        }
    }

    void writeQuestion(DNSQuestion dNSQuestion) throws IOException {
        this.writeName(dNSQuestion.name);
        this.writeShort(dNSQuestion.type);
        this.writeShort(dNSQuestion.clazz);
    }

    void writeRecord(DNSRecord dNSRecord, long l) throws IOException {
        int n = this.off;
        try {
            this.writeName(dNSRecord.name);
            this.writeShort(dNSRecord.type);
            this.writeShort(dNSRecord.clazz | (dNSRecord.unique && this.multicast ? 32768 : 0));
            this.writeInt(l == 0L ? dNSRecord.ttl : dNSRecord.getRemainingTTL(l));
            this.writeShort(0);
            int n2 = this.off;
            dNSRecord.write(this);
            int n3 = this.off - n2;
            this.data[n2 - 2] = (byte)(n3 >> 8);
            this.data[n2 - 1] = (byte)(n3 & 0xFF);
        }
        catch (IOException iOException) {
            this.off = n;
            throw iOException;
        }
    }

    void finish() throws IOException {
        int n = this.off;
        this.off = 0;
        this.writeShort(this.multicast ? 0 : this.id);
        this.writeShort(this.flags);
        this.writeShort(this.numQuestions);
        this.writeShort(this.numAnswers);
        this.writeShort(this.numAuthorities);
        this.writeShort(this.numAdditionals);
        this.off = n;
    }
}

