/*
 * Decompiled with CFR 0.152.
 */
package com.chaotic;

import com.chaotic.Base64;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class PropertyList {
    public static final String PLIST_XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    public static final String PLIST_XML_DOCTYPE = "<!DOCTYPE plist SYSTEM \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">\n";
    public static final String PLIST_XML_VERSION_BEGIN = "<plist version=\"1.0\">\n";
    public static final String PLIST_XML_VERSION_END = "</plist>\n";
    public static final String PLIST_XML_ARRAY_BEGIN = "<array>\n";
    public static final String PLIST_XML_ARRAY_END = "</array>\n";
    public static final String PLIST_XML_ARRAY_EMPTY = "<array/>\n";
    public static final String PLIST_XML_BOOLEAN_TRUE = "<true/>\n";
    public static final String PLIST_XML_BOOLEAN_FALSE = "<false/>\n";
    public static final String PLIST_XML_DATA_BEGIN = "<data>\n";
    public static final String PLIST_XML_DATA_END = "</data>\n";
    public static final String PLIST_XML_DATE_BEGIN = "<date>";
    public static final String PLIST_XML_DATE_END = "</date>\n";
    public static final String PLIST_XML_DICTIONARY_BEGIN = "<dict>\n";
    public static final String PLIST_XML_DICTIONARY_END = "</dict>\n";
    public static final String PLIST_XML_DICTIONARY_EMPTY = "<dict/>\n";
    public static final String PLIST_XML_KEY_BEGIN = "<key>";
    public static final String PLIST_XML_KEY_END = "</key>\n";
    public static final String PLIST_XML_INTEGER_BEGIN = "<integer>";
    public static final String PLIST_XML_INTEGER_END = "</integer>\n";
    public static final String PLIST_XML_REAL_BEGIN = "<real>";
    public static final String PLIST_XML_REAL_END = "</real>\n";
    public static final String PLIST_XML_STRING_BEGIN = "<string>";
    public static final String PLIST_XML_STRING_END = "</string>\n";
    protected static final String PLIST_DATE_FORMAT = "yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'";

    public static Object createFormatted(String string, Object[] objectArray) {
        return PropertyList.appendFormatted(null, string, objectArray);
    }

    public static Object appendFormatted(Object object, String string, Object[] objectArray) {
        Object object2;
        Map map;
        ArrayList arrayList;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        if (object instanceof ArrayList) {
            arrayList = (ArrayList)object;
            map = null;
        } else if (object instanceof Map) {
            map = (Map)object;
            arrayList = null;
        } else {
            arrayList = null;
            map = null;
        }
        String string2 = null;
        int n = 0;
        int n2 = string.length();
        block14: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '[': {
                    object2 = new ArrayList();
                    if (arrayList != null) {
                        arrayList.add(object2);
                        linkedList.addFirst(arrayList);
                    } else if (map != null) {
                        if (string2 == null) {
                            throw new IllegalArgumentException("array begin in dictionary with no previous key");
                        }
                        map.put(string2, object2);
                        linkedList.addFirst(map);
                        string2 = null;
                    }
                    arrayList = (ArrayList)object2;
                    map = null;
                    continue block14;
                }
                case ']': {
                    if (linkedList.size() <= 0) continue block14;
                    object2 = linkedList.removeFirst();
                    if (object2 instanceof ArrayList) {
                        arrayList = (ArrayList)object2;
                        map = null;
                        continue block14;
                    }
                    if (object2 instanceof Map) {
                        map = (Map)object2;
                        arrayList = null;
                        continue block14;
                    }
                    throw new IllegalArgumentException("array end with non-container parent");
                }
                case '{': {
                    object2 = new HashMap();
                    if (arrayList != null) {
                        arrayList.add(object2);
                        linkedList.addFirst(arrayList);
                    } else if (map != null) {
                        if (string2 == null) {
                            throw new IllegalArgumentException("dictionary begin in dictionary with no previous key");
                        }
                        map.put(string2, object2);
                        linkedList.addFirst(map);
                        string2 = null;
                    }
                    map = (Map)object2;
                    arrayList = null;
                    continue block14;
                }
                case '}': {
                    if (linkedList.size() <= 0) continue block14;
                    object2 = linkedList.removeFirst();
                    if (object2 instanceof ArrayList) {
                        arrayList = (ArrayList)object2;
                        map = null;
                        continue block14;
                    }
                    if (object2 instanceof Map) {
                        map = (Map)object2;
                        arrayList = null;
                        continue block14;
                    }
                    throw new IllegalArgumentException("dictionary end with non-container parent");
                }
                case 'k': {
                    if (string2 != null) {
                        throw new IllegalArgumentException("second key found before first key used");
                    }
                    if (map == null) {
                        throw new IllegalArgumentException("key without parent dictionary");
                    }
                    string2 = (String)objectArray[n++];
                    continue block14;
                }
                case 'i': {
                    object2 = objectArray[n++];
                    if (object2 instanceof Byte) {
                        object2 = new Long(((Byte)object2).longValue());
                    } else if (object2 instanceof Short) {
                        object2 = new Long(((Short)object2).longValue());
                    } else if (object2 instanceof Integer) {
                        object2 = new Long(((Integer)object2).longValue());
                    } else if (!(object2 instanceof Long)) {
                        throw new IllegalArgumentException("'i' used with non-Integer arg: " + Integer.toString(n - 1));
                    }
                    if (arrayList != null) {
                        arrayList.add(object2);
                        continue block14;
                    }
                    if (map == null) continue block14;
                    if (string2 == null) {
                        throw new IllegalArgumentException("integer in dictionary with no previous key");
                    }
                    map.put(string2, object2);
                    string2 = null;
                    continue block14;
                }
                case 's': {
                    object2 = objectArray[n++];
                    if (!(object2 instanceof String)) {
                        throw new IllegalArgumentException("'s' used with non-String arg: " + Integer.toString(n - 1));
                    }
                    if (arrayList != null) {
                        arrayList.add(object2);
                        continue block14;
                    }
                    if (map == null) continue block14;
                    if (string2 == null) {
                        throw new IllegalArgumentException("string in dictionary with no previous key");
                    }
                    map.put(string2, object2);
                    string2 = null;
                    continue block14;
                }
                case 'b': {
                    object2 = objectArray[n++];
                    if (!(object2 instanceof Boolean)) {
                        throw new IllegalArgumentException("'b' used with non-Boolean arg: " + Integer.toString(n - 1));
                    }
                    if (arrayList != null) {
                        arrayList.add(object2);
                        continue block14;
                    }
                    if (map == null) continue block14;
                    if (string2 == null) {
                        throw new IllegalArgumentException("boolean in dictionary with no previous key");
                    }
                    map.put(string2, object2);
                    string2 = null;
                    continue block14;
                }
                case 'd': {
                    object2 = objectArray[n++];
                    if (!(object2 instanceof byte[])) {
                        throw new IllegalArgumentException("'b' used with non-byte[] arg: " + Integer.toString(n - 1));
                    }
                    if (arrayList != null) {
                        arrayList.add(object2);
                        continue block14;
                    }
                    if (map == null) continue block14;
                    if (string2 == null) {
                        throw new IllegalArgumentException("raw data in dictionary with no previous key");
                    }
                    map.put(string2, object2);
                    string2 = null;
                    continue block14;
                }
                case 'D': {
                    object2 = objectArray[n++];
                    if (!(object2 instanceof Date)) {
                        throw new IllegalArgumentException("'b' used with non-Boolean arg: " + Integer.toString(n - 1));
                    }
                    if (arrayList != null) {
                        arrayList.add(object2);
                        continue block14;
                    }
                    if (map == null) continue block14;
                    if (string2 == null) {
                        throw new IllegalArgumentException("date in dictionary with no previous key");
                    }
                    map.put(string2, object2);
                    string2 = null;
                    continue block14;
                }
                case 'o': {
                    object2 = objectArray[n++];
                    if (!PropertyList.isCompatibleObject(object2)) {
                        throw new IllegalArgumentException(object2.getClass().toString() + " is not compatible with Property Lists");
                    }
                    if (arrayList != null) {
                        arrayList.add(object2);
                        continue block14;
                    }
                    if (map == null) continue block14;
                    if (string2 == null) {
                        throw new IllegalArgumentException("object in dictionary with no previous key");
                    }
                    map.put(string2, object2);
                    string2 = null;
                    continue block14;
                }
                case '@': {
                    object2 = arrayList != null ? arrayList : (map != null ? map : null);
                    objectArray[n++] = object2;
                    continue block14;
                }
            }
        }
        object2 = arrayList != null ? arrayList : (map != null ? map : null);
        return object2;
    }

    public static Object[] extractFormatted(Object object, String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '<') continue;
            int n2 = string.indexOf(62, i + 1);
            if (n2 < 0) {
                throw new IllegalArgumentException("'<' without closing '>'");
            }
            Object object2 = PropertyList.extractOneFormatted(object, string.substring(i + 1, n2));
            if (object2 == null) {
                return null;
            }
            arrayList.add(object2);
            i = n2;
        }
        return arrayList.toArray();
    }

    protected static Object extractOneFormatted(Object object, String string) {
        if (!(object instanceof Map)) {
            throw new IllegalArgumentException("non-container object = \"" + object.getClass().toString() + "\"");
        }
        Map map = (Map)object;
        Object v = map.get(string);
        return v;
    }

    public static Object readXML(Reader reader) throws Exception {
        XMLReader xMLReader = PropertyList.getParser().getXMLReader();
        Handler handler = new Handler();
        xMLReader.setContentHandler(handler);
        xMLReader.setEntityResolver(handler);
        xMLReader.setErrorHandler(handler);
        xMLReader.parse(new InputSource(reader));
        return handler.postProcess();
    }

    public static void writeXML(Object object, Writer writer) throws IOException {
        writer.write(PLIST_XML_DECLARATION);
        writer.write(PLIST_XML_DOCTYPE);
        writer.write(PLIST_XML_VERSION_BEGIN);
        PropertyList.writeXMLLevel(object, 0, writer);
        writer.write(PLIST_XML_VERSION_END);
    }

    protected static void writeXMLLevel(Object object, int n, Writer writer) throws IOException {
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            if (arrayList.size() > 0) {
                PropertyList.writeStringWithIndent(PLIST_XML_ARRAY_BEGIN, n, writer);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    PropertyList.writeXMLLevel(iterator.next(), n + 1, writer);
                }
                PropertyList.writeStringWithIndent(PLIST_XML_ARRAY_END, n, writer);
            } else {
                PropertyList.writeStringWithIndent(PLIST_XML_ARRAY_EMPTY, n, writer);
            }
        } else if (object instanceof byte[]) {
            PropertyList.writeStringWithIndent(PLIST_XML_DATA_BEGIN, n, writer);
            writer.write(Base64.encodeLines((byte[])object, n));
            PropertyList.writeStringWithIndent(PLIST_XML_DATA_END, n, writer);
        } else if (object instanceof Date) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(PLIST_DATE_FORMAT);
            PropertyList.writeStringWithIndent(PLIST_XML_DATE_BEGIN, n, writer);
            writer.write(simpleDateFormat.format((Date)object));
            writer.write(PLIST_XML_DATE_END);
        } else if (object instanceof Map) {
            Map map = (Map)object;
            if (map.size() > 0) {
                PropertyList.writeStringWithIndent(PLIST_XML_DICTIONARY_BEGIN, n, writer);
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    PropertyList.writeStringWithIndent(PLIST_XML_KEY_BEGIN, n + 1, writer);
                    PropertyList.writeMinimallyEscapedXML((String)entry.getKey(), writer);
                    writer.write(PLIST_XML_KEY_END);
                    PropertyList.writeXMLLevel(entry.getValue(), n + 1, writer);
                }
                PropertyList.writeStringWithIndent(PLIST_XML_DICTIONARY_END, n, writer);
            } else {
                PropertyList.writeStringWithIndent(PLIST_XML_DICTIONARY_EMPTY, n, writer);
            }
        } else if (object instanceof Byte || object instanceof Short || object instanceof Long || object instanceof Integer) {
            PropertyList.writeStringWithIndent(PLIST_XML_INTEGER_BEGIN, n, writer);
            writer.write(object.toString());
            writer.write(PLIST_XML_INTEGER_END);
        } else if (object instanceof Double) {
            PropertyList.writeStringWithIndent(PLIST_XML_REAL_BEGIN, n, writer);
            writer.write(object.toString());
            writer.write(PLIST_XML_REAL_END);
        } else if (object instanceof String) {
            PropertyList.writeStringWithIndent(PLIST_XML_STRING_BEGIN, n, writer);
            PropertyList.writeMinimallyEscapedXML((String)object, writer);
            writer.write(PLIST_XML_STRING_END);
        } else if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                PropertyList.writeStringWithIndent(PLIST_XML_BOOLEAN_TRUE, n, writer);
            } else {
                PropertyList.writeStringWithIndent(PLIST_XML_BOOLEAN_FALSE, n, writer);
            }
        } else {
            throw new IllegalArgumentException("unexpected object type = \"" + object.getClass().toString() + "\"");
        }
    }

    public static void writeStringWithIndent(String string, int n, Writer writer) throws IOException {
        for (int i = 0; i < n; ++i) {
            writer.write(9);
        }
        writer.write(string);
    }

    public static void writeMinimallyEscapedXML(String string, Writer writer) throws IOException {
        int n = string.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    writer.write("&amp;");
                    continue block5;
                }
                case '<': {
                    writer.write("&lt;");
                    continue block5;
                }
                case '>': {
                    writer.write("&gt;");
                    continue block5;
                }
                default: {
                    writer.write(c);
                }
            }
        }
    }

    public static Object deepCopy(Object object) {
        HashMap<Object, Object> hashMap;
        if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                arrayList2.add(PropertyList.deepCopy(iterator.next()));
            }
            hashMap = arrayList2;
        } else if (object instanceof byte[]) {
            hashMap = ((byte[])object).clone();
        } else if (object instanceof Date) {
            hashMap = ((Date)object).clone();
        } else if (object instanceof Map) {
            Map map = (Map)object;
            HashMap<Object, Object> hashMap2 = new HashMap<Object, Object>();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                hashMap2.put(PropertyList.deepCopy(entry.getKey()), PropertyList.deepCopy(entry.getValue()));
            }
            hashMap = hashMap2;
        } else if (object instanceof Long) {
            hashMap = object;
        } else if (object instanceof Double) {
            hashMap = object;
        } else if (object instanceof String) {
            hashMap = object;
        } else if (object instanceof Boolean) {
            hashMap = object;
        } else {
            throw new IllegalArgumentException("unexpected object type = \"" + object.getClass().toString() + "\"");
        }
        return hashMap;
    }

    public static boolean isCompatibleObject(Object object) {
        return object != null && (object instanceof ArrayList || object instanceof Boolean || object instanceof byte[] || object instanceof Date || object instanceof Map || object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof String);
    }

    protected static SAXParser getParser() throws SAXException, ParserConfigurationException, FactoryConfigurationError {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        return sAXParserFactory.newSAXParser();
    }

    protected static final class Handler
    extends DefaultHandler {
        public static final String APPLE_PROPERTY_LIST_DTD_URL_PREFIX = "http://www.apple.com/DTDs/PropertyList";
        public static final String APPLE_PROPERTY_LIST_DTD = "<!ENTITY % plistObject \"(array | data | date | dict | real | integer | string | true | false )\" >\n<!ELEMENT plist %plistObject;>\n<!ATTLIST plist version CDATA \"1.0\" >\n<!ELEMENT array (%plistObject;)*>\n<!ELEMENT dict (key, %plistObject;)*>\n<!ELEMENT key (#PCDATA)>\n<!ELEMENT string (#PCDATA)>\n<!ELEMENT data (#PCDATA)>\n<!ELEMENT date (#PCDATA)>\n<!ELEMENT true EMPTY>\n<!ELEMENT false EMPTY>\n<!ELEMENT real (#PCDATA)>\n<!ELEMENT integer (#PCDATA)>";
        protected static final String ELEMENT_NAME_PLIST = "plist";
        protected static final String ELEMENT_NAME_KEY = "key";
        protected static final String ELEMENT_NAME_ARRAY = "array";
        protected static final String ELEMENT_NAME_DATA = "data";
        protected static final String ELEMENT_NAME_DATE = "date";
        protected static final String ELEMENT_NAME_DICTIONARY = "dict";
        protected static final String ELEMENT_NAME_INTEGER = "integer";
        protected static final String ELEMENT_NAME_REAL = "real";
        protected static final String ELEMENT_NAME_STRING = "string";
        protected static final String ELEMENT_NAME_TRUE = "true";
        protected static final String ELEMENT_NAME_FALSE = "false";
        protected Node rootNode;
        protected Node currentNode;

        protected Handler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            Node node = new Node();
            if (string2 != null && string2.length() > 0) {
                node.name = string2;
            } else if (string3 != null && string3.length() > 0) {
                node.name = string3;
            } else {
                throw new IllegalArgumentException("null or empty XML node name");
            }
            if (this.currentNode != null) {
                node.parent = this.currentNode;
                if (this.currentNode.lastChild != null) {
                    this.currentNode.lastChild.next = node;
                } else {
                    this.currentNode.firstChild = node;
                }
                this.currentNode.lastChild = node;
            } else {
                this.rootNode = node;
            }
            this.currentNode = node;
        }

        public void endElement(String string, String string2, String string3) {
            if (this.currentNode != null) {
                this.currentNode = this.currentNode.parent;
            }
        }

        public void characters(char[] cArray, int n, int n2) {
            if (this.currentNode != null) {
                if (this.currentNode.data == null) {
                    this.currentNode.data = new StringBuffer();
                }
                this.currentNode.data.append(cArray, n, n2);
            }
        }

        public Object postProcess() throws ParseException, UnsupportedEncodingException {
            if (this.rootNode == null || !this.rootNode.name.equals(ELEMENT_NAME_PLIST)) {
                throw new IllegalArgumentException("no top-level plist element");
            }
            if (this.rootNode.firstChild == null) {
                throw new IllegalArgumentException("no element underneath plist element");
            }
            return this.postProcessNode(this.rootNode.firstChild);
        }

        public Object postProcessNode(Node node) throws ParseException, UnsupportedEncodingException {
            Object object;
            if (node.name.equals(ELEMENT_NAME_ARRAY)) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Node node2 = node.firstChild;
                while (node2 != null) {
                    arrayList.add(this.postProcessNode(node2));
                    node2 = node2.next;
                }
                object = arrayList;
            } else if (node.name.equals(ELEMENT_NAME_DATA)) {
                object = node.data != null ? (Object)Base64.decode(node.data.toString()) : (Object)new byte[0];
            } else if (node.name.equals(ELEMENT_NAME_DATE)) {
                if (node.data == null) {
                    throw new IllegalArgumentException("no content for date element");
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(PropertyList.PLIST_DATE_FORMAT);
                object = simpleDateFormat.parse(node.data.toString());
            } else if (node.name.equals(ELEMENT_NAME_DICTIONARY)) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                Node node3 = node.firstChild;
                while (node3 != null) {
                    if (!node3.name.equals(ELEMENT_NAME_KEY)) {
                        throw new IllegalArgumentException("invalid key node type = \"" + node3.name + "\"");
                    }
                    if (node3.next == null) {
                        throw new IllegalArgumentException("key node without value node following it = \"" + node3.name + "\"");
                    }
                    String string = node3.data != null ? node3.data.toString() : "";
                    hashMap.put(string, this.postProcessNode(node3.next));
                    node3 = node3.next;
                    node3 = node3.next;
                }
                object = hashMap;
            } else if (node.name.equals(ELEMENT_NAME_INTEGER)) {
                if (node.data == null) {
                    throw new IllegalArgumentException("no content for integer element");
                }
                object = Long.valueOf(node.data.toString());
            } else if (node.name.equals(ELEMENT_NAME_REAL)) {
                if (node.data == null) {
                    throw new IllegalArgumentException("no content for real element");
                }
                object = Double.valueOf(node.data.toString());
            } else if (node.name.equals(ELEMENT_NAME_STRING)) {
                object = node.data != null ? node.data.toString() : "";
            } else if (node.name.equals(ELEMENT_NAME_TRUE)) {
                object = Boolean.TRUE;
            } else if (node.name.equals(ELEMENT_NAME_FALSE)) {
                object = Boolean.FALSE;
            } else {
                throw new IllegalArgumentException("unexpected node type = \"" + node.name + "\"");
            }
            return object;
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            if (string2.startsWith(APPLE_PROPERTY_LIST_DTD_URL_PREFIX)) {
                return new InputSource(new StringReader(APPLE_PROPERTY_LIST_DTD));
            }
            return null;
        }

        protected static final class Node {
            public Node next;
            public Node parent;
            public Node firstChild;
            public Node lastChild;
            public String name;
            public StringBuffer data;

            protected Node() {
            }
        }
    }
}

