/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.update;

import com.apple.mrj.MRJFileUtils;
import com.apple.net.acp.AcpPropertyCode;
import com.apple.util.Gestalt;
import com.apple.util.VersionNumber;
import com.apple.util.plist.PListUtils;
import com.apple.util.plist.PropertyList;
import com.apple.util.plist.PropertyListException;
import com.apple.xsr.AquaAlert;
import com.apple.xsr.AquaAlertAdapter;
import com.apple.xsr.RaidAdmin;
import com.apple.xsr.Resources;
import com.apple.xsr.net.AcpxCommandException;
import com.apple.xsr.net.AcpxConstants;
import com.apple.xsr.net.MessageFactory;
import com.apple.xsr.net.RequestMessage;
import com.apple.xsr.net.Response;
import com.apple.xsr.net.UpdateFirmwareRequest;
import com.apple.xsr.som.RaidSystem;
import com.apple.xsr.update.FirmwareBundleConnection;
import com.apple.xsr.update.FirmwareUpdatePane;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class FirmwareUpdater
implements ActionListener {
    private RaidSystem system;
    private String password;
    private String bundlePath;
    private JFrame root;
    private FirmwareUpdatePane updatePane;
    private AquaAlert dialog;
    private VersionNumber currentCpTop;
    private VersionNumber currentCpBottom;
    private VersionNumber currentRcTop;
    private VersionNumber currentRcBottom;
    private VersionNumber newCoprocessorUpdateVersion;
    private String newCoprocessorUpdateVersionString = "?";
    private String newCoprocessorUpdateDate;
    private VersionNumber newRaidControllerUpdateVersion;
    private String newRaidControllerUpdateVersionString = "?";
    private String newRaidControllerUpdateDate;
    private boolean[] diskCacheSettingsTop;
    private boolean[] diskCacheSettingsBottom;
    private boolean controllerCacheEnabledTop;
    private boolean controllerCacheEnabledBottom;
    private boolean restoreCacheError = false;
    private Thread updateThread;
    private static final Attributes.Name RAID_CONTROLLER_UPDATE_IMAGE = new Attributes.Name("xserveraid-raid-controller-update-image");
    private static final Attributes.Name COPROCESSOR_FULL_IMAGE = new Attributes.Name("xserveraid-coprocessor-full-image");
    private static final Attributes.Name COPROCESSOR_UPDATE_IMAGE = new Attributes.Name("xserveraid-coprocessor-update-image");
    private static final String FIRMWARE_VERSION = "firmware-version";
    private static final String FIRMWARE_DATE = "firmware-date";
    private static final int IO_ERR = -102;
    private static final int RESPONSE_FORMAT_ERR = -103;
    private static final String EXTENSION = Resources.getString("fwUpdate.bundleExtension");
    private static final int RESTART_DELAY = 40;
    private static final int RC_FLASH_DELAY = 60;
    private static final String MIN_ATLAS_VERSION_FOR_RC_VERSION_PROPERTY = "1.2.0";
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$update$FirmwareUpdater == null ? (class$com$apple$xsr$update$FirmwareUpdater = FirmwareUpdater.class$("com.apple.xsr.update.FirmwareUpdater")) : class$com$apple$xsr$update$FirmwareUpdater);
    static /* synthetic */ Class class$com$apple$xsr$update$FirmwareUpdater;

    public FirmwareUpdater(Component component, RaidSystem raidSystem, String string) {
        int n;
        if (raidSystem == null) {
            throw new NullPointerException("system cannot be null");
        }
        this.system = raidSystem;
        Component component2 = SwingUtilities.getRoot(component);
        if (component2 == null || !(component2 instanceof JFrame)) {
            throw new NullPointerException("Root frame for " + component.getName() + " not a JFrame");
        }
        this.root = (JFrame)component2;
        this.password = string;
        this.diskCacheSettingsTop = new boolean[7];
        for (n = 0; n < this.diskCacheSettingsTop.length; ++n) {
            this.diskCacheSettingsTop[n] = false;
        }
        this.diskCacheSettingsBottom = new boolean[7];
        for (n = 0; n < this.diskCacheSettingsBottom.length; ++n) {
            this.diskCacheSettingsBottom[n] = false;
        }
        this.updatePane = new FirmwareUpdatePane(this.system.getName());
        this.bundlePath = this.getBundlePath();
        logger.info("Bundle path = \"" + this.bundlePath + "\"");
        if (this.bundlePath != null) {
            try {
                this.initUpdatePane();
                this.dialog = new AquaAlert(this.updatePane, null, null, null);
                this.dialog.addAquaAlertListener(new UpdateSheetListener());
                this.dialog.showSheet(this.root);
            }
            catch (Exception exception) {
                logger.error(exception);
            }
        } else {
            logger.info("User cancelled the Open Bundle file dialog");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("ACTION_CMD_UPDATE")) {
            this.root.getRootPane().setDefaultButton(null);
            this.updatePane.setMode("UPDATE");
            this.dialog.resizeVertically();
        } else if (actionEvent.getActionCommand().equals("ACTION_CMD_CANCEL") || actionEvent.getActionCommand().equals("ACTION_CMD_OK")) {
            this.dialog.dismissSheetOrDialog(1);
        }
    }

    private synchronized void startUpdate() {
        if (this.updateThread == null) {
            this.system.setPollingEnabled(false);
            this.updateThread = new UpdateThread();
            this.updateThread.start();
        } else {
            logger.error("Error! Attempt to call startUpdate after an update has already begun.");
        }
    }

    private void updateComplete(int n, String string) {
        this.updatePane.setMode("COMPLETE");
        this.updatePane.setStatusMessage(string);
        this.root.getRootPane().setDefaultButton(this.updatePane.getDefaultButton());
        if (n == 0) {
            String string2 = this.newCoprocessorUpdateVersionString;
            String string3 = this.newRaidControllerUpdateVersionString;
            this.updatePane.setCurrentCoprocessorVersions(string2, string2);
            this.updatePane.setCurrentRaidControllerVersions(string3, string3);
            this.updatePane.setCoprocessorNeedsUpdate(false);
            this.updatePane.setRaidControllerNeedsUpdate(false);
        }
        if (this.restoreCacheError) {
            this.updatePane.setErrorMessage(Resources.getString("fwUpdate.statusMessage.restoreCache.failure"));
        }
        this.dialog.resizeVertically();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBundlePath() {
        FileDialog fileDialog = null;
        String string = null;
        try {
            fileDialog = this.createFileDialog();
            fileDialog.show();
            if (fileDialog.getDirectory() != null && fileDialog.getFile() != null) {
                string = fileDialog.getDirectory() + fileDialog.getFile();
            }
        }
        finally {
            if (fileDialog != null) {
                fileDialog.dispose();
            }
        }
        return string;
    }

    private FileDialog createFileDialog() {
        String string = Resources.getString("fwUpdate.chooseBundleLabel");
        String string2 = null;
        if (Gestalt.isMacOS()) {
            try {
                string2 = MRJFileUtils.findFolder(MRJFileUtils.kDesktopFolderType).getPath();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(EXTENSION);
            }
        };
        FileDialog fileDialog = new FileDialog((Frame)this.root, string, 0);
        if (RaidAdmin.lastFirmwareFilePath != null) {
            fileDialog.setDirectory(RaidAdmin.lastFirmwareFilePath);
        } else if (string2 != null) {
            fileDialog.setDirectory(string2);
        }
        fileDialog.setFilenameFilter(filenameFilter);
        return fileDialog;
    }

    private void initUpdatePane() throws Exception {
        boolean bl;
        Attributes attributes;
        try {
            this.currentCpTop = VersionNumber.newAppleVersionNumber(this.system.getSystemController(1).getSystemVersion());
        }
        catch (ParseException parseException) {
            logger.warn("Unable to parse top coprocessor version \"" + this.system.getSystemController(1).getSystemVersion() + "\"");
            this.currentCpTop = null;
        }
        try {
            this.currentCpBottom = VersionNumber.newAppleVersionNumber(this.system.getSystemController(2).getSystemVersion());
        }
        catch (ParseException parseException) {
            logger.warn("Unable to parse bottom coprocessor version \"" + this.system.getSystemController(2).getSystemVersion() + "\"");
            this.currentCpBottom = null;
        }
        try {
            this.currentRcTop = VersionNumber.newAcsVersionNumber(this.system.getRaidController(1).getFirmwareVersion());
        }
        catch (ParseException parseException) {
            logger.warn("Unable to parse top RAID controller version \"" + this.system.getRaidController(1).getFirmwareVersion() + "\"");
            this.currentRcTop = null;
        }
        try {
            this.currentRcBottom = VersionNumber.newAcsVersionNumber(this.system.getRaidController(2).getFirmwareVersion());
        }
        catch (ParseException parseException) {
            logger.warn("Unable to parse bottom RAID controller version \"" + this.system.getRaidController(2).getFirmwareVersion() + "\"");
            this.currentRcBottom = null;
        }
        FirmwareBundleConnection firmwareBundleConnection = new FirmwareBundleConnection("jar:file:" + this.bundlePath + "!/");
        Manifest manifest = firmwareBundleConnection.getManifest();
        Attributes attributes2 = manifest.getMainAttributes();
        String string = null;
        String string2 = null;
        String string3 = null;
        if (attributes2.containsKey(COPROCESSOR_FULL_IMAGE)) {
            string2 = attributes2.getValue(COPROCESSOR_FULL_IMAGE);
        }
        if (attributes2.containsKey(COPROCESSOR_UPDATE_IMAGE)) {
            string3 = attributes2.getValue(COPROCESSOR_UPDATE_IMAGE);
        }
        if (attributes2.containsKey(RAID_CONTROLLER_UPDATE_IMAGE)) {
            string = attributes2.getValue(RAID_CONTROLLER_UPDATE_IMAGE);
        }
        if (string3 != null) {
            attributes = manifest.getAttributes(string3);
            this.newCoprocessorUpdateVersionString = attributes.getValue(FIRMWARE_VERSION);
            try {
                this.newCoprocessorUpdateVersion = VersionNumber.newAppleVersionNumber(attributes.getValue(FIRMWARE_VERSION));
                logger.info("Coprocessor Update     -- Version: " + this.newCoprocessorUpdateVersion);
            }
            catch (ParseException parseException) {
                logger.warn("Coprocessor Update     -- Version: " + parseException);
            }
            this.newCoprocessorUpdateDate = attributes.getValue(FIRMWARE_DATE);
            logger.info("Coprocessor Update     -- Date: " + this.newCoprocessorUpdateDate);
        } else {
            logger.info("Coprocessor Update     -- Not found!");
        }
        if (string != null) {
            attributes = manifest.getAttributes(string);
            this.newRaidControllerUpdateVersionString = attributes.getValue(FIRMWARE_VERSION);
            try {
                this.newRaidControllerUpdateVersion = VersionNumber.newAcsVersionNumber(attributes.getValue(FIRMWARE_VERSION));
                logger.info("RAID Controller Update -- Version: " + this.newRaidControllerUpdateVersion);
            }
            catch (ParseException parseException) {
                logger.warn("RAID Controller Update -- Version: " + parseException);
            }
            this.newRaidControllerUpdateDate = attributes.getValue(FIRMWARE_DATE);
            logger.info("RAID Controller Update -- Date: " + this.newRaidControllerUpdateDate);
        } else {
            logger.info("RAID Controller Update -- Not found!");
        }
        this.updatePane.setCurrentCoprocessorVersions(this.currentCpTop, this.currentCpBottom);
        this.updatePane.setCurrentRaidControllerVersions(this.currentRcTop, this.currentRcBottom);
        if (this.currentCpTop == null || this.currentCpBottom == null || this.newCoprocessorUpdateVersion == null) {
            bl = true;
        } else {
            boolean bl2 = bl = this.currentCpTop.compareTo(this.newCoprocessorUpdateVersion) < 0;
        }
        boolean bl3 = this.currentRcTop == null || this.currentRcBottom == null || this.newRaidControllerUpdateVersion == null ? true : this.currentRcTop.compareTo(this.newRaidControllerUpdateVersion) < 0;
        this.updatePane.setCoprocessorNeedsUpdate(bl);
        this.updatePane.setRaidControllerNeedsUpdate(bl3);
        this.updatePane.setNewCoprocessorVersion(this.newCoprocessorUpdateVersionString);
        this.updatePane.setNewRaidControllerVersion(this.newRaidControllerUpdateVersionString);
        this.updatePane.addActionListener(this);
    }

    private int updateRaidController(RequestMessage.Target target) throws IOException, PropertyListException {
        Object object;
        Object object2;
        int n = 1;
        int n2 = 1;
        FirmwareBundleConnection firmwareBundleConnection = new FirmwareBundleConnection("jar:file:" + this.bundlePath + "!/raid-controller/updateROM.bin");
        UpdateFirmwareRequest updateFirmwareRequest = new UpdateFirmwareRequest(target, n, n2, firmwareBundleConnection.getInputStream());
        updateFirmwareRequest.setUser(this.system.getManagementUserId());
        updateFirmwareRequest.setPassword(this.password);
        try {
            object2 = target == RequestMessage.TARGET_TOP ? this.currentRcTop : this.currentRcBottom;
            object = VersionNumber.newAppleVersionNumber(MIN_ATLAS_VERSION_FOR_RC_VERSION_PROPERTY);
            if (object2 != null && ((VersionNumber)object2).compareTo((VersionNumber)object) >= 0) {
                updateFirmwareRequest.setRequestProperty("X-Apple-RAID-Firmware-Version", this.newRaidControllerUpdateVersionString);
            }
        }
        catch (ParseException parseException) {
            logger.error("Error attempting to add RAID firmware version property to request: " + parseException);
        }
        logger.info("Sending firmware update to " + (target == RequestMessage.TARGET_TOP ? "top" : "bottom") + " RAID controller...");
        object2 = this.system.postMessage(updateFirmwareRequest);
        object = (PropertyList)object2.getContent();
        logger.info("Firmware update sent.");
        logger.info("Response:\n" + ((PropertyList)object).toString());
        Map map = PListUtils.toDictionary(((PropertyList)object).getRootElement());
        int n3 = PListUtils.toInteger(map.get("status"), "status").intValue();
        return n3;
    }

    private int updateCoprocessor(RequestMessage.Target target) throws IOException, PropertyListException {
        int n = 0;
        int n2 = 1;
        FirmwareBundleConnection firmwareBundleConnection = new FirmwareBundleConnection("jar:file:" + this.bundlePath + "!/coprocessor/updateROM.bin");
        UpdateFirmwareRequest updateFirmwareRequest = new UpdateFirmwareRequest(target, n, n2, firmwareBundleConnection.getInputStream());
        updateFirmwareRequest.setUser(this.system.getManagementUserId());
        updateFirmwareRequest.setPassword(this.password);
        logger.info("Sending firmware update to " + (target == RequestMessage.TARGET_TOP ? "top" : "bottom") + " coprocessor...");
        Response response = this.system.postMessage(updateFirmwareRequest);
        PropertyList propertyList = (PropertyList)response.getContent();
        logger.info("Firmware update sent.");
        logger.info("Response:\n" + propertyList.toString());
        Map map = PListUtils.toDictionary(propertyList.getRootElement());
        int n3 = PListUtils.toInteger(map.get("status"), "status").intValue();
        return n3;
    }

    private void disableDiskCaches(int n) throws Exception {
        boolean[] blArray = this.system.getDiskCacheSettings(n);
        int n2 = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            RequestMessage requestMessage = this.system.getMessageFactory().newSetDriveCacheControlRequest(i + 1, false);
            requestMessage.setUser(this.system.getManagementUserId());
            requestMessage.setPassword(this.password);
            Response response = this.system.postMessage(requestMessage, n);
            if (response.getResultCode() == 0) continue;
            logger.error("\"/raid/drive/cache-control\" request failed (" + response.getResultCode() + ")");
            ++n2;
        }
        if (n == 1) {
            this.diskCacheSettingsTop = blArray;
        } else {
            this.diskCacheSettingsBottom = blArray;
        }
        if (n2 != 0) {
            throw new AcpxCommandException(n2 + " \"/raid/drive/cache-control\" request(s) failed");
        }
    }

    private void reenableDiskCaches(int n) throws Exception {
        boolean[] blArray = n == 1 ? this.diskCacheSettingsTop : this.diskCacheSettingsBottom;
        int n2 = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            RequestMessage requestMessage = this.system.getMessageFactory().newSetDriveCacheControlRequest(i + 1, true);
            requestMessage.setUser(this.system.getManagementUserId());
            requestMessage.setPassword(this.password);
            Response response = this.system.postMessage(requestMessage, n);
            if (response.getResultCode() == 0) continue;
            logger.error("\"/raid/drive/cache-control\" request failed (" + response.getResultCode() + ")");
            ++n2;
        }
        if (n2 != 0) {
            throw new AcpxCommandException(n2 + " \"/raid/drive/cache-control\" request(s) failed");
        }
    }

    private void disableControllerCache(int n) throws Exception {
        boolean bl = this.system.getRaidControllerCacheEnabled(n);
        if (bl) {
            RequestMessage requestMessage = this.system.getMessageFactory().newSetRAIDCacheControlRequest(false);
            requestMessage.setUser(this.system.getManagementUserId());
            requestMessage.setPassword(this.password);
            Response response = this.system.postMessage(requestMessage, n);
            if (response.getResultCode() != 0) {
                logger.error("/raid/cache-control\" request failed (" + response.getResultCode() + ")");
                throw new AcpxCommandException("get-page request failed (" + response.getResultCode() + ")");
            }
        }
        if (n == 1) {
            this.controllerCacheEnabledTop = bl;
        } else {
            this.controllerCacheEnabledBottom = bl;
        }
    }

    private void reenableControllerCache(int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n == 1 ? this.controllerCacheEnabledTop : this.controllerCacheEnabledBottom;
        if (bl) {
            RequestMessage requestMessage = this.system.getMessageFactory().newSetRAIDCacheControlRequest(true);
            requestMessage.setUser(this.system.getManagementUserId());
            requestMessage.setPassword(this.password);
            Response response = this.system.postMessage(requestMessage, n);
            if (response.getResultCode() != 0) {
                logger.error("/raid/cache-control\" request failed (" + response.getResultCode() + ")");
                throw new AcpxCommandException("get-page request failed (" + response.getResultCode() + ")");
            }
        }
    }

    private void debugCurrentVersions() {
        Map map;
        Map map2;
        PropertyList propertyList;
        Response response;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        MessageFactory messageFactory = this.system.getMessageFactory();
        RequestMessage requestMessage = messageFactory.newGetPropertyRequest(AcpPropertyCode.SYS_VERSION);
        try {
            response = this.system.postMessage(requestMessage, 1);
            propertyList = (PropertyList)response.getContent();
            map2 = PListUtils.toDictionary(propertyList.getRootElement());
            map = PListUtils.toDictionary(map2.get("syVs"));
            string = PListUtils.toString(map.get("data"));
        }
        catch (IOException iOException) {
        }
        catch (PropertyListException propertyListException) {
            // empty catch block
        }
        try {
            response = this.system.postMessage(requestMessage, 2);
            propertyList = (PropertyList)response.getContent();
            map2 = PListUtils.toDictionary(propertyList.getRootElement());
            map = PListUtils.toDictionary(map2.get("syVs"));
            string2 = PListUtils.toString(map.get("data"));
        }
        catch (IOException iOException) {
        }
        catch (PropertyListException propertyListException) {
            // empty catch block
        }
        requestMessage = messageFactory.newGetControllerPageRequest(AcpxConstants.CONTROLLER_PAGE_0);
        try {
            response = this.system.postMessage(requestMessage, 1);
            propertyList = (PropertyList)response.getContent();
            map2 = PListUtils.toDictionary(propertyList.getRootElement());
            map = PListUtils.toDictionary(map2.get("get-page"));
            string3 = PListUtils.toString(map.get(FIRMWARE_VERSION));
        }
        catch (IOException iOException) {
        }
        catch (PropertyListException propertyListException) {
            // empty catch block
        }
        try {
            response = this.system.postMessage(requestMessage, 2);
            propertyList = (PropertyList)response.getContent();
            map2 = PListUtils.toDictionary(propertyList.getRootElement());
            map = PListUtils.toDictionary(map2.get("get-page"));
            string4 = PListUtils.toString(map.get(FIRMWARE_VERSION));
        }
        catch (IOException iOException) {
        }
        catch (PropertyListException propertyListException) {
            // empty catch block
        }
        logger.info("Atlas Top: " + string);
        logger.info("Atlas Bottom: " + string2);
        logger.info("RAID Controller Top: " + string3);
        logger.info("RAID Controller Bottom: " + string4);
    }

    private void dumpManifest(Manifest manifest) {
        Object object;
        Set<Map.Entry<Object, Object>> set = manifest.getMainAttributes().entrySet();
        Object object2 = set.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            System.out.println("Key: " + object.getKey());
            System.out.println("Attribute: " + object.getValue());
        }
        System.out.println();
        object2 = manifest.getEntries().entrySet();
        object = object2.iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            System.out.println("Key: " + entry.getKey());
            System.out.println("Attributes:");
            Set<Map.Entry<Object, Object>> set2 = ((Attributes)entry.getValue()).entrySet();
            Iterator<Map.Entry<Object, Object>> iterator = set2.iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry2 = iterator.next();
                System.out.println("Attrib Key: " + entry2.getKey());
                System.out.println("Attrib Value: " + entry2.getValue());
            }
            System.out.println();
        }
    }

    private void debugVersionsForManifest(Manifest manifest) {
        Attributes attributes = manifest.getAttributes("coprocessor/updateROM.bin");
        String string = attributes.getValue(FIRMWARE_VERSION);
        String string2 = attributes.getValue(FIRMWARE_DATE);
        Attributes attributes2 = manifest.getAttributes("raid-controller/updateROM.bin");
        String string3 = attributes2.getValue(FIRMWARE_VERSION);
        String string4 = attributes2.getValue(FIRMWARE_DATE);
        System.out.println("Atlas (Coprocessor) Update Version: " + string);
        System.out.println("Atlas (Coprocessor) Date: " + string2);
        System.out.println("RAID Controller Version: " + string3);
        System.out.println("RAID Controller Date: " + string4);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class UpdateThread
    extends Thread {
        private UpdateThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block51: {
                block50: {
                    block49: {
                        block48: {
                            boolean bl = FirmwareUpdater.this.updatePane.isUpdateAllSelected();
                            try {
                                try {
                                    Response response;
                                    VersionNumber versionNumber;
                                    String string;
                                    RequestMessage.Target target;
                                    VersionNumber versionNumber2;
                                    String string2;
                                    RequestMessage.Target target2;
                                    int n;
                                    if (bl || FirmwareUpdater.this.newRaidControllerUpdateVersion == null || FirmwareUpdater.this.currentRcTop == null || FirmwareUpdater.this.currentRcBottom == null || FirmwareUpdater.this.currentRcTop.compareTo(FirmwareUpdater.this.newRaidControllerUpdateVersion) != 0) {
                                        FirmwareUpdater.this.updatePane.setStatusMessage(Resources.getStringWithReplacement("fwUpdate.statusMessage.updatingRaidControllers", new Object[]{"version", FirmwareUpdater.this.newRaidControllerUpdateVersionString}));
                                        try {
                                            logger.info("Disabling top disk caches");
                                            FirmwareUpdater.this.disableDiskCaches(1);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        try {
                                            logger.info("Disabling top controller cache");
                                            FirmwareUpdater.this.disableControllerCache(1);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        FirmwareUpdater.this.updatePane.setStatusMessage(Resources.getStringWithReplacement("fwUpdate.statusMessage.updatingRaidController", new Object[]{"location", Resources.getString("fwUpdate.topLocation"), "version", FirmwareUpdater.this.newRaidControllerUpdateVersionString}));
                                        n = FirmwareUpdater.this.updateRaidController(RequestMessage.TARGET_TOP);
                                        if (n != 0) {
                                            FirmwareUpdater.this.updateComplete(n, Resources.getStringWithReplacement("fwUpdate.statusMessage.errorUpdatingRaidController", new Object[]{"location", Resources.getString("fwUpdate.topLocation"), "status", n + ""}));
                                            logger.error("Error flashing top RAID controller: " + n);
                                            Object var13_18 = null;
                                            FirmwareUpdater.this.system.clear();
                                            FirmwareUpdater.this.system.authenticate(null, FirmwareUpdater.this.system.getMonitoringUserId(), FirmwareUpdater.this.system.getMonitoringPassword(), false);
                                            FirmwareUpdater.this.system.setPollingEnabled(true);
                                            return;
                                        }
                                        try {
                                            logger.info("Waiting 60 secs for top RAID controller to restart...");
                                            Thread.sleep(70000L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                        try {
                                            logger.info("Polling for top RAID controller online...");
                                            FirmwareUpdater.this.system.pollForRaidControllerOnline(1);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                        try {
                                            logger.info("Re-enabling top disk caches");
                                            FirmwareUpdater.this.reenableDiskCaches(1);
                                        }
                                        catch (Exception exception) {
                                            FirmwareUpdater.this.restoreCacheError = true;
                                        }
                                        try {
                                            logger.info("Re-enabling top controller cache");
                                            FirmwareUpdater.this.reenableControllerCache(1);
                                        }
                                        catch (Exception exception) {
                                            FirmwareUpdater.this.restoreCacheError = true;
                                        }
                                    }
                                    if (bl || FirmwareUpdater.this.currentRcTop == null || FirmwareUpdater.this.currentRcBottom == null || FirmwareUpdater.this.newRaidControllerUpdateVersion == null || FirmwareUpdater.this.currentRcBottom.compareTo(FirmwareUpdater.this.newRaidControllerUpdateVersion) != 0) {
                                        try {
                                            logger.info("Disabling bottom disk caches");
                                            FirmwareUpdater.this.disableDiskCaches(2);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        try {
                                            logger.info("Disabling bottom controller cache");
                                            FirmwareUpdater.this.disableControllerCache(2);
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                        FirmwareUpdater.this.updatePane.setStatusMessage(Resources.getStringWithReplacement("fwUpdate.statusMessage.updatingRaidController", new Object[]{"location", Resources.getString("fwUpdate.bottomLocation"), "version", FirmwareUpdater.this.newRaidControllerUpdateVersionString}));
                                        n = FirmwareUpdater.this.updateRaidController(RequestMessage.TARGET_BOTTOM);
                                        if (n != 0) {
                                            FirmwareUpdater.this.updateComplete(n, Resources.getStringWithReplacement("fwUpdate.statusMessage.errorUpdatingRaidController", new Object[]{"location", Resources.getString("fwUpdate.bottomLocation"), "status", n + ""}));
                                            logger.error("Error flashing bottom RAID controller: " + n);
                                            break block48;
                                        }
                                        try {
                                            logger.info("Waiting 60 secs for bottom RAID controller to restart...");
                                            Thread.sleep(60000L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                        try {
                                            logger.info("Polling for bottom RAID controller online...");
                                            FirmwareUpdater.this.system.pollForRaidControllerOnline(2);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                        try {
                                            logger.info("Re-enabling bottom disk caches");
                                            FirmwareUpdater.this.reenableDiskCaches(2);
                                        }
                                        catch (Exception exception) {
                                            FirmwareUpdater.this.restoreCacheError = true;
                                        }
                                        try {
                                            logger.info("Re-enabling bottom controller cache");
                                            FirmwareUpdater.this.reenableControllerCache(2);
                                        }
                                        catch (Exception exception) {
                                            FirmwareUpdater.this.restoreCacheError = true;
                                        }
                                    }
                                    if (FirmwareUpdater.this.system.getPrimarySystemController().getId() == 1) {
                                        target2 = RequestMessage.TARGET_TOP;
                                        string2 = Resources.getString("fwUpdate.topLocation");
                                        versionNumber2 = FirmwareUpdater.this.currentCpTop;
                                        target = RequestMessage.TARGET_BOTTOM;
                                        string = Resources.getString("fwUpdate.bottomLocation");
                                        versionNumber = FirmwareUpdater.this.currentCpBottom;
                                    } else {
                                        target2 = RequestMessage.TARGET_BOTTOM;
                                        string2 = Resources.getString("fwUpdate.bottomLocation");
                                        versionNumber2 = FirmwareUpdater.this.currentCpBottom;
                                        target = RequestMessage.TARGET_TOP;
                                        string = Resources.getString("fwUpdate.topLocation");
                                        versionNumber = FirmwareUpdater.this.currentCpTop;
                                    }
                                    if (bl || versionNumber2 == null || versionNumber == null || FirmwareUpdater.this.newCoprocessorUpdateVersion == null || versionNumber.compareTo(FirmwareUpdater.this.newCoprocessorUpdateVersion) != 0) {
                                        FirmwareUpdater.this.updatePane.setStatusMessage(Resources.getStringWithReplacement("fwUpdate.statusMessage.updatingCoprocessor", new Object[]{"location", string, "version", FirmwareUpdater.this.newCoprocessorUpdateVersionString}));
                                        n = FirmwareUpdater.this.updateCoprocessor(target);
                                        if (n != 0) {
                                            FirmwareUpdater.this.updateComplete(n, Resources.getStringWithReplacement("fwUpdate.statusMessage.errorUpdatingCoprocessor", new Object[]{"location", string, "status", n + ""}));
                                            logger.error("Error flashing " + string + " coprocessor: " + n);
                                            break block49;
                                        }
                                    }
                                    if (bl || versionNumber2 == null || versionNumber == null || FirmwareUpdater.this.newCoprocessorUpdateVersion == null || versionNumber2.compareTo(FirmwareUpdater.this.newCoprocessorUpdateVersion) != 0) {
                                        FirmwareUpdater.this.updatePane.setStatusMessage(Resources.getStringWithReplacement("fwUpdate.statusMessage.updatingCoprocessor", new Object[]{"location", string2, "version", FirmwareUpdater.this.newCoprocessorUpdateVersionString}));
                                        n = FirmwareUpdater.this.updateCoprocessor(target2);
                                        if (n != 0) {
                                            FirmwareUpdater.this.updateComplete(n, Resources.getStringWithReplacement("fwUpdate.statusMessage.errorUpdatingCoprocessor", new Object[]{"location", string2, "status", n + ""}));
                                            logger.error("Error flashing " + string2 + " coprocessor: " + n);
                                            break block50;
                                        }
                                    }
                                    RequestMessage requestMessage = FirmwareUpdater.this.system.getMessageFactory().newRestartSystemRequest();
                                    requestMessage.setUser(FirmwareUpdater.this.system.getManagementUserId());
                                    requestMessage.setPassword(FirmwareUpdater.this.password);
                                    if (bl || versionNumber2 == null || versionNumber == null || FirmwareUpdater.this.newCoprocessorUpdateVersion == null || versionNumber.compareTo(FirmwareUpdater.this.newCoprocessorUpdateVersion) != 0) {
                                        FirmwareUpdater.this.updatePane.setStatusMessage(Resources.getStringWithReplacement("fwUpdate.statusMessage.restartingControllerModule", new Object[]{"location", string}));
                                        logger.info("Restarting " + string + " coprocessor...");
                                        requestMessage.setTargetController(target);
                                        response = FirmwareUpdater.this.system.postMessage(requestMessage);
                                        if (response.getResultCode() != 0) {
                                            // empty if block
                                        }
                                        logger.info("Pausing 40 seconds before restarting " + string2 + " coprocessor...");
                                        try {
                                            Thread.sleep(40000L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    }
                                    if (bl || versionNumber2 == null || versionNumber == null || FirmwareUpdater.this.newCoprocessorUpdateVersion == null || versionNumber2.compareTo(FirmwareUpdater.this.newCoprocessorUpdateVersion) != 0) {
                                        FirmwareUpdater.this.updatePane.setStatusMessage(Resources.getStringWithReplacement("fwUpdate.statusMessage.restartingControllerModule", new Object[]{"location", string2}));
                                        logger.info("Restarting " + string2 + " coprocessor...");
                                        requestMessage.setTargetController(target2);
                                        response = FirmwareUpdater.this.system.postMessage(requestMessage);
                                        if (response.getResultCode() != 0) {
                                            // empty if block
                                        }
                                        logger.info("Pausing 40 seconds to allow " + string2 + " coprocessor to finish rebooting...");
                                        try {
                                            Thread.sleep(40000L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    }
                                    FirmwareUpdater.this.updateComplete(0, Resources.getString("fwUpdate.statusMessage.updateComplete.success"));
                                    break block51;
                                }
                                catch (IOException iOException) {
                                    FirmwareUpdater.this.updateComplete(-102, Resources.getString("fwUpdate.statusMessage.updateComplete.failure"));
                                    logger.error(iOException);
                                    Object var13_23 = null;
                                    FirmwareUpdater.this.system.clear();
                                    FirmwareUpdater.this.system.authenticate(null, FirmwareUpdater.this.system.getMonitoringUserId(), FirmwareUpdater.this.system.getMonitoringPassword(), false);
                                    FirmwareUpdater.this.system.setPollingEnabled(true);
                                    return;
                                }
                                catch (PropertyListException propertyListException) {
                                    FirmwareUpdater.this.updateComplete(-103, Resources.getString("fwUpdate.statusMessage.updateComplete.failure"));
                                    logger.error("PropertyListException: " + propertyListException);
                                    Object var13_24 = null;
                                    FirmwareUpdater.this.system.clear();
                                    FirmwareUpdater.this.system.authenticate(null, FirmwareUpdater.this.system.getMonitoringUserId(), FirmwareUpdater.this.system.getMonitoringPassword(), false);
                                    FirmwareUpdater.this.system.setPollingEnabled(true);
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var13_25 = null;
                                FirmwareUpdater.this.system.clear();
                                FirmwareUpdater.this.system.authenticate(null, FirmwareUpdater.this.system.getMonitoringUserId(), FirmwareUpdater.this.system.getMonitoringPassword(), false);
                                FirmwareUpdater.this.system.setPollingEnabled(true);
                                throw throwable;
                            }
                        }
                        Object var13_19 = null;
                        FirmwareUpdater.this.system.clear();
                        FirmwareUpdater.this.system.authenticate(null, FirmwareUpdater.this.system.getMonitoringUserId(), FirmwareUpdater.this.system.getMonitoringPassword(), false);
                        FirmwareUpdater.this.system.setPollingEnabled(true);
                        return;
                    }
                    Object var13_20 = null;
                    FirmwareUpdater.this.system.clear();
                    FirmwareUpdater.this.system.authenticate(null, FirmwareUpdater.this.system.getMonitoringUserId(), FirmwareUpdater.this.system.getMonitoringPassword(), false);
                    FirmwareUpdater.this.system.setPollingEnabled(true);
                    return;
                }
                Object var13_21 = null;
                FirmwareUpdater.this.system.clear();
                FirmwareUpdater.this.system.authenticate(null, FirmwareUpdater.this.system.getMonitoringUserId(), FirmwareUpdater.this.system.getMonitoringPassword(), false);
                FirmwareUpdater.this.system.setPollingEnabled(true);
                return;
            }
            Object var13_22 = null;
            FirmwareUpdater.this.system.clear();
            FirmwareUpdater.this.system.authenticate(null, FirmwareUpdater.this.system.getMonitoringUserId(), FirmwareUpdater.this.system.getMonitoringPassword(), false);
            FirmwareUpdater.this.system.setPollingEnabled(true);
        }
    }

    private class UpdateSheetListener
    extends AquaAlertAdapter {
        private UpdateSheetListener() {
        }

        public void aquaAlertSheetVisible(Object object) {
            FirmwareUpdater.this.root.getRootPane().setDefaultButton(FirmwareUpdater.this.updatePane.getDefaultButton());
        }

        public void aquaAlertResized(Object object) {
            if (FirmwareUpdater.this.updatePane.getMode() == "UPDATE") {
                FirmwareUpdater.this.startUpdate();
            }
        }
    }
}

