/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.xsr.som.AbstractSystemElement;
import com.apple.xsr.som.RaidSet;

public class Slice
extends AbstractSystemElement
implements Comparable {
    public static final int LUN_ID_NONE = -1;
    private final int id;
    private int size = 0;
    private int lunId = -1;
    RaidSet raidSet;

    public Slice(RaidSet raidSet, int n) {
        this(raidSet, n, 0);
    }

    public Slice(RaidSet raidSet, int n, int n2) {
        if (raidSet == null) {
            throw new NullPointerException("parent RAID set cannot be null");
        }
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException("Illegal slice ID " + n);
        }
        this.raidSet = raidSet;
        this.id = n;
        this.size = n2;
    }

    public Slice(Slice slice) {
        this.id = slice.id;
        this.size = slice.size;
        this.lunId = slice.lunId;
        this.raidSet = slice.raidSet;
    }

    public int getNativeId() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return "Slice " + this.id;
    }

    public int getStatus() {
        return 0;
    }

    synchronized void setSize(int n) {
        if (this.size != n) {
            this.size = n;
        }
    }

    public synchronized int getSize() {
        return this.size;
    }

    synchronized void setLunId(int n) {
        if ((n < 0 || n > 7) && n != -1) {
            throw new IllegalArgumentException("Invalid LUN ID " + n);
        }
        if (this.lunId != n) {
            this.lunId = n;
        }
    }

    public synchronized int getLunId() {
        return this.lunId;
    }

    public synchronized boolean isMapped() {
        return this.lunId != -1;
    }

    public RaidSet getRaidSet() {
        return this.raidSet;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Slice)) {
            return false;
        }
        Slice slice = (Slice)object;
        return slice.id == this.id && slice.raidSet == this.raidSet;
    }

    public int hashCode() {
        int n = 13;
        n = 37 * n + this.id;
        n = 37 * n + (this.raidSet != null ? this.raidSet.hashCode() : 0);
        return n;
    }

    public int compareTo(Object object) {
        Slice slice = (Slice)object;
        return this.id - slice.id;
    }

    public synchronized String toString() {
        String string = this.getClass().getName() + "[";
        string = string + "id=" + this.id + ",";
        string = string + "size=" + this.size + ",";
        string = string + "lunId=" + this.lunId;
        string = string + "]";
        return string;
    }
}

