/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.net.acp.AcpPropertyCode;
import com.apple.util.VersionNumber;
import com.apple.util.plist.PListUtils;
import com.apple.util.plist.PropertyList;
import com.apple.util.plist.PropertyListException;
import com.apple.xsr.Utilities;
import com.apple.xsr.eventlog.EventLog;
import com.apple.xsr.net.AcpxCommandException;
import com.apple.xsr.net.AcpxConstants;
import com.apple.xsr.net.AcpxMessageFactory;
import com.apple.xsr.net.CommunicationHandler;
import com.apple.xsr.net.CommunicationsManager;
import com.apple.xsr.net.MessageFactory;
import com.apple.xsr.net.RequestMessage;
import com.apple.xsr.net.Response;
import com.apple.xsr.som.AbstractSystemElement;
import com.apple.xsr.som.Battery;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.DiskSlot;
import com.apple.xsr.som.Fan;
import com.apple.xsr.som.HostInterface;
import com.apple.xsr.som.NetworkInterface;
import com.apple.xsr.som.PowerSupply;
import com.apple.xsr.som.RaidController;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystemAgent;
import com.apple.xsr.som.SystemController;
import com.apple.xsr.som.SystemElement;
import com.apple.xsr.som.SystemEvent;
import com.apple.xsr.som.SystemEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class RaidSystem
extends AbstractSystemElement
implements SystemEventListener {
    public static final String DEFAULT_NAME = "Unknown Xserve Raid";
    public static final int DISK_SLOT_MIN_ID = 1;
    public static final int DISK_SLOT_MAX_ID = 14;
    public static final int CONTROLLER_MODULE_TOP = 1;
    public static final int CONTROLLER_MODULE_BOTTOM = 2;
    public static final int SYSTEM_CONTROLLER_MIN_ID = 1;
    public static final int SYSTEM_CONTROLLER_MAX_ID = 2;
    public static final int SYSTEM_CONTROLLER_1 = 1;
    public static final int SYSTEM_CONTROLLER_2 = 2;
    public static final int SYSTEM_CONTROLLER_TOP = 1;
    public static final int SYSTEM_CONTROLLER_BOTTOM = 2;
    public static final int RAID_CONTROLLER_MIN_ID = 1;
    public static final int RAID_CONTROLLER_MAX_ID = 2;
    public static final int RAID_CONTROLLER_1 = 1;
    public static final int RAID_CONTROLLER_2 = 2;
    public static final int RAID_CONTROLLER_TOP = 1;
    public static final int RAID_CONTROLLER_BOTTOM = 2;
    public static final int HOST_INTERFACE_MIN_ID = 1;
    public static final int HOST_INTERFACE_MAX_ID = 2;
    public static final int NETWORK_INTERFACE_MIN_ID = 1;
    public static final int NETWORK_INTERFACE_MAX_ID = 2;
    public static final int POWER_SUPPLY_MIN_ID = 1;
    public static final int POWER_SUPPLY_MAX_ID = 2;
    public static final int POWER_SUPPLY_LEFT = 1;
    public static final int POWER_SUPPLY_RIGHT = 2;
    public static final int BATTERY_MIN_ID = 1;
    public static final int BATTERY_MAX_ID = 2;
    public static final int BATTERY_LEFT = 1;
    public static final int BATTERY_RIGHT = 2;
    public static final int FAN_MIN_ID = 1;
    public static final int FAN_MAX_ID = 2;
    public static final int FAN_TOP = 1;
    public static final int FAN_BOTTOM = 2;
    public static final int AUTO_REBOOT_DISABLED = 0;
    public static final int AUTO_REBOOT_ENABLED = 1;
    public static final int AUDIBLE_ALARM_DISABLED = 0;
    public static final int AUDIBLE_ALARM_ENABLED = 1;
    public static final int UNLOCKED = 0;
    public static final int LOCKED = 1;
    public static final int SERVICE_ID_OFF = 0;
    public static final int SERVICE_ID_ON = 1;
    public static final int UPS_POWER_FAILURE = 0;
    public static final int UPS_LOW_BATTERY = 1;
    public static final int UPS_SHUTDOWN = 2;
    public static final int POWER_OFF = 0;
    public static final int POWER_ON = 1;
    public static final int POWER_UPS_BACKUP = 2;
    public static final String NON_LEGACY_SLICE_ID_MIN_COPROCESSOR_VERSION = "1.2";
    public static final String NON_LEGACY_LUN_ID_MIN_COPROCESSOR_VERSION = "1.2";
    public static final int TRANSLATE_TO_LEGACY = 0;
    public static final int TRANSLATE_FROM_LEGACY = 1;
    private String name = "Unknown Xserve Raid";
    private String primaryHostAddress;
    private String secondaryHostAddress;
    private String currentAddress;
    private String monitoringPassword;
    private String managementPassword;
    private boolean managementPasswordSaved;
    private boolean loggedOn = false;
    private long totalCapacity = -1L;
    private String contact = "";
    private String description = "";
    private String location = "";
    private int lockState = -1;
    private int serviceIdState = -1;
    private long timeOffset = Long.MAX_VALUE;
    private int uptime = -1;
    private int autoRebootState = -1;
    private int audibleAlarmState = -1;
    private int upsStatus = -1;
    private int powerState = -1;
    private EventLog eventLog = new EventLog();
    private int userMessageIndex = 0;
    private boolean userMessageIsAsync = false;
    private Timer userMessageTimer = null;
    public static final int USER_MESSAGE_INDEX_NONE = 0;
    public static final int USER_MESSAGE_INDEX_AUTHENTICATING = 1;
    public static final int USER_MESSAGE_INDEX_CONNECTING = 2;
    public static final int USER_MESSAGE_INDEX_GATHERING = 3;
    public static final int USER_MESSAGE_INDEX_CONNECTION_FAILURE = 4;
    public static final int USER_MESSAGE_INDEX_COMMUNICATIONS_ERROR = 5;
    public static final int USER_MESSAGE_INDEX_STANDBY_POWER_MODE = 6;
    public static final int USER_MESSAGE_INDEX_RESTARTING = 7;
    public static final int USER_MESSAGE_INDEX_SHUTTING_DOWN = 8;
    public static final int USER_MESSAGE_INDEX_POWERING_ON = 9;
    public static final int USER_MESSAGE_INDEX_RAID_CONTROLLER_NOT_READY = 10;
    public static final int USER_MESSAGE_INDEX_AUTHENTICATION_FAILURE = 11;
    public static final int USER_MESSAGE_INDEX_REQUESTING_UPDATE = 12;
    public static final int USER_MESSAGE_INDEX_CLEARING_EVENT_LOG = 13;
    private Map systemControllers = Collections.synchronizedSortedMap(new TreeMap());
    private Map raidControllers = Collections.synchronizedSortedMap(new TreeMap());
    private Map powerSupplies = Collections.synchronizedSortedMap(new TreeMap());
    private Map batteries = Collections.synchronizedSortedMap(new TreeMap());
    private Map fans = Collections.synchronizedSortedMap(new TreeMap());
    private int creationInProgressControllerID = -1;
    private int creationInProgressRaidSetID = -1;
    private CommunicationsManager comms;
    private MessageFactory messageFactory;
    private RaidSystemAgent agent;
    public static final long MODULE_BOOT_TIME = 60000L;
    public static final long WAIT_FOR_UPDATE_TIMEOUT = 300000L;
    private boolean pollStarted = false;
    private boolean pollFinished = false;
    public static final long WAIT_FOR_RAID_CONTROLLER_ONLINE_TIMEOUT = 120000L;
    private boolean waitingForTopRaidControllerOnline = false;
    private boolean waitingForBottomRaidControllerOnline = false;
    public static final long WAIT_FOR_RAID_SET_ONLINE_TIMEOUT = 120000L;
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$som$RaidSystem == null ? (class$com$apple$xsr$som$RaidSystem = RaidSystem.class$("com.apple.xsr.som.RaidSystem")) : class$com$apple$xsr$som$RaidSystem);
    static /* synthetic */ Class class$com$apple$xsr$som$RaidSystem;

    public RaidSystem(String string) {
        AbstractSystemElement abstractSystemElement;
        int n;
        if (string == null) {
            throw new NullPointerException("host address cannot be null");
        }
        this.primaryHostAddress = string;
        this.currentAddress = string;
        for (n = 1; n <= 2; ++n) {
            abstractSystemElement = new SystemController(n, this);
            this.systemControllers.put(new Integer(n), abstractSystemElement);
        }
        for (n = 1; n <= 2; ++n) {
            abstractSystemElement = new RaidController(n, this);
            this.raidControllers.put(new Integer(n), abstractSystemElement);
        }
        for (n = 1; n <= 2; ++n) {
            abstractSystemElement = new PowerSupply(n);
            this.powerSupplies.put(new Integer(n), abstractSystemElement);
        }
        for (n = 1; n <= 2; ++n) {
            abstractSystemElement = new Fan(n);
            this.addFan((Fan)abstractSystemElement);
        }
        this.comms = new CommunicationsManager(this);
        this.messageFactory = new AcpxMessageFactory();
        this.agent = new RaidSystemAgent(this);
    }

    public RaidSystem(RaidSystem raidSystem) {
        AbstractSystemElement abstractSystemElement;
        Object v;
        Map.Entry entry;
        this.name = raidSystem.name;
        this.primaryHostAddress = raidSystem.primaryHostAddress;
        this.secondaryHostAddress = raidSystem.secondaryHostAddress;
        this.currentAddress = raidSystem.currentAddress;
        this.monitoringPassword = raidSystem.monitoringPassword;
        this.managementPassword = raidSystem.managementPassword;
        this.managementPasswordSaved = raidSystem.managementPasswordSaved;
        this.loggedOn = raidSystem.loggedOn;
        this.totalCapacity = raidSystem.totalCapacity;
        this.contact = raidSystem.contact;
        this.description = raidSystem.description;
        this.location = raidSystem.location;
        this.lockState = raidSystem.lockState;
        this.serviceIdState = raidSystem.serviceIdState;
        this.timeOffset = raidSystem.timeOffset;
        this.uptime = raidSystem.uptime;
        this.autoRebootState = raidSystem.autoRebootState;
        this.audibleAlarmState = raidSystem.audibleAlarmState;
        this.upsStatus = raidSystem.upsStatus;
        this.powerState = raidSystem.powerState;
        this.userMessageIndex = raidSystem.userMessageIndex;
        this.userMessageIsAsync = raidSystem.userMessageIsAsync;
        this.eventLog = new EventLog(raidSystem.eventLog);
        Iterator iterator = raidSystem.systemControllers.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            v = entry.getValue();
            if (v == null) continue;
            abstractSystemElement = new SystemController((SystemController)v);
            abstractSystemElement.system = this;
            this.systemControllers.put(entry.getKey(), abstractSystemElement);
        }
        iterator = raidSystem.raidControllers.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            v = entry.getValue();
            if (v == null) continue;
            abstractSystemElement = new RaidController((RaidController)v);
            ((RaidController)abstractSystemElement).system = this;
            this.raidControllers.put(entry.getKey(), abstractSystemElement);
        }
        iterator = raidSystem.powerSupplies.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            v = entry.getValue();
            if (v == null) continue;
            abstractSystemElement = new PowerSupply((PowerSupply)v);
            this.powerSupplies.put(entry.getKey(), abstractSystemElement);
        }
        iterator = raidSystem.batteries.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            v = entry.getValue();
            if (v == null) continue;
            abstractSystemElement = new Battery((Battery)v);
            this.batteries.put(entry.getKey(), abstractSystemElement);
        }
        iterator = raidSystem.fans.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            v = entry.getValue();
            if (v == null) continue;
            abstractSystemElement = new Fan((Fan)v);
            this.fans.put(entry.getKey(), abstractSystemElement);
        }
    }

    public int getNativeId() {
        return this.hashCode();
    }

    public int getId() {
        return this.hashCode();
    }

    public void setName(String string) {
        if (string == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public int getStatus() {
        int n = -1;
        int n2 = this.getGeneralRaidSetAndDiskStatus();
        int n3 = this.getGeneralComponentStatus();
        int n4 = this.getGeneralHostInterfaceStatus();
        int n5 = this.getGeneralNetworkInterfaceStatus();
        int n6 = this.getUpsStatus();
        n = n2 == 2 || n3 == 2 || n4 == 2 || n5 == 2 ? 2 : (n2 == 1 || n3 == 1 || n4 == 1 || n5 == 1 || this.getServiceIdState() == 1 || n6 == 1 || n6 == 0 || n6 == 2 ? 1 : (n2 == 0 || n3 == 0 || n4 == 0 || n5 == 0 ? 0 : -1));
        return n;
    }

    public int getGeneralRaidSetAndDiskStatus() {
        int n = this.getGeneralRaidSetStatus();
        int n2 = this.getGeneralDiskStatus();
        if (n == -1) {
            n = n2;
        }
        if ((n2 == 1 || n2 == 2) && n != 2) {
            n = 1;
        }
        return n;
    }

    public int getGeneralRaidSetStatus() {
        return this.getGeneralStatus(this.getRaidSets());
    }

    public int getGeneralDiskStatus() {
        int n = this.getGeneralStatus(this.getDisks());
        if (n == -1) {
            Collection collection = this.getDiskSlots();
            boolean bl = true;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                DiskSlot diskSlot = (DiskSlot)iterator.next();
                if (!diskSlot.isPopulated()) continue;
                bl = false;
                break;
            }
            if (bl) {
                n = 1;
            }
        }
        return n;
    }

    public int getGeneralComponentStatus() {
        int n = RaidSystem.getRedundantComponentStatus(this.getPowerSupply(1), this.getPowerSupply(2));
        int n2 = RaidSystem.getRedundantComponentStatus(this.getFan(1), this.getFan(2));
        int n3 = this.getGeneralStatus(this.getSystemControllers());
        int n4 = this.getGeneralStatus(this.getRaidControllers());
        int n5 = n == 2 || n2 == 2 || n3 == 2 || n4 == 2 ? 2 : (n == 1 || n2 == 1 || n3 == 1 || n4 == 1 ? 1 : (n == -1 || n2 == -1 || n3 == -1 || n4 == -1 ? -1 : 0));
        return n5;
    }

    public int getGeneralNetworkInterfaceStatus() {
        int n = this.getGeneralStatus(this.getNetworkInterfaces());
        if (n == -1) {
            n = 2;
        }
        return n;
    }

    public int getGeneralHostInterfaceStatus() {
        return this.getGeneralStatus(this.getHostInterfaces());
    }

    public int getGeneralPowerSupplyStatus() {
        return this.getGeneralStatus(this.getPowerSupplies());
    }

    public int getGeneralFanStatus() {
        return this.getGeneralStatus(this.getFans());
    }

    public void setHostAddress(String string) {
        this.currentAddress = string;
    }

    public String getHostAddress() {
        return this.currentAddress;
    }

    public void setPrimaryHostAddress(String string) {
        this.primaryHostAddress = string;
    }

    public String getPrimaryHostAddress() {
        return this.primaryHostAddress;
    }

    void setSecondaryHostAddress(String string) {
        this.secondaryHostAddress = string;
    }

    public String getSecondaryHostAddress() {
        return this.secondaryHostAddress;
    }

    public String getMonitoringUserId() {
        return "guest";
    }

    public synchronized void setMonitoringPassword(String string) {
        this.monitoringPassword = string;
        AcpxMessageFactory acpxMessageFactory = (AcpxMessageFactory)this.agent.getMessageFactory();
        acpxMessageFactory.setDefaultPassword(string);
    }

    public synchronized String getMonitoringPassword() {
        return this.monitoringPassword;
    }

    public String getManagementUserId() {
        return "admin";
    }

    public void setManagementPassword(String string) {
        this.managementPassword = string;
    }

    public String getManagementPassword() {
        return this.managementPassword;
    }

    public void setManagementPasswordSaved(boolean bl) {
        this.managementPasswordSaved = bl;
        this.setChanged();
    }

    public boolean getManagementPasswordSaved() {
        return this.managementPasswordSaved;
    }

    void setLoggedOn(boolean bl) {
        this.loggedOn = bl;
    }

    public boolean isLoggedOn() {
        return this.loggedOn;
    }

    public void setPowerState(int n) {
        this.powerState = n;
    }

    public int getPowerState() {
        return this.powerState;
    }

    public long getCapacity() {
        return this.totalCapacity;
    }

    public void setContact(String string) {
        this.contact = string;
    }

    public String getContact() {
        return this.contact;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public String getLocation() {
        return this.location;
    }

    public void setServiceIdState(int n) {
        if (n != 0 && n != 1 && n != -1) {
            throw new IllegalArgumentException("Illegal service ID state: " + n);
        }
        this.serviceIdState = n;
    }

    public int getServiceIdState() {
        return this.serviceIdState;
    }

    void setLockState(int n) {
        if (n != 1 && n != 0 && n != -1) {
            throw new IllegalArgumentException("Illegal lock state: " + n);
        }
        this.lockState = n;
    }

    public int getLockState() {
        return this.lockState;
    }

    public void setTimeOffset(long l) {
        this.timeOffset = l;
    }

    public Date getTime() {
        if (this.timeOffset == Long.MAX_VALUE) {
            return null;
        }
        return new Date(new Date().getTime() - this.timeOffset);
    }

    void setUpTime(int n) {
        this.uptime = n;
    }

    public int getUpTime() {
        return this.uptime;
    }

    void setAutoRebootState(int n) {
        this.autoRebootState = n;
    }

    public int getAutoRebootState() {
        return this.autoRebootState;
    }

    void setAudibleAlarmState(int n) {
        this.audibleAlarmState = n;
    }

    public int getAudibleAlarmState() {
        return this.audibleAlarmState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNtpServerAddress() {
        String string = ".";
        boolean bl = true;
        Collection collection = this.systemControllers.values();
        Map map = this.systemControllers;
        synchronized (map) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                SystemController systemController = (SystemController)iterator.next();
                if (bl) {
                    string = systemController.getNtpServerAddress();
                    if (string == null) {
                        string = ".";
                        break;
                    }
                } else if (!string.equals(systemController.getNtpServerAddress())) {
                    string = ".";
                    RequestMessage requestMessage = this.getMessageFactory().newSetPropertyRequest(AcpPropertyCode.NTP_CONFIG.toString(), ".");
                    this.postMessageAsync(null, requestMessage, 1, null);
                    this.postMessageAsync(null, requestMessage, 2, null);
                    break;
                }
                bl = false;
            }
        }
        return string;
    }

    void setUpsStatus(int n) {
        if (n != 0 && n != 1 && n != 2 && n != -1) {
            throw new IllegalArgumentException("illegal UPS status (" + n + ")");
        }
        this.upsStatus = n;
    }

    public int getUpsStatus() {
        return this.upsStatus;
    }

    public int getBackgroundConditioningPriority() {
        int n = -1;
        int n2 = -1;
        if (this.isControllerModulePresent(1)) {
            n = this.getRaidController(1).getBackgroundConditioningPriority();
        }
        if (this.isControllerModulePresent(2)) {
            n2 = this.getRaidController(2).getBackgroundConditioningPriority();
        }
        return n == n2 ? n : -1;
    }

    public boolean isBusy() {
        Collection collection = this.getRaidControllers();
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RaidController raidController = (RaidController)iterator.next();
            Collection collection2 = raidController.getRaidSets();
            Iterator iterator2 = collection2.iterator();
            while (iterator2.hasNext()) {
                RaidSet raidSet = (RaidSet)iterator2.next();
                int n = raidSet.getOperation();
                if (n != 1 && n != 4 && n != 3 && n != 2 && n != 5) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            break;
        }
        return bl;
    }

    public EventLog getEventLog() {
        return this.eventLog;
    }

    public void setUserMessageIndex(int n) {
        if (this.userMessageTimer != null) {
            this.userMessageTimer.stop();
            this.userMessageTimer = null;
        }
        if (n == 0) {
            this.userMessageTimer = new Timer(4000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RaidSystem.this.userMessageIndex = 0;
                    RaidSystem.this.userMessageIsAsync = false;
                    RaidSystem.this.setChanged();
                }
            });
            this.userMessageTimer.start();
            return;
        }
        this.userMessageIndex = n;
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                this.userMessageIsAsync = true;
                break;
            }
            default: {
                this.userMessageIsAsync = false;
            }
        }
        this.setChanged();
    }

    public int getUserMessageIndex() {
        return this.userMessageIndex;
    }

    public boolean getUserMessageIsAsync() {
        return this.userMessageIsAsync;
    }

    public Collection getSystemControllers() {
        return Collections.unmodifiableCollection(this.systemControllers.values());
    }

    public SystemController getSystemController(int n) {
        if (n < 1 || n > 2) {
            throw new IllegalArgumentException("Illegal controller ID: " + n);
        }
        return (SystemController)this.systemControllers.get(new Integer(n));
    }

    public SystemController getPrimarySystemController() {
        String string;
        int n = this.isControllerModulePresent(1) && this.isControllerModulePresent(2) ? ((string = this.getSystemController(1).getNetworkInterface().getAddress() + "").equals(this.getPrimaryHostAddress()) ? 1 : 2) : (this.isControllerModulePresent(1) ? 1 : 2);
        return this.getSystemController(n);
    }

    public boolean allSystemControllersAreAtLeastVersion(String string) {
        boolean bl = true;
        try {
            VersionNumber versionNumber = VersionNumber.newAppleVersionNumber(string);
            Iterator iterator = this.getSystemControllers().iterator();
            while (iterator.hasNext()) {
                SystemController systemController = (SystemController)iterator.next();
                VersionNumber versionNumber2 = VersionNumber.newAppleVersionNumber(systemController.getSystemVersion());
                if (versionNumber2.compareTo(versionNumber) >= 0) continue;
                bl = false;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public int getDriveCacheFlags() {
        int n;
        if (!this.supportsGlobalDriveCacheFeature()) {
            throw new UnsupportedOperationException("Drive cache flags are not supported on this system.");
        }
        RequestMessage requestMessage = this.getMessageFactory().newGetPropertyRequest(AcpPropertyCode.DRIVE_CACHE_FLAGS);
        String string = this.getMonitoringUserId();
        String string2 = this.getMonitoringPassword();
        if (string != null && string2 != null) {
            requestMessage.setUser(string);
            requestMessage.setPassword(string2);
        }
        try {
            Response response = this.postMessage(requestMessage);
            PropertyList propertyList = (PropertyList)response.getContent();
            Map map = PListUtils.toDictionary(propertyList.getRootElement());
            Map map2 = PListUtils.toDictionary(map.get("drCH"));
            n = PListUtils.toInteger(map2.get("data")).intValue();
        }
        catch (IOException iOException) {
            logger.error("IOException when retrieving drive cache flags property");
            n = -128;
        }
        catch (PropertyListException propertyListException) {
            logger.error("PropertyListException when retrieving drive cache flags property");
            n = -128;
        }
        return n;
    }

    public boolean supportsGlobalDriveCacheFeature() {
        boolean bl;
        RequestMessage requestMessage = this.getMessageFactory().newGetPropertyRequest(AcpPropertyCode.FEATURES);
        String string = this.getMonitoringUserId();
        String string2 = this.getMonitoringPassword();
        if (string != null && string2 != null) {
            requestMessage.setUser(string);
            requestMessage.setPassword(string2);
        }
        try {
            Response response = this.postMessage(requestMessage);
            PropertyList propertyList = (PropertyList)response.getContent();
            Map map = PListUtils.toDictionary(propertyList.getRootElement());
            Map map2 = PListUtils.toDictionary(map.get("fe01"));
            Long l = PListUtils.toInteger(map2.get("data"));
            bl = (l & 0x800000L) != 0L;
        }
        catch (IOException iOException) {
            logger.error("IOException when retrieving FEATURES property");
            bl = false;
        }
        catch (PropertyListException propertyListException) {
            logger.error("PropertyListException when retrieving FEATURES property");
            bl = false;
        }
        return bl;
    }

    public int getRaidControllerCount() {
        return this.raidControllers.size();
    }

    public Collection getRaidControllers() {
        return Collections.unmodifiableCollection(this.raidControllers.values());
    }

    public RaidController getRaidController(int n) {
        if (n < 1 || n > 2) {
            throw new IllegalArgumentException("Illegal controller ID: " + n);
        }
        return (RaidController)this.raidControllers.get(new Integer(n));
    }

    public RaidController getRaidControllerForDiskSlot(int n) {
        if (n < 1 || n > 14) {
            throw new IllegalArgumentException("Illegal disk slot: " + n);
        }
        if (n <= 7) {
            return this.getRaidController(1);
        }
        return this.getRaidController(2);
    }

    public Collection getPowerSupplies() {
        return Collections.unmodifiableCollection(this.powerSupplies.values());
    }

    public PowerSupply getPowerSupply(int n) {
        if (n < 1 || n > 2) {
            throw new IllegalArgumentException("Illegal power supply ID: " + n);
        }
        return (PowerSupply)this.powerSupplies.get(new Integer(n));
    }

    void addFan(Fan fan) {
        this.fans.put(new Integer(fan.getId()), fan);
    }

    Fan removeFan(int n) {
        return (Fan)this.fans.remove(new Integer(n));
    }

    public Collection getFans() {
        return Collections.unmodifiableCollection(this.fans.values());
    }

    public Fan getFan(int n) {
        if (n < 1 || n > 2) {
            throw new IllegalArgumentException("Illegal fan ID: " + n);
        }
        return (Fan)this.fans.get(new Integer(n));
    }

    void addBattery(Battery battery) {
        this.batteries.put(new Integer(battery.getId()), battery);
    }

    Battery removeBattery(int n) {
        return (Battery)this.batteries.remove(new Integer(n));
    }

    public Collection getBatteries() {
        return Collections.unmodifiableCollection(this.batteries.values());
    }

    public Battery getBattery(int n) {
        if (n < 1 || n > 2) {
            throw new IllegalArgumentException("Illegal battery ID: " + n);
        }
        return (Battery)this.batteries.get(new Integer(n));
    }

    public boolean isControllerModulePresent(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Illegal module (" + n + ")");
        }
        return true;
    }

    public int getControllerModuleStatus(int n) {
        SystemController systemController;
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Illegal module (" + n + ")");
        }
        int n2 = 0;
        RaidController raidController = this.getRaidController(n == 1 ? 1 : 2);
        if (raidController != null) {
            if (raidController.getStatus() == 1) {
                int n3 = n2 = n2 == 2 ? 2 : 1;
            }
            if (raidController.getStatus() == 2) {
                n2 = 2;
            }
        }
        if ((systemController = this.getSystemController(n == 1 ? 1 : 2)) != null) {
            if (systemController.getStatus() == 1) {
                int n4 = n2 = n2 == 2 ? 2 : 1;
            }
            if (systemController.getStatus() == 2) {
                n2 = 2;
            }
        }
        return n2;
    }

    public Collection getNetworkInterfaces() {
        TreeSet<NetworkInterface> treeSet = new TreeSet<NetworkInterface>();
        Iterator iterator = this.getSystemControllers().iterator();
        while (iterator.hasNext()) {
            SystemController systemController = (SystemController)iterator.next();
            treeSet.add(systemController.getNetworkInterface());
        }
        return treeSet;
    }

    public RaidSet getRaidSet(int n) {
        RaidSet raidSet = null;
        Iterator iterator = this.getRaidSets().iterator();
        while (iterator.hasNext()) {
            SystemElement systemElement = (SystemElement)iterator.next();
            if (systemElement.getId() != n) continue;
            raidSet = (RaidSet)systemElement;
            break;
        }
        return raidSet;
    }

    public Collection getRaidSets() {
        TreeSet treeSet = new TreeSet();
        Iterator iterator = this.getRaidControllers().iterator();
        while (iterator.hasNext()) {
            RaidController raidController = (RaidController)iterator.next();
            treeSet.addAll(raidController.getRaidSets());
        }
        return treeSet;
    }

    public synchronized boolean isRaidSetBeingCreated(RaidSet raidSet) {
        if (raidSet == null) {
            throw new NullPointerException("raidSet cannot be null");
        }
        return this.creationInProgressControllerID != -1 && this.creationInProgressRaidSetID != -1 && raidSet.getController().getId() == this.creationInProgressControllerID && raidSet.getNativeId() == this.creationInProgressRaidSetID;
    }

    public synchronized void setRaidSetCreationInProgress(int n, int n2) {
        this.creationInProgressControllerID = n;
        this.creationInProgressRaidSetID = n2;
    }

    public synchronized void clearRaidSetCreationInProgress() {
        this.creationInProgressControllerID = -1;
        this.creationInProgressRaidSetID = -1;
    }

    public DiskSlot getDiskSlot(int n) {
        DiskSlot diskSlot = null;
        if (n < 1 || n > 14) {
            throw new IllegalArgumentException("Invalid disk slot ID (" + n + ")");
        }
        Collection collection = n <= 7 ? this.getRaidController(1).getRaidSets() : this.getRaidController(2).getRaidSets();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SystemElement systemElement = (SystemElement)iterator.next();
            if (systemElement.getId() != n) continue;
            diskSlot = (DiskSlot)systemElement;
            break;
        }
        return diskSlot;
    }

    public Collection getDiskSlots() {
        TreeSet treeSet = new TreeSet();
        Iterator iterator = this.getRaidControllers().iterator();
        while (iterator.hasNext()) {
            RaidController raidController = (RaidController)iterator.next();
            treeSet.addAll(raidController.getDiskSlots());
        }
        return treeSet;
    }

    public Disk getDisk(int n) {
        Disk disk = null;
        if (n < 1 || n > 14) {
            throw new IllegalArgumentException("Invalid disk ID (" + n + ")");
        }
        Collection collection = n <= 7 ? this.getRaidController(1).getDisks() : this.getRaidController(2).getDisks();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            SystemElement systemElement = (SystemElement)iterator.next();
            if (systemElement.getId() != n) continue;
            disk = (Disk)systemElement;
            break;
        }
        return disk;
    }

    public Collection getDisks() {
        TreeSet treeSet = new TreeSet();
        Iterator iterator = this.getRaidControllers().iterator();
        while (iterator.hasNext()) {
            RaidController raidController = (RaidController)iterator.next();
            treeSet.addAll(raidController.getDisks());
        }
        return treeSet;
    }

    public HostInterface getHostInterface(int n) {
        HostInterface hostInterface = null;
        if (n < 1 || n > 2) {
            throw new IllegalArgumentException("Invalid host interface ID (" + n + ")");
        }
        Iterator iterator = this.getHostInterfaces().iterator();
        while (iterator.hasNext()) {
            SystemElement systemElement = (SystemElement)iterator.next();
            if (systemElement.getId() != n) continue;
            hostInterface = (HostInterface)systemElement;
            break;
        }
        return hostInterface;
    }

    public Collection getHostInterfaces() {
        TreeSet treeSet = new TreeSet();
        Iterator iterator = this.getRaidControllers().iterator();
        while (iterator.hasNext()) {
            RaidController raidController = (RaidController)iterator.next();
            treeSet.addAll(raidController.getHostInterfaces());
        }
        return treeSet;
    }

    public boolean[] getDiskCacheSettings(int n) throws IOException, PropertyListException, AcpxCommandException {
        Response response;
        int n2;
        boolean[] blArray = new boolean[7];
        for (n2 = 0; n2 < 7; ++n2) {
            blArray[n2] = false;
        }
        RequestMessage requestMessage = this.getMessageFactory().newGetControllerPageRequest(AcpxConstants.CONTROLLER_PAGE_1);
        String string = this.getMonitoringUserId();
        String string2 = this.getMonitoringPassword();
        if (string != null && string2 != null) {
            requestMessage.setUser(string);
            requestMessage.setPassword(string2);
        }
        if ((response = this.postMessage(requestMessage, n)).getResultCode() != 0) {
            logger.error("get-page request failed (" + response.getResultCode() + ")");
            throw new AcpxCommandException("get-page request failed (" + response.getResultCode() + ")");
        }
        PropertyList propertyList = (PropertyList)response.getContent();
        Map map = PListUtils.toDictionary(propertyList.getRootElement());
        Map map2 = PListUtils.toDictionary(map.get("get-page"));
        List list = PListUtils.toArray(map2.get("slots"));
        n2 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Map map3 = PListUtils.toDictionary(iterator.next());
            Map map4 = PListUtils.toDictionary(map3.get("status"), "status");
            boolean bl = PListUtils.toBoolean(map4.get("disk-cache-enabled"));
            blArray[n2++] = bl;
        }
        return blArray;
    }

    public boolean getRaidControllerCacheEnabled(int n) throws IOException, PropertyListException, AcpxCommandException {
        Response response;
        RequestMessage requestMessage = this.getMessageFactory().newGetControllerPageRequest(AcpxConstants.CONTROLLER_PAGE_0);
        String string = this.getMonitoringUserId();
        String string2 = this.getMonitoringPassword();
        if (string != null && string2 != null) {
            requestMessage.setUser(string);
            requestMessage.setPassword(string2);
        }
        if ((response = this.postMessage(requestMessage, n)).getResultCode() != 0) {
            logger.error("get-page request failed (" + response.getResultCode() + ")");
            throw new AcpxCommandException("get-page request failed (" + response.getResultCode() + ")");
        }
        PropertyList propertyList = (PropertyList)response.getContent();
        Map map = PListUtils.toDictionary(propertyList.getRootElement());
        Map map2 = PListUtils.toDictionary(map.get("get-page"));
        return PListUtils.toBoolean(map2.get("write-buffer-enabled"));
    }

    public boolean hasRaidOrJbodDisks() {
        Iterator iterator = this.getDisks().iterator();
        while (iterator.hasNext()) {
            int n = ((Disk)iterator.next()).getType();
            if (n != 1 && n != 3) continue;
            return true;
        }
        return false;
    }

    public void stateChanged(SystemEvent systemEvent) {
        this.fireStateChanged(systemEvent);
    }

    public void connect(CommunicationHandler communicationHandler, String string, String string2, boolean bl) {
        String string3;
        if (string == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Password cannot be null");
        }
        String string4 = string3 = bl ? RaidSystem.crypt(string2) : string2;
        if (string.equals("guest")) {
            this.setMonitoringPassword(string3);
        }
        this.agent.connect(communicationHandler, string, string3);
    }

    public void disconnect() {
        this.agent.shutdown();
        this.comms.shutdown();
    }

    public boolean isConnected() {
        return this.comms.isConnected();
    }

    public void authenticate(CommunicationHandler communicationHandler, String string, String string2, boolean bl) {
        String string3;
        if (string == null) {
            throw new IllegalArgumentException("User cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Password cannot be null");
        }
        String string4 = string3 = bl ? RaidSystem.crypt(string2) : string2;
        if (string.equals("guest")) {
            this.setMonitoringPassword(string3);
        }
        if (string.equals("admin")) {
            ((AcpxMessageFactory)this.messageFactory).setDefaultUser(string);
            ((AcpxMessageFactory)this.messageFactory).setDefaultPassword(string3);
        }
        this.agent.authenticate(communicationHandler, string, string3);
    }

    public Response postMessage(RequestMessage requestMessage) throws IOException {
        return this.comms.postMessage(requestMessage);
    }

    public Response postMessage(RequestMessage requestMessage, int n) throws IOException {
        requestMessage.setTargetController(RequestMessage.Target.getTarget(n));
        return this.comms.postMessage(requestMessage);
    }

    public void postMessageAsync(CommunicationHandler communicationHandler, RequestMessage requestMessage) {
        this.postMessageAsync(communicationHandler, requestMessage, null);
    }

    public void postMessageAsync(CommunicationHandler communicationHandler, RequestMessage requestMessage, int n, Object object) {
        requestMessage.setTargetController(RequestMessage.Target.getTarget(n));
        this.postMessageAsync(communicationHandler, requestMessage, object);
    }

    public void postMessageAsync(CommunicationHandler communicationHandler, RequestMessage requestMessage, Object object) {
        this.comms.postMessageAsync(communicationHandler, requestMessage, object);
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public void updateImmediately(boolean bl) {
        if (this.isConnected() && !this.agent.isPolling()) {
            this.setUserMessageIndex(12);
            if (bl) {
                this.clear();
            }
            this.agent.updateImmediately();
        }
    }

    public void setPollingEnabled(boolean bl) {
        this.agent.setPollingEnabled(bl);
    }

    public boolean isPollingEnabled() {
        return this.agent.isPollingEnabled();
    }

    public void setPollDelay(int n) {
        this.agent.setPollDelay(n);
    }

    public int getPollDelay() {
        return this.agent.getPollDelay();
    }

    public synchronized void waitForUpdate() throws InterruptedException {
        long l = System.currentTimeMillis();
        long l2 = 300000L;
        this.pollStarted = false;
        this.pollFinished = false;
        while (true) {
            if (l2 <= 0L) {
                throw new InterruptedException("Timed out waiting for update");
            }
            this.wait(l2);
            if (this.pollStarted && this.pollFinished) break;
            long l3 = System.currentTimeMillis();
            l2 = 300000L - (l3 - l);
        }
    }

    public synchronized void waitForUpdateFinished() throws InterruptedException {
        long l = System.currentTimeMillis();
        long l2 = 300000L;
        this.pollFinished = false;
        while (true) {
            if (l2 <= 0L) {
                throw new InterruptedException("Timed out waiting for update to finish");
            }
            this.wait(l2);
            if (this.pollFinished) break;
            long l3 = System.currentTimeMillis();
            l2 = 300000L - (l3 - l);
        }
        logger.info("waitForUpdateFinished: Poll cycle completed");
    }

    synchronized void notifyUpdateStarted() {
        this.pollStarted = true;
        this.notifyAll();
    }

    synchronized void notifyUpdateFinished() {
        this.pollFinished = true;
        this.notifyAll();
    }

    public void pollForRaidControllerOnline(int n) throws InterruptedException {
        boolean bl = false;
        long l = System.currentTimeMillis();
        long l2 = 120000L;
        if (n < 1 || n > 2) {
            throw new IllegalArgumentException("Invalid RAID controller ID: " + n);
        }
        RequestMessage requestMessage = this.getMessageFactory().newGetControllerPageRequest(AcpxConstants.CONTROLLER_PAGE_0);
        String string = this.getMonitoringUserId();
        String string2 = this.getMonitoringPassword();
        if (string != null && string2 != null) {
            requestMessage.setUser(string);
            requestMessage.setPassword(string2);
        }
        while (true) {
            long l3;
            if ((l2 = 120000L - ((l3 = System.currentTimeMillis()) - l)) <= 0L) {
                throw new InterruptedException("Timed out waiting for RAID controller " + n + " to come online");
            }
            logger.info("Checking if RAID controller " + n + " is online...");
            try {
                Response response = this.postMessage(requestMessage, n);
                if (response.getResultCode() == 0) {
                    PropertyList propertyList = (PropertyList)response.getContent();
                    Map map = PListUtils.toDictionary(propertyList.getRootElement());
                    Map map2 = PListUtils.toDictionary(map.get("get-page"));
                    bl = PListUtils.toBoolean(map2.get("ready-state"));
                }
            }
            catch (Exception exception) {
                logger.warn("While polling for RAID controller " + n + " online: " + exception);
            }
            if (bl) break;
            Thread.currentThread();
            Thread.sleep(5000L);
        }
        logger.info("RAID controller " + n + " online.");
    }

    public synchronized void waitForRaidControllerOnline(int n) throws InterruptedException {
        if (n < 1 || n > 2) {
            throw new IllegalArgumentException("Invalid RAID controller ID: " + n);
        }
        long l = System.currentTimeMillis();
        long l2 = 120000L;
        if (n == 1) {
            this.waitingForTopRaidControllerOnline = true;
        } else {
            this.waitingForBottomRaidControllerOnline = true;
        }
        while (true) {
            if (l2 <= 0L) {
                throw new InterruptedException("Timed out waiting for RAID controller to come online");
            }
            this.wait(l2);
            if (n == 1 && !this.waitingForTopRaidControllerOnline || n == 2 && !this.waitingForBottomRaidControllerOnline) break;
            long l3 = System.currentTimeMillis();
            l2 = 120000L - (l3 - l);
        }
    }

    synchronized void notifyRaidControllerOnline(int n) {
        if (n == 1) {
            this.waitingForTopRaidControllerOnline = false;
        } else if (n == 2) {
            this.waitingForBottomRaidControllerOnline = false;
        }
        this.notifyAll();
    }

    public synchronized void waitForRaidSetOnline(int n, int n2) throws InterruptedException {
        int n3;
        RaidController raidController = this.getRaidController(n);
        if (raidController == null) {
            throw new IllegalArgumentException("RAID controller " + n + " does not exist");
        }
        long l = 120000L;
        long l2 = System.currentTimeMillis();
        while (true) {
            if (l <= 0L) {
                throw new InterruptedException("Timed out waiting for RAID set " + n2 + " to come online");
            }
            this.wait(l);
            RaidSet raidSet = raidController.getRaidSet(n2);
            if (raidSet != null) {
                n3 = raidSet.getStatus();
                if (n3 != 0 && n3 != 2) continue;
                break;
            }
            long l3 = System.currentTimeMillis();
            l = 120000L - (l3 - l2);
        }
        logger.info("waitForRaidSetOnline: RAID controller " + n + " RAID set " + n2 + " is " + (n3 == 0 ? "online" : "degraded"));
    }

    synchronized void notifyRaidSetOnline(RaidSet raidSet) {
        this.notifyAll();
    }

    public int translateSliceId(int n, int n2, int n3) {
        return this.translateId(n, n2, n3, "1.2");
    }

    public int translateLunId(int n, int n2, int n3) {
        return this.translateId(n, n2, n3, "1.2");
    }

    private int translateId(int n, int n2, int n3, String string) {
        int n4;
        block5: {
            String string2;
            n4 = n;
            SystemController systemController = this.getSystemController(n2);
            if (systemController != null && string != null && string.length() > 0 && (string2 = systemController.getSystemVersion()) != null) {
                try {
                    VersionNumber versionNumber = VersionNumber.newAppleVersionNumber(string2);
                    VersionNumber versionNumber2 = VersionNumber.newAppleVersionNumber(string);
                    if (versionNumber.compareTo(versionNumber2) >= 0) break block5;
                    if (n3 == 0) {
                        n4 = n + 1;
                        break block5;
                    }
                    if (n3 == 1) {
                        n4 = n - 1;
                        break block5;
                    }
                    throw new IllegalArgumentException("Unrecognized translation direction: " + n3);
                }
                catch (Exception exception) {
                    logger.warn("Could not translate ID: " + n);
                }
            }
        }
        return n4;
    }

    public synchronized void clear() {
        AbstractSystemElement abstractSystemElement;
        int n;
        this.loggedOn = false;
        this.totalCapacity = -1L;
        this.contact = "";
        this.description = "";
        this.location = "";
        this.serviceIdState = -1;
        this.lockState = -1;
        this.timeOffset = Long.MAX_VALUE;
        this.uptime = -1;
        this.autoRebootState = -1;
        this.audibleAlarmState = -1;
        this.upsStatus = -1;
        this.powerState = -1;
        this.eventLog = new EventLog();
        this.systemControllers.clear();
        for (n = 1; n <= 2; ++n) {
            abstractSystemElement = new SystemController(n, this);
            this.systemControllers.put(new Integer(n), abstractSystemElement);
        }
        this.raidControllers.clear();
        for (n = 1; n <= 2; ++n) {
            abstractSystemElement = new RaidController(n, this);
            this.raidControllers.put(new Integer(n), abstractSystemElement);
        }
        this.powerSupplies.clear();
        for (n = 1; n <= 2; ++n) {
            abstractSystemElement = new PowerSupply(n);
            this.powerSupplies.put(new Integer(n), abstractSystemElement);
        }
        this.batteries.clear();
        this.fans.clear();
        for (n = 1; n <= 2; ++n) {
            abstractSystemElement = new Fan(n);
            this.addFan((Fan)abstractSystemElement);
        }
        this.setChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String paramString() {
        Iterator iterator;
        String string = "";
        string = string + "name=" + this.name + ",";
        string = string + "primaryHostAddress=" + this.primaryHostAddress + ",";
        string = string + "secondaryHostAddress=" + this.secondaryHostAddress + ",";
        string = string + "currentAddress=" + this.currentAddress + ",";
        string = string + "monitoringPassword=" + this.monitoringPassword + ",";
        string = string + "managementPassword=" + this.managementPassword + ",";
        string = string + "loggedOn=" + this.loggedOn + ",";
        string = string + "powerState=" + this.powerState + ",";
        string = string + "totalCapacity=" + this.totalCapacity + ",";
        string = string + "contact=" + this.contact + ",";
        string = string + "description=" + this.description + ",";
        string = string + "location=" + this.location + ",";
        string = string + "serviceIdState=" + this.serviceIdState + ",";
        string = string + "lockState=" + this.lockState + ",";
        string = string + "timeOffset=" + this.timeOffset + ",";
        string = string + "uptime=" + this.uptime + ",";
        string = string + "autoRebootState=" + this.autoRebootState + ",";
        string = string + "audibleAlarmState=" + this.audibleAlarmState + ",";
        string = string + "upsStatus=" + this.upsStatus + ",";
        string = string + "powerState=" + this.powerState + ",";
        string = string + "userMessageIndex=" + this.userMessageIndex + ",";
        string = string + "userMessageIsAsync=" + this.userMessageIsAsync + ",";
        Collection collection = this.systemControllers.values();
        Map map = this.systemControllers;
        synchronized (map) {
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                string = string + iterator.next() + ",";
            }
        }
        collection = this.raidControllers.values();
        map = this.raidControllers;
        synchronized (map) {
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                string = string + iterator.next() + ",";
            }
        }
        collection = this.powerSupplies.values();
        map = this.powerSupplies;
        synchronized (map) {
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                string = string + iterator.next() + ",";
            }
        }
        collection = this.batteries.values();
        map = this.batteries;
        synchronized (map) {
            iterator = this.batteries.values().iterator();
            while (iterator.hasNext()) {
                string = string + iterator.next() + ",";
            }
        }
        collection = this.fans.values();
        map = this.fans;
        synchronized (map) {
            iterator = this.fans.values().iterator();
            while (iterator.hasNext()) {
                string = string + iterator.next();
                if (!iterator.hasNext()) continue;
                string = string + ",";
            }
        }
        return string;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    public void setChanged() {
        super.setChanged();
        this.notifyObservers();
    }

    CommunicationsManager getCommunicationsManager() {
        return this.comms;
    }

    void updateGlobalRaidSetIdentifiers() {
        int n = 1;
        RaidSet[] raidSetArray = this.getRaidSets().toArray(new RaidSet[0]);
        for (int i = 0; i < raidSetArray.length; ++i) {
            RaidSet raidSet = raidSetArray[i];
            raidSet.setGlobalId(n++);
        }
    }

    private int getGeneralStatus(Collection collection) {
        if (collection.size() == 0) {
            return -1;
        }
        int n = -1;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SystemElement)) {
                throw new ClassCastException("element " + e.getClass() + " not a SystemElement");
            }
            int n2 = ((SystemElement)e).getStatus();
            if (n2 == 0 && n == -1) {
                n = 0;
            }
            if (n2 == 1) {
                n = 1;
                continue;
            }
            if (n2 != 2) continue;
            n = 2;
            break;
        }
        return n;
    }

    private static int getRedundantComponentStatus(SystemElement systemElement, SystemElement systemElement2) {
        int n = systemElement != null ? systemElement.getStatus() : -1;
        int n2 = systemElement2 != null ? systemElement2.getStatus() : -1;
        if (n == -1 || n2 == -1 || n == 2 || n2 == 2) {
            return 2;
        }
        if (n == 1 || n2 == 1) {
            return 1;
        }
        return 0;
    }

    private static String crypt(String string) {
        if (string == null) {
            throw new NullPointerException("source cannot be null");
        }
        String string2 = null;
        try {
            string2 = Utilities.crypt(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("crypt failed. " + unsupportedEncodingException);
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

