/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.xsr.som.AbstractSystemElement;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.DiskSlot;
import com.apple.xsr.som.FibreChannelInterface;
import com.apple.xsr.som.HostInterface;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystem;
import com.apple.xsr.som.Slice;
import com.apple.xsr.som.SystemEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class RaidController
extends AbstractSystemElement
implements Comparable {
    public static final int DISABLED = 0;
    public static final int ENABLED = 1;
    public static final int ACCESS_MODE_SEQUENTIAL = 0;
    public static final int ACCESS_MODE_RANDOM = 1;
    public static final int CONTROLLER_NOT_READY = 0;
    public static final int CONTROLLER_READY = 1;
    public static final int WRITE_CACHE_DISABLED = 0;
    public static final int WRITE_CACHE_ENABLED = 1;
    public static final int DISK_CHANNEL_MIN_ID = 1;
    public static final int DISK_CHANNEL_MAX_ID = 7;
    public static final int DISK_CHANNEL_COUNT = 7;
    public static final int HOST_INTERFACE_MIN_ID = 1;
    public static final int HOST_INTERFACE_MAX_ID = 1;
    public static final int HOST_INTERFACE_1 = 1;
    public static final int RAID_SET_MIN_ID = 1;
    public static final int RAID_SET_MAX_ID = 4;
    public static final int SLICE_MIN_ID = 0;
    public static final int SLICE_MAX_ID = 7;
    public static final int RAID_SET_MAX_SLICES = 8;
    public static final int LUN_MIN_ID = 0;
    public static final int LUN_MAX_ID = 7;
    public static final int LUN_MASK_DISABLED = 0;
    public static final int LUN_MASK_ENABLED = 1;
    public static final int NO_RAIDSET_ID_AVAILABLE = -1;
    private static final int REBUILD_RATE_MIN = 1;
    private static final int REBUILD_RATE_MAX = 7;
    private static final int[] STRIPE_SIZES = new int[]{8, 16, 32, 64, 128};
    private final int id;
    private String productId = "";
    private String modelName = "";
    private String serialNumber = "";
    private int stripeSize = -1;
    private int writeCacheState = -1;
    private int hostInterfaceCount = -1;
    private int diskChannelCount = -1;
    private int slotCount = -1;
    private int memorySize = -1;
    private int cacheHitRatio = -1;
    private int readyState = -1;
    private int clientCount = -1;
    private String firmwareVersion = "";
    private int accessMode = -1;
    private int prefetchSize = -1;
    private boolean autoRebuildEnabled = false;
    private int rebuildRate = -1;
    private boolean checkDataGenerationEnabled = false;
    private int lunMaskEnabled = -1;
    private boolean jbodMaskEnabled = true;
    private int jbodModeState = -1;
    private int slowReadBypassModeState = -1;
    private int diagnosticFunctionStatus = -1;
    private int cpuTemperature = -1;
    private int tempStatus = -1;
    private int bgrwConditioningPriority = -1;
    private int syncCacheState = -1;
    private final Map raidSets = new TreeMap();
    private final Map disks = new TreeMap();
    private final Map hostInterfaces = new TreeMap();
    private final Map slots = new TreeMap();
    RaidSystem system;

    public RaidController(int n, RaidSystem raidSystem) {
        AbstractSystemElement abstractSystemElement;
        int n2;
        if (raidSystem == null) {
            throw new NullPointerException("system cannot be null");
        }
        this.id = n;
        this.system = raidSystem;
        for (n2 = 1; n2 <= 7; ++n2) {
            abstractSystemElement = new DiskSlot(n2, this);
            this.slots.put(new Integer(n2), abstractSystemElement);
            Disk disk = new Disk(n2, this);
            this.disks.put(new Integer(n2), disk);
            ((DiskSlot)abstractSystemElement).setDisk(disk);
        }
        for (n2 = 1; n2 <= 1; ++n2) {
            abstractSystemElement = new FibreChannelInterface(n2, this);
            this.hostInterfaces.put(new Integer(n2), abstractSystemElement);
        }
    }

    public RaidController(RaidController raidController) {
        Object object;
        AbstractSystemElement abstractSystemElement;
        Disk disk;
        Object object2;
        Object object3;
        this.id = raidController.id;
        this.productId = raidController.productId;
        this.modelName = raidController.modelName;
        this.serialNumber = raidController.serialNumber;
        this.stripeSize = raidController.stripeSize;
        this.writeCacheState = raidController.writeCacheState;
        this.hostInterfaceCount = raidController.hostInterfaceCount;
        this.diskChannelCount = raidController.diskChannelCount;
        this.slotCount = raidController.slotCount;
        this.memorySize = raidController.memorySize;
        this.cacheHitRatio = raidController.cacheHitRatio;
        this.readyState = raidController.readyState;
        this.clientCount = raidController.clientCount;
        this.firmwareVersion = raidController.firmwareVersion;
        this.accessMode = raidController.accessMode;
        this.prefetchSize = raidController.prefetchSize;
        this.autoRebuildEnabled = raidController.autoRebuildEnabled;
        this.rebuildRate = raidController.rebuildRate;
        this.checkDataGenerationEnabled = raidController.checkDataGenerationEnabled;
        this.lunMaskEnabled = raidController.lunMaskEnabled;
        this.jbodMaskEnabled = raidController.jbodMaskEnabled;
        this.jbodModeState = raidController.jbodModeState;
        this.slowReadBypassModeState = raidController.slowReadBypassModeState;
        this.diagnosticFunctionStatus = raidController.diagnosticFunctionStatus;
        this.cpuTemperature = raidController.cpuTemperature;
        this.tempStatus = raidController.tempStatus;
        this.bgrwConditioningPriority = raidController.bgrwConditioningPriority;
        this.syncCacheState = raidController.syncCacheState;
        Object object4 = raidController.disks.entrySet().iterator();
        while (object4.hasNext()) {
            object3 = object4.next();
            object2 = object3.getValue();
            if (object2 == null) continue;
            disk = new Disk((Disk)object2);
            disk.controller = this;
            this.disks.put(object3.getKey(), disk);
        }
        object4 = (Map)((TreeMap)raidController.raidSets).clone();
        object3 = object4.entrySet().iterator();
        while (object3.hasNext()) {
            object2 = (Map.Entry)object3.next();
            disk = object2.getValue();
            if (disk == null) continue;
            abstractSystemElement = new RaidSet((RaidSet)((Object)disk));
            object = ((RaidSet)abstractSystemElement).getMembers();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Disk disk2 = (Disk)iterator.next();
                ((RaidSet)abstractSystemElement).removeMember(disk2);
                Disk disk3 = (Disk)this.disks.get(new Integer(disk2.getNativeId()));
                if (disk3 != null) {
                    ((RaidSet)abstractSystemElement).addMember(disk3);
                    continue;
                }
                throw new NullPointerException("Disk with native ID " + disk2.getNativeId() + " was null");
            }
            ((RaidSet)abstractSystemElement).controller = this;
            this.raidSets.put(object2.getKey(), abstractSystemElement);
        }
        object3 = raidController.hostInterfaces.entrySet().iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            disk = object2.getValue();
            if (disk == null) continue;
            abstractSystemElement = new FibreChannelInterface((FibreChannelInterface)((Object)disk));
            this.hostInterfaces.put(object2.getKey(), abstractSystemElement);
        }
        object3 = raidController.slots.entrySet().iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            disk = object2.getValue();
            if (disk == null) continue;
            abstractSystemElement = new DiskSlot((DiskSlot)((Object)disk));
            object = (Disk)this.disks.get(new Integer(((DiskSlot)abstractSystemElement).getNativeId()));
            if (object == null) {
                throw new NullPointerException("Disk with native ID " + ((DiskSlot)abstractSystemElement).getNativeId() + " was null");
            }
            ((DiskSlot)abstractSystemElement).setDisk((Disk)object);
            ((DiskSlot)abstractSystemElement).controller = this;
            this.slots.put(object2.getKey(), abstractSystemElement);
        }
        this.system = raidController.system;
    }

    public int getNativeId() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return "RAID Controller " + this.id;
    }

    public int getStatus() {
        int n = this.readyState == 1 ? this.tempStatus : (this.readyState == 0 ? 1 : -1);
        return n;
    }

    public boolean isTop() {
        return this.id == 1;
    }

    public boolean isBottom() {
        return this.id == 2;
    }

    void setProductId(String string) {
        this.productId = string;
    }

    public String getProductId() {
        return this.productId;
    }

    void setModelName(String string) {
        this.modelName = string;
    }

    public String getModelName() {
        return this.modelName;
    }

    void setSerialNumber(String string) {
        this.serialNumber = string;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    void setStripeSize(int n) throws IllegalArgumentException {
        if (!RaidController.isValidStripeSize(n)) {
            throw new IllegalArgumentException("Illegal stripe size: " + n);
        }
        this.stripeSize = n;
    }

    public int getStripeSize() {
        return this.stripeSize;
    }

    void setWriteCacheState(int n) {
        this.writeCacheState = n;
    }

    public int getWriteCacheState() {
        return this.writeCacheState;
    }

    void setHostInterfaceCount(int n) {
        this.hostInterfaceCount = n;
    }

    public int getHostInterfaceCount() {
        return this.hostInterfaceCount;
    }

    void setDiskChannelCount(int n) {
        this.diskChannelCount = n;
    }

    public int getDiskChannelCount() {
        return this.diskChannelCount;
    }

    void setSlotCount(int n) {
        this.slotCount = n;
    }

    public int getSlotCount() {
        return this.slotCount;
    }

    void setMemorySize(int n) {
        this.memorySize = n;
    }

    public int getMemorySize() {
        return this.memorySize;
    }

    void setCacheHitRatio(int n) {
        this.cacheHitRatio = n;
    }

    public int getCacheHitRatio() {
        return this.cacheHitRatio;
    }

    void setReadyState(int n) {
        if (n == 1) {
            this.system.notifyRaidControllerOnline(this.id);
        }
        if (n != this.readyState) {
            int n2 = this.readyState;
            this.readyState = n;
            if (n == 1) {
                this.fireStateChanged(new SystemEvent(this, 1));
            } else if (n == 0) {
                this.fireStateChanged(new SystemEvent(this, 2));
            }
        }
    }

    public int getReadyState() {
        return this.readyState;
    }

    public boolean isOnline() {
        return this.readyState == 1;
    }

    void setClientCount(int n) {
        this.clientCount = n;
    }

    public int getClientCount() {
        return this.clientCount;
    }

    void setFirmwareVersion(String string) {
        this.firmwareVersion = string;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    void setAccessMode(int n) throws IllegalArgumentException {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal access mode: " + n);
        }
        this.accessMode = n;
    }

    public int getAccessMode() {
        return this.accessMode;
    }

    void setPrefetchSize(int n) {
        this.prefetchSize = n;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    void setAutoRebuildEnabled(boolean bl) {
        this.autoRebuildEnabled = bl;
    }

    public boolean getAutoRebuildEnabled() {
        return this.autoRebuildEnabled;
    }

    void setRebuildRate(int n) throws IllegalArgumentException {
        if (n < 1 || n > 7) {
            throw new IllegalArgumentException("Illegal rebuild rate: " + n);
        }
        this.rebuildRate = n;
    }

    public int getRebuildRate() {
        return this.rebuildRate;
    }

    void setCheckDataGenerationEnabled(boolean bl) {
        this.checkDataGenerationEnabled = bl;
    }

    public boolean getCheckDataGenerationEnabled() {
        return this.checkDataGenerationEnabled;
    }

    void setLunMaskEnabled(int n) {
        this.lunMaskEnabled = n;
    }

    public int getLunMaskEnabled() {
        return this.lunMaskEnabled;
    }

    void setJbodMaskEnabled(boolean bl) {
        this.jbodMaskEnabled = bl;
    }

    public boolean getJbodMaskEnabled() {
        return this.jbodMaskEnabled;
    }

    void setJbodModeState(int n) {
        this.jbodModeState = n;
    }

    public int getJbodModeState() {
        return this.jbodModeState;
    }

    void setSlowReadBypassModeState(int n) {
        this.slowReadBypassModeState = n;
    }

    public int getSlowReadBypassModeState() {
        return this.slowReadBypassModeState;
    }

    void setDiagnosticFunctionStatus(int n) {
        this.diagnosticFunctionStatus = n;
    }

    public int getDiagnosticFunctionStatus() {
        return this.diagnosticFunctionStatus;
    }

    void setCpuTemperature(int n) {
        this.cpuTemperature = n;
    }

    public int getCpuTemperature() {
        return this.cpuTemperature;
    }

    public void setBackgroundConditioningPriority(int n) {
        this.bgrwConditioningPriority = n;
    }

    public int getBackgroundConditioningPriority() {
        return this.bgrwConditioningPriority;
    }

    void setSyncCacheState(int n) {
        this.syncCacheState = n;
    }

    public int getSyncCacheState() {
        return this.syncCacheState;
    }

    void setTemperatureStatus(int n) {
        this.tempStatus = n;
    }

    public RaidSystem getRaidSystem() {
        return this.system;
    }

    void addRaidSet(RaidSet raidSet) {
        this.raidSets.put(new Integer(raidSet.getNativeId()), raidSet);
        this.system.updateGlobalRaidSetIdentifiers();
    }

    RaidSet removeRaidSet(int n) {
        RaidSet raidSet = (RaidSet)this.raidSets.remove(new Integer(n));
        if (raidSet != null) {
            this.system.updateGlobalRaidSetIdentifiers();
        }
        return raidSet;
    }

    public RaidSet getRaidSet(int n) {
        return (RaidSet)this.raidSets.get(new Integer(n));
    }

    public Collection getRaidSets() {
        Map map = (Map)((TreeMap)this.raidSets).clone();
        return Collections.unmodifiableCollection(map.values());
    }

    public Disk getDisk(int n) {
        return (Disk)this.disks.get(new Integer(n));
    }

    public Collection getDisks() {
        return Collections.unmodifiableCollection(this.disks.values());
    }

    public HostInterface getHostInterface(int n) {
        return (FibreChannelInterface)this.hostInterfaces.get(new Integer(n));
    }

    public Collection getHostInterfaces() {
        return Collections.unmodifiableCollection(this.hostInterfaces.values());
    }

    public DiskSlot getDiskSlot(int n) {
        return (DiskSlot)this.slots.get(new Integer(n));
    }

    public Collection getDiskSlots() {
        return Collections.unmodifiableCollection(this.slots.values());
    }

    public Collection getMappedLuns() {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Iterator iterator = this.getRaidSets().iterator();
        while (iterator.hasNext()) {
            Collection collection = ((RaidSet)iterator.next()).getMappedSlices();
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                Slice slice = (Slice)iterator2.next();
                treeSet.add(new Integer(slice.getLunId()));
            }
        }
        return treeSet;
    }

    public Collection getUnmappedLuns() {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Collection collection = this.getMappedLuns();
        for (int i = 0; i <= 7; ++i) {
            Integer n = new Integer(i);
            if (collection.contains(n)) continue;
            treeSet.add(n);
        }
        return treeSet;
    }

    public int getLunsAllocated() {
        int n = 0;
        Iterator iterator = this.getRaidSets().iterator();
        while (iterator.hasNext()) {
            n += ((RaidSet)iterator.next()).getMappedSlices().size();
        }
        return n;
    }

    public int getLunsRemaining() {
        return 8 - this.getLunsAllocated();
    }

    public int getLunsRemainingForCreation() {
        return this.getLunsRemaining();
    }

    public int getLunsRemainingForSlicing() {
        return this.getLunsRemaining();
    }

    public static boolean isValidStripeSize(int n) {
        for (int i = 0; i < STRIPE_SIZES.length; ++i) {
            if (n != STRIPE_SIZES[i]) continue;
            return true;
        }
        return false;
    }

    public int nextRaidSetId() {
        int n = -1;
        Collection collection = this.getRaidSets();
        for (int i = 1; i <= 4; ++i) {
            boolean bl = false;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (((RaidSet)iterator.next()).getNativeId() != i) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            n = i;
            break;
        }
        return n;
    }

    public int compareTo(Object object) {
        RaidController raidController = (RaidController)object;
        return this.id - raidController.id;
    }

    public String paramString() {
        String string = "";
        string = string + "id=" + this.id + ",";
        string = string + "productId=" + this.productId + ",";
        string = string + "modelName=" + this.modelName + ",";
        string = string + "serialNumber=" + this.serialNumber + ",";
        string = string + "stripeSize=" + this.stripeSize + ",";
        string = string + "writeCacheEnabled=" + this.writeCacheState + ",";
        string = string + "hostInterfaceCount=" + this.hostInterfaceCount + ",";
        string = string + "diskChannelCount=" + this.diskChannelCount + ",";
        string = string + "slotCount=" + this.slotCount + ",";
        string = string + "memorySize=" + this.memorySize + ",";
        string = string + "cacheHitRatio=" + this.cacheHitRatio + ",";
        string = string + "readyState=" + this.readyState + ",";
        string = string + "clientCount=" + this.clientCount + ",";
        string = string + "firmwareVersion=" + this.firmwareVersion + ",";
        string = string + "accessMode=" + this.accessMode + ",";
        string = string + "prefetchSize=" + this.prefetchSize + ",";
        string = string + "autoRebuildEnabled=" + this.autoRebuildEnabled + ",";
        string = string + "rebuildRate=" + this.rebuildRate + ",";
        string = string + "checkDataGenerationEnabled=" + this.checkDataGenerationEnabled + ",";
        string = string + "lunMaskEnabled=" + this.lunMaskEnabled + ",";
        string = string + "jbodMaskEnabled=" + this.jbodMaskEnabled + ",";
        string = string + "diagnosticFunctionStatus=" + this.diagnosticFunctionStatus + ",";
        string = string + "cpuTemperature=" + this.cpuTemperature + ",";
        string = string + "tempStatus=" + this.tempStatus + ",";
        string = string + "bgrwConditioningPriority=" + this.bgrwConditioningPriority + ",";
        Iterator iterator = this.raidSets.values().iterator();
        while (iterator.hasNext()) {
            string = string + iterator.next() + ",";
        }
        iterator = this.disks.values().iterator();
        while (iterator.hasNext()) {
            string = string + iterator.next() + ",";
        }
        iterator = this.hostInterfaces.values().iterator();
        while (iterator.hasNext()) {
            string = string + iterator.next() + ",";
        }
        iterator = this.slots.values().iterator();
        while (iterator.hasNext()) {
            string = string + iterator.next();
            if (!iterator.hasNext()) continue;
            string = string + ",";
        }
        return string;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }
}

