/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.xsr.som.AbstractSystemElement;

public class PowerSupply
extends AbstractSystemElement
implements Comparable {
    private int id;
    private int status = -1;
    private float fiveVolt = -1.0f;
    private float twelveVolt = -1.0f;

    public PowerSupply(int n) {
        this.id = n;
    }

    public PowerSupply(PowerSupply powerSupply) {
        this.id = powerSupply.id;
        this.status = powerSupply.status;
        this.fiveVolt = powerSupply.fiveVolt;
        this.twelveVolt = powerSupply.twelveVolt;
    }

    public int getNativeId() {
        return this.id;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return "Power Supply " + this.id;
    }

    void setStatus(int n) {
        if (n != 0 && n != 1 && n != 2 && n != -1) {
            throw new IllegalArgumentException("illegal status argument (" + n + ")");
        }
        this.status = n;
    }

    public int getStatus() {
        return this.status;
    }

    void setFiveVolt(float f) {
        this.fiveVolt = f;
    }

    public float getFiveVolt() {
        return this.fiveVolt;
    }

    void setTwelveVolt(float f) {
        this.twelveVolt = f;
    }

    public float getTwelveVolt() {
        return this.twelveVolt;
    }

    public int compareTo(Object object) {
        PowerSupply powerSupply = (PowerSupply)object;
        return this.id - powerSupply.id;
    }

    public String paramString() {
        String string = "";
        string = string + "id=" + this.id + ",";
        string = string + "status=" + this.status + ",";
        string = string + "fiveVolt=" + this.fiveVolt + ",";
        string = string + "twelveVolt=" + this.twelveVolt;
        return string;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }
}

