/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.xsr.net.IPAddress;
import com.apple.xsr.som.AbstractSystemElement;
import com.apple.xsr.som.SystemController;
import java.net.UnknownHostException;

public class NetworkInterface
extends AbstractSystemElement
implements Comparable {
    public static final int LINK_DOWN = 0;
    public static final int LINK_UP = 1;
    public static final int DHCP = 512;
    public static final int STATIC = 1024;
    public static final int BOOTP = 8192;
    private static final int CONFIGURATION_METHOD_DYNAMIC = 256;
    public static final int SPEED_10MBIT = 0;
    public static final int SPEED_100MBIT = 1;
    public static final int SPEED_1000MBIT = 2;
    public static final int SPEED_1GBIT = 2;
    public static final int DUPLEX_HALF = 0;
    public static final int DUPLEX_FULL = 1;
    private int nativeId;
    private int id;
    private int status = -1;
    private int linkState = -1;
    private int configurationMethod = -1;
    private String macAddress;
    private IPAddress address;
    private IPAddress subnetMask;
    private IPAddress gatewayAddress;
    private IPAddress[] dns = new IPAddress[0];
    private int speed = -1;
    private int maxSpeed = -1;
    private int duplex = -1;
    private String dhcpClientId = "";
    SystemController controller;

    public NetworkInterface(int n, SystemController systemController) {
        if (systemController == null) {
            throw new NullPointerException("controller cannot be null");
        }
        this.nativeId = n;
        this.controller = systemController;
        this.id = systemController.getId();
    }

    public NetworkInterface(NetworkInterface networkInterface) {
        this.nativeId = networkInterface.nativeId;
        this.id = networkInterface.id;
        this.status = networkInterface.status;
        this.linkState = networkInterface.linkState;
        this.configurationMethod = networkInterface.configurationMethod;
        this.macAddress = networkInterface.macAddress;
        this.address = networkInterface.address;
        this.subnetMask = networkInterface.subnetMask;
        this.gatewayAddress = networkInterface.gatewayAddress;
        this.dns = (IPAddress[])networkInterface.dns.clone();
        this.speed = networkInterface.speed;
        this.maxSpeed = networkInterface.maxSpeed;
        this.duplex = networkInterface.duplex;
        this.dhcpClientId = networkInterface.dhcpClientId;
        this.controller = networkInterface.controller;
    }

    public int getNativeId() {
        return this.nativeId;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return "Network Interface " + this.id;
    }

    void setStatus(int n) {
        if (n != 0 && n != 1 && n != 2 && n != -1) {
            throw new IllegalArgumentException("illegal status argument (" + n + ")");
        }
        this.status = n;
    }

    public int getStatus() {
        return this.status;
    }

    void setLinkState(int n) {
        this.linkState = n;
        this.status = n == 1 ? 0 : 1;
    }

    public int getLinkState() {
        return this.linkState;
    }

    void setConfigurationMethod(int n) {
        if (n != 512 && n != 1024 && n != 8192 && n != -1) {
            throw new IllegalArgumentException("illegal configuration method " + n);
        }
        this.configurationMethod = n;
    }

    public int getConfigurationMethod() {
        return this.configurationMethod;
    }

    void setMacAddress(String string) {
        this.macAddress = string;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public String getMacAddressString() {
        return this.macAddress != null ? this.macAddress.toString() : "";
    }

    void setAddress(String string) throws UnknownHostException {
        this.address = new IPAddress(string);
    }

    public IPAddress getAddress() {
        return this.address;
    }

    public String getAddressString() {
        return this.address != null ? this.address.toString() : "";
    }

    void setSubnetMask(String string) throws UnknownHostException {
        this.subnetMask = new IPAddress(string);
    }

    public IPAddress getSubnetMask() {
        return this.subnetMask;
    }

    public String getSubnetMaskString() {
        return this.subnetMask != null ? this.subnetMask.toString() : "";
    }

    void setGateway(String string) throws UnknownHostException {
        this.gatewayAddress = new IPAddress(string);
    }

    public IPAddress getGateway() {
        return this.gatewayAddress;
    }

    void setDns(String[] stringArray) throws UnknownHostException {
        IPAddress[] iPAddressArray = new IPAddress[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            iPAddressArray[i] = new IPAddress(stringArray[i]);
        }
        this.dns = iPAddressArray;
    }

    public IPAddress[] getDns() {
        if (this.dns != null) {
            return (IPAddress[])this.dns.clone();
        }
        return new IPAddress[0];
    }

    void setSpeed(int n) {
        this.speed = n;
    }

    public int getSpeed() {
        return this.speed;
    }

    void setDuplex(int n) {
        this.duplex = n;
    }

    public int getDuplex() {
        return this.duplex;
    }

    void setDhcpClientId(String string) {
        this.dhcpClientId = string;
    }

    public String getDhcpClientId() {
        return this.dhcpClientId;
    }

    public int compareTo(Object object) {
        NetworkInterface networkInterface = (NetworkInterface)object;
        return this.id - networkInterface.id;
    }

    public String paramString() {
        String string = "";
        string = string + "id=" + this.id + ",";
        string = string + "linkState=" + this.linkState + ",";
        string = string + "configurationMethod=" + this.configurationMethod + ",";
        string = string + "macAddress=" + this.macAddress + ",";
        string = string + "address=" + this.address + ",";
        string = string + "subnetMask=" + this.subnetMask + ",";
        string = string + "gatewayAddress=" + this.gatewayAddress + ",";
        for (int i = 0; i < this.dns.length; ++i) {
            string = string + "dns" + (i + 1) + "=" + this.dns[i] + ",";
        }
        string = string + "speed=" + this.speed + ",";
        string = string + "maxSpeed=" + this.maxSpeed + ",";
        string = string + "duplex=" + this.duplex + ",";
        string = string + "dhcpClientId=" + this.dhcpClientId + ",";
        return string;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }
}

