/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.som;

import com.apple.xsr.som.AbstractSystemElement;
import com.apple.xsr.som.RaidController;
import com.apple.xsr.som.RaidSet;

public class Disk
extends AbstractSystemElement
implements Comparable {
    public static final int STATE_EMPTY = -2;
    public static final int STATE_OFFLINE = 0;
    public static final int STATE_ONLINE = 1;
    public static final int STATE_PREDICTIVE_FAILURE = 2;
    public static final int OFFLINE = 0;
    public static final int ONLINE = 1;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_UNASSIGNED = 0;
    public static final int TYPE_RAID_MEMBER = 1;
    public static final int TYPE_SPARE = 0;
    public static final int TYPE_JBOD = 3;
    public static final int TYPE_ORPHAN = 4;
    public static final int RAID_SET_NONE = -2;
    public static final int OP_NONE = 0;
    public static final int OP_REBUILDING = 1;
    public static final int OP_INITIALIZING = 2;
    private static final int SMART_NUM_ATTR = 30;
    private static final int SMART_ATTR_SIZE = 12;
    private static final int SMART_POWER_ON_HOURS_ATTR_ID = 9;
    private static final int SMART_BUFFER_SIZE = 512;
    private static final String IBM_MODEL = "IBM";
    private static final String HITACHI_MODEL = "Hitachi";
    private static final String HITACHI_VANCOUVER_4_MODEL = "HDT";
    private static final String MAXTOR_MODEL = "Maxtor";
    private static final String SEAGATE_GALAXY_MODEL = "ST3750640NA";
    public static final int CACHE_DISABLED = 0;
    public static final int CACHE_ENABLED = 1;
    public static final int SMART_THRESHOLD_NOT_EXCEEDED = 0;
    public static final int SMART_STATUS_OK = 0;
    public static final int SMART_THRESHOLD_EXCEEDED = 2;
    public static final int BLOCK_SIZE = 512;
    public static final int MEMBER_STATE_NORMAL = 0;
    public static final int MEMBER_STATE_ORPHANED = 1;
    public static final int MEMBER_STATE_RAID_SET_ID_CONFLICT = 2;
    public static final int MEMBER_STATE_RAID_MEMBER_CONFLICT = 3;
    public static final int MEMBER_STATE_HOT_PLUG = 4;
    public static final int RAID_TYPE_REGULAR = 0;
    public static final int RAID_TYPE_RAID_NOW = 1;
    public static final int HANDLE_OPEN = 0;
    public static final int HANDLE_CLOSED = 1;
    private int handleState = -1;
    private int nativeId;
    private int id;
    private int state = -1;
    private int type = -1;
    private int operation = -1;
    private long capacity = -1L;
    private int raidset = -1;
    private String vendor = "";
    private String product = "";
    private String revision = "";
    private int badBlockCount = -1;
    private int remappedBlockCount = -1;
    private int cacheState = -1;
    private int smartStatus = -1;
    private byte[] smartData = null;
    private int powerOnHours = -1;
    private OrphanMemberInfo orphanMemberInfo = null;
    RaidController controller;

    public Disk(int n, RaidController raidController) {
        if (raidController == null) {
            throw new NullPointerException("controller cannot be null");
        }
        this.nativeId = n;
        this.controller = raidController;
        int n2 = this.controller.getId();
        if (n2 == 1) {
            this.id = this.nativeId;
        } else if (n2 == 2) {
            this.id = this.nativeId + 7;
        } else {
            throw new IllegalArgumentException("Unrecognized RAID controller \"" + raidController + "\"");
        }
    }

    public Disk(Disk disk) {
        this.nativeId = disk.nativeId;
        this.id = disk.id;
        this.state = disk.state;
        this.type = disk.type;
        this.operation = disk.operation;
        this.capacity = disk.capacity;
        this.raidset = disk.raidset;
        this.vendor = disk.vendor;
        this.product = disk.product;
        this.revision = disk.revision;
        this.badBlockCount = disk.badBlockCount;
        this.remappedBlockCount = disk.remappedBlockCount;
        this.cacheState = disk.cacheState;
        this.smartStatus = disk.smartStatus;
        this.smartData = disk.smartData != null ? (byte[])disk.smartData.clone() : null;
        this.powerOnHours = disk.powerOnHours;
        this.handleState = disk.handleState;
        this.orphanMemberInfo = disk.orphanMemberInfo != null ? new OrphanMemberInfo(disk.orphanMemberInfo) : null;
        this.controller = disk.controller;
    }

    public int getNativeId() {
        return this.nativeId;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return "Disk " + this.getId();
    }

    public int getStatus() {
        if (this.state == 1) {
            if (this.smartStatus == 2) {
                return 1;
            }
            return 0;
        }
        if (this.state == 0 && this.type == 1) {
            return 2;
        }
        return -1;
    }

    void setState(int n) {
        this.state = n;
    }

    public int getState() {
        return this.state;
    }

    void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    void setOperation(int n) {
        this.operation = n;
    }

    public int getOperation() {
        return this.operation;
    }

    void setCapacity(long l) {
        this.capacity = l;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getCapacityBytes() {
        return this.capacity * 512L;
    }

    void setRaidSet(int n) {
        this.raidset = n;
    }

    public RaidSet getRaidSet() {
        if (this.raidset != -2) {
            return this.controller.getRaidSet(this.raidset);
        }
        return null;
    }

    void setVendor(String string) {
        if (string == null) {
            throw new NullPointerException("vendor cannot be null");
        }
        this.vendor = string;
    }

    public String getVendor() {
        return this.vendor;
    }

    void setModel(String string) {
        if (string == null) {
            throw new NullPointerException("model cannot be null");
        }
        this.product = string;
    }

    public String getModel() {
        return this.product;
    }

    void setRevision(String string) {
        if (string == null) {
            throw new NullPointerException("revision cannot be null");
        }
        this.revision = string;
    }

    public String getRevision() {
        return this.revision;
    }

    void setBadBlockCount(int n) {
        this.badBlockCount = n;
    }

    public int getBadBlockCount() {
        return this.badBlockCount;
    }

    void setRemappedBlockCount(int n) {
        this.remappedBlockCount = n;
    }

    public int getRemappedBlockCount() {
        return this.remappedBlockCount;
    }

    void setCacheState(int n) {
        if (n != 0 && n != 1 && n != -1) {
            throw new IllegalArgumentException("Illegal cache state: " + n);
        }
        this.cacheState = n;
    }

    public int getCacheState() {
        return this.cacheState;
    }

    public void setSmartData(byte[] byArray) {
        this.smartData = byArray;
        int n = this.parsePowerOnHoursFromSmartData(byArray);
        this.setPowerOnHours(n);
    }

    public byte[] getSmartData() {
        return this.smartData;
    }

    protected void setPowerOnHours(int n) {
        this.powerOnHours = n;
    }

    public int getPowerOnHours() {
        return this.powerOnHours;
    }

    void setSmartStatus(int n) {
        if (n != 0 && n != 2 && n != -1) {
            throw new IllegalArgumentException("Illegal SMART status (" + n + ")");
        }
        this.smartStatus = n;
    }

    public int getSmartStatus() {
        return this.smartStatus;
    }

    void setOrphanRaidMember(OrphanMemberInfo orphanMemberInfo) {
        this.orphanMemberInfo = orphanMemberInfo;
        if (orphanMemberInfo != null) {
            this.type = 4;
        }
    }

    public boolean isOrphanRaidMember() {
        return this.orphanMemberInfo != null;
    }

    public int getMemberState() {
        return this.orphanMemberInfo != null ? this.orphanMemberInfo.memberState : -1;
    }

    public long getFloatingId() {
        return this.orphanMemberInfo != null ? this.orphanMemberInfo.floatingId : -1L;
    }

    public long getMetaDataUpdateCount() {
        return this.orphanMemberInfo != null ? this.orphanMemberInfo.metaDataUpdateCount : -1L;
    }

    public int getOrphanRaidSetId() {
        return this.orphanMemberInfo != null ? this.orphanMemberInfo.raidSetId : -1;
    }

    public int getOrphanRaidLevel() {
        return this.orphanMemberInfo != null ? this.orphanMemberInfo.raidLevel : -1;
    }

    public int getOrphanRaidMemberCount() {
        return this.orphanMemberInfo != null ? this.orphanMemberInfo.diskCount : -1;
    }

    public int getOrphanRaidMemberIndex() {
        return this.orphanMemberInfo != null ? this.orphanMemberInfo.memberIndex : -1;
    }

    public int getOrphanRaidType() {
        return this.orphanMemberInfo != null ? this.orphanMemberInfo.raidType : -1;
    }

    public String getRaidControllerSerialNumber() {
        return this.orphanMemberInfo != null ? this.orphanMemberInfo.serialNumber : "";
    }

    public RaidController getRaidController() {
        return this.controller;
    }

    void setHandleState(int n) {
        if (n != 0 && n != 1 && n != -1) {
            throw new IllegalArgumentException("illegal handle state (" + n + ")");
        }
        this.handleState = n;
    }

    public int getHandleState() {
        return this.handleState;
    }

    protected int parsePowerOnHoursFromSmartData(byte[] byArray) {
        int n = -1;
        String string = this.getModel();
        if (string.regionMatches(0, IBM_MODEL, 0, IBM_MODEL.length()) || string.regionMatches(0, MAXTOR_MODEL, 0, MAXTOR_MODEL.length()) || string.regionMatches(0, HITACHI_MODEL, 0, HITACHI_MODEL.length()) || string.regionMatches(0, HITACHI_VANCOUVER_4_MODEL, 0, HITACHI_VANCOUVER_4_MODEL.length()) || string.regionMatches(0, SEAGATE_GALAXY_MODEL, 0, SEAGATE_GALAXY_MODEL.length())) {
            int n2 = 2;
            if (byArray != null && byArray.length == 512) {
                for (int i = 0; i < 30; ++i) {
                    if (byArray[n2] == 9) {
                        n = (byArray[n2 + 8] >= 0 ? byArray[n2 + 8] : byArray[n2 + 8] + 256) << 24 | (byArray[n2 + 7] >= 0 ? byArray[n2 + 7] : byArray[n2 + 7] + 256) << 16 | (byArray[n2 + 6] >= 0 ? byArray[n2 + 6] : byArray[n2 + 6] + 256) << 8 | (byArray[n2 + 5] >= 0 ? byArray[n2 + 5] : byArray[n2 + 5] + 256) << 0;
                        if (!string.regionMatches(0, MAXTOR_MODEL, 0, MAXTOR_MODEL.length())) continue;
                        n /= 60;
                        continue;
                    }
                    n2 += 12;
                }
            }
        }
        return n;
    }

    void clear() {
        this.state = -1;
        this.type = -1;
        this.operation = -1;
        this.capacity = -1L;
        this.raidset = -1;
        this.vendor = "";
        this.product = "";
        this.revision = "";
        this.remappedBlockCount = -1;
        this.smartStatus = -1;
        this.orphanMemberInfo = null;
        this.handleState = -1;
    }

    public int compareTo(Object object) {
        Disk disk = (Disk)object;
        return this.id - disk.id;
    }

    public String paramString() {
        String string = "";
        string = string + "nativeId=" + this.nativeId + ",";
        string = string + "id=" + this.id + ",";
        string = string + "state=" + this.state + ",";
        string = string + "type=" + this.type + ",";
        string = string + "operation=" + this.operation + ",";
        string = string + "capacity=" + this.capacity + ",";
        string = string + "raidset=" + this.raidset + ",";
        string = string + "vendor=" + this.vendor + ",";
        string = string + "model=" + this.product + ",";
        string = string + "revision=" + this.revision + ",";
        string = string + "badBlockCount=" + this.badBlockCount + ",";
        string = string + "remappedBlockCount=" + this.remappedBlockCount + ",";
        string = string + "cacheState=" + this.cacheState + ",";
        string = string + "smartStatus=" + this.smartStatus + ",";
        string = string + this.orphanMemberInfo + ",";
        string = string + "handleState=" + this.handleState;
        return string;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    public static class OrphanMemberInfo {
        public int memberState = -1;
        public long floatingId = -1L;
        public long metaDataUpdateCount = -1L;
        public int raidSetId = -1;
        public int raidLevel = -1;
        public int diskCount = -1;
        public int memberIndex = -1;
        public int raidType = -1;
        public String serialNumber = "";

        public OrphanMemberInfo() {
        }

        public OrphanMemberInfo(int n, long l, long l2, int n2, int n3, int n4, int n5, int n6, String string) {
            this.memberState = n;
            this.floatingId = l;
            this.metaDataUpdateCount = l2;
            this.raidSetId = n2;
            this.raidLevel = n3;
            this.diskCount = n4;
            this.memberIndex = n5;
            this.raidType = n6;
            this.serialNumber = string;
        }

        public OrphanMemberInfo(OrphanMemberInfo orphanMemberInfo) {
            this.memberState = orphanMemberInfo.memberState;
            this.floatingId = orphanMemberInfo.floatingId;
            this.metaDataUpdateCount = orphanMemberInfo.metaDataUpdateCount;
            this.raidSetId = orphanMemberInfo.raidSetId;
            this.raidLevel = orphanMemberInfo.raidLevel;
            this.diskCount = orphanMemberInfo.diskCount;
            this.memberIndex = orphanMemberInfo.memberIndex;
            this.raidType = orphanMemberInfo.raidType;
            this.serialNumber = orphanMemberInfo.serialNumber;
        }

        public String toString() {
            String string = "";
            string = string + "memberState=" + this.memberState;
            string = string + ",floatingId=" + this.floatingId;
            string = string + ",metaDataUpdateCount=" + this.metaDataUpdateCount;
            string = string + ",raidSetId=" + this.raidSetId;
            string = string + ",raidLevel=" + this.raidLevel;
            string = string + ",diskCount=" + this.diskCount;
            string = string + ",memberIndex=" + this.memberIndex;
            string = string + ",raidType=" + this.raidType;
            string = string + ",serialNumber=" + this.serialNumber;
            return string;
        }
    }
}

