/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.net;

import com.apple.xsr.net.AbstractRequestMessage;
import com.apple.xsr.net.RequestMessage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class UpdateFirmwareRequest
extends AbstractRequestMessage {
    public static final int DEFAULT_TIMEOUT = 180000;
    public static final String PROPERTY_RAID_FIRMWARE_VERSION = "X-Apple-RAID-Firmware-Version";
    protected static final String FIRMWARE_UPDATE = "/cgi-bin/firmware-update";
    protected static final String FIRMWARE_UPDATE_FULL = "/cgi-bin/firmware-update-full";
    protected static final String UPDATE_RAID_FIRMWARE = "/cgi-bin/update-raid-firmware";
    private InputStream inStream;

    public UpdateFirmwareRequest(RequestMessage.Target target, int n, int n2, InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("InputStream cannot be null");
        }
        this.init(target, n, n2);
        this.inStream = inputStream;
    }

    public UpdateFirmwareRequest(RequestMessage.Target target, int n, int n2, String string) throws FileNotFoundException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid imageFile (" + string + ")");
        }
        this.init(target, n, n2);
        File file = new File(string);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            throw new FileNotFoundException("Failed to open " + string);
        }
        this.inStream = new FileInputStream(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream) throws IOException {
        BufferedInputStream bufferedInputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(this.inStream);
            while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
                outputStream.write(n);
            }
            outputStream.flush();
        }
        finally {
            if (bufferedInputStream != null) {
                ((InputStream)bufferedInputStream).close();
            }
        }
    }

    public Object clone() {
        UpdateFirmwareRequest updateFirmwareRequest = (UpdateFirmwareRequest)super.clone();
        return updateFirmwareRequest;
    }

    private void init(RequestMessage.Target target, int n, int n2) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid controller type (" + n + ")");
        }
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("Invalid flash type (" + n2 + ")");
        }
        if (n == 0) {
            this.path = n2 == 0 ? FIRMWARE_UPDATE_FULL : FIRMWARE_UPDATE;
        } else if (n == 1) {
            this.path = UPDATE_RAID_FIRMWARE;
        } else {
            throw new Error("assert failed");
        }
        this.setTimeout(180000);
        this.xsyncTarget = target;
    }
}

