/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.net;

import java.net.UnknownHostException;

public class IPAddress
implements Comparable {
    private byte[] address;

    public IPAddress(String string) throws UnknownHostException {
        if (string == null) {
            throw new NullPointerException("address cannot be null");
        }
        this.parseAddress(string);
    }

    public IPAddress(byte[] byArray) throws UnknownHostException {
        if (byArray == null) {
            throw new NullPointerException("address cannot be null");
        }
        if (byArray.length < 4) {
            throw new UnknownHostException("Illegal IP address: " + byArray);
        }
        this.address = byArray;
    }

    public byte[] getAddress() {
        return this.address;
    }

    public Integer toInteger() {
        return new Integer(this.toInt());
    }

    public boolean isDefaultNetwork() {
        return this.isAllZero();
    }

    public boolean isAllZero() {
        boolean bl = true;
        for (int i = 0; i < this.address.length; ++i) {
            if (this.address[i] == 0) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean isLoopbackAddress() {
        return (this.address[0] & 0xFF) == 127;
    }

    public boolean isLinkLocalAddress() {
        return (this.address[0] & 0xFF) == 169 && (this.address[1] & 0xFF) == 254;
    }

    public boolean isLimitedBroadcastAddress() {
        boolean bl = true;
        for (int i = 0; i < this.address.length; ++i) {
            if ((this.address[i] & 0xFF) == 255) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((this.address[0] & 0xFF) + ".");
        stringBuffer.append((this.address[1] & 0xFF) + ".");
        stringBuffer.append((this.address[2] & 0xFF) + ".");
        stringBuffer.append(this.address[3] & 0xFF);
        return stringBuffer.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Assertion failure");
        }
    }

    public int hashCode() {
        return this.toInt();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof IPAddress && ((IPAddress)object).toInt() == this.toInt();
    }

    public int compareTo(Object object) {
        IPAddress iPAddress = (IPAddress)object;
        return this.toInt() - iPAddress.toInt();
    }

    private void parseAddress(String string) throws UnknownHostException {
        byte[] byArray = new byte[16];
        int n = 0;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c < '0' || c > '9') {
                throw new UnknownHostException("Illegal character (" + c + ") in  address: " + string);
            }
            int n2 = 0;
            while (c != '.') {
                if (c < '0' || c > '9') {
                    // empty if block
                }
                n2 = n2 * 10 + c - 48;
                if (++i >= cArray.length) break;
                c = cArray[i];
            }
            if (n2 > 255) {
                throw new UnknownHostException("Illegal octet (" + n2 + ") in address: " + string);
            }
            byArray[n] = (byte)n2;
            if (++n < byArray.length) continue;
            throw new UnknownHostException("Address too large: " + string);
        }
        if (n < 4 || string.endsWith(".")) {
            throw new UnknownHostException("Illegal address: " + string);
        }
        this.address = new byte[n];
        System.arraycopy(byArray, 0, this.address, 0, n);
    }

    private int toInt() {
        int n = this.address[3] & 0xFF;
        n |= this.address[2] << 8 & 0xFF00;
        n |= this.address[1] << 16 & 0xFF0000;
        return n |= this.address[0] << 24 & 0xFF000000;
    }
}

