/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.net;

import com.apple.xsr.net.HttpRequest;
import com.apple.xsr.net.HttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class HttpConnection {
    public static final int CONNECTION_TIMEOUT = 5000;
    public static final int DEFAULT_SO_TIMEOUT = 30000;
    public static final String SCHEME = "http";
    public static final int PORT = 80;
    private Socket socket;
    private String host;
    private boolean connected = false;
    private boolean persistent = false;
    private int timeout = 30000;
    private boolean requestOutstanding = false;
    private boolean requestSent = false;
    private boolean responseReceived = false;
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$net$HttpConnection == null ? (class$com$apple$xsr$net$HttpConnection = HttpConnection.class$("com.apple.xsr.net.HttpConnection")) : class$com$apple$xsr$net$HttpConnection);
    static /* synthetic */ Class class$com$apple$xsr$net$HttpConnection;

    public HttpConnection(String string) throws IOException, UnknownHostException {
        this.host = string;
    }

    public HttpRequest newRequest(String string) throws IOException, MalformedURLException {
        if (this.requestOutstanding) {
            String string2 = "There is an outstanding request. Either send the request or read the response first.";
            throw new IllegalStateException(string2);
        }
        URL uRL = new URL(SCHEME, this.host, string);
        HttpRequest httpRequest = new HttpRequest(this, uRL);
        this.requestOutstanding = true;
        this.requestSent = false;
        return httpRequest;
    }

    public HttpResponse getResponse() throws IOException {
        if (!this.requestOutstanding) {
            throw new IllegalStateException("No outstanding request");
        }
        if (!this.requestSent) {
            throw new IllegalStateException("Unsent request outstanding");
        }
        HttpResponse httpResponse = new HttpResponse(this);
        return httpResponse;
    }

    public void connect() throws IOException {
        if (this.socket == null || !this.connected) {
            this.createSocket(5000);
            this.connected = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws IOException {
        if (this.socket != null) {
            try {
                this.socket.close();
                logger.debug("Socket closed");
                Object var2_1 = null;
                this.socket = null;
                this.connected = false;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.socket = null;
                this.connected = false;
                throw throwable;
            }
        }
    }

    public void open() throws IOException {
        this.connect();
    }

    public void close() throws IOException {
        this.disconnect();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setPersistent(boolean bl) {
        this.persistent = bl;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setTimeout(int n) throws IOException {
        int n2 = n != 0 ? n : 30000;
        if (n2 == this.timeout) {
            return;
        }
        try {
            this.socket.setSoTimeout(n2);
            this.timeout = n2;
        }
        catch (SocketException socketException) {
            throw new IOException("Failed to set SO timeout: " + socketException.getMessage());
        }
    }

    public int getTimeout() throws IOException {
        try {
            return this.socket.getSoTimeout();
        }
        catch (SocketException socketException) {
            throw new IOException("Failed to read SO timeout: " + socketException.getMessage());
        }
    }

    OutputStream getOutputStream() throws IOException {
        if (this.socket == null || !this.isConnected()) {
            this.connect();
        }
        return this.socket.getOutputStream();
    }

    InputStream getInputStream() throws IOException {
        if (this.socket == null || !this.isConnected()) {
            this.connect();
        }
        return this.socket.getInputStream();
    }

    void setRequestOutstanding(boolean bl) {
        this.requestOutstanding = bl;
    }

    void setRequestSent(boolean bl) {
        this.requestSent = bl;
    }

    private void createSocket(int n) throws IOException {
        this.socket = new Socket(this.host, 80);
        try {
            this.socket.setSoTimeout(this.timeout);
        }
        catch (SocketException socketException) {
            logger.error(socketException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SocketProducer
    extends Thread {
        private Socket socket;
        private String host;
        private int port;
        private IOException exception;
        private boolean aborted = false;

        public SocketProducer(String string, int n) {
            super("SocketProducer: " + string + ":" + n);
            try {
                this.setDaemon(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.host = string;
            this.port = n;
        }

        public void run() {
            try {
                InetAddress[] inetAddressArray = InetAddress.getAllByName(this.host);
                for (int i = 0; i < inetAddressArray.length; ++i) {
                    try {
                        this.socket = new Socket(inetAddressArray[i], this.port);
                        break;
                    }
                    catch (SocketException socketException) {
                        if (i == inetAddressArray.length - 1 || this.aborted) {
                            throw socketException;
                        }
                        if (!this.aborted) {
                            continue;
                        }
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                this.exception = iOException;
            }
            if (this.aborted && this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.socket = null;
            }
        }

        public Socket getSocket() {
            return this.socket;
        }

        public IOException getException() {
            return this.exception;
        }

        public void abort() {
            this.aborted = true;
        }
    }
}

