/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.net;

import com.apple.xsr.net.AcpxConnection;
import com.apple.xsr.net.BasicResponse;
import com.apple.xsr.net.CommShutdownException;
import com.apple.xsr.net.CommunicationHandler;
import com.apple.xsr.net.RequestMessage;
import com.apple.xsr.net.Response;
import com.apple.xsr.som.RaidSystem;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import sun.io.MalformedInputException;

public class CommunicationsManager
implements Runnable {
    private static final int CONNECT_BACKOFF_CEILING = 3600000;
    private AcpxConnection connection;
    private LinkedList queue = new LinkedList();
    private RaidSystem system;
    private String primary;
    private String secondary;
    private Thread thread;
    private boolean stopped = false;
    private boolean connected = false;
    private boolean connectionFailureSent = false;
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$net$CommunicationsManager == null ? (class$com$apple$xsr$net$CommunicationsManager = CommunicationsManager.class$("com.apple.xsr.net.CommunicationsManager")) : class$com$apple$xsr$net$CommunicationsManager);
    static /* synthetic */ Class class$com$apple$xsr$net$CommunicationsManager;

    public CommunicationsManager(RaidSystem raidSystem) {
        this.system = raidSystem;
        this.thread = new Thread(this);
        this.thread.setName("CommMgr");
        this.thread.start();
    }

    public void postMessageAsync(CommunicationHandler communicationHandler, RequestMessage requestMessage) {
        this.postMessageAsync(communicationHandler, requestMessage, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMessageAsync(CommunicationHandler communicationHandler, RequestMessage requestMessage, Object object) {
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.add(new Transaction(communicationHandler, (RequestMessage)requestMessage.clone(), object));
            this.queue.notifyAll();
        }
    }

    public Response postMessage(RequestMessage requestMessage) throws IOException {
        if (this.isStopped()) {
            throw new CommShutdownException();
        }
        SyncSender syncSender = new SyncSender((RequestMessage)requestMessage.clone());
        Response response = syncSender.getResponse();
        if (response != null) {
            if (response.getException() != null) {
                Exception exception = response.getException();
                if (exception instanceof ConnectException) {
                    throw (ConnectException)exception;
                }
                if (exception instanceof CommShutdownException) {
                    throw (CommShutdownException)exception;
                }
                throw new IOException(response.getException().getMessage());
            }
        } else {
            logger.error("Reponse for sync postMessage was null");
        }
        return response;
    }

    public synchronized boolean isConnected() {
        return this.connected && this.connection != null;
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    public synchronized void exit() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        this.stopped = true;
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (true) {
                Object object;
                Object object2;
                Transaction transaction;
                Object object3 = this.queue;
                synchronized (object3) {
                    while (this.queue.size() == 0 && !this.isStopped()) {
                        this.queue.wait();
                    }
                    if (this.queue.size() == 0 && this.isStopped()) {
                        break;
                    }
                    transaction = (Transaction)this.queue.removeFirst();
                }
                if (logger.isDebugEnabled()) {
                    object3 = transaction.getMessage();
                    object2 = object3.getCommand();
                    object = object3.getTargetController();
                    logger.info("TX: Sending " + object3.getPath() + (object2 != null ? "/" + (String)object2 : "") + " to " + (object != null ? object + "" : "default"));
                }
                object3 = transaction.getHandler();
                object2 = null;
                object = null;
                try {
                    Object object4;
                    if (!this.isConnected() && !this.isStopped()) {
                        this.doConnect((CommunicationHandler)object3);
                    }
                    if (!this.isStopped()) {
                        object4 = transaction.getMessage();
                        object2 = this.connection.send(transaction.getMessage());
                        object = new BasicResponse(2, object2);
                    } else if (!this.connectionFailureSent) {
                        object4 = new CommShutdownException();
                        object = new BasicResponse(2, null, -102, (Exception)object4);
                    }
                }
                catch (MalformedInputException malformedInputException) {
                    logger.error((Object)malformedInputException, malformedInputException);
                    object = new BasicResponse(2, null, -102, (Exception)((Object)malformedInputException));
                }
                catch (IOException iOException) {
                    if (iOException.getMessage().startsWith("PropertyListException")) {
                        object = new BasicResponse(2, null, -103, iOException);
                        logger.error(iOException, iOException);
                    }
                    Object object5 = this;
                    synchronized (object5) {
                        this.connected = false;
                    }
                    object5 = this.queue;
                    synchronized (object5) {
                        this.queue.addFirst(transaction);
                    }
                    logger.error(iOException, iOException);
                    this.system.setUserMessageIndex(5);
                    this.doConnect((CommunicationHandler)object3);
                    object3 = null;
                }
                catch (Exception exception) {
                    logger.error(exception, exception);
                    object = new BasicResponse(2, null, -102, exception);
                }
                if (object3 != null && object != null) {
                    object3.handleResponse(this.system, (Response)object, transaction.getContext());
                }
                this.connectionFailureSent = false;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.info("Message dispatching stopped");
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnect(CommunicationHandler communicationHandler) {
        String string = null;
        long l = 0L;
        int n = 0;
        boolean bl = false;
        this.connectionFailureSent = false;
        long l2 = 5000L + (long)(Math.random() * 5000.0);
        while (!this.isStopped()) {
            Object object;
            Object object2;
            Object object3;
            String string2 = this.system.getPrimaryHostAddress();
            String string3 = this.system.getSecondaryHostAddress();
            if (this.isValidAddress(string2) && this.isValidAddress(string3)) {
                n = 2;
                object3 = null;
                if (this.connection != null) {
                    object3 = this.connection.getHostAddress();
                }
                if (object3 == null) {
                    object2 = string2;
                    object = string3;
                } else if (((String)object3).equals(string2)) {
                    object2 = string3;
                    object = string2;
                } else {
                    object2 = string2;
                    object = string3;
                }
                string = (l & 1L) == 0L ? object2 : object;
                logger.info("Attempt " + l + " to connect to " + string + " (" + (string.equals(string2) ? "primary" : "secondary") + ")");
            } else if (this.isValidAddress(string2)) {
                n = 1;
                string = string2;
                logger.info("Attempt " + l + " to connect to " + string + " (secondary not available)");
            } else if (this.isValidAddress(string3)) {
                n = 1;
                string = string3;
                logger.info("Attempt " + l + " to connect to " + string + " (primary not available)");
            } else {
                String string4 = "No valid host address for system \"" + this.system.getName() + "\"";
                object2 = new ConnectException(string4);
                object = new BasicResponse(0, null, -101, (Exception)object2);
                logger.error(string4);
                communicationHandler.handleResponse(this.system, (Response)object, null);
                return;
            }
            try {
                this.connection = new AcpxConnection(string);
                this.system.setHostAddress(string);
                this.system.setPollingEnabled(true);
                object3 = this;
                synchronized (object3) {
                    this.connected = true;
                }
                logger.info("Connected to " + string + " successfully");
                return;
            }
            catch (IOException iOException) {
                object2 = this;
                synchronized (object2) {
                    this.connected = false;
                }
                if (!(bl || communicationHandler == null || n >= 2 && ++l <= 1L)) {
                    object2 = new ConnectException(iOException.getMessage());
                    object = new BasicResponse(0, null, -101, (Exception)object2);
                    communicationHandler.handleResponse(this.system, (Response)object, null);
                    bl = true;
                    this.connectionFailureSent = true;
                }
                if (this.isStopped()) break;
                logger.warn("Failed to connect to " + string + ". Will retry in " + l2 / 1000L + " secs.");
                try {
                    Thread.sleep(l2);
                    if (l2 > 3600000L) continue;
                    l2 = l2 * 3L / 2L + 1L;
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
        logger.info("Stopped while attempting to connect to " + string);
    }

    private boolean isValidAddress(String string) {
        if (string == null || string.length() < 7) {
            return false;
        }
        return !string.equals("0.0.0.0");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SyncSender
    implements CommunicationHandler {
        Response response;
        boolean handled = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SyncSender(RequestMessage requestMessage) {
            CommunicationsManager.this.postMessageAsync(this, requestMessage);
            SyncSender syncSender = this;
            synchronized (syncSender) {
                while (!this.handled) {
                    try {
                        if (Thread.currentThread() == CommunicationsManager.this.thread) {
                            throw new IllegalStateException("Attempt to post message synchronously from handler callback");
                        }
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptedIOException interruptedIOException = new InterruptedIOException("communications shutdown");
                        this.response = new BasicResponse(2, null, -102, interruptedIOException);
                        this.handled = true;
                        break;
                    }
                }
            }
        }

        public synchronized void handleResponse(RaidSystem raidSystem, Response response, Object object) {
            this.response = response;
            this.handled = true;
            this.notifyAll();
        }

        public synchronized Response getResponse() {
            return this.response;
        }
    }

    private static class Transaction {
        CommunicationHandler handler;
        RequestMessage message;
        Object context;

        public Transaction(CommunicationHandler communicationHandler, RequestMessage requestMessage, Object object) {
            this.handler = communicationHandler;
            this.message = requestMessage;
            this.context = object;
        }

        public CommunicationHandler getHandler() {
            return this.handler;
        }

        public RequestMessage getMessage() {
            return this.message;
        }

        public Object getContext() {
            return this.context;
        }
    }
}

