/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.net;

import com.apple.net.acp.AcpPropertyCode;
import com.apple.net.acp.SimpleCryptCoder;
import com.apple.util.Base64Utilities;
import com.apple.util.plist.PropertyList;
import com.apple.util.plist.PropertyListException;
import com.apple.xsr.TestEmail;
import com.apple.xsr.net.AbstractRequestMessage;
import com.apple.xsr.net.AcpxConstants;
import com.apple.xsr.net.MessageFactory;
import com.apple.xsr.net.RequestMessage;
import com.apple.xsr.net.UpdateFirmwareRequest;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AcpxMessageFactory
implements MessageFactory {
    public static final int OUTBAND = 0;
    public static final int INBAND = 1;
    private static final String URL_ACP_GET = "/cgi-bin/acp-get";
    private static final String URL_ACP_SET = "/cgi-bin/acp-set";
    private static final String URL_ACP_ACTION = "/cgi-bin/acp-action";
    private static final String URL_RSP_ACTION = "/cgi-bin/rsp-action";
    private static final String URL_PERFORM_ACTION = "/cgi-bin/perform";
    private static final String URL_NOOP = "/cgi-bin/noop";
    private static final String URL_DIAGNOSTIC_ACTION = "/cgi-bin/diagnostic-action";
    private static final String ILLUMINATE = "led";
    private static final String CREATE_ARRAY = "create-array";
    private static final String DELETE_ARRAY = "delete-array";
    private static final String POWER = "power";
    private static final String GET_POWER_STATE = "power-state-get";
    private static final String RESTART_SYSTEM = "restart";
    private static final String MORSE_CODE = "morse-code";
    private static final String GET_CONTROLLER_PAGE = "get-page";
    private static final String GET_TIME = "get-rtc";
    private static final String SET_TIME = "set-rtc";
    private static final String SET_FIBRE_CHANNEL_SPEED = "set-fibre-channel-speed";
    private static final String JBOD_MASK_ENABLE = "jbod-mask-enable";
    private static final String CLEAR_EVENT_LOG = "clear-log";
    private static final String RESET_CONTROLLER_NVRAM = "raid-reset-nvram";
    private static final String RECALCULATE_CHECK_DATA = "recalculate-check-data";
    private static final String RESTART_CONTROLLER = "restart-controller";
    private static final String GET_POST_RESULTS = "boot-check-results-get";
    private static final String LED_DIAGNOSTIC = "led-test";
    private static final String DISK_DIAGNOSTIC = "drive-test";
    private static final String CONTROLLER_CACHE_DIAGNOSTIC = "dram-test";
    private static final String FIBRE_CHANNEL_DIAGNOSTIC = "fibre-channel-test";
    private static final String SERIAL_INTERFACE_DIAGNOSTIC = "serial-port-test";
    private static final String WRITE_SIGNATURE = "write-signature";
    private static final String READ_SIGNATURE = "read-signature";
    private static final String METHOD_SYSTEM_GET_EVENT_LOG = "/system/get-event-log";
    private static final String METHOD_SYSTEM_CLEAR_EVENT_LOG = "/system/clear-event-log";
    private static final String METHOD_SYSTEM_GET_SYSTEM_STATUS = "/system/get-system-status";
    private static final String METHOD_SYSTEM_MONITOR_RESET = "/system/monitor-reset";
    private static final String METHOD_SYSTEM_SEND_EMAIL = "/system/send-email";
    private static final String METHOD_SYSTEM_SET_LED = "/system/set-led";
    private static final String METHOD_RAID_ARRAY_BGRW = "/raid/array/background-raid-read-and-write";
    private static final String METHOD_RAID_ARRAY_CREATE = "/raid/array/create";
    private static final String METHOD_RAID_ARRAY_EXPAND = "/raid/array/expand";
    private static final String METHOD_RAID_ARRAY_SET_SLICE_SIZE = "/raid/array/set-slice-size";
    private static final String METHOD_RAID_ARRAY_VERIFY_CHECK_DATA = "/raid/array/verify-check-data";
    private static final String METHOD_RAID_FIBRE_TOPOLOGY_CONTROL = "/raid/fibre/topology-control";
    private static final String METHOD_RAID_FIBRE_HARD_LOOP_ID_CONTROL = "/raid/fibre/hard-loop-id-control";
    private static final String METHOD_RAID_FIBRE_HARD_LOOP_ID_SET = "/raid/fibre/hard-loop-id-set";
    private static final String METHOD_RAID_LUN_MASK_CONTROL = "/raid/lun/mask-control";
    private static final String METHOD_RAID_LUN_MASK_SET = "/raid/lun/mask-set";
    private static final String METHOD_RAID_LUN_ASSIGN = "/raid/lun/assign";
    private static final String METHOD_RAID_CACHE_CONTROL = "/raid/cache-control";
    private static final String METHOD_RAID_DRIVE_CACHE_CONTROL = "/raid/drive/cache-control";
    private static final String METHOD_RAID_FLUSH_NVRAM = "/raid/flush-nvram";
    private static final String METHOD_RAID_SET_PREFETCH_SIZE = "/raid/set-prefetch-size";
    private static final String METHOD_RAID_SET_BGRW_THRESHOLD = "/raid/set-background-raid-read-and-write-threshold";
    private static final String METHOD_RAID_SET_SYNCHRONIZE_CACHE = "/raid/set-synchronize-cache";
    private static final String METHOD_RAID_SLOW_READ_BYPASS_MODE_ENABLE = "/raid/real-time-slow-read-bypass-mode-enable";
    private static final String METHOD_RAID_DELETE_BROKEN_RAID_MEMBER = "/raid/delete-broken-raid-member";
    private static final String METHOD_RAID_CHANGE_BROKEN_RAID_ID = "/raid/change-broken-raid-id";
    private static final String GET_TEMPERATURE = "get-temperature";
    private static final String GET_DEVICE_PROPERTIES = "get-device-properties";
    private static final String TIMEOUT = "timeout";
    private static final String DEVICE = "name";
    private static final String DEVICE_ID = "id";
    private static final String DRIVE_ID = "drive-id";
    private static final String ARRAY_ID = "array-id";
    private static final String SLICE_ID = "slice-id";
    private static final String STATE = "state";
    private static final String ACTION = "action";
    private static final String PASSES = "passes";
    private static final String MODE = "mode";
    private static final String PAGE_ID = "page-id";
    private static final String GET_EVENT_LOG_DATE = "date";
    private static final String DATE = "rtc";
    private static final String ENABLE_DISABLE = "enable-disable";
    private static final String SIZE = "size";
    private static final String HOST_INTERFACE = "host-interface-id";
    private static final String SPEED = "speed";
    private static final String TOPOLOGY = "topology";
    private static final String HARD_LOOP_ID = "hard-loop-id";
    private static final String LUN_MASKS = "lun-masks";
    private static final String LUN_ID = "lun-id";
    private static final String SETTINGS = "settings";
    private static final String JBOD_MASK_ENABLED = "enable";
    private static final String JBOD_MASK_DISABLED = "disable";
    private static final String THRESHOLD = "threshold";
    private static final String RAID_LEVEL = "raid-level";
    private static final String STRIPE_SIZE = "stripe-size";
    private static final String MEMBERS = "drive-ids";
    private static final String RAID_TYPE = "raid-type";
    private static final String RPC_ARRAY_ID = "array-id";
    private static final String RPC_RAID_LEVEL = "raid-level";
    private static final String RPC_MEMBERS = "drives";
    private static final String RPC_RAID_TYPE = "raid-type";
    private static final String RPC_RAID_DISK_CACHE_CONTROL = "drive-cache-control";
    private static final String RPC_RAID_DISK_CACHE_ENABLE = "enable";
    private static final String RPC_RAID_DISK_CACHE_DISABLE = "disable";
    private static final String COUNT = "count";
    private static final String SLICE_SIZE_MB = "slice-size-mb";
    private static final String FLAG = "flag";
    private static final String MESSAGE = "message";
    private static final String LED_TYPE = "led-type";
    private static final String DISK = "drive-id";
    private static final String CYLINDER_COUNT = "cylinder-count";
    private static final String PORT1 = "port-1-id";
    private static final String PORT2 = "port-2-id";
    private static final String SIGNATURE = "signature";
    private static final String SIGNATURE_BLOCK_NUMBER = "block-number";
    private static final String SIGNATURE_MAX_SIZE = "max-size";
    private int channel = 0;
    private RequestMessage.Target defaultXsyncTarget;
    private int defaultTimeout = 0;
    private String defaultUser;
    private String defaultPassword;

    public AcpxMessageFactory() {
    }

    public AcpxMessageFactory(int n) {
        this.channel = n;
    }

    public RequestMessage.Target getDefaultTargetController() {
        return this.defaultXsyncTarget;
    }

    public void setDefaultTargetController(RequestMessage.Target target) {
        this.defaultXsyncTarget = target;
    }

    public int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(int n) {
        this.defaultTimeout = n;
    }

    public void setDefaultUser(String string) {
        this.defaultUser = string;
    }

    public void setDefaultPassword(String string) {
        this.setDefaultPassword(string, false);
    }

    public void setDefaultPassword(String string, boolean bl) {
        String string2 = null;
        if (bl) {
            try {
                byte[] byArray = SimpleCryptCoder.crypt(string.getBytes("UTF-8"));
                string2 = Base64Utilities.encode(byArray);
            }
            catch (Exception exception) {}
        } else {
            string2 = string;
        }
        this.defaultPassword = string2;
    }

    public RequestMessage newNoOpRequest() {
        return new AbstractRequestMessage(this.defaultXsyncTarget, this.defaultTimeout, URL_NOOP){

            public void writeTo(OutputStream outputStream) {
            }
        };
    }

    public RequestMessage newGetPropertyRequest(String string) {
        if (string == null) {
            throw new NullPointerException("Property cannot be null");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        PropertyList propertyList = new PropertyList(arrayList);
        return new AcpxRequestMessage(propertyList, URL_ACP_GET);
    }

    public RequestMessage newGetPropertyRequest(AcpPropertyCode acpPropertyCode) {
        if (acpPropertyCode == null) {
            throw new NullPointerException("property cannot be null");
        }
        return this.newGetPropertyRequest(acpPropertyCode.toString());
    }

    public RequestMessage newGetPropertiesRequest(String[] stringArray) {
        if (stringArray == null) {
            throw new NullPointerException("Properties cannot be null");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            arrayList.add(stringArray[i]);
        }
        PropertyList propertyList = new PropertyList(arrayList);
        return new AcpxRequestMessage(propertyList, URL_ACP_GET);
    }

    public RequestMessage newGetPropertiesRequest(AcpPropertyCode[] acpPropertyCodeArray) {
        if (acpPropertyCodeArray == null) {
            throw new NullPointerException("properties cannot be null");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < acpPropertyCodeArray.length; ++i) {
            if (acpPropertyCodeArray[i] == null) continue;
            arrayList.add(acpPropertyCodeArray[i].toString());
        }
        PropertyList propertyList = new PropertyList(arrayList);
        return new AcpxRequestMessage(propertyList, URL_ACP_GET);
    }

    public RequestMessage newSetPropertyRequest(String string, Object object) {
        if (string == null) {
            throw new NullPointerException("Property cannot be null");
        }
        if (object == null) {
            throw new NullPointerException("Value cannot be null");
        }
        if (!PropertyList.isValidElement(object)) {
            throw new IllegalArgumentException("illegal property list element " + object.getClass());
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(string, object);
        PropertyList propertyList = new PropertyList(hashMap);
        return new AcpxRequestMessage(propertyList, URL_ACP_SET);
    }

    public RequestMessage newSetPropertiesRequest(Map map) {
        if (map == null) {
            throw new NullPointerException("Properties cannot be null");
        }
        HashMap hashMap = new HashMap();
        Object object = map.keySet().iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (string == null) continue;
            Object v = map.get(string);
            if (v == null) {
                throw new NullPointerException("Value for \"" + string + "\" cannot be null");
            }
            if (!PropertyList.isValidElement(v)) {
                throw new ClassCastException("Illegal property list element \"" + v.getClass() + "\"");
            }
            hashMap.put(string, v);
        }
        object = new PropertyList(hashMap);
        return new AcpxRequestMessage((PropertyList)object, URL_ACP_SET);
    }

    public RequestMessage newGetStatusRequest() {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_SYSTEM_GET_SYSTEM_STATUS);
        return rpcRequestMessage;
    }

    public RequestMessage newGetControllerPageRequest(Integer n) {
        AcpxRequestMessage acpxRequestMessage = new AcpxRequestMessage(GET_CONTROLLER_PAGE, URL_RSP_ACTION);
        acpxRequestMessage.appendParam(PAGE_ID, n, new Integer(0));
        return acpxRequestMessage;
    }

    public RequestMessage newGetEventLogRequest(Date date) {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_SYSTEM_GET_EVENT_LOG);
        if (date != null) {
            rpcRequestMessage.appendParam(GET_EVENT_LOG_DATE, date);
        }
        return rpcRequestMessage;
    }

    public RequestMessage newClearEventLogRequest() {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_SYSTEM_CLEAR_EVENT_LOG);
        return rpcRequestMessage;
    }

    public RequestMessage newGetTimeRequest() {
        return new AcpxRequestMessage(GET_TIME, URL_RSP_ACTION);
    }

    public RequestMessage newSetTimeRequest(Date date) {
        AcpxRequestMessage acpxRequestMessage = new AcpxRequestMessage(SET_TIME, URL_RSP_ACTION);
        acpxRequestMessage.appendParam(DATE, date, new Date());
        return acpxRequestMessage;
    }

    public RequestMessage newGetTemperatureRequest(String string) {
        AcpxRequestMessage acpxRequestMessage = new AcpxRequestMessage(GET_TEMPERATURE, URL_DIAGNOSTIC_ACTION);
        acpxRequestMessage.appendParam(DEVICE, string, "emu");
        return acpxRequestMessage;
    }

    public RequestMessage newGetDevicePropertiesRequest(String string, Integer n) {
        AcpxRequestMessage acpxRequestMessage = new AcpxRequestMessage(GET_DEVICE_PROPERTIES, URL_DIAGNOSTIC_ACTION);
        acpxRequestMessage.appendParam(DEVICE, string, "emu");
        if (n != null) {
            acpxRequestMessage.appendParam(DEVICE_ID, n, null);
        }
        return acpxRequestMessage;
    }

    public RequestMessage newIlluminateRequest(String string, Integer n, String string2) {
        AcpxRequestMessage acpxRequestMessage = new AcpxRequestMessage(ILLUMINATE, URL_ACP_ACTION);
        acpxRequestMessage.appendParam(DEVICE, string, "service");
        if (n != null) {
            acpxRequestMessage.appendParam(DEVICE_ID, n, null);
        }
        acpxRequestMessage.appendParam(STATE, string2, "on");
        return acpxRequestMessage;
    }

    public RequestMessage newSystemMonitorResetRequest() {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_SYSTEM_MONITOR_RESET);
        return rpcRequestMessage;
    }

    public RequestMessage newSetDriveCacheControlRequest(int n, boolean bl) {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_RAID_DRIVE_CACHE_CONTROL);
        rpcRequestMessage.appendParam("drive-id", new Integer(n));
        rpcRequestMessage.appendParam(STATE, bl ? "enable" : "disable");
        return rpcRequestMessage;
    }

    public RequestMessage newSetRAIDCacheControlRequest(boolean bl) {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_RAID_CACHE_CONTROL);
        rpcRequestMessage.appendParam(STATE, bl ? "enable" : "disable");
        return rpcRequestMessage;
    }

    public RequestMessage newSetSynchronizeCacheRequest(int n) {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_RAID_SET_SYNCHRONIZE_CACHE);
        rpcRequestMessage.appendParam(ENABLE_DISABLE, new Integer(n));
        return rpcRequestMessage;
    }

    public RequestMessage newSlowReadBypassModeControlRequest(boolean bl) {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_RAID_SLOW_READ_BYPASS_MODE_ENABLE);
        rpcRequestMessage.appendParam(ENABLE_DISABLE, new Integer(bl ? 1 : 2));
        return rpcRequestMessage;
    }

    public RequestMessage newSetRAIDPrefetchSizeRequest(int n) {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_RAID_SET_PREFETCH_SIZE);
        rpcRequestMessage.appendParam(SIZE, new Integer(n));
        return rpcRequestMessage;
    }

    public RequestMessage newSetFibreChannelSpeedRequest(Integer n, String string) {
        AcpxRequestMessage acpxRequestMessage = new AcpxRequestMessage(SET_FIBRE_CHANNEL_SPEED, URL_RSP_ACTION);
        acpxRequestMessage.appendParam(HOST_INTERFACE, n, new Integer(1));
        acpxRequestMessage.appendParam(SPEED, string, "auto-negotiated");
        return acpxRequestMessage;
    }

    public RequestMessage newSetFibreChannelTopologyRequest(String string) {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_RAID_FIBRE_TOPOLOGY_CONTROL);
        rpcRequestMessage.appendParam(TOPOLOGY, string, "auto");
        return rpcRequestMessage;
    }

    public RequestMessage newSetFibreChannelHardLoopIDEnableRequest(boolean bl) {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_RAID_FIBRE_HARD_LOOP_ID_CONTROL);
        rpcRequestMessage.appendParam(STATE, bl ? "enable" : "disable");
        return rpcRequestMessage;
    }

    public RequestMessage newSetFibreChannelHardLoopIDRequest(Integer n) {
        if (n < 0 || n > 128) {
            throw new IllegalArgumentException("Illegal hard loop id value = " + n);
        }
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_RAID_FIBRE_HARD_LOOP_ID_SET);
        rpcRequestMessage.appendParam(HARD_LOOP_ID, n);
        return rpcRequestMessage;
    }

    public RequestMessage newSetFibreChannelLUNMaskEnableRequest(boolean bl) {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_RAID_LUN_MASK_CONTROL);
        rpcRequestMessage.appendParam(STATE, bl ? "enable" : "disable");
        return rpcRequestMessage;
    }

    public RequestMessage newSetFibreChannelLUNMaskRequest(ArrayList arrayList) {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_RAID_LUN_MASK_SET);
        rpcRequestMessage.appendParam(LUN_MASKS, arrayList);
        return rpcRequestMessage;
    }

    public RequestMessage newLUNAssignmentRequest(Integer n, Integer n2, Integer n3) {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_RAID_LUN_ASSIGN);
        rpcRequestMessage.appendParam("array-id", n);
        rpcRequestMessage.appendParam(SLICE_ID, n2);
        rpcRequestMessage.appendParam(LUN_ID, n3);
        return rpcRequestMessage;
    }

    public RequestMessage newSendEmailRequest(TestEmail testEmail) {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_SYSTEM_SEND_EMAIL);
        rpcRequestMessage.appendParam(SETTINGS, testEmail.toMap());
        return rpcRequestMessage;
    }

    public RequestMessage newJbodMaskEnableRequest(Boolean bl) {
        AcpxRequestMessage acpxRequestMessage = new AcpxRequestMessage(JBOD_MASK_ENABLE, URL_RSP_ACTION);
        String string = null;
        if (bl != null) {
            string = bl != false ? "enable" : "disable";
        }
        acpxRequestMessage.appendParam(ENABLE_DISABLE, string, "enable");
        return acpxRequestMessage;
    }

    public RequestMessage newFlushRaidControllerNvramRequest() {
        return new RpcRequestMessage(METHOD_RAID_FLUSH_NVRAM);
    }

    public RequestMessage newResetControllerNvramRequest() {
        return new AcpxRequestMessage(RESET_CONTROLLER_NVRAM, URL_ACP_ACTION);
    }

    public RequestMessage newCreateArrayRequest(Integer n, String string, Integer[] integerArray, String string2) {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_RAID_ARRAY_CREATE);
        rpcRequestMessage.appendParam("array-id", n, new Integer(0));
        rpcRequestMessage.appendParam("raid-level", string, "5");
        rpcRequestMessage.appendParam("raid-type", string2, "raid-now");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (integerArray != null) {
            for (int i = 0; i < integerArray.length; ++i) {
                if (integerArray[i] == null) continue;
                arrayList.add(integerArray[i]);
            }
        } else {
            for (int i = 0; i < 7; ++i) {
                arrayList.add(new Integer(i + 1));
            }
        }
        rpcRequestMessage.appendParam(RPC_MEMBERS, arrayList);
        rpcRequestMessage.appendParam(RPC_RAID_DISK_CACHE_CONTROL, "enable", "enable");
        return rpcRequestMessage;
    }

    public RequestMessage newCreateArrayAcpxRequest(Integer n, String string, Integer n2, Integer[] integerArray, String string2) {
        AcpxRequestMessage acpxRequestMessage = new AcpxRequestMessage(CREATE_ARRAY, URL_ACP_ACTION);
        acpxRequestMessage.appendParam("array-id", n, new Integer(0));
        acpxRequestMessage.appendParam("raid-level", string, "5");
        if (n2 != null) {
            acpxRequestMessage.appendParam(STRIPE_SIZE, n2, AcpxConstants.STRIPE_SIZE_128);
        }
        acpxRequestMessage.appendParam("raid-type", string2, "raid-now");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (integerArray != null) {
            for (int i = 0; i < integerArray.length; ++i) {
                if (integerArray[i] == null) continue;
                arrayList.add(integerArray[i]);
            }
        } else {
            for (int i = 0; i < 7; ++i) {
                arrayList.add(new Integer(i + 1));
            }
        }
        acpxRequestMessage.appendParam(MEMBERS, arrayList);
        return acpxRequestMessage;
    }

    public RequestMessage newDeleteArrayRequest(Integer n) {
        AcpxRequestMessage acpxRequestMessage = new AcpxRequestMessage(DELETE_ARRAY, URL_ACP_ACTION);
        acpxRequestMessage.appendParam("array-id", n, new Integer(0));
        return acpxRequestMessage;
    }

    public RequestMessage newExpandArrayRequest(Integer n, Integer n2) {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_RAID_ARRAY_EXPAND);
        rpcRequestMessage.appendParam("array-id", n, new Integer(0));
        rpcRequestMessage.appendParam(COUNT, n2, new Integer(0));
        return rpcRequestMessage;
    }

    public RequestMessage newSetSliceSizeRequest(Integer n, Integer n2, Integer n3) {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_RAID_ARRAY_SET_SLICE_SIZE);
        rpcRequestMessage.appendParam("array-id", n, new Integer(0));
        rpcRequestMessage.appendParam(SLICE_ID, n2);
        rpcRequestMessage.appendParam(SLICE_SIZE_MB, n3);
        return rpcRequestMessage;
    }

    public RequestMessage newVerifyCheckDataRequest(Integer n, String string) {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_RAID_ARRAY_VERIFY_CHECK_DATA);
        rpcRequestMessage.appendParam("array-id", n, new Integer(0));
        Integer n2 = string.equals("start") ? new Integer(1) : new Integer(2);
        rpcRequestMessage.appendParam(FLAG, n2, new Integer(1));
        return rpcRequestMessage;
    }

    public RequestMessage newRecalculateCheckDataRequest(Integer n, String string) {
        AcpxRequestMessage acpxRequestMessage = new AcpxRequestMessage(RECALCULATE_CHECK_DATA, URL_RSP_ACTION);
        acpxRequestMessage.appendParam("array-id", n, new Integer(1));
        acpxRequestMessage.appendParam(ACTION, string, "start");
        return acpxRequestMessage;
    }

    public RequestMessage newBackgroundReadWriteScanRequest(int n, int n2) {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_RAID_ARRAY_BGRW);
        rpcRequestMessage.appendParam("array-id", new Integer(n));
        rpcRequestMessage.appendParam(FLAG, new Integer(n2));
        return rpcRequestMessage;
    }

    public RequestMessage newSetBackgroundReadWriteScanThresholdRequest(Integer n) {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_RAID_SET_BGRW_THRESHOLD);
        rpcRequestMessage.appendParam(THRESHOLD, n, new Integer(0));
        return rpcRequestMessage;
    }

    public RequestMessage newDeleteBrokenRaidMemberRequest(int n) {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_RAID_DELETE_BROKEN_RAID_MEMBER);
        rpcRequestMessage.appendParam("drive-id", new Integer(n));
        return rpcRequestMessage;
    }

    public RequestMessage newChangeBrokenRaidIdRequest(int n, int n2) {
        RpcRequestMessage rpcRequestMessage = new RpcRequestMessage(METHOD_RAID_CHANGE_BROKEN_RAID_ID);
        rpcRequestMessage.appendParam("drive-id", new Integer(n));
        rpcRequestMessage.appendParam("array-id", new Integer(n2));
        return rpcRequestMessage;
    }

    public RequestMessage newPowerRequest(String string) {
        AcpxRequestMessage acpxRequestMessage = new AcpxRequestMessage(POWER, URL_ACP_ACTION);
        acpxRequestMessage.appendParam(ACTION, string, "on");
        return acpxRequestMessage;
    }

    public RequestMessage newGetPowerStateRequest() {
        return new AcpxRequestMessage(GET_POWER_STATE, URL_ACP_ACTION);
    }

    public RequestMessage newRestartSystemRequest() {
        AcpxRequestMessage acpxRequestMessage = new AcpxRequestMessage(RESTART_SYSTEM, URL_ACP_ACTION);
        acpxRequestMessage.setShutdownConnection(true);
        return acpxRequestMessage;
    }

    public RequestMessage newRestartRaidControllerRequest() {
        return new AcpxRequestMessage(RESTART_CONTROLLER, URL_RSP_ACTION);
    }

    public RequestMessage newClearRaidControllerEventLogRequest() {
        return new AcpxRequestMessage(CLEAR_EVENT_LOG, URL_RSP_ACTION);
    }

    public RequestMessage newMorseCodeRequest(String string, String string2) {
        AcpxRequestMessage acpxRequestMessage = new AcpxRequestMessage(MORSE_CODE, URL_ACP_ACTION);
        acpxRequestMessage.appendParam(DEVICE, string, "buzzer");
        acpxRequestMessage.appendParam(MESSAGE, string2, "lucy");
        return acpxRequestMessage;
    }

    public RequestMessage newUpdateFirmwareRequest(int n, int n2, String string) throws FileNotFoundException {
        return new UpdateFirmwareRequest(this.defaultXsyncTarget, n, n2, string);
    }

    public RequestMessage newLedDiagnosticRequest(String string, String string2, Integer n) {
        AcpxRequestMessage acpxRequestMessage = new AcpxRequestMessage(LED_DIAGNOSTIC, URL_ACP_ACTION);
        acpxRequestMessage.appendParam(LED_TYPE, string, "drive");
        acpxRequestMessage.appendParam(ACTION, string2, "start");
        acpxRequestMessage.appendParam(PASSES, n, new Integer(1));
        return acpxRequestMessage;
    }

    public RequestMessage newDiskDiagnosticRequest(Integer n, String string, String string2, Integer n2, Integer n3) {
        AcpxRequestMessage acpxRequestMessage = new AcpxRequestMessage(DISK_DIAGNOSTIC, URL_RSP_ACTION);
        acpxRequestMessage.appendParam("drive-id", n, new Integer(1));
        acpxRequestMessage.appendParam(ACTION, string, "start");
        acpxRequestMessage.appendParam(MODE, string2, "sequential-compare");
        acpxRequestMessage.appendParam(CYLINDER_COUNT, n2, new Integer(0));
        acpxRequestMessage.appendParam(PASSES, n3, new Integer(1));
        return acpxRequestMessage;
    }

    public RequestMessage newControllerCacheDiagnosticRequest(String string, Integer n) {
        AcpxRequestMessage acpxRequestMessage = new AcpxRequestMessage(CONTROLLER_CACHE_DIAGNOSTIC, URL_RSP_ACTION);
        acpxRequestMessage.appendParam(MODE, string, "normal");
        acpxRequestMessage.appendParam(PASSES, n, new Integer(1));
        return acpxRequestMessage;
    }

    public RequestMessage newFibreChannelDiagnosticRequest(String string, Integer n) {
        AcpxRequestMessage acpxRequestMessage = new AcpxRequestMessage(FIBRE_CHANNEL_DIAGNOSTIC, URL_RSP_ACTION);
        acpxRequestMessage.appendParam(ACTION, string, "start");
        acpxRequestMessage.appendParam(PASSES, n, new Integer(1));
        return acpxRequestMessage;
    }

    public RequestMessage newSerialInterfaceDiagnosticRequest(Integer n, Integer n2, String string, Integer n3) {
        AcpxRequestMessage acpxRequestMessage = new AcpxRequestMessage(SERIAL_INTERFACE_DIAGNOSTIC, URL_RSP_ACTION);
        acpxRequestMessage.appendParam(PORT1, n, new Integer(1));
        acpxRequestMessage.appendParam(PORT2, n2, new Integer(2));
        acpxRequestMessage.appendParam(ACTION, string, "start");
        acpxRequestMessage.appendParam(PASSES, n3, new Integer(1));
        return acpxRequestMessage;
    }

    public RequestMessage newGetPostResultsRequest() {
        AcpxRequestMessage acpxRequestMessage = new AcpxRequestMessage(GET_POST_RESULTS, URL_RSP_ACTION);
        return acpxRequestMessage;
    }

    public RequestMessage newWriteSignatureRequest(Integer n, String string) {
        AcpxRequestMessage acpxRequestMessage = new AcpxRequestMessage(WRITE_SIGNATURE, URL_RSP_ACTION);
        acpxRequestMessage.appendParam(SIGNATURE_BLOCK_NUMBER, n, new Integer(32768));
        byte[] byArray = null;
        try {
            if (string != null) {
                int n2 = 0;
                do {
                    if ((n2 = (string.getBytes("UTF-8").length + 2) / 3 * 4) <= 512) continue;
                    string = string.substring(0, string.length() - 1);
                } while (n2 > 512);
                byArray = string.getBytes("UTF-8");
            } else {
                byArray = new String("LCM+SBH").getBytes("UTF-8");
            }
            acpxRequestMessage.appendParam(SIGNATURE, byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return acpxRequestMessage;
    }

    public RequestMessage newReadSignatureRequest(Integer n, Integer n2) {
        AcpxRequestMessage acpxRequestMessage = new AcpxRequestMessage(READ_SIGNATURE, URL_RSP_ACTION);
        acpxRequestMessage.appendParam(SIGNATURE_BLOCK_NUMBER, n, new Integer(32768));
        acpxRequestMessage.appendParam(SIGNATURE_MAX_SIZE, n2, new Integer(512));
        return acpxRequestMessage;
    }

    private class RpcRequestMessage
    extends AcpxRequestTemplate {
        public RpcRequestMessage(String string) {
            super(AcpxMessageFactory.this.defaultXsyncTarget, AcpxMessageFactory.this.defaultTimeout, AcpxMessageFactory.URL_PERFORM_ACTION, string);
            if (string == null) {
                throw new NullPointerException("method cannot be null");
            }
            this.paramDict = new HashMap();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("method", string);
            hashMap.put("inputs", this.paramDict);
            ArrayList<HashMap<String, Object>> arrayList = new ArrayList<HashMap<String, Object>>();
            arrayList.add(hashMap);
            HashMap<String, ArrayList<HashMap<String, Object>>> hashMap2 = new HashMap<String, ArrayList<HashMap<String, Object>>>();
            hashMap2.put("requests", arrayList);
            this.plist = new PropertyList(hashMap2);
            if (AcpxMessageFactory.this.defaultUser != null) {
                this.setUser(AcpxMessageFactory.this.defaultUser);
            }
            if (AcpxMessageFactory.this.defaultPassword != null) {
                this.setPassword(AcpxMessageFactory.this.defaultPassword);
            }
        }

        public Object clone() {
            RpcRequestMessage rpcRequestMessage = (RpcRequestMessage)super.clone();
            return rpcRequestMessage;
        }
    }

    private class AcpxRequestMessage
    extends AcpxRequestTemplate {
        public AcpxRequestMessage(String string, String string2) {
            this(string, string2, true);
        }

        public AcpxRequestMessage(String string, String string2, boolean bl) {
            super(AcpxMessageFactory.this.defaultXsyncTarget, AcpxMessageFactory.this.defaultTimeout, string2, string);
            if (string == null) {
                throw new NullPointerException("command cannot be null");
            }
            if (string2 == null) {
                throw new NullPointerException("path cannot be null");
            }
            this.paramDict = new HashMap();
            if (bl && this.timeout != 0) {
                this.paramDict.put(AcpxMessageFactory.TIMEOUT, new Integer(this.timeout));
            }
            HashMap<String, Map> hashMap = new HashMap<String, Map>();
            hashMap.put(this.command, this.paramDict);
            this.plist = new PropertyList(hashMap);
            if (AcpxMessageFactory.this.defaultUser != null) {
                this.setUser(AcpxMessageFactory.this.defaultUser);
            }
            if (AcpxMessageFactory.this.defaultPassword != null) {
                this.setPassword(AcpxMessageFactory.this.defaultPassword);
            }
        }

        public AcpxRequestMessage(PropertyList propertyList, String string) {
            super(AcpxMessageFactory.this.defaultXsyncTarget, AcpxMessageFactory.this.defaultTimeout, string);
            if (propertyList == null) {
                throw new NullPointerException("PropertyList cannot be null");
            }
            this.plist = propertyList;
            this.path = string;
            if (AcpxMessageFactory.this.defaultUser != null) {
                this.setUser(AcpxMessageFactory.this.defaultUser);
            }
            if (AcpxMessageFactory.this.defaultPassword != null) {
                this.setPassword(AcpxMessageFactory.this.defaultPassword);
            }
        }

        public Object clone() {
            HashMap hashMap;
            AcpxRequestMessage acpxRequestMessage = (AcpxRequestMessage)super.clone();
            acpxRequestMessage.plist = new PropertyList(this.plist);
            if (acpxRequestMessage.paramDict != null && acpxRequestMessage.plist != null && (hashMap = (HashMap)acpxRequestMessage.plist.getRootElement()) != null) {
                acpxRequestMessage.paramDict = (Map)hashMap.get(this.command);
            }
            return acpxRequestMessage;
        }
    }

    private static abstract class AcpxRequestTemplate
    extends AbstractRequestMessage {
        PropertyList plist;
        Map paramDict;

        public AcpxRequestTemplate(RequestMessage.Target target, int n, String string) {
            super(target, n, string);
        }

        public AcpxRequestTemplate(RequestMessage.Target target, int n, String string, String string2) {
            super(target, n, string, string2);
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            if (outputStream == null) {
                throw new NullPointerException("OutputStream cannot be null");
            }
            if (this.plist == null) {
                throw new NullPointerException("Request message PList is null");
            }
            try {
                this.plist.writeTo(outputStream);
            }
            catch (PropertyListException propertyListException) {
                throw new IOException("Error parsing property list to XML: " + propertyListException.getMessage());
            }
        }

        public void appendParam(String string, String string2, String string3) {
            if (string == null) {
                throw new NullPointerException("Param cannot be null");
            }
            if (string2 == null && string3 == null) {
                throw new NullPointerException("Value and default value cannot both be null");
            }
            if (this.paramDict == null) {
                throw new IllegalStateException("Parameter dictionary is null");
            }
            if (string2 != null) {
                this.paramDict.put(string, string2);
            } else {
                this.paramDict.put(string, string3);
            }
        }

        public void appendParam(String string, Integer n, Integer n2) {
            if (string == null) {
                throw new NullPointerException("Param cannot be null");
            }
            if (n == null && n2 == null) {
                throw new NullPointerException("Value and default value cannot both be null");
            }
            if (this.paramDict == null) {
                throw new IllegalStateException("Parameter dictionary is null");
            }
            if (n != null) {
                this.paramDict.put(string, n);
            } else {
                this.paramDict.put(string, n2);
            }
        }

        public void appendParam(String string, Date date, Date date2) {
            if (string == null) {
                throw new NullPointerException("Param cannot be null");
            }
            if (date == null && date2 == null) {
                throw new NullPointerException("Value and default value cannot both be null");
            }
            if (this.paramDict == null) {
                throw new IllegalStateException("Parameter dictionary is null");
            }
            if (date != null) {
                this.paramDict.put(string, date);
            } else {
                this.paramDict.put(string, date2);
            }
        }

        public void appendParam(String string, Object object) {
            if (string == null) {
                throw new NullPointerException("Param cannot be null");
            }
            if (object == null) {
                throw new NullPointerException("Value cannot be null");
            }
            if (!PropertyList.isValidElement(object)) {
                throw new IllegalArgumentException("illegal plist element " + object.getClass());
            }
            this.paramDict.put(string, object);
        }

        public String toString() {
            String string = super.toString() + "\nContent:\n" + this.plist.toString();
            return string;
        }

        public Object clone() {
            AcpxRequestTemplate acpxRequestTemplate = (AcpxRequestTemplate)super.clone();
            return acpxRequestTemplate;
        }
    }
}

