/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.net;

import com.apple.net.acp.SimpleCryptInputStream;
import com.apple.net.acp.SimpleCryptOutputStream;
import com.apple.util.plist.PropertyList;
import com.apple.util.plist.PropertyListException;
import com.apple.xsr.net.HttpConnection;
import com.apple.xsr.net.HttpRequest;
import com.apple.xsr.net.HttpResponse;
import com.apple.xsr.net.RequestMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class AcpxConnection {
    public static final String PLIST_EXCEPTION = "PropertyListException";
    private static final boolean DEFAULT_PERSISTENT_CONNECTION_STATE = true;
    private static final boolean DEFAULT_ENCRYPTION_STATE = false;
    private static final boolean DUMP_XML = false;
    protected static final String CONTENT_TYPE = "text/xml";
    protected static final String USER_AGENT = "Apple-Xserve_RAID_Admin/1.6.0";
    protected static final String APPLE_XSYNC = "Apple-Xsync";
    protected String host;
    protected boolean persistent = true;
    protected boolean encrypted = false;
    protected HttpConnection connection;
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$net$AcpxConnection == null ? (class$com$apple$xsr$net$AcpxConnection = AcpxConnection.class$("com.apple.xsr.net.AcpxConnection")) : class$com$apple$xsr$net$AcpxConnection);
    static /* synthetic */ Class class$com$apple$xsr$net$AcpxConnection;

    public AcpxConnection(String string) throws IOException {
        if (string == null) {
            throw new NullPointerException("Host cannot be null");
        }
        this.host = string;
        this.createConnection();
    }

    public void close() throws IOException {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public void disconnect() throws IOException {
        this.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PropertyList send(RequestMessage requestMessage) throws IOException {
        boolean bl;
        PropertyList propertyList;
        block11: {
            if (requestMessage == null) {
                throw new NullPointerException("request cannot be null");
            }
            if (this.connection == null) {
                this.createConnection();
            }
            propertyList = null;
            OutputStream outputStream = null;
            InputStream inputStream = null;
            try {
                try {
                    HttpRequest httpRequest = this.connection.newRequest(requestMessage.getPath());
                    this.addHeaders(httpRequest, requestMessage);
                    this.connection.setTimeout(requestMessage.getTimeout());
                    outputStream = this.encrypted ? new SimpleCryptOutputStream(httpRequest.getOutputStream()) : httpRequest.getOutputStream();
                    requestMessage.writeTo(outputStream);
                    outputStream.close();
                    logger.debug("Request sent (" + httpRequest.getContentLength() + " bytes) " + "command=\"" + requestMessage.getCommand() + "\" " + "target=\"" + requestMessage.getTargetController() + "\"");
                    HttpResponse httpResponse = this.connection.getResponse();
                    inputStream = this.encrypted ? new SimpleCryptInputStream(httpResponse.getInputStream()) : httpResponse.getInputStream();
                    if (inputStream.available() != 0) {
                        propertyList = new PropertyList(inputStream);
                    }
                    logger.debug("Response read (" + httpResponse.getContentLength() + " bytes)");
                }
                catch (PropertyListException propertyListException) {
                    logger.error(propertyListException);
                    throw new IOException("PropertyListException: " + propertyListException.getMessage());
                }
                Object var8_8 = null;
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                boolean bl2;
                Object var8_9 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                boolean bl3 = bl2 = requestMessage.getShutdownConnection() || requestMessage.getRestartConnection() != -1;
                if (this.persistent) {
                    if (!bl2) throw throwable;
                }
                this.connection.disconnect();
                this.connection = null;
                throw throwable;
            }
            inputStream.close();
        }
        boolean bl4 = bl = requestMessage.getShutdownConnection() || requestMessage.getRestartConnection() != -1;
        if (this.persistent) {
            if (!bl) return propertyList;
        }
        this.connection.disconnect();
        this.connection = null;
        return propertyList;
    }

    public String getHostAddress() {
        return this.host;
    }

    public String getHost() {
        return this.getHostAddress();
    }

    public void setPersistent(boolean bl) {
        this.persistent = bl;
    }

    public void setEncrypted(boolean bl) {
        this.encrypted = bl;
    }

    private void createConnection() throws IOException {
        if (this.connection == null) {
            this.connection = new HttpConnection(this.host);
            this.connection.setPersistent(this.persistent);
            this.connection.open();
        } else {
            logger.warn("Attempt to create a connection with an existing connection open");
        }
    }

    private void addHeaders(HttpRequest httpRequest, RequestMessage requestMessage) {
        String[] stringArray;
        RequestMessage.Target target;
        boolean bl;
        httpRequest.setHeaderField("User-Agent", USER_AGENT);
        boolean bl2 = bl = requestMessage.getShutdownConnection() || requestMessage.getRestartConnection() != -1;
        if (!this.persistent || bl) {
            httpRequest.setHeaderField("Connection", "close");
        }
        String string = requestMessage.getUser();
        String string2 = requestMessage.getPassword();
        if (string != null) {
            httpRequest.setHeaderField("ACP-User", string);
        }
        if (string2 != null) {
            httpRequest.setHeaderField("ACP-Password", string2);
        }
        if ((target = requestMessage.getTargetController()) != null) {
            httpRequest.setHeaderField(APPLE_XSYNC, target + "");
        }
        if (this.encrypted) {
            httpRequest.setHeaderField("Content-Encoding", "acp-crypt");
        }
        if ((stringArray = requestMessage.getRequestProperties()).length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                logger.info("Adding request property \"" + stringArray[i] + "\" value = \"" + requestMessage.getRequestProperty(stringArray[i]) + "\"");
                httpRequest.setHeaderField(stringArray[i], requestMessage.getRequestProperty(stringArray[i]));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

