/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.net;

import com.apple.xsr.net.RequestMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

public abstract class AbstractRequestMessage
implements RequestMessage {
    protected String path = "";
    protected String command;
    protected RequestMessage.Target xsyncTarget;
    protected int timeout = 0;
    protected String user;
    protected String password;
    protected boolean shutdown = false;
    protected int restart = -1;
    protected HashMap properties = new HashMap();

    public AbstractRequestMessage() {
    }

    public AbstractRequestMessage(RequestMessage.Target target, int n, String string) {
        this(target, n, string, null);
    }

    public AbstractRequestMessage(RequestMessage.Target target, int n, String string, String string2) {
        this.xsyncTarget = target;
        this.timeout = n;
        this.path = string;
        this.command = string2;
    }

    public RequestMessage.Target getTargetController() {
        return this.xsyncTarget;
    }

    public void setTargetController(RequestMessage.Target target) {
        this.xsyncTarget = target;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public String getPath() {
        return this.path;
    }

    public String getCommand() {
        return this.command;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setShutdownConnection(boolean bl) {
        this.shutdown = bl;
    }

    public boolean getShutdownConnection() {
        return this.shutdown;
    }

    public void setRestartConnection(boolean bl, int n) {
        if (n < 0) {
            n = 0;
        }
        this.restart = bl ? n : -1;
    }

    public int getRestartConnection() {
        return this.restart;
    }

    public void setRequestProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    public String getRequestProperty(String string) {
        return (String)this.properties.get(string);
    }

    public String[] getRequestProperties() {
        return this.properties.keySet().toArray(new String[0]);
    }

    public abstract void writeTo(OutputStream var1) throws IOException;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Path: " + this.path + "\n");
        stringBuffer.append("Command: " + this.command + "\n");
        stringBuffer.append("Xsync Target: " + this.xsyncTarget + "\n");
        stringBuffer.append("Timeout: " + this.timeout + "\n");
        stringBuffer.append("User: " + this.user + "\n");
        stringBuffer.append("Password: " + this.password + "\n");
        return stringBuffer.toString();
    }

    public Object clone() {
        try {
            AbstractRequestMessage abstractRequestMessage = (AbstractRequestMessage)super.clone();
            return abstractRequestMessage;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Assertion failure");
        }
    }
}

