/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.firstaid;

import com.apple.gui.GUIFactory;
import com.apple.xsr.AbstractChooserMgmtPane;
import com.apple.xsr.DataModel;
import com.apple.xsr.DriveInfoPanelController;
import com.apple.xsr.DriveInformationPanel;
import com.apple.xsr.DrivePanel;
import com.apple.xsr.DrivePanelEvent;
import com.apple.xsr.DrivePanelListener;
import com.apple.xsr.DriveSelectionPanelEx;
import com.apple.xsr.RadioButtonGroup;
import com.apple.xsr.Resources;
import com.apple.xsr.StepByStepPanel;
import com.apple.xsr.firstaid.AbstractFirstAidPane;
import com.apple.xsr.firstaid.FirstAidDataModel;
import com.apple.xsr.som.Disk;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;

class RecognizeArrayPane
extends AbstractFirstAidPane {
    public static final String TAG = "RECOGNIZE_ARRAY_PANE";
    public static final String ACTION_CMD_UPPER_RADIO = "UPPER";
    public static final String ACTION_CMD_LOWER_RADIO = "LOWER";
    private static final Image IMG_VALIDATE_OK = Resources.getImage("icon.step.four");
    private static final Image IMG_VALIDATE_ERROR = Resources.getImage("icon.step.five");
    private static final AbstractFirstAidPane.PaneProperties props = new AbstractFirstAidPane.PaneProperties();
    private RadioButtonGroup controllerButtonGroup;
    private JRadioButton upperControllerRadio;
    private JRadioButton lowerControllerRadio;
    private int orphanCountTop;
    private int orphanCountBottom;
    private boolean radioClicked = false;

    public RecognizeArrayPane(AbstractChooserMgmtPane abstractChooserMgmtPane) {
        super(abstractChooserMgmtPane, props);
        this.buttons.setRestartRequiredLabelVisible(true);
        this.buttons.okButton.setEnabled(false);
    }

    public void populateUI(DataModel dataModel) {
        if (dataModel == null) {
            throw new NullPointerException("data cannot be null");
        }
        if (!(dataModel instanceof FirstAidDataModel)) {
            throw new IllegalArgumentException("illegal data model type \"" + dataModel.getClass() + "\"");
        }
        FirstAidDataModel firstAidDataModel = (FirstAidDataModel)dataModel;
        this.system = firstAidDataModel.getRaidSystem();
        this.driveSelectionPanel.setRaidSystem(this.system);
        this.legend.setRaidSystem(this.system);
        for (int i = 1; i <= 2; ++i) {
            Iterator iterator = this.system.getRaidController(i).getDisks().iterator();
            while (iterator.hasNext()) {
                if (((Disk)iterator.next()).getType() != 4) continue;
                if (i == 1) {
                    ++this.orphanCountTop;
                    continue;
                }
                ++this.orphanCountBottom;
            }
        }
    }

    public boolean validateUI(DataModel dataModel) {
        if (dataModel != null && paneExecuted.equals(TAG)) {
            if (!(dataModel instanceof FirstAidDataModel)) {
                throw new IllegalArgumentException("illegal data model type \"" + dataModel.getClass() + "\"");
            }
            FirstAidDataModel firstAidDataModel = (FirstAidDataModel)dataModel;
            firstAidDataModel.setOperation(7);
            firstAidDataModel.setControllerID(this.getSelectedControllerID());
        }
        return true;
    }

    protected final JPanel createDrivePanel(int n, StepByStepPanel stepByStepPanel, JTextPane jTextPane, JButton jButton) {
        JPanel jPanel = GUIFactory.newPanel(new GridBagLayout());
        DriveInformationPanel driveInformationPanel = new DriveInformationPanel(null, Resources.getString("management.driveInfo.note"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.driveSelectionPanel = new DriveSelectionPanelEx(n);
        ((DriveSelectionPanelEx)this.driveSelectionPanel).setSelectionPolicy(new DrivePanel.DefaultSelectionPolicy(-1, -1));
        ((DriveSelectionPanelEx)this.driveSelectionPanel).addDrivePanelListener(new DrivePanelListener(){

            public void valueChanged(DrivePanelEvent drivePanelEvent) {
                if (!drivePanelEvent.getValueIsAdjusting() && drivePanelEvent.getStateChange() == 1) {
                    int n = drivePanelEvent.getFirstID();
                    if (n <= 7) {
                        RecognizeArrayPane.this.upperControllerRadio.setSelected(true);
                    } else {
                        RecognizeArrayPane.this.lowerControllerRadio.setSelected(true);
                    }
                    boolean bl = RecognizeArrayPane.this.isPaneValid();
                    RecognizeArrayPane.this.buttons.okButton.setEnabled(bl);
                    RecognizeArrayPane.this.summaryHeader.setIcon(bl ? IMG_VALIDATE_OK : IMG_VALIDATE_ERROR);
                }
            }

            public void driveIconEntered(DrivePanelEvent drivePanelEvent) {
            }

            public void driveIconExited(DrivePanelEvent drivePanelEvent) {
            }

            public void driveIconClicked(DrivePanelEvent drivePanelEvent) {
            }
        });
        DriveInfoPanelController driveInfoPanelController = new DriveInfoPanelController(driveInformationPanel);
        ((DriveSelectionPanelEx)this.driveSelectionPanel).addDrivePanelListener(driveInfoPanelController);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        jPanel.add((Component)((JPanel)((Object)this.driveSelectionPanel)), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        jPanel.add((Component)driveInformationPanel, gridBagConstraints);
        return jPanel;
    }

    protected JPanel createConfirmationPanel(String string) {
        return null;
    }

    protected void addSteps() {
        this.controllerButtonGroup = new RadioButtonGroup();
        this.addStep(this.getNextStep(), Resources.getString("firstAid.recognizeArray.chooseController"));
        JPanel jPanel = GUIFactory.newPanel(new GridBagLayout());
        ControllerRadioListener controllerRadioListener = new ControllerRadioListener();
        this.upperControllerRadio = GUIFactory.newRadioButton(Resources.getString("firstAid.recognizeArray.chooseController.upper"));
        this.upperControllerRadio.setFont(GUIFactory.FONT_SMALL);
        this.upperControllerRadio.setActionCommand(ACTION_CMD_UPPER_RADIO);
        this.upperControllerRadio.addActionListener(controllerRadioListener);
        this.lowerControllerRadio = GUIFactory.newRadioButton(Resources.getString("firstAid.recognizeArray.chooseController.lower"));
        this.lowerControllerRadio.setFont(GUIFactory.FONT_SMALL);
        this.lowerControllerRadio.setActionCommand(ACTION_CMD_LOWER_RADIO);
        this.lowerControllerRadio.addActionListener(controllerRadioListener);
        this.controllerButtonGroup.add(this.upperControllerRadio);
        this.controllerButtonGroup.add(this.lowerControllerRadio);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.upperControllerRadio, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.lowerControllerRadio, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = this.getCurrentRow();
        gridBagConstraints.insets = new Insets(0, 20, 15, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        this.setCurrentRow(gridBagConstraints.gridy + 1);
    }

    private int getSelectedControllerID() {
        int n = this.controllerButtonGroup.getSelectedIndex();
        if (n != -1) {
            n = n == 0 ? 1 : 2;
        }
        return n;
    }

    private boolean isPaneValid() {
        int n = 0;
        int n2 = this.getSelectedControllerID();
        if (n2 != -1) {
            n = n2 == 1 ? this.orphanCountTop : this.orphanCountBottom;
        }
        return n > 1;
    }

    static {
        RecognizeArrayPane.props.icon = new ImageIcon(Resources.getImage("icon.recognizeArray"));
        RecognizeArrayPane.props.title = Resources.getString("firstAid.recognizeArray");
        RecognizeArrayPane.props.explanation = Resources.getString("firstAid.recognizeArrayExplanation");
        RecognizeArrayPane.props.tag = TAG;
        RecognizeArrayPane.props.headerText = Resources.getString("firstAid.recognizeArray.examineDrives");
        RecognizeArrayPane.props.legendTitle = Resources.getString("firstAid.general.legendTitle");
        RecognizeArrayPane.props.summaryTitle = Resources.getString("firstAid.general.summaryTitle");
        RecognizeArrayPane.props.summaryText = Resources.getString("firstAid.recognizeArray.summary");
        RecognizeArrayPane.props.actionButtonText = Resources.getString("firstAid.recognizeArray.actionButton");
        RecognizeArrayPane.props.driveSelectionMode = 3;
        RecognizeArrayPane.props.arraySelectionMode = 0;
    }

    private class ControllerRadioListener
    implements ActionListener {
        private ControllerRadioListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand() == RecognizeArrayPane.ACTION_CMD_UPPER_RADIO) {
                ((DriveSelectionPanelEx)RecognizeArrayPane.this.driveSelectionPanel).doClick(1);
            } else {
                ((DriveSelectionPanelEx)RecognizeArrayPane.this.driveSelectionPanel).doClick(8);
            }
        }
    }
}

