/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.cli;

import com.apple.xsr.cli.CommandLineOption;
import com.apple.xsr.cli.IllegalOptionException;
import com.apple.xsr.cli.MissingArgumentException;
import com.apple.xsr.cli.OptionException;
import java.util.Hashtable;
import java.util.Vector;

public class OptionTokenizer {
    private String[] args;
    private Hashtable options;
    private int index;
    private int nextArgIndex;
    private int groupIndex;
    private boolean processingGroupedArgs;

    public OptionTokenizer(String[] stringArray, String string) {
        this.args = stringArray;
        this.index = 0;
        this.nextArgIndex = 0;
        this.groupIndex = 0;
        this.processingGroupedArgs = false;
        this.options = new Hashtable();
        this.parseOptionString(string);
    }

    public boolean hasMoreOptions() {
        boolean bl = true;
        try {
            if (this.getNextOption() == null) {
                bl = false;
            }
        }
        catch (OptionException optionException) {
            // empty catch block
        }
        return bl;
    }

    public boolean hasNext() {
        return this.hasMoreOptions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CommandLineOption nextOption() throws IllegalOptionException, MissingArgumentException {
        CommandLineOption commandLineOption = null;
        OptionException optionException = null;
        try {
            try {
                commandLineOption = this.getNextOption();
            }
            catch (OptionException optionException2) {
                optionException = optionException2;
                Object var5_4 = null;
                this.incrementIndex();
                if (optionException == null) return commandLineOption;
                if (optionException instanceof IllegalOptionException) {
                    throw (IllegalOptionException)optionException;
                }
                if (!(optionException instanceof MissingArgumentException)) return commandLineOption;
                throw (MissingArgumentException)optionException;
            }
            Object var5_3 = null;
            this.incrementIndex();
            if (optionException == null) return commandLineOption;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.incrementIndex();
            if (optionException == null) throw throwable;
            if (optionException instanceof IllegalOptionException) {
                throw (IllegalOptionException)optionException;
            }
            if (!(optionException instanceof MissingArgumentException)) throw throwable;
            throw (MissingArgumentException)optionException;
        }
        if (optionException instanceof IllegalOptionException) {
            throw (IllegalOptionException)optionException;
        }
        if (!(optionException instanceof MissingArgumentException)) return commandLineOption;
        throw (MissingArgumentException)optionException;
    }

    public Object next() throws IllegalOptionException, MissingArgumentException {
        return this.nextOption();
    }

    /*
     * Enabled aggressive block sorting
     */
    private CommandLineOption getNextOption() throws IllegalOptionException, MissingArgumentException {
        String string;
        int n;
        Vector<String> vector;
        CommandLineOption commandLineOption;
        block11: {
            String string2;
            block9: {
                block10: {
                    commandLineOption = null;
                    vector = null;
                    if (this.index >= this.args.length) {
                        return null;
                    }
                    string2 = this.args[this.index];
                    if (this.processingGroupedArgs) break block9;
                    if (!string2.startsWith("-") || string2.equals("-") || string2.equals("--")) break block10;
                    String string3 = this.getOptionName(string2);
                    if (!this.isValidOption(string3)) {
                        this.nextArgIndex = this.index + 1;
                        throw new IllegalOptionException(string2);
                    }
                    commandLineOption = new CommandLineOption(string3);
                    if (this.requiresArgs(string3).equals(Boolean.TRUE)) {
                        vector = new Vector<String>();
                        if (string2.length() > 2) {
                            vector.add(string2.substring(2));
                        }
                        break block11;
                    } else {
                        if (string2.length() > 2) {
                            this.processingGroupedArgs = true;
                            this.groupIndex = 0;
                        }
                        this.nextArgIndex = this.index + 1;
                        return commandLineOption;
                    }
                }
                if (string2.equals("-")) {
                    // empty if block
                }
                if (!string2.equals("--")) return commandLineOption;
                this.nextArgIndex = this.args.length;
                return commandLineOption;
            }
            String string4 = string2.substring(this.groupIndex + 1, this.groupIndex + 2);
            if (this.isValidOption(string4) && this.requiresArgs(string4).equals(Boolean.FALSE)) {
                return new CommandLineOption(string4);
            }
            if (!this.requiresArgs(string4).equals(Boolean.TRUE)) throw new IllegalOptionException(string4);
            throw new MissingArgumentException(string4);
        }
        for (n = this.index + 1; !(n >= this.args.length || (string = this.args[n]).startsWith("-") && this.isValidOption(string)); ++n) {
            vector.add(string);
        }
        this.nextArgIndex = n;
        if (vector.size() <= 0) throw new MissingArgumentException(commandLineOption.getName());
        commandLineOption.setArguments(vector.toArray(new String[0]));
        return commandLineOption;
    }

    private void incrementIndex() {
        if (this.processingGroupedArgs) {
            ++this.groupIndex;
            if (this.groupIndex + 1 >= this.args[this.index].length()) {
                this.processingGroupedArgs = false;
                this.groupIndex = 0;
                ++this.index;
            }
        } else if (this.index < this.args.length) {
            this.index = this.nextArgIndex;
        }
    }

    private boolean isValidOption(String string) {
        boolean bl;
        String string2 = this.getOptionName(string);
        if (string2.equals("")) {
            bl = false;
        }
        bl = this.options.containsKey(string2);
        return bl;
    }

    private Boolean requiresArgs(String string) {
        String string2 = this.getOptionName(string);
        Boolean bl = (Boolean)this.options.get(string);
        if (bl != null) {
            return bl;
        }
        return Boolean.FALSE;
    }

    private String getOptionName(String string) {
        String string2 = "";
        if (string.startsWith("-") && string.length() >= 2) {
            string2 = string.substring(1, 2);
        } else if (string.length() == 1) {
            string2 = string;
        }
        return string2;
    }

    private void parseOptionString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            String string2 = stringBuffer.substring(i, i + 1);
            Boolean bl = Boolean.FALSE;
            if (i + 1 < stringBuffer.length() && stringBuffer.charAt(i + 1) == ':') {
                bl = Boolean.TRUE;
                ++i;
            }
            this.options.put(string2, bl);
        }
    }
}

