/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.cli;

import com.apple.xsr.cli.CommandLineOption;
import com.apple.xsr.cli.IllegalOptionException;
import com.apple.xsr.cli.MissingArgumentException;
import com.apple.xsr.cli.OptionException;
import com.apple.xsr.cli.OptionTokenizer;
import java.util.Hashtable;

public class OptionSet {
    private Hashtable options;

    public OptionSet() {
        this.options = new Hashtable();
    }

    public OptionSet(String[] stringArray, String string) throws MissingArgumentException {
        if (stringArray == null) {
            throw new NullPointerException("Args cannot be null");
        }
        if (string == null) {
            throw new NullPointerException("optstring cannot be null");
        }
        this.options = new Hashtable();
        this.parseArgs(stringArray, string);
    }

    public CommandLineOption get(String string) throws OptionException {
        if (string == null) {
            throw new NullPointerException("Option name cannot be null");
        }
        CommandLineOption commandLineOption = (CommandLineOption)this.options.get(string);
        if (commandLineOption == null) {
            commandLineOption = new CommandLineOption(string);
        }
        return commandLineOption;
    }

    public void put(CommandLineOption commandLineOption) {
        if (commandLineOption == null) {
            throw new NullPointerException("Option cannot be null");
        }
        this.options.put(commandLineOption.getName(), commandLineOption);
    }

    public boolean contains(String string) {
        return this.options.containsKey(string);
    }

    private void parseArgs(String[] stringArray, String string) throws MissingArgumentException {
        if (stringArray == null) {
            throw new NullPointerException("Args cannot be null");
        }
        if (string == null) {
            throw new NullPointerException("Optstring cannot be null");
        }
        OptionTokenizer optionTokenizer = new OptionTokenizer(stringArray, string);
        while (true) {
            try {
                CommandLineOption commandLineOption;
                while ((commandLineOption = optionTokenizer.nextOption()) != null) {
                    this.put(commandLineOption);
                }
            }
            catch (IllegalOptionException illegalOptionException) {
                continue;
            }
            break;
        }
    }
}

