/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.cli;

import com.apple.net.acp.AcpPropertyCode;
import com.apple.util.plist.PListUtils;
import com.apple.util.plist.PropertyList;
import com.apple.util.plist.PropertyListException;
import com.apple.xsr.cli.AcpPropertyMap;
import com.apple.xsr.cli.CommandHandler;
import com.apple.xsr.cli.CommandLineOption;
import com.apple.xsr.cli.CommandLineUtils;
import com.apple.xsr.cli.IllegalOptionException;
import com.apple.xsr.cli.MissingArgumentException;
import com.apple.xsr.cli.OptionException;
import com.apple.xsr.cli.OptionSet;
import com.apple.xsr.cli.OptionTokenizer;
import com.apple.xsr.net.AcpxConnection;
import com.apple.xsr.net.AcpxMessageFactory;
import com.apple.xsr.net.MessageFactory;
import com.apple.xsr.net.RequestMessage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Set;

public class CommandDispatcher {
    private static final boolean USE_PERSISTENT_CONNECTIONS = false;
    private static final boolean ENCRYPT_COMMUNICATIONS = true;
    private static CommandDispatcher INSTANCE = new CommandDispatcher();
    private Hashtable commands = new Hashtable();

    private CommandDispatcher() {
        this.initGetCommandHandlers();
        this.initSetCommandHandlers();
        this.initDoCommandHandlers();
        this.initStopCommandHandlers();
    }

    public static CommandDispatcher getInstance() {
        return INSTANCE;
    }

    public void dispatch(String string, String string2, String[] stringArray, String[] stringArray2, OutputStream outputStream) throws OptionException, IOException {
        CommandHandler commandHandler;
        Hashtable hashtable = (Hashtable)this.commands.get(string);
        if (hashtable != null) {
            commandHandler = (CommandHandler)hashtable.get(string2);
            if (commandHandler != null) {
                try {
                    commandHandler = (CommandHandler)commandHandler.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new Error("Assertion failure");
                }
            } else if (string.equals("get")) {
                commandHandler = new GetPropertyHandler(string2);
            } else if (string.equals("set")) {
                commandHandler = new SetPropertyHandler(string2);
            }
            if (commandHandler == null) {
                throw new OptionException("Illegal command object: " + string2, -404);
            }
        } else {
            throw new OptionException("Illegal command: " + string, -403);
        }
        commandHandler.handle(stringArray, stringArray2, outputStream);
    }

    public Set getCommands() {
        return this.getCommands(null);
    }

    public Set getCommands(String string) {
        Set set = null;
        if (string == null || string.equals("")) {
            set = Collections.unmodifiableSet(this.commands.keySet());
        } else {
            Hashtable hashtable = (Hashtable)this.commands.get(string);
            if (hashtable != null) {
                set = Collections.unmodifiableSet(((Hashtable)this.commands.get(string)).keySet());
            }
        }
        return set;
    }

    private void initGetCommandHandlers() {
        Object object;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        AcpPropertyMap acpPropertyMap = AcpPropertyMap.getInstance();
        Object object2 = acpPropertyMap.keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            hashtable.put((String)object, new GetPropertyHandler(acpPropertyMap.get((String)object)));
        }
        hashtable.put("page", new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "p:");
                Integer n = optionSet.get("p").argIntegerValue(0);
                return this.msgFactory.newGetControllerPageRequest(n);
            }
        });
        object2 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) {
                return this.msgFactory.newGetControllerPageRequest(new Integer(0));
            }
        };
        hashtable.put("controller_info", object2);
        hashtable.put("controller-info", object2);
        object = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) {
                return this.msgFactory.newGetControllerPageRequest(new Integer(1));
            }
        };
        hashtable.put("raid_info", object);
        hashtable.put("raid-info", object);
        DefaultHandler defaultHandler = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) {
                return this.msgFactory.newGetControllerPageRequest(new Integer(2));
            }
        };
        hashtable.put("rs232_info", defaultHandler);
        hashtable.put("rs232-info", defaultHandler);
        hashtable.put("serial_info", defaultHandler);
        hashtable.put("serial-info", defaultHandler);
        DefaultHandler defaultHandler2 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) {
                return this.msgFactory.newGetControllerPageRequest(new Integer(16));
            }
        };
        hashtable.put("slot_info", defaultHandler2);
        hashtable.put("slot-info", defaultHandler2);
        DefaultHandler defaultHandler3 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) {
                return this.msgFactory.newGetControllerPageRequest(new Integer(3));
            }
        };
        hashtable.put("event_log1", defaultHandler3);
        hashtable.put("event-log1", defaultHandler3);
        DefaultHandler defaultHandler4 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) {
                return this.msgFactory.newGetControllerPageRequest(new Integer(4));
            }
        };
        hashtable.put("event_log2", defaultHandler4);
        hashtable.put("event-log2", defaultHandler4);
        DefaultHandler defaultHandler5 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) {
                return this.msgFactory.newGetControllerPageRequest(new Integer(5));
            }
        };
        hashtable.put("event_log3", defaultHandler5);
        hashtable.put("event-log3", defaultHandler5);
        DefaultHandler defaultHandler6 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) {
                return this.msgFactory.newGetControllerPageRequest(new Integer(6));
            }
        };
        hashtable.put("event_log4", defaultHandler6);
        hashtable.put("event-log4", defaultHandler6);
        hashtable.put("date", new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) {
                return this.msgFactory.newGetTimeRequest();
            }
        });
        hashtable.put("temperature", new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "n:");
                String string = optionSet.get("n").argStringValue(0);
                return this.msgFactory.newGetTemperatureRequest(string);
            }
        });
        DefaultHandler defaultHandler7 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "n:i:");
                String string = optionSet.get("n").argStringValue(0);
                Integer n = optionSet.get("i").argIntegerValue(0);
                return this.msgFactory.newGetDevicePropertiesRequest(string, n);
            }
        };
        hashtable.put("device_properties", defaultHandler7);
        hashtable.put("device-properties", defaultHandler7);
        DefaultHandler defaultHandler8 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                return this.msgFactory.newGetStatusRequest();
            }
        };
        hashtable.put("system_status", defaultHandler8);
        hashtable.put("system-status", defaultHandler8);
        DefaultHandler defaultHandler9 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                return this.msgFactory.newGetPostResultsRequest();
            }
        };
        hashtable.put("post_results", defaultHandler9);
        hashtable.put("post-results", defaultHandler9);
        AbstractHandler abstractHandler = new AbstractHandler(){

            public void handle(String[] stringArray, String[] stringArray2, OutputStream outputStream) throws OptionException, IOException {
                HashMap<String, Object> hashMap;
                Object object;
                Object object2;
                this.parseGlobalArgs(stringArray);
                if (this.getHostAddress() == null) {
                    throw new OptionException("No host address specified", -405);
                }
                RequestMessage.Target target = this.getTargetController();
                AcpxConnection acpxConnection = new AcpxConnection(this.getHostAddress());
                acpxConnection.setPersistent(false);
                acpxConnection.setEncrypted(this.isEncryptionEnabled());
                AcpxMessageFactory acpxMessageFactory = new AcpxMessageFactory();
                acpxMessageFactory.setDefaultTimeout(this.timeout);
                if (this.getUser() != null) {
                    acpxMessageFactory.setDefaultUser(this.getUser());
                    acpxMessageFactory.setDefaultPassword(this.getPassword(), true);
                }
                RequestMessage requestMessage = acpxMessageFactory.newGetPropertyRequest(AcpPropertyCode.SYS_VERSION.fourCharCode());
                requestMessage.setTargetController(target);
                PropertyList propertyList = acpxConnection.send(requestMessage);
                String string = "";
                try {
                    object2 = PListUtils.toDictionary(propertyList.getRootElement());
                    object = PListUtils.toDictionary(object2.get("syVs"));
                    string = PListUtils.toString(object.get("data"));
                }
                catch (PropertyListException propertyListException) {
                    string = "Unable to get system controller version";
                }
                requestMessage = acpxMessageFactory.newGetControllerPageRequest(new Integer(0));
                requestMessage.setTargetController(target);
                propertyList = acpxConnection.send(requestMessage);
                object2 = "";
                try {
                    object = PListUtils.toDictionary(propertyList.getRootElement());
                    hashMap = PListUtils.toDictionary(object.get("get-page"));
                    object2 = PListUtils.toString(hashMap.get("firmware-version"));
                }
                catch (PropertyListException propertyListException) {
                    object2 = "Unable to get RAID controller version";
                }
                object = CommandDispatcher.this.getAppVersion();
                if (object == null) {
                    object = "Unable to get RAID Admin version";
                }
                hashMap = new HashMap<String, Object>();
                hashMap.put("atlas", string);
                hashMap.put("raid-admin", object);
                hashMap.put("controller", object2);
                HashMap<String, HashMap<String, Object>> hashMap2 = new HashMap<String, HashMap<String, Object>>();
                hashMap2.put("versions", hashMap);
                PropertyList propertyList2 = new PropertyList(hashMap2);
                if (outputStream != null) {
                    try {
                        propertyList2.writeTo(outputStream);
                    }
                    catch (PropertyListException propertyListException) {
                        throw new IOException("error processing plist: " + propertyListException.getMessage());
                    }
                }
            }
        };
        hashtable.put("versions", abstractHandler);
        this.commands.put("get", hashtable);
    }

    private void initSetCommandHandlers() {
        Object object;
        Object object2;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        AcpPropertyMap acpPropertyMap = AcpPropertyMap.getInstance();
        Object object3 = acpPropertyMap.keySet().iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            object = acpPropertyMap.get((String)object2);
            if (!((AcpPropertyCode)object).isWriteable()) continue;
            hashtable.put((String)object2, new SetPropertyHandler((AcpPropertyCode)object));
        }
        object3 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "i:s:c:");
                Integer n = optionSet.get("i").argIntegerValue(0);
                Integer n2 = optionSet.get("s").argIntegerValue(0);
                Integer n3 = optionSet.get("c").argIntegerValue(0);
                return this.msgFactory.newSetSliceSizeRequest(n, n2, n3);
            }
        };
        hashtable.put("slice_size", object3);
        hashtable.put("slice-size", object3);
        hashtable.put("ipconfig_method", new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                Integer n;
                if (stringArray.length < 1) {
                    throw new OptionException("Missing argument", -402);
                }
                if (stringArray[0].equalsIgnoreCase("static")) {
                    n = new Integer(1024);
                } else if (stringArray[0].equalsIgnoreCase("dhcp")) {
                    n = new Integer(768);
                } else if (stringArray[0].equalsIgnoreCase("ppp")) {
                    n = new Integer(2304);
                } else if (stringArray[0].equalsIgnoreCase("bootp")) {
                    n = new Integer(8448);
                } else {
                    throw new OptionException("Illegal method argument: " + stringArray[0], -401);
                }
                return this.msgFactory.newSetPropertyRequest(AcpPropertyCode.LAN_CONFIGURE_VIA.fourCharCode(), n);
            }
        });
        hashtable.put("led", new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "n:i:s:");
                String string = optionSet.get("n").argStringValue(0);
                Integer n = optionSet.get("i").argIntegerValue(0);
                String string2 = optionSet.get("s").argStringValue(0);
                return this.msgFactory.newIlluminateRequest(string, n, string2);
            }
        });
        hashtable.put("date", new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                Date date = null;
                if (stringArray.length >= 1) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM d HH':'mm':'ss zzz yyyy");
                    try {
                        date = simpleDateFormat.parse(stringArray[0]);
                    }
                    catch (ParseException parseException) {
                        throw new OptionException("Invalid date: " + stringArray[0], -407);
                    }
                }
                return this.msgFactory.newSetTimeRequest(date);
            }
        });
        object2 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "i:s:");
                Integer n = optionSet.get("i").argIntegerValue(0);
                String string = null;
                String string2 = optionSet.get("s").argStringValue(0);
                if (string2 != null) {
                    string = string2.equals("0") ? "auto-negotiated" : (string2.equals("1") ? "1Gb/sec" : (string2.equals("2") ? "2Gb/sec" : string2));
                }
                return this.msgFactory.newSetFibreChannelSpeedRequest(n, string);
            }
        };
        hashtable.put("fc_speed", object2);
        hashtable.put("fc-speed", object2);
        object = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                if (stringArray.length < 1) {
                    throw new OptionException("Missing argument", -402);
                }
                return this.msgFactory.newSetFibreChannelTopologyRequest(stringArray[0]);
            }
        };
        hashtable.put("fc_topology", object);
        hashtable.put("fc-topology", object);
        DefaultHandler defaultHandler = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                Boolean bl = null;
                if (stringArray != null && stringArray.length > 0) {
                    String string = stringArray[0].trim().toLowerCase();
                    if (string.equals("0") || string.equals("off") || string.equals("disable")) {
                        bl = Boolean.FALSE;
                    } else if (string.equals("1") || string.equals("on") || string.equals("enable")) {
                        bl = Boolean.TRUE;
                    } else {
                        throw new OptionException("Invalid JBOD mask enable argument: " + stringArray[0], -408);
                    }
                }
                return this.msgFactory.newJbodMaskEnableRequest(bl);
            }
        };
        hashtable.put("jbod_mask", defaultHandler);
        hashtable.put("jbod-mask", defaultHandler);
        DefaultHandler defaultHandler2 = new DefaultHandler(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                Integer n;
                AcpPropertyCode acpPropertyCode = AcpPropertyMap.getInstance().get("server_mode");
                if (stringArray != null && stringArray.length > 0) {
                    String string = stringArray[0].trim().toLowerCase();
                    if (string.equals("0") || string.equals("off")) {
                        n = new Integer(0);
                        return this.msgFactory.newSetPropertyRequest(acpPropertyCode.fourCharCode(), n);
                    } else {
                        if (!string.equals("1") && !string.equals("on")) throw new OptionException("Invalid mode: " + stringArray[0], -409);
                        n = new Integer(1);
                    }
                    return this.msgFactory.newSetPropertyRequest(acpPropertyCode.fourCharCode(), n);
                } else {
                    n = new Integer(1);
                }
                return this.msgFactory.newSetPropertyRequest(acpPropertyCode.fourCharCode(), n);
            }
        };
        hashtable.put("server_mode", defaultHandler2);
        hashtable.put("server-mode", defaultHandler2);
        this.commands.put("set", hashtable);
    }

    private void initDoCommandHandlers() {
        Hashtable<String, DefaultHandler> hashtable = new Hashtable<String, DefaultHandler>();
        DefaultHandler defaultHandler = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "i:l:m:t:c:");
                Integer n = optionSet.get("i").argIntegerValue(0);
                String string = optionSet.get("l").argStringValue(0);
                String string2 = optionSet.get("m").argStringValue(0);
                String string3 = optionSet.get("t").argStringValue(0);
                Integer[] integerArray = null;
                if (string2 != null && !string2.equals("")) {
                    try {
                        integerArray = CommandLineUtils.parseMembers(string2);
                    }
                    catch (CommandLineUtils.MemberListFormatException memberListFormatException) {
                        throw new OptionException("Invalid member list", -410);
                    }
                }
                return this.msgFactory.newCreateArrayRequest(n, string, integerArray, string3);
            }
        };
        hashtable.put("create_array", defaultHandler);
        hashtable.put("create-array", defaultHandler);
        DefaultHandler defaultHandler2 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "i:");
                Integer n = optionSet.get("i").argIntegerValue(0);
                return this.msgFactory.newDeleteArrayRequest(n);
            }
        };
        hashtable.put("delete_array", defaultHandler2);
        hashtable.put("delete-array", defaultHandler2);
        DefaultHandler defaultHandler3 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "i:c:");
                Integer n = optionSet.get("i").argIntegerValue(0);
                Integer n2 = optionSet.get("c").argIntegerValue(0);
                return this.msgFactory.newExpandArrayRequest(n, n2);
            }
        };
        hashtable.put("expand_array", defaultHandler3);
        hashtable.put("expand-array", defaultHandler3);
        DefaultHandler defaultHandler4 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "i:");
                Integer n = optionSet.get("i").argIntegerValue(0);
                return this.msgFactory.newRecalculateCheckDataRequest(n, "start");
            }
        };
        hashtable.put("init_array", defaultHandler4);
        hashtable.put("init-array", defaultHandler4);
        DefaultHandler defaultHandler5 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "i:");
                Integer n = optionSet.get("i").argIntegerValue(0);
                return this.msgFactory.newVerifyCheckDataRequest(n, "start");
            }
        };
        hashtable.put("check_array", defaultHandler5);
        hashtable.put("check-array", defaultHandler5);
        DefaultHandler defaultHandler6 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "i:s:l:");
                Integer n = optionSet.get("i").argIntegerValue(0);
                Integer n2 = optionSet.get("s").argIntegerValue(0);
                Integer n3 = optionSet.get("l").argIntegerValue(0);
                return this.msgFactory.newLUNAssignmentRequest(n, n2, n3);
            }
        };
        hashtable.put("map_lun", defaultHandler6);
        hashtable.put("map-lun", defaultHandler6);
        DefaultHandler defaultHandler7 = new DefaultHandler(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                RequestMessage requestMessage = null;
                if (stringArray.length == 0) return this.msgFactory.newClearRaidControllerEventLogRequest();
                OptionSet optionSet = new OptionSet(stringArray, "t:");
                String string = optionSet.get("t").argStringValue(0);
                if (string.equalsIgnoreCase("coprocessor")) return this.msgFactory.newClearEventLogRequest();
                if (string.equalsIgnoreCase("system_controller")) {
                    return this.msgFactory.newClearEventLogRequest();
                }
                if (string.equalsIgnoreCase("raid_controller")) return this.msgFactory.newClearRaidControllerEventLogRequest();
                if (string.equalsIgnoreCase("controller")) return this.msgFactory.newClearRaidControllerEventLogRequest();
                if (!string.equalsIgnoreCase("raid")) throw new OptionException("Invalid log type \"" + string + "\"");
                return this.msgFactory.newClearRaidControllerEventLogRequest();
            }
        };
        hashtable.put("clear_log", defaultHandler7);
        hashtable.put("clear-log", defaultHandler7);
        hashtable.put("power", new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                if (stringArray != null && stringArray.length >= 1) {
                    if (!stringArray[0].equals("on") && !stringArray[0].equals("off")) {
                        throw new OptionException("Illegal power state: " + stringArray[0], -411);
                    }
                } else {
                    throw new OptionException("Power state must be 'on' or 'off'", -411);
                }
                return this.msgFactory.newPowerRequest(stringArray[0]);
            }
        });
        hashtable.put("restart", new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                return this.msgFactory.newRestartSystemRequest();
            }
        });
        DefaultHandler defaultHandler8 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                return this.msgFactory.newRestartRaidControllerRequest();
            }
        };
        hashtable.put("restart_controller", defaultHandler8);
        hashtable.put("restart-controller", defaultHandler8);
        DefaultHandler defaultHandler9 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                return this.msgFactory.newFlushRaidControllerNvramRequest();
            }
        };
        hashtable.put("flush_raid_nvram", defaultHandler9);
        hashtable.put("flush-raid-nvram", defaultHandler9);
        DefaultHandler defaultHandler10 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                return this.msgFactory.newResetControllerNvramRequest();
            }
        };
        hashtable.put("reset_nvram", defaultHandler10);
        hashtable.put("reset-nvram", defaultHandler10);
        DefaultHandler defaultHandler11 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "d:m:");
                String string = optionSet.get("d").argStringValue(0);
                String string2 = optionSet.get("m").argStringValue(0);
                return this.msgFactory.newMorseCodeRequest(string, string2);
            }
        };
        hashtable.put("morse_code", defaultHandler11);
        hashtable.put("morse-code", defaultHandler11);
        hashtable.put("morse", defaultHandler11);
        DefaultHandler defaultHandler12 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "l:a:p:");
                String string = optionSet.get("l").argStringValue(0);
                String string2 = optionSet.get("a").argStringValue(0);
                Integer n = optionSet.get("p").argIntegerValue(0);
                return this.msgFactory.newLedDiagnosticRequest(string, string2, n);
            }
        };
        hashtable.put("led_test", defaultHandler12);
        hashtable.put("led-test", defaultHandler12);
        DefaultHandler defaultHandler13 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "s:");
                String string = optionSet.get("s").argStringValue(0);
                return this.msgFactory.newIlluminateRequest("buzzer", null, string);
            }
        };
        hashtable.put("buzzer_test", defaultHandler13);
        hashtable.put("buzzer-test", defaultHandler13);
        DefaultHandler defaultHandler14 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "m:p:");
                String string = optionSet.get("m").argStringValue(0);
                Integer n = optionSet.get("p").argIntegerValue(0);
                return this.msgFactory.newControllerCacheDiagnosticRequest(string, n);
            }
        };
        hashtable.put("mem_test", defaultHandler14);
        hashtable.put("mem-test", defaultHandler14);
        hashtable.put("dram_test", defaultHandler14);
        hashtable.put("dram-test", defaultHandler14);
        DefaultHandler defaultHandler15 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "a:p:");
                String string = optionSet.get("a").argStringValue(0);
                Integer n = optionSet.get("p").argIntegerValue(0);
                return this.msgFactory.newFibreChannelDiagnosticRequest(string, n);
            }
        };
        hashtable.put("fc_test", defaultHandler15);
        hashtable.put("fc-test", defaultHandler15);
        DefaultHandler defaultHandler16 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "1:2:a:p:");
                Integer n = optionSet.get("1").argIntegerValue(0);
                Integer n2 = optionSet.get("2").argIntegerValue(0);
                String string = optionSet.get("a").argStringValue(0);
                Integer n3 = optionSet.get("p").argIntegerValue(0);
                return this.msgFactory.newSerialInterfaceDiagnosticRequest(n, n2, string, n3);
            }
        };
        hashtable.put("com_test", defaultHandler16);
        hashtable.put("com-test", defaultHandler16);
        DefaultHandler defaultHandler17 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "d:a:m:c:p:");
                Integer n = optionSet.get("d").argIntegerValue(0);
                String string = optionSet.get("a").argStringValue(0);
                String string2 = optionSet.get("m").argStringValue(0);
                Integer n2 = optionSet.get("c").argIntegerValue(0);
                Integer n3 = optionSet.get("p").argIntegerValue(0);
                return this.msgFactory.newDiskDiagnosticRequest(n, string, string2, n2, n3);
            }
        };
        hashtable.put("disk_test", defaultHandler17);
        hashtable.put("disk-test", defaultHandler17);
        DefaultHandler defaultHandler18 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "b:s:");
                Integer n = optionSet.get("b").argIntegerValue(0);
                String string = optionSet.get("s").argStringValue(0);
                return this.msgFactory.newWriteSignatureRequest(n, string);
            }
        };
        hashtable.put("write_signature", defaultHandler18);
        hashtable.put("write-signature", defaultHandler18);
        DefaultHandler defaultHandler19 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "b:s:");
                Integer n = optionSet.get("b").argIntegerValue(0);
                Integer n2 = optionSet.get("s").argIntegerValue(0);
                return this.msgFactory.newReadSignatureRequest(n, n2);
            }
        };
        hashtable.put("read_signature", defaultHandler19);
        hashtable.put("read-signature", defaultHandler19);
        DefaultHandler defaultHandler20 = new DefaultHandler(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                int n;
                OptionSet optionSet = new OptionSet(stringArray, "d:t:i:");
                String string = optionSet.get("d").argStringValue(0);
                if (string == null) {
                    throw new OptionException("No device specified");
                }
                String string2 = optionSet.get("i").argStringValue(0);
                if (string2 == null) throw new OptionException("No flash ROM image file specified");
                if (string2.length() == 0) {
                    throw new OptionException("No flash ROM image file specified");
                }
                int n2 = 0;
                if (string.equals("system_controller") || string.equals("system-controller")) {
                    n = 0;
                    String string3 = optionSet.get("t").argStringValue(0);
                    if (string3 == null) {
                        throw new OptionException("No flash type specified. Must be 'full' or 'update'.", -413);
                    }
                    if (string3.equals("full")) {
                        n2 = 0;
                    } else {
                        if (!string3.equals("update")) throw new OptionException("Invalid flash update type: " + (String)string3, -413);
                        n2 = 1;
                    }
                } else {
                    if (!string.equals("raid_controller")) {
                        if (!string.equals("raid-controller")) throw new OptionException("Invalid device: " + string, -414);
                    }
                    n = 1;
                }
                try {
                    return this.msgFactory.newUpdateFirmwareRequest(n, n2, string2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new OptionException("ROM image file " + string2 + " could not be opened", -412);
                }
            }
        };
        hashtable.put("flash", defaultHandler20);
        this.commands.put("do", hashtable);
        this.commands.put("start", hashtable);
    }

    private void initStopCommandHandlers() {
        Hashtable<String, DefaultHandler> hashtable = new Hashtable<String, DefaultHandler>();
        DefaultHandler defaultHandler = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "i:");
                Integer n = optionSet.get("i").argIntegerValue(0);
                return this.msgFactory.newRecalculateCheckDataRequest(n, "stop");
            }
        };
        hashtable.put("init_array", defaultHandler);
        hashtable.put("init-array", defaultHandler);
        DefaultHandler defaultHandler2 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "i:");
                Integer n = optionSet.get("i").argIntegerValue(0);
                return this.msgFactory.newVerifyCheckDataRequest(n, "stop");
            }
        };
        hashtable.put("check_array", defaultHandler2);
        hashtable.put("check-array", defaultHandler2);
        DefaultHandler defaultHandler3 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                return this.msgFactory.newLedDiagnosticRequest(null, "stop", null);
            }
        };
        hashtable.put("led_test", defaultHandler3);
        hashtable.put("led-test", defaultHandler3);
        DefaultHandler defaultHandler4 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                return this.msgFactory.newFibreChannelDiagnosticRequest("stop", null);
            }
        };
        hashtable.put("fc_test", defaultHandler4);
        hashtable.put("fc-test", defaultHandler4);
        DefaultHandler defaultHandler5 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "1:2:");
                Integer n = optionSet.get("1").argIntegerValue(0);
                Integer n2 = optionSet.get("2").argIntegerValue(0);
                return this.msgFactory.newSerialInterfaceDiagnosticRequest(n, n2, "stop", null);
            }
        };
        hashtable.put("com_test", defaultHandler5);
        hashtable.put("com-test", defaultHandler5);
        DefaultHandler defaultHandler6 = new DefaultHandler(){

            public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
                OptionSet optionSet = new OptionSet(stringArray, "d:a:m:c:p:");
                Integer n = optionSet.get("d").argIntegerValue(0);
                String string = optionSet.get("m").argStringValue(0);
                Integer n2 = optionSet.get("c").argIntegerValue(0);
                Integer n3 = optionSet.get("p").argIntegerValue(0);
                return this.msgFactory.newDiskDiagnosticRequest(n, "stop", string, n2, n3);
            }
        };
        hashtable.put("disk_test", defaultHandler6);
        hashtable.put("disk-test", defaultHandler6);
        this.commands.put("stop", hashtable);
    }

    private String getAppVersion() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.apple.xsr.resources.Versions");
        return resourceBundle.getString("app_version");
    }

    private static abstract class DefaultHandler
    extends AbstractHandler {
        protected MessageFactory msgFactory;

        private DefaultHandler() {
        }

        public void handle(String[] stringArray, String[] stringArray2, OutputStream outputStream) throws OptionException, IOException {
            this.parseGlobalArgs(stringArray);
            if (this.getHostAddress() == null) {
                throw new OptionException("No host address specified", -405);
            }
            this.msgFactory = new AcpxMessageFactory();
            ((AcpxMessageFactory)this.msgFactory).setDefaultTimeout(this.timeout);
            if (this.getUser() != null) {
                ((AcpxMessageFactory)this.msgFactory).setDefaultUser(this.getUser());
                ((AcpxMessageFactory)this.msgFactory).setDefaultPassword(this.getPassword(), true);
            }
            RequestMessage requestMessage = this.createRequestMessage(stringArray2);
            requestMessage.setTargetController(this.getTargetController());
            AcpxConnection acpxConnection = new AcpxConnection(this.getHostAddress());
            acpxConnection.setPersistent(false);
            acpxConnection.setEncrypted(this.isEncryptionEnabled());
            PropertyList propertyList = acpxConnection.send(requestMessage);
            if (outputStream != null) {
                try {
                    propertyList.writeTo(outputStream);
                }
                catch (PropertyListException propertyListException) {
                    throw new IOException("error processing plist: " + propertyListException.getMessage());
                }
            }
        }

        public abstract RequestMessage createRequestMessage(String[] var1) throws OptionException;

        public Object clone() throws CloneNotSupportedException {
            DefaultHandler defaultHandler = (DefaultHandler)super.clone();
            defaultHandler.msgFactory = this.msgFactory;
            return defaultHandler;
        }
    }

    private static abstract class AbstractHandler
    implements CommandHandler,
    Cloneable {
        private String hostAddress;
        protected int timeout = 0;
        protected String user;
        protected String password;
        protected String xsyncTarget;
        protected boolean encryptionEnabled = true;

        private AbstractHandler() {
        }

        protected void setHostAddress(String string) {
            this.hostAddress = string;
        }

        public String getHostAddress() {
            if (this.hostAddress != null && this.hostAddress.length() > 0) {
                return this.hostAddress;
            }
            String string = null;
            try {
                string = System.getProperty("XSRHOST");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string != null && string.length() > 0) {
                return string;
            }
            return null;
        }

        public String getUser() {
            if (this.user == null) {
                String string = null;
                try {
                    string = System.getProperty("XSRUSER");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string != null) {
                    return string;
                }
            }
            return this.user;
        }

        public String getPassword() {
            if (this.password == null) {
                String string = null;
                try {
                    string = System.getProperty("XSRPASSWD");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string != null) {
                    return string;
                }
                return "";
            }
            return this.password;
        }

        public RequestMessage.Target getTargetController() throws OptionException {
            RequestMessage.Target target = null;
            if (this.xsyncTarget != null) {
                if (this.xsyncTarget.equalsIgnoreCase("master")) {
                    target = RequestMessage.Target.MASTER;
                } else if (this.xsyncTarget.equalsIgnoreCase("top")) {
                    target = RequestMessage.Target.TOP;
                } else if (this.xsyncTarget.equalsIgnoreCase("companion")) {
                    target = RequestMessage.Target.COMPANION;
                } else if (this.xsyncTarget.equalsIgnoreCase("bottom")) {
                    target = RequestMessage.Target.BOTTOM;
                } else {
                    throw new OptionException("Unrecognized controller target (" + this.xsyncTarget + ")", -401);
                }
            }
            return target;
        }

        public boolean isEncryptionEnabled() {
            return this.encryptionEnabled;
        }

        public Object clone() throws CloneNotSupportedException {
            AbstractHandler abstractHandler = (AbstractHandler)super.clone();
            return abstractHandler;
        }

        protected void parseGlobalArgs(String[] stringArray) throws OptionException, MissingArgumentException {
            String string = "a:c:t:u:p:x:";
            OptionTokenizer optionTokenizer = new OptionTokenizer(stringArray, string);
            try {
                CommandLineOption commandLineOption;
                while ((commandLineOption = optionTokenizer.nextOption()) != null) {
                    Object object;
                    if (commandLineOption.getName().equals("a")) {
                        this.hostAddress = commandLineOption.argStringValue(0);
                        continue;
                    }
                    if (commandLineOption.getName().equals("c")) {
                        this.xsyncTarget = commandLineOption.argStringValue(0);
                        continue;
                    }
                    if (commandLineOption.getName().equals("t")) {
                        object = commandLineOption.argIntegerValue(0);
                        if (object == null) continue;
                        this.timeout = (Integer)object;
                        continue;
                    }
                    if (commandLineOption.getName().equals("u")) {
                        this.user = commandLineOption.argStringValue(0);
                        continue;
                    }
                    if (commandLineOption.getName().equals("p")) {
                        this.password = commandLineOption.argStringValue(0);
                        continue;
                    }
                    if (!commandLineOption.getName().equals("x")) continue;
                    object = commandLineOption.argStringValue(0);
                    if (((String)object).equalsIgnoreCase("off") || ((String)object).equalsIgnoreCase("false") || ((String)object).equals("0")) {
                        this.encryptionEnabled = false;
                        continue;
                    }
                    if (((String)object).equalsIgnoreCase("on") || ((String)object).equalsIgnoreCase("true") || ((String)object).equals("1")) {
                        this.encryptionEnabled = true;
                        continue;
                    }
                    throw new OptionException("Unrecognized encryption flag \"" + (String)object + "\"");
                }
            }
            catch (IllegalOptionException illegalOptionException) {
                // empty catch block
            }
        }
    }

    private static class SetPropertyHandler
    extends DefaultHandler {
        private String propertyCode;

        public SetPropertyHandler(AcpPropertyCode acpPropertyCode) {
            this.propertyCode = acpPropertyCode.fourCharCode();
        }

        public SetPropertyHandler(String string) throws OptionException {
            if (string == null || string.length() != 4) {
                throw new OptionException("Invalid property code: " + string);
            }
            this.propertyCode = string;
        }

        public RequestMessage createRequestMessage(String[] stringArray) throws OptionException {
            if (stringArray.length < 1) {
                throw new OptionException("Illegal number of arguments");
            }
            Object object = stringArray[0];
            try {
                object = new Integer(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return this.msgFactory.newSetPropertyRequest(this.propertyCode, object);
        }
    }

    private static class GetPropertyHandler
    extends DefaultHandler {
        private String propertyCode;

        public GetPropertyHandler(AcpPropertyCode acpPropertyCode) {
            this.propertyCode = acpPropertyCode.fourCharCode();
        }

        public GetPropertyHandler(String string) throws OptionException {
            if (string == null || string.length() != 4) {
                throw new OptionException("Invalid property code: " + string);
            }
            this.propertyCode = string;
        }

        public RequestMessage createRequestMessage(String[] stringArray) {
            return this.msgFactory.newGetPropertyRequest(this.propertyCode);
        }
    }
}

