/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.advanced;

import com.apple.xsr.AbstractChooserMgmtPane;
import com.apple.xsr.AquaAlert;
import com.apple.xsr.AquaAlertAdapter;
import com.apple.xsr.ChooserButtonPanel;
import com.apple.xsr.DataModel;
import com.apple.xsr.ManagementPane;
import com.apple.xsr.OperationManager;
import com.apple.xsr.Resources;
import com.apple.xsr.advanced.AdvancedExpansionModel;
import com.apple.xsr.advanced.AdvancedExpansionPane;
import com.apple.xsr.advanced.AdvancedMaskingModel;
import com.apple.xsr.advanced.AdvancedMaskingPane;
import com.apple.xsr.advanced.AdvancedSlicingModel;
import com.apple.xsr.advanced.AdvancedSlicingPane;
import com.apple.xsr.som.RaidSystem;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;

public class AdvancedPane
extends AbstractChooserMgmtPane {
    private static final boolean INCLUDE_MASKING = false;
    public static final int SLICING_OPERATION = 0;
    public static final int EXPANSION_OPERATION = 1;
    public static final int MASKING_OPERATION = 2;
    public static final int ADVANCED_COUNT = 3;
    private static final int PREFERRED_WIDTH = 780;
    private static final int PREFERRED_HEIGHT = 560;
    private AdvancedSlicingPane slicingPane = new AdvancedSlicingPane(this);
    private AdvancedExpansionPane expansionPane = new AdvancedExpansionPane(this);
    private AdvancedMaskingPane maskingPane;
    private ManagementPane[] panes = new ManagementPane[]{this.slicingPane, this.expansionPane};
    private RaidSystem system;

    public AdvancedPane() {
        super(780, 560, Resources.getString("advanced.choose"));
        this.setPanes(this.panes);
    }

    public void populateUI(DataModel dataModel) {
        throw new UnsupportedOperationException();
    }

    public void populateUI(DataModel[] dataModelArray) {
        int n;
        if (dataModelArray == null) {
            throw new NullPointerException("data cannot be null");
        }
        if (dataModelArray.length != 3) {
            String string = "data model array contains an invalid number of elements (" + dataModelArray.length + " elements, expected " + 3 + ")";
            throw new IllegalArgumentException(string);
        }
        this.system = null;
        for (n = 0; n < dataModelArray.length; ++n) {
            if (dataModelArray[n] instanceof AdvancedSlicingModel) {
                this.slicingPane.populateUI((AdvancedSlicingModel)dataModelArray[n]);
                this.system = ((AdvancedSlicingModel)dataModelArray[n]).getRaidSystem();
                continue;
            }
            if (dataModelArray[n] instanceof AdvancedExpansionModel) {
                this.expansionPane.populateUI((AdvancedExpansionModel)dataModelArray[n]);
                continue;
            }
            if (dataModelArray[n] instanceof AdvancedMaskingModel) continue;
            throw new IllegalArgumentException("illegal data model " + dataModelArray[n].getClass());
        }
        n = 1;
        boolean bl = true;
        boolean bl2 = true;
        if (this.system != null) {
            try {
                n = OperationManager.isSupported(this.system, OperationManager.OP_SLICE_ARRAY) ? 1 : 0;
            }
            catch (Exception exception) {
                n = 1;
            }
            try {
                bl = OperationManager.isSupported(this.system, OperationManager.OP_EXPAND_ARRAY);
            }
            catch (Exception exception) {
                bl = true;
            }
            try {
                bl2 = OperationManager.isSupported(this.system, OperationManager.OP_CONFIGURE_LUN_MASKING);
            }
            catch (Exception exception) {
                bl2 = true;
            }
        }
        this.chooserPanel.setPaneEnabled(this.slicingPane, n != 0);
        this.chooserPanel.setPaneEnabled(this.expansionPane, bl);
        if (n != 0) {
            this.chooserPanel.setSelectedPane(this.slicingPane);
        } else if (bl) {
            this.chooserPanel.setSelectedPane(this.expansionPane);
        } else if (bl2) {
            // empty if block
        }
    }

    public boolean validateUI(DataModel dataModel) {
        throw new UnsupportedOperationException();
    }

    public boolean validateUI(DataModel[] dataModelArray) {
        if (dataModelArray != null) {
            for (int i = 0; i < dataModelArray.length; ++i) {
                if (dataModelArray[i] instanceof AdvancedSlicingModel) {
                    this.slicingPane.validateUI((AdvancedSlicingModel)dataModelArray[i]);
                    continue;
                }
                if (dataModelArray[i] instanceof AdvancedExpansionModel) {
                    this.expansionPane.validateUI((AdvancedExpansionModel)dataModelArray[i]);
                    continue;
                }
                if (dataModelArray[i] instanceof AdvancedMaskingModel) continue;
                throw new IllegalArgumentException("illegal data model " + dataModelArray[i].getClass());
            }
        }
        return true;
    }

    public boolean allowAbort() {
        ManagementPane managementPane = this.getCurrentlyShowingManagementPane();
        if (managementPane != null) {
            return managementPane.allowAbort();
        }
        return true;
    }

    protected ChooserButtonPanel createChooserButtonPanel() {
        ChooserButtonPanel chooserButtonPanel = new ChooserButtonPanel(false);
        chooserButtonPanel.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedPane.this.fireActionPerformed(new ActionEvent(AdvancedPane.this, 1001, "CANCEL"));
            }
        });
        chooserButtonPanel.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = AdvancedPane.this.getSelectedPaneTag();
                if (string != null) {
                    AdvancedPane.this.showPane(string);
                }
            }
        });
        return chooserButtonPanel;
    }

    private void showMaskingDisabledDialog() {
        Container container = this.getTopLevelAncestor();
        JFrame jFrame = container instanceof JFrame ? (JFrame)container : null;
        AquaAlert aquaAlert = AquaAlert.createStandardAquaAlert(Resources.getString("advanced.masking.busyDialog.message"), Resources.getString("advanced.masking.busyDialog.explanation"), Resources.getImage("icon.application"), Resources.getString("ok"), null, null);
        aquaAlert.showSheet(jFrame, new AquaAlertAdapter(){

            public void aquaAlertDismissed(int n, Object object) {
                AdvancedPane.this.showPane(AdvancedPane.this.maskingPane.getTag());
            }

            public boolean allowAquaAlertToBeDismissed(int n, Object object) {
                return true;
            }
        }, null);
    }
}

