/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr.advanced;

import com.apple.gui.AlternatingTable;
import com.apple.gui.GUIFactory;
import com.apple.gui.RestrictedTextField;
import com.apple.xsr.AbstractManagementPane;
import com.apple.xsr.AquaTableCellBorder;
import com.apple.xsr.ChooserButtonPanel;
import com.apple.xsr.DataModel;
import com.apple.xsr.RadioButtonGroup;
import com.apple.xsr.Resources;
import com.apple.xsr.advanced.AdvancedMaskingModel;
import com.apple.xsr.advanced.AdvancedPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;

public class AdvancedMaskingPane
extends AbstractManagementPane {
    private final AdvancedPane parent;
    private JPanel controllerSelector;
    private RadioButtonGroup controllerRadioButtonGroup;
    private JCheckBox lunEnable;
    private HostModel hostModel;
    private LUNModel lunModel;
    private AlternatingTable hostTable;
    private AlternatingTable lunTable;
    private JScrollPane hostScrollPane;
    private JScrollPane lunScrollPane;
    private JButton addButton;
    private JButton removeButton;
    private JButton allOnButton;
    private JButton allOffButton;
    private JButton copyButton;
    private JButton pasteButton;
    private ChooserButtonPanel buttons;
    private int controller = 0;
    private boolean[] enabled = new boolean[2];
    private ArrayList[] wwpNames = new ArrayList[2];
    private ArrayList[] lunIDs = new ArrayList[2];
    private ArrayList[] lunNames = new ArrayList[2];
    private ArrayList[] lunDescriptions = new ArrayList[2];
    private ArrayList[] lunVisible = new ArrayList[2];
    private BitSet nullBitSet = new BitSet();
    private boolean paneEnabled = true;
    private static final int MAX_HOST_COUNT = 8;
    private static final int COLUMN_HOST = 0;
    private static final int COLUMN_LUN_CHECKBOX = 0;
    private static final int COLUMN_LUN_NAME = 1;
    private static final int COLUMN_LUN_DESCRIPTION = 2;
    private static final String TAG = "ADVANCED_MASKING";
    private static final int PREFERRED_WIDTH = 663;
    private static final int PREFERRED_HEIGHT = 437;
    private static final Insets LABEL_INSETS = new Insets(0, 0, 16, 0);
    private static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$advanced$AdvancedMaskingPane == null ? (class$com$apple$xsr$advanced$AdvancedMaskingPane = AdvancedMaskingPane.class$("com.apple.xsr.advanced.AdvancedMaskingPane")) : class$com$apple$xsr$advanced$AdvancedMaskingPane);
    static /* synthetic */ Class class$com$apple$xsr$advanced$AdvancedMaskingPane;
    static /* synthetic */ Class class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx;
    static /* synthetic */ Class class$javax$swing$event$CellEditorListener;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$apple$xsr$advanced$AdvancedMaskingModel;

    AdvancedMaskingPane(AdvancedPane advancedPane) {
        super(663, 437);
        this.parent = advancedPane;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        this.controllerSelector = GUIFactory.newPanel();
        JLabel jLabel = new JLabel(Resources.getString("advanced.masking.selectController"));
        this.controllerSelector.add(jLabel);
        this.controllerRadioButtonGroup = new RadioButtonGroup();
        JRadioButton jRadioButton = GUIFactory.newRadioButton(Resources.getString("advanced.masking.upperController"), true);
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedMaskingPane.this.populateForController(0);
            }
        });
        this.controllerSelector.add(jRadioButton);
        this.controllerRadioButtonGroup.add(jRadioButton);
        JRadioButton jRadioButton2 = GUIFactory.newRadioButton(Resources.getString("advanced.masking.lowerController"), false);
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedMaskingPane.this.populateForController(1);
            }
        });
        this.controllerSelector.add(jRadioButton2);
        this.controllerRadioButtonGroup.add(jRadioButton2);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        this.addComponent(this.controllerSelector, this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        this.lunEnable = GUIFactory.newCheckBox(Resources.getString("advanced.masking.enable"));
        this.lunEnable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((AdvancedMaskingPane)AdvancedMaskingPane.this).enabled[((AdvancedMaskingPane)AdvancedMaskingPane.this).controller] = AdvancedMaskingPane.this.lunEnable.isSelected();
            }
        });
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = LABEL_INSETS;
        this.addComponent(this.lunEnable, this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.insets = ZERO_INSETS;
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        this.hostModel = new HostModel();
        this.hostTable = new AlternatingTable(this.hostModel);
        this.hostTable.setSelectionModel(new SelectionModel());
        this.updateTableKeyBindings();
        this.hostTable.setRowSelectionAllowed(true);
        this.hostTable.setColumnSelectionAllowed(false);
        this.hostTable.setRowHeight(22);
        this.hostTable.getSelectionModel().setSelectionMode(0);
        this.hostTable.setAutoResizeMode(3);
        this.hostScrollPane = new JScrollPane(this.hostTable);
        this.hostScrollPane.setVerticalScrollBarPolicy(22);
        this.hostScrollPane.setHorizontalScrollBarPolicy(32);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.addComponent(this.hostScrollPane, this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridx;
        this.hostTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                if (AdvancedMaskingPane.this.paneEnabled) {
                    int n = AdvancedMaskingPane.this.hostTable.getModel().getRowCount();
                    AdvancedMaskingPane.this.addButton.setEnabled(n < 8);
                }
            }
        });
        this.hostTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = AdvancedMaskingPane.this.hostTable.getSelectedRow();
                if (n != -1 && n < AdvancedMaskingPane.this.hostModel.getRowCount()) {
                    BitSet bitSet = (BitSet)((AdvancedMaskingPane)AdvancedMaskingPane.this).hostModel.visibleList.get(n);
                    AdvancedMaskingPane.this.lunModel.setVisibleList(bitSet);
                    AdvancedMaskingPane.this.removeButton.setEnabled(true);
                    AdvancedMaskingPane.this.allOnButton.setEnabled(true);
                    AdvancedMaskingPane.this.allOffButton.setEnabled(true);
                    AdvancedMaskingPane.this.copyButton.setEnabled(true);
                } else {
                    AdvancedMaskingPane.this.lunModel.setVisibleList(null);
                    AdvancedMaskingPane.this.removeButton.setEnabled(false);
                    AdvancedMaskingPane.this.allOnButton.setEnabled(false);
                    AdvancedMaskingPane.this.allOffButton.setEnabled(false);
                    AdvancedMaskingPane.this.copyButton.setEnabled(false);
                    AdvancedMaskingPane.this.pasteButton.setEnabled(false);
                }
            }
        });
        TableColumn tableColumn = this.hostTable.getColumnModel().getColumn(0);
        tableColumn.setCellRenderer(new HostRenderer());
        HostEditor hostEditor = new HostEditor(this.hostTable);
        tableColumn.setCellEditor(hostEditor);
        hostEditor.addCellEditorListener(new CellEditorListenerEx(){

            public void editingStarted(ChangeEvent changeEvent) {
                logger.debug("EDITING STARTED");
                this.updatePaneState(false);
            }

            public void editingStopped(ChangeEvent changeEvent) {
                logger.debug("EDITING STOPPED");
                this.updatePaneState(true);
                this.removeRowIfEmpty(changeEvent);
            }

            public void editingCanceled(ChangeEvent changeEvent) {
                logger.debug("EDITING CANCELED");
                this.updatePaneState(true);
                this.removeRowIfEmpty(changeEvent);
            }

            public void validationSucceeded(ChangeEvent changeEvent) {
                logger.debug("VALIDATION SUCCEEDED");
            }

            public void validationFailed(ChangeEvent changeEvent) {
                logger.debug("VALIDATION FAILED");
            }

            private void updatePaneState(boolean bl) {
                Enumeration<AbstractButton> enumeration = AdvancedMaskingPane.this.controllerRadioButtonGroup.getElements();
                while (enumeration.hasMoreElements()) {
                    ((Component)enumeration.nextElement()).setEnabled(bl);
                }
                AdvancedMaskingPane.this.addButton.setEnabled(bl);
                ((AdvancedMaskingPane)AdvancedMaskingPane.this).buttons.okButton.setEnabled(bl);
                ((AdvancedMaskingPane)AdvancedMaskingPane.this).buttons.backButton.setEnabled(bl);
                ((SelectionModel)AdvancedMaskingPane.this.hostTable.getSelectionModel()).setSelectionEnabled(bl);
            }

            private void removeRowIfEmpty(ChangeEvent changeEvent) {
                String string = (String)((HostEditor)changeEvent.getSource()).getCellEditorValue();
                logger.debug("removeRowIfEmpty: value=" + string + " length=" + string.length());
                if (string.length() == 0) {
                    AdvancedMaskingPane.this.hostModel.removeSelectedRow(AdvancedMaskingPane.this.hostTable);
                }
            }
        });
        gridBagConstraints.gridy = 1;
        this.addComponent(Box.createHorizontalStrut(16), this, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridx;
        JLabel jLabel2 = new JLabel(Resources.getString("advanced.masking.choose"));
        gridBagConstraints.insets = LABEL_INSETS;
        this.addComponent(jLabel2, this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.insets = ZERO_INSETS;
        ++gridBagConstraints.gridy;
        this.lunModel = new LUNModel();
        this.lunTable = new AlternatingTable(this.lunModel);
        this.lunTable.setRowSelectionAllowed(false);
        this.lunTable.setColumnSelectionAllowed(false);
        this.lunTable.setRowHeight(22);
        this.lunTable.setAutoResizeMode(3);
        this.lunScrollPane = new JScrollPane(this.lunTable);
        this.lunScrollPane.setVerticalScrollBarPolicy(22);
        this.lunScrollPane.setHorizontalScrollBarPolicy(32);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 1.0;
        this.addComponent(this.lunScrollPane, this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        TableColumn tableColumn2 = this.lunTable.getColumnModel().getColumn(0);
        tableColumn2.setResizable(false);
        tableColumn2.setMaxWidth(32);
        tableColumn2.setMinWidth(32);
        tableColumn2.setCellRenderer(new VisibleRenderer(this.lunTable));
        tableColumn2.setCellEditor(new VisibleEditor(this.lunTable));
        TableColumn tableColumn3 = this.lunTable.getColumnModel().getColumn(1);
        tableColumn3.setResizable(false);
        tableColumn3.setMaxWidth(80);
        tableColumn3.setMinWidth(80);
        gridBagConstraints.gridx = 0;
        JPanel jPanel = GUIFactory.newPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        this.addButton = GUIFactory.newButton(Resources.getString("advanced.masking.host.add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedMaskingPane.this.hostModel.insertValue("", AdvancedMaskingPane.this.hostTable);
            }
        });
        jPanel.add(this.addButton);
        this.removeButton = GUIFactory.newButton(Resources.getString("advanced.masking.host.remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.setVerifyInputWhenFocusTarget(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedMaskingPane.this.hostModel.removeSelectedRow(AdvancedMaskingPane.this.hostTable);
            }
        });
        jPanel.add(this.removeButton);
        this.addComponent(jPanel, this, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridx;
        ++gridBagConstraints.gridx;
        JPanel jPanel2 = GUIFactory.newPanel();
        jPanel2.setLayout(new GridLayout(1, 4));
        this.allOnButton = GUIFactory.newButton(Resources.getString("advanced.masking.all.on"));
        this.allOnButton.setEnabled(false);
        this.allOnButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedMaskingPane.this.lunModel.setAll(true);
            }
        });
        jPanel2.add(this.allOnButton);
        this.allOffButton = GUIFactory.newButton(Resources.getString("advanced.masking.all.off"));
        this.allOffButton.setEnabled(false);
        this.allOffButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedMaskingPane.this.lunModel.setAll(false);
            }
        });
        jPanel2.add(this.allOffButton);
        this.copyButton = GUIFactory.newButton(Resources.getString("advanced.masking.copy"));
        this.copyButton.setEnabled(false);
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedMaskingPane.this.lunModel.copyOnOff();
                AdvancedMaskingPane.this.pasteButton.setEnabled(true);
            }
        });
        jPanel2.add(this.copyButton);
        this.pasteButton = GUIFactory.newButton(Resources.getString("advanced.masking.paste"));
        this.pasteButton.setEnabled(false);
        this.pasteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedMaskingPane.this.lunModel.pasteOnOff();
            }
        });
        jPanel2.add(this.pasteButton);
        this.addComponent(jPanel2, this, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        this.addComponent(Box.createVerticalStrut(16), this, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.buttons = new ChooserButtonPanel(true);
        this.buttons.setRestartRequiredLabelVisible(true);
        this.buttons.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedMaskingPane.this.parent.goBackToChooser();
            }
        });
        this.buttons.cancelButton.setVerifyInputWhenFocusTarget(false);
        this.buttons.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableCellEditor tableCellEditor = AdvancedMaskingPane.this.hostTable.getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.cancelCellEditing();
                }
                ActionEvent actionEvent2 = new ActionEvent(AdvancedMaskingPane.this.parent, 1001, "CANCEL");
                AdvancedMaskingPane.this.parent.fireActionPerformed(actionEvent2);
            }
        });
        this.buttons.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionEvent actionEvent2 = new ActionEvent(AdvancedMaskingPane.this, 1001, "APPLY");
                AdvancedMaskingPane.this.parent.fireActionPerformed(actionEvent2);
            }
        });
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 3;
        this.addComponent(this.buttons, this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
    }

    void setPaneEnabled(boolean bl) {
        this.paneEnabled = bl;
        this.hostTable.setEnabled(bl);
        this.lunEnable.setEnabled(bl);
        this.addButton.setEnabled(bl);
        this.buttons.okButton.setEnabled(bl);
        if (!bl) {
            this.removeButton.setEnabled(bl);
            this.allOnButton.setEnabled(bl);
            this.allOffButton.setEnabled(bl);
            this.copyButton.setEnabled(bl);
            this.pasteButton.setEnabled(bl);
        }
    }

    private void updateTableKeyBindings() {
        InputMap inputMap = this.hostTable.getInputMap(1);
        ActionMap actionMap = this.hostTable.getActionMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        Object object = null;
        if (inputMap != null) {
            object = inputMap.get(keyStroke);
        }
        if (actionMap != null && object != null) {
            ActionListener actionListener = this.hostTable.getActionForKeyStroke(keyStroke);
            actionMap.put(object, new CancelEditingAction(this.hostTable, actionListener));
        }
    }

    public void populateForController(int n) {
        if (this.hostTable.getEditingRow() != -1) {
            this.hostTable.getCellEditor().stopCellEditing();
        }
        this.controller = n;
        this.lunEnable.setSelected(this.enabled[this.controller]);
        this.hostModel.setNamesAndVisible(this.wwpNames[this.controller], this.lunVisible[this.controller]);
        this.lunModel.setLists(this.lunIDs[this.controller], this.lunNames[this.controller], this.lunDescriptions[this.controller]);
    }

    public void populateUI(DataModel dataModel) {
        if (dataModel.getClass() != (class$com$apple$xsr$advanced$AdvancedMaskingModel == null ? (class$com$apple$xsr$advanced$AdvancedMaskingModel = AdvancedMaskingPane.class$("com.apple.xsr.advanced.AdvancedMaskingModel")) : class$com$apple$xsr$advanced$AdvancedMaskingModel)) {
            throw new IllegalArgumentException("illegal data model type " + dataModel.getClass());
        }
        if (dataModel != null) {
            AdvancedMaskingModel advancedMaskingModel = (AdvancedMaskingModel)dataModel;
            int n = advancedMaskingModel.getControllers();
            this.controllerSelector.setVisible(n > 1);
            for (int i = 0; i < n; ++i) {
                AdvancedMaskingModel.AdvancedMaskingControllerModel advancedMaskingControllerModel = i == 0 ? advancedMaskingModel.getUpperControllerModel() : advancedMaskingModel.getLowerControllerModel();
                this.enabled[i] = advancedMaskingControllerModel.getLUNMaskEnabled();
                this.wwpNames[i] = advancedMaskingControllerModel.getWWPName();
                this.lunIDs[i] = advancedMaskingControllerModel.getLUNIDs();
                this.lunNames[i] = advancedMaskingControllerModel.getLUNNames();
                this.lunDescriptions[i] = advancedMaskingControllerModel.getLUNDescriptions();
                this.lunVisible[i] = advancedMaskingControllerModel.getLUNVisible();
            }
            this.populateForController(0);
        }
        this.validateUI((DataModel)null);
    }

    public boolean validateUI(DataModel dataModel) {
        if (dataModel != null) {
            AdvancedMaskingModel advancedMaskingModel = (AdvancedMaskingModel)dataModel;
            int n = advancedMaskingModel.getControllers();
            for (int i = 0; i < n; ++i) {
                AdvancedMaskingModel.AdvancedMaskingControllerModel advancedMaskingControllerModel = i == 0 ? advancedMaskingModel.getUpperControllerModel() : advancedMaskingModel.getLowerControllerModel();
                advancedMaskingControllerModel.setLUNMaskEnabled(new Boolean(this.enabled[i]));
                advancedMaskingControllerModel.setWWPName(this.wwpNames[i]);
                advancedMaskingControllerModel.setLUNVisible(this.lunVisible[i]);
            }
        }
        return true;
    }

    public boolean allowAbort() {
        logger.debug("Allow abort called");
        TableCellEditor tableCellEditor = this.hostTable.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.cancelCellEditing();
        }
        return true;
    }

    public ImageIcon getIcon() {
        return new ImageIcon(Resources.getImage("icon.masking"));
    }

    public String getTitle() {
        return Resources.getString("advanced.masking");
    }

    public String getExplanation() {
        return Resources.getString("advanced.maskingExplanation");
    }

    public String getTag() {
        return TAG;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class LUNModel
    extends AbstractTableModel
    implements ListDataListener {
        ArrayList ids = new ArrayList();
        ArrayList names = new ArrayList();
        ArrayList descriptions = new ArrayList();
        BitSet visible = null;
        BitSet clipboard = new BitSet();

        public LUNModel() {
            this.setAll(false);
        }

        public void setLists(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
            this.ids = arrayList;
            this.names = arrayList2;
            this.descriptions = arrayList3;
            this.fireTableDataChanged();
        }

        public void setVisibleList(BitSet bitSet) {
            this.visible = bitSet;
            this.fireTableDataChanged();
        }

        public void setAll(boolean bl) {
            if (this.visible != null) {
                if (bl) {
                    for (int i = 0; i < 128; ++i) {
                        this.visible.set(i);
                    }
                } else {
                    for (int i = 0; i < 128; ++i) {
                        this.visible.clear(i);
                    }
                }
                this.fireTableDataChanged();
            }
        }

        public void copyOnOff() {
            if (this.visible != null) {
                for (int i = 0; i < 128; ++i) {
                    if (this.visible.get(i)) {
                        this.clipboard.set(i);
                        continue;
                    }
                    this.clipboard.clear(i);
                }
            }
        }

        public void pasteOnOff() {
            if (this.visible != null) {
                for (int i = 0; i < 128; ++i) {
                    if (this.clipboard.get(i)) {
                        this.visible.set(i);
                        continue;
                    }
                    this.visible.clear(i);
                }
                this.fireTableDataChanged();
            }
        }

        public int getRowCount() {
            return this.descriptions.size();
        }

        public int getColumnCount() {
            return 3;
        }

        public Object getValueAt(int n, int n2) {
            Object object = null;
            switch (n2) {
                case 0: {
                    if (this.visible == null || n >= this.ids.size()) {
                        object = null;
                        break;
                    }
                    int n3 = (Integer)this.ids.get(n);
                    if (n3 >= 0) {
                        object = new Boolean(this.visible.get(n3));
                        break;
                    }
                    object = new Boolean(false);
                    break;
                }
                case 1: {
                    if (n >= this.names.size()) break;
                    object = this.names.get(n);
                    break;
                }
                case 2: {
                    if (n >= this.descriptions.size()) break;
                    object = this.descriptions.get(n) + " ";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal column: " + n2);
                }
            }
            return object;
        }

        public void setValueAt(Object object, int n, int n2) {
            switch (n2) {
                case 0: {
                    int n3;
                    if (n >= this.ids.size() || (n3 = ((Integer)this.ids.get(n)).intValue()) < 0 || this.visible == null) break;
                    if (object != null && object.equals(Boolean.TRUE)) {
                        this.visible.set(n3);
                        break;
                    }
                    this.visible.clear(n3);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal column: " + n2);
                }
            }
        }

        public String getColumnName(int n) {
            String string = "";
            switch (n) {
                case 0: {
                    string = Resources.getString("advanced.masking.on");
                    break;
                }
                case 1: {
                    string = Resources.getString("advanced.masking.name");
                    break;
                }
                case 2: {
                    string = Resources.getString("advanced.masking.description");
                }
            }
            return string;
        }

        public Class getColumnClass(int n) {
            Class clazz = null;
            switch (n) {
                case 0: {
                    clazz = class$java$lang$Object == null ? (class$java$lang$Object = AdvancedMaskingPane.class$("java.lang.Object")) : class$java$lang$Object;
                    break;
                }
                case 1: 
                case 2: {
                    clazz = class$java$lang$String == null ? (class$java$lang$String = AdvancedMaskingPane.class$("java.lang.String")) : class$java$lang$String;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal column: " + n);
                }
            }
            return clazz;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ LUNModel this$1;
                {
                    this.this$1 = lUNModel;
                }

                public void run() {
                    this.this$1.fireTableDataChanged();
                }
            });
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }
    }

    private class HostModel
    extends AbstractTableModel {
        ArrayList hostsList = new ArrayList();
        ArrayList visibleList = new ArrayList();

        private HostModel() {
        }

        public void setNamesAndVisible(ArrayList arrayList, ArrayList arrayList2) {
            this.hostsList = arrayList;
            this.visibleList = arrayList2;
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            return this.hostsList.size();
        }

        public int getColumnCount() {
            return 1;
        }

        public Object getValueAt(int n, int n2) {
            Object var3_3 = null;
            switch (n2) {
                case 0: {
                    var3_3 = this.hostsList.get(n);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal column: " + n2);
                }
            }
            return var3_3;
        }

        public void setValueAt(Object object, int n, int n2) {
            switch (n2) {
                case 0: {
                    this.hostsList.set(n, object);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal column: " + n2);
                }
            }
        }

        public int insertValue(Object object, JTable jTable) {
            int n = jTable.getSelectedRow();
            if (n == -1) {
                n = this.hostsList.size();
            }
            if (jTable.getEditingRow() != -1 && !jTable.getCellEditor().stopCellEditing()) {
                return -1;
            }
            this.hostsList.add(n, object);
            this.visibleList.add(n, new BitSet());
            this.fireTableRowsInserted(n, n);
            jTable.changeSelection(n, 0, false, false);
            jTable.editCellAt(n, 0);
            Component component = jTable.getEditorComponent();
            if (component != null) {
                component.requestFocus();
            }
            return n;
        }

        public void removeSelectedRow(JTable jTable) {
            int n = jTable.getSelectedRow();
            if (jTable.getEditingRow() == n && jTable.getCellEditor() != null) {
                jTable.getCellEditor().cancelCellEditing();
            }
            if (n != -1 && n < this.hostsList.size()) {
                this.hostsList.remove(n);
                this.visibleList.remove(n);
            }
            this.fireTableDataChanged();
        }

        public String getColumnName(int n) {
            return Resources.getString("advanced.masking.hostWWPN");
        }

        public Class getColumnClass(int n) {
            Class clazz = null;
            switch (n) {
                case 0: {
                    clazz = class$java$lang$String == null ? (class$java$lang$String = AdvancedMaskingPane.class$("java.lang.String")) : class$java$lang$String;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal column: " + n);
                }
            }
            return clazz;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }
    }

    static class SelectionModel
    extends DefaultListSelectionModel {
        protected boolean selectionEnabled = true;

        SelectionModel() {
        }

        public void setSelectionEnabled(boolean bl) {
            this.selectionEnabled = bl;
        }

        public void addSelectionInterval(int n, int n2) {
            if (this.selectionEnabled) {
                super.addSelectionInterval(n, n2);
            }
        }

        public void insertIndexInterval(int n, int n2, boolean bl) {
            if (this.selectionEnabled) {
                super.insertIndexInterval(n, n2, bl);
            }
        }

        public void removeIndexInterval(int n, int n2) {
            if (this.selectionEnabled) {
                super.removeIndexInterval(n, n2);
            }
        }

        public void removeSelectionInterval(int n, int n2) {
            if (this.selectionEnabled) {
                super.removeSelectionInterval(n, n2);
            }
        }

        public void setAnchorSelectionIndex(int n) {
            if (this.selectionEnabled) {
                super.setAnchorSelectionIndex(n);
            }
        }

        public void setLeadSelectionIndex(int n) {
            if (this.selectionEnabled) {
                super.setLeadSelectionIndex(n);
            }
        }

        public void setSelectionInterval(int n, int n2) {
            if (this.selectionEnabled) {
                super.setSelectionInterval(n, n2);
            }
        }
    }

    static class WWNInputVerifier
    extends InputVerifier {
        WWNInputVerifier() {
        }

        public boolean verify(JComponent jComponent) {
            JTextField jTextField = (JTextField)jComponent;
            String string = jTextField.getText();
            boolean bl = string.length() == 0 ? true : (string.length() > 23 ? false : this.checkColons(jTextField));
            logger.debug("WWNInputVerifier result: " + bl);
            return bl;
        }

        boolean checkColons(JTextField jTextField) {
            String string = jTextField.getText();
            boolean bl = true;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != ':') {
                    ++n2;
                    continue;
                }
                if (n2 < 1 || n2 > 2 || n > 7) {
                    return false;
                }
                ++n;
                n2 = 0;
            }
            if (string.length() != 16 && n < 7 || string.length() == 16 && n != 0) {
                bl = false;
            } else if (string.length() == 16 && n == 0) {
                StringBuffer stringBuffer = new StringBuffer();
                int n3 = 0;
                for (int i = 2; i <= 16; i += 2) {
                    stringBuffer.append(string.substring(n3, i) + (i < 16 ? ":" : ""));
                    n3 = i;
                }
                jTextField.setText(stringBuffer.toString());
            }
            return bl;
        }
    }

    static abstract class AbstractCellEditorEx
    extends AbstractCellEditor {
        AbstractCellEditorEx() {
        }

        public boolean isCellEditable(EventObject eventObject) {
            this.fireEditingStarted();
            return true;
        }

        public void addCellEditorListener(CellEditorListenerEx cellEditorListenerEx) {
            this.listenerList.add(class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx == null ? (class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx = AdvancedMaskingPane.class$("com.apple.xsr.advanced.AdvancedMaskingPane$CellEditorListenerEx")) : class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx, cellEditorListenerEx);
        }

        public void removeCellEditorListener(CellEditorListenerEx cellEditorListenerEx) {
            this.listenerList.remove(class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx == null ? (class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx = AdvancedMaskingPane.class$("com.apple.xsr.advanced.AdvancedMaskingPane$CellEditorListenerEx")) : class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx, cellEditorListenerEx);
        }

        protected void fireEditingStopped() {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != (class$javax$swing$event$CellEditorListener == null ? AdvancedMaskingPane.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener) && objectArray[i] != (class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx == null ? AdvancedMaskingPane.class$("com.apple.xsr.advanced.AdvancedMaskingPane$CellEditorListenerEx") : class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx)) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)objectArray[i + 1]).editingStopped(this.changeEvent);
            }
        }

        protected void fireEditingCanceled() {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != (class$javax$swing$event$CellEditorListener == null ? AdvancedMaskingPane.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener) && objectArray[i] != (class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx == null ? AdvancedMaskingPane.class$("com.apple.xsr.advanced.AdvancedMaskingPane$CellEditorListenerEx") : class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx)) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)objectArray[i + 1]).editingCanceled(this.changeEvent);
            }
        }

        protected void fireEditingStarted() {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != (class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx == null ? AdvancedMaskingPane.class$("com.apple.xsr.advanced.AdvancedMaskingPane$CellEditorListenerEx") : class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx)) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListenerEx)objectArray[i + 1]).editingStarted(this.changeEvent);
            }
        }

        protected void fireValidationSucceeded() {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != (class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx == null ? AdvancedMaskingPane.class$("com.apple.xsr.advanced.AdvancedMaskingPane$CellEditorListenerEx") : class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx)) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListenerEx)objectArray[i + 1]).validationSucceeded(this.changeEvent);
            }
        }

        protected void fireValidationFailed() {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != (class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx == null ? AdvancedMaskingPane.class$("com.apple.xsr.advanced.AdvancedMaskingPane$CellEditorListenerEx") : class$com$apple$xsr$advanced$AdvancedMaskingPane$CellEditorListenerEx)) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListenerEx)objectArray[i + 1]).validationFailed(this.changeEvent);
            }
        }
    }

    static interface CellEditorListenerEx
    extends CellEditorListener {
        public void editingStarted(ChangeEvent var1);

        public void validationSucceeded(ChangeEvent var1);

        public void validationFailed(ChangeEvent var1);
    }

    static class HostEditor
    extends AbstractCellEditorEx
    implements TableCellEditor {
        private JTable table;
        private TextComponent comp = new TextComponent();
        private Object initialValue;

        public HostEditor(JTable jTable) {
            this.table = jTable;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            logger.debug("getTableCellEditorComponent: value=" + object + " isSelected=" + bl + " row=" + n + " col=" + n2);
            this.initialValue = object;
            this.comp.setValue(object);
            this.comp.setAttributes(bl, false, n);
            return this.comp;
        }

        public Object getCellEditorValue() {
            return this.comp.getValue();
        }

        public boolean stopCellEditing() {
            Boolean bl = null;
            if (this.comp.hasFocus() && !this.comp.shouldYieldFocus()) {
                this.fireValidationFailed();
                bl = Boolean.FALSE;
            }
            if (bl == null) {
                this.fireValidationSucceeded();
                bl = new Boolean(super.stopCellEditing());
            }
            return bl;
        }

        public void cancelCellEditing() {
            this.comp.setValue(this.initialValue);
            this.fireEditingCanceled();
        }

        public boolean isCellEditable(EventObject eventObject) {
            boolean bl = true;
            if (eventObject instanceof MouseEvent) {
                JTable jTable = (JTable)eventObject.getSource();
                int n = jTable.getSelectedRow();
                if (n != -1 && jTable.rowAtPoint(((MouseEvent)eventObject).getPoint()) == n) {
                    bl = true;
                } else {
                    boolean bl2 = bl = ((MouseEvent)eventObject).getClickCount() >= 2;
                }
            }
            if (bl) {
                this.fireEditingStarted();
            }
            return bl;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        static class TextComponent
        extends RestrictedTextField {
            private InputVerifier verifier = new WWNInputVerifier();

            public TextComponent() {
                this.setFont(GUIFactory.FONT_SMALL);
                this.setRestrictedCharacterSet("0123456789AaBbCcDdEeFf:");
                this.setMaxNumCharactersAllowed(23);
                this.setInputVerifier(this.verifier);
            }

            public void setValue(Object object) {
                this.setText(object == null ? "" : object.toString());
            }

            public Object getValue() {
                return this.getText();
            }

            public void setAttributes(boolean bl, boolean bl2, int n) {
            }

            public boolean shouldYieldFocus() {
                return this.verifier.shouldYieldFocus(this);
            }
        }
    }

    static class HostRenderer
    extends JPanel
    implements TableCellRenderer {
        private JLabel label;
        private static final AquaTableCellBorder border = new AquaTableCellBorder();

        public HostRenderer() {
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(border);
            this.label = new JLabel();
            this.label.setFont(GUIFactory.FONT_SMALL);
            this.label.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
            this.add(this.label);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            this.label.setText((String)object);
            this.label.setForeground(bl ? Color.white : Color.black);
            border.setAttributes(bl, jTable.hasFocus(), n);
            return this;
        }
    }

    static class VisibleEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        VisibleRenderer renderer;

        public VisibleEditor(JTable jTable) {
            this.renderer = new VisibleRenderer(jTable);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return this.renderer.getTableCellRendererComponent(jTable, object, true, false, n, n2);
        }

        public Object getCellEditorValue() {
            return new Boolean(this.renderer.checkbox.isSelected());
        }
    }

    static class VisibleRenderer
    extends JPanel
    implements TableCellRenderer {
        private JTable table;
        public JCheckBox checkbox;
        AquaTableCellBorder border;

        public VisibleRenderer(JTable jTable) {
            this.table = jTable;
            this.setLayout(new GridLayout(1, 1, 0, 0));
            this.border = new AquaTableCellBorder();
            this.setBorder(this.border);
            this.checkbox = GUIFactory.newCheckBox();
            this.checkbox.setOpaque(false);
            this.add(this.checkbox);
            this.checkbox.addActionListener(new ActionListener(this){
                private final /* synthetic */ VisibleRenderer this$0;
                {
                    this.this$0 = visibleRenderer;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    VisibleRenderer.access$1800(this.this$0).getCellEditor().stopCellEditing();
                }
            });
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.checkbox.setEnabled(object != null);
            this.checkbox.setSelected(object != null && object.equals(Boolean.TRUE));
            this.border.setAttributes(false, false, n);
            return this;
        }

        static /* synthetic */ JTable access$1800(VisibleRenderer visibleRenderer) {
            return visibleRenderer.table;
        }
    }

    static class CancelEditingAction
    extends AbstractAction {
        JTable table;
        ActionListener originalAction;

        public CancelEditingAction(JTable jTable, ActionListener actionListener) {
            this.table = jTable;
            this.originalAction = actionListener;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TableCellEditor tableCellEditor = this.table.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.cancelCellEditing();
            }
            if (this.originalAction != null) {
                this.originalAction.actionPerformed(actionEvent);
            }
        }
    }
}

