/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.xsr.SystemRegistryEvent;
import com.apple.xsr.SystemRegistryListener;
import com.apple.xsr.som.RaidSystem;
import com.apple.xsr.som.SystemObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import javax.swing.event.EventListenerList;

public class SystemRegistry
implements SystemObserver {
    protected List list = Collections.synchronizedList(new ArrayList());
    private EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$com$apple$xsr$SystemRegistryListener;

    public void add(RaidSystem raidSystem) {
        raidSystem.addObserver(this);
        this.list.add(raidSystem);
        this.fireSystemAdded(raidSystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String string) {
        List list = this.list;
        synchronized (list) {
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                RaidSystem raidSystem = (RaidSystem)iterator.next();
                if (!raidSystem.getName().equals(string)) continue;
                this.remove(raidSystem);
                break;
            }
        }
    }

    public void remove(RaidSystem raidSystem) {
        RaidSystem[] raidSystemArray = new RaidSystem[]{raidSystem};
        this.remove(raidSystemArray);
    }

    public void remove(RaidSystem[] raidSystemArray) {
        for (int i = 0; i < raidSystemArray.length; ++i) {
            raidSystemArray[i].deleteObserver(this);
            this.list.remove(raidSystemArray[i]);
        }
        this.fireSystemRemoved(raidSystemArray);
    }

    public int getSystemCount() {
        return this.list.size();
    }

    public RaidSystem getSystem(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.list.size()) {
            throw new IndexOutOfBoundsException("index = " + n);
        }
        return (RaidSystem)this.list.get(n);
    }

    public Collection getSystems() {
        return Collections.unmodifiableCollection(this.list);
    }

    public void addSystemRegistryListener(SystemRegistryListener systemRegistryListener) {
        this.listenerList.add(class$com$apple$xsr$SystemRegistryListener == null ? (class$com$apple$xsr$SystemRegistryListener = SystemRegistry.class$("com.apple.xsr.SystemRegistryListener")) : class$com$apple$xsr$SystemRegistryListener, systemRegistryListener);
    }

    public void removeSystemRegistryListener(SystemRegistryListener systemRegistryListener) {
        this.listenerList.remove(class$com$apple$xsr$SystemRegistryListener == null ? (class$com$apple$xsr$SystemRegistryListener = SystemRegistry.class$("com.apple.xsr.SystemRegistryListener")) : class$com$apple$xsr$SystemRegistryListener, systemRegistryListener);
    }

    public void update(Observable observable, Object object) {
        RaidSystem[] raidSystemArray = new RaidSystem[]{(RaidSystem)observable};
        this.fireSystemUpdated(raidSystemArray);
    }

    protected void fireSystemAdded(RaidSystem raidSystem) {
        if (raidSystem == null) {
            throw new NullPointerException("system cannot be null");
        }
        RaidSystem[] raidSystemArray = new RaidSystem[]{raidSystem};
        this.fireRegistryChanged(new SystemRegistryEvent(this, 0, raidSystemArray));
    }

    protected void fireSystemRemoved(RaidSystem[] raidSystemArray) {
        if (raidSystemArray == null) {
            throw new NullPointerException("systems cannot be null");
        }
        if (raidSystemArray.length == 0) {
            throw new IllegalArgumentException("systems must contain at least one system object");
        }
        this.fireRegistryChanged(new SystemRegistryEvent(this, 1, raidSystemArray));
    }

    protected void fireSystemUpdated(RaidSystem[] raidSystemArray) {
        if (raidSystemArray == null) {
            throw new NullPointerException("systems cannot be null");
        }
        if (raidSystemArray.length == 0) {
            throw new IllegalArgumentException("systems must contain at least one system object");
        }
        this.fireRegistryChanged(new SystemRegistryEvent(this, 2, raidSystemArray));
    }

    protected void fireRegistryChanged(SystemRegistryEvent systemRegistryEvent) {
        if (systemRegistryEvent == null) {
            throw new NullPointerException("event cannot be null");
        }
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$apple$xsr$SystemRegistryListener == null ? SystemRegistry.class$("com.apple.xsr.SystemRegistryListener") : class$com$apple$xsr$SystemRegistryListener)) continue;
            ((SystemRegistryListener)objectArray[i + 1]).registryChanged(systemRegistryEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

