/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.util.Gestalt;
import com.apple.xsr.AbstractManagementPane;
import com.apple.xsr.AquaAlert;
import com.apple.xsr.AquaAlertListener;
import com.apple.xsr.DataModel;
import com.apple.xsr.ManagementFibreModel;
import com.apple.xsr.ManagementFibrePane;
import com.apple.xsr.ManagementNetworkModel;
import com.apple.xsr.ManagementNetworkPane;
import com.apple.xsr.ManagementPerformanceModel;
import com.apple.xsr.ManagementPerformancePane;
import com.apple.xsr.ManagementSystemModel;
import com.apple.xsr.ManagementSystemPane;
import com.apple.xsr.Resources;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SetupPane
extends AbstractManagementPane
implements AquaAlertListener {
    public static final int SYSTEM_TAB = 0;
    public static final int NETWORK_TAB = 1;
    public static final int FIBRE_TAB = 2;
    public static final int PERFORMANCE_TAB = 3;
    private JFrame parent;
    public JTabbedPane tabbedPane;
    private boolean modified = false;
    private ManagementSystemPane systemPane;
    private ManagementNetworkPane networkPane;
    private ManagementFibrePane fibrePane;
    private ManagementPerformancePane performancePane;
    private JLabel restartIcon;
    private JLabel restartLabel;
    private static final int preferredWidth = 800;
    private static final int preferredHeight = 610;

    public SetupPane() {
        super(800, 610);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabPlacement(1);
        this.tabbedPane.setFont(GUIFactory.FONT_SMALL);
        this.addComponent(this.tabbedPane, this, gridBagLayout, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.systemPane = new ManagementSystemPane(this);
        this.tabbedPane.addTab(Resources.getString("management.systemInfo"), this.systemPane);
        this.networkPane = new ManagementNetworkPane(this);
        this.tabbedPane.addTab(Resources.getString("management.network"), this.networkPane);
        this.fibrePane = new ManagementFibrePane(this);
        this.tabbedPane.addTab(Resources.getString("management.fibre"), this.fibrePane);
        this.performancePane = new ManagementPerformancePane(this);
        this.tabbedPane.addTab(Resources.getString("management.performance"), this.performancePane);
        JPanel jPanel = GUIFactory.newPanel();
        jPanel.setBorder(new EmptyBorder(0, 10, 0, 0));
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 1;
        this.restartIcon = new JLabel(new ImageIcon(Resources.getImage("icon.restart")));
        this.addComponent(this.restartIcon, jPanel, gridBagLayout2, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        this.addComponent(Box.createHorizontalStrut(5), jPanel, gridBagLayout2, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        this.restartLabel = new JLabel(Resources.getString("management.restartRequired"));
        this.restartLabel.setFont(GUIFactory.FONT_SMALL);
        this.addComponent(this.restartLabel, jPanel, gridBagLayout2, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.weightx = 1.0;
        this.addComponent(Box.createHorizontalStrut(0), jPanel, gridBagLayout2, gridBagConstraints2);
        gridBagConstraints2.weightx = 0.0;
        ++gridBagConstraints2.gridx;
        JButton jButton = GUIFactory.newCancelButton();
        jButton.setFont(GUIFactory.FONT_SMALL);
        this.addComponent(jButton, jPanel, gridBagLayout2, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetupPane.this.confirmCancel();
            }
        });
        this.addComponent(Box.createHorizontalStrut(10), jPanel, gridBagLayout2, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        JButton jButton2 = GUIFactory.newOKButton();
        jButton2.setFont(GUIFactory.FONT_SMALL);
        this.addComponent(jButton2, jPanel, gridBagLayout2, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionEvent actionEvent2 = new ActionEvent(SetupPane.this, 1001, "APPLY");
                SetupPane.this.fireActionPerformed(actionEvent2);
            }
        });
        if (!Gestalt.isAquaLookAndFeel) {
            gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        }
        this.addComponent(jPanel, this, gridBagLayout, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ++gridBagConstraints.gridy;
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SetupPane.this.systemPane.validate(null);
                SetupPane.this.networkPane.validate(null);
                SetupPane.this.fibrePane.validate(null);
                SetupPane.this.performancePane.validate(null);
                SetupPane.this.syncRestartMessage();
            }
        });
        this.syncRestartMessage();
    }

    public void addNotify() {
        super.addNotify();
        this.parent = (JFrame)this.getTopLevelAncestor();
    }

    public void populateUI(DataModel dataModel) {
        throw new UnsupportedOperationException();
    }

    public void populateUI(DataModel[] dataModelArray) {
        if (dataModelArray == null) {
            throw new NullPointerException("data cannot be null");
        }
        if (dataModelArray.length != this.tabbedPane.getTabCount()) {
            String string = "data model array contains an invalid number of elements (" + dataModelArray.length + " elements, expected " + this.tabbedPane.getTabCount() + ")";
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < dataModelArray.length; ++i) {
            if (dataModelArray[i] instanceof ManagementSystemModel) {
                this.systemPane.populate((ManagementSystemModel)dataModelArray[i]);
                continue;
            }
            if (dataModelArray[i] instanceof ManagementNetworkModel) {
                this.networkPane.populate((ManagementNetworkModel)dataModelArray[i]);
                continue;
            }
            if (dataModelArray[i] instanceof ManagementFibreModel) {
                this.fibrePane.populate((ManagementFibreModel)dataModelArray[i]);
                continue;
            }
            if (dataModelArray[i] instanceof ManagementPerformanceModel) {
                this.performancePane.populate((ManagementPerformanceModel)dataModelArray[i]);
                continue;
            }
            throw new IllegalArgumentException("illegal data model " + dataModelArray[i].getClass());
        }
    }

    public boolean validateUI(DataModel dataModel) {
        throw new UnsupportedOperationException();
    }

    public boolean validateUI(DataModel[] dataModelArray) {
        boolean bl = true;
        if (dataModelArray != null) {
            int n;
            int n2 = this.tabbedPane.getTabCount();
            if (dataModelArray.length != n2) {
                String string = "data model array contains an invalid number of elements (" + dataModelArray.length + " elements, expected " + n2 + ")";
                throw new IllegalArgumentException(string);
            }
            boolean[] blArray = new boolean[n2];
            for (n = 0; n < blArray.length; ++n) {
                blArray[n] = false;
            }
            for (n = 0; n < dataModelArray.length; ++n) {
                if (dataModelArray[n] instanceof ManagementSystemModel) {
                    blArray[0] = this.systemPane.validate((ManagementSystemModel)dataModelArray[n]);
                    continue;
                }
                if (dataModelArray[n] instanceof ManagementNetworkModel) {
                    blArray[1] = this.networkPane.validate((ManagementNetworkModel)dataModelArray[n]);
                    continue;
                }
                if (dataModelArray[n] instanceof ManagementFibreModel) {
                    blArray[2] = this.fibrePane.validate((ManagementFibreModel)dataModelArray[n]);
                    continue;
                }
                if (dataModelArray[n] instanceof ManagementPerformanceModel) {
                    blArray[3] = this.performancePane.validate((ManagementPerformanceModel)dataModelArray[n]);
                    continue;
                }
                throw new IllegalArgumentException("illegal data model " + dataModelArray[n].getClass());
            }
            n = -1;
            for (int i = 0; i < blArray.length; ++i) {
                if (blArray[i]) continue;
                n = i;
                break;
            }
            if (n != -1) {
                if (blArray[this.tabbedPane.getSelectedIndex()]) {
                    this.tabbedPane.setSelectedIndex(n);
                }
                this.showValidationAlert();
                bl = false;
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public void aquaAlertWillBeShown(Object object) {
    }

    public void aquaAlertResized(Object object) {
    }

    public void aquaAlertSheetVisible(Object object) {
    }

    public void aquaAlertDismissed(int n, Object object) {
        if (n == 1) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "APPLY");
            this.fireActionPerformed(actionEvent);
        } else if (n == 2) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "CANCEL");
            this.fireActionPerformed(actionEvent);
        }
    }

    public boolean allowAquaAlertToBeDismissed(int n, Object object) {
        return true;
    }

    void syncRestartMessage() {
        boolean bl = false;
        Component component = this.tabbedPane.getSelectedComponent();
        if (component instanceof ManagementSystemPane) {
            bl = true;
        } else if (component instanceof ManagementNetworkPane) {
            bl = true;
        } else if (component instanceof ManagementFibrePane) {
            bl = true;
        }
        this.restartIcon.setVisible(bl);
        this.restartLabel.setVisible(bl);
    }

    public void setModified() {
        this.getRootPane().putClientProperty("windowModified", Boolean.TRUE);
        this.modified = true;
    }

    public void confirmCancel() {
        if (this.modified) {
            AquaAlert aquaAlert = AquaAlert.createStandardAquaAlert(Resources.getString("management.unsaved.title"), Resources.getString("management.unsaved.message"), Resources.getImage("icon.application"), Resources.getString("management.unsaved.applyButton"), Resources.getString("management.unsaved.dontApplyButton"), null);
            aquaAlert.showSheet(this.parent, this, null);
        } else {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "CANCEL");
            this.fireActionPerformed(actionEvent);
        }
    }

    private void showValidationAlert() {
        AquaAlert aquaAlert = AquaAlert.createStandardAquaAlert(Resources.getString("management.validation.title"), Resources.getString("management.validation.message"), Resources.getImage("icon.application"), Resources.getString("ok"), null, null);
        aquaAlert.showSheet(this.parent, null, null);
    }
}

