/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.TextField;
import com.apple.util.Gestalt;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;

public class SelectableLabel
extends TextField {
    private static String ellipsis = "\u2026";
    private static int LABEL_WIDTH = 130;
    private String actualText = "";

    public SelectableLabel() {
        this(null);
    }

    public SelectableLabel(String string) {
        super(string);
        this.setEditable(false);
        this.setOpaque(false);
        if (Gestalt.isJava141OrLater) {
            this.setBorder(null);
        } else {
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                SelectableLabel.this.setText(SelectableLabel.this.actualText);
            }
        });
    }

    public void setText(String string) {
        this.actualText = string;
        super.setText(this.truncateText(string));
    }

    public Dimension getPreferredSize() {
        return new Dimension(LABEL_WIDTH, this.getFontMetrics(this.getFont()).getHeight());
    }

    public Dimension getMinimumSize() {
        return new Dimension(LABEL_WIDTH, this.getFontMetrics(this.getFont()).getHeight());
    }

    private String truncateText(String string) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = this.getWidth();
        if (fontMetrics.stringWidth(string) < n) {
            return string;
        }
        n -= fontMetrics.stringWidth(ellipsis);
        String string2 = "";
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            String string3 = string.substring(i, i + 1);
            if (fontMetrics.stringWidth(string2) + fontMetrics.stringWidth(string3) >= n) break;
            string2 = string2 + string3;
        }
        return string2.trim() + ellipsis;
    }
}

