/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.util.CapacityConverter;
import com.apple.util.Gestalt;
import com.apple.util.StringUtilities;
import com.apple.xsr.Resources;
import com.apple.xsr.som.Battery;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.DiskSlot;
import com.apple.xsr.som.Fan;
import com.apple.xsr.som.FibreChannelInterface;
import com.apple.xsr.som.NetworkInterface;
import com.apple.xsr.som.PowerSupply;
import com.apple.xsr.som.RaidController;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystem;
import com.apple.xsr.som.Slice;
import com.apple.xsr.som.SystemController;
import com.apple.xsr.som.SystemElement;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SOMLocalizer {
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int HOURS_PER_DAY = 24;
    public static final int SECONDS_PER_HOUR = 3600;
    public static final int SECONDS_PER_DAY = 86400;

    static String getStatusString(int n) {
        String string;
        switch (n) {
            case 0: {
                string = Resources.getString("componentStatus.ok");
                break;
            }
            case 1: {
                string = Resources.getString("componentStatus.warning");
                break;
            }
            case 2: {
                string = Resources.getString("componentStatus.failure");
                break;
            }
            case -1: {
                string = Resources.getString("componentStatus.unknown");
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal status code (" + n + ")");
            }
        }
        return string;
    }

    static String getElementStatus(SystemElement systemElement) {
        return SOMLocalizer.getStatusString(systemElement.getStatus());
    }

    static String getElementName(SystemElement systemElement) {
        String string;
        String string2 = null;
        if (systemElement instanceof Battery) {
            string2 = Resources.getString("battery");
        } else if (systemElement instanceof Disk) {
            string2 = Resources.getString("disk");
        } else if (systemElement instanceof DiskSlot) {
            string2 = Resources.getString("diskSlot");
        } else if (systemElement instanceof Fan) {
            string2 = Resources.getString("fan");
        } else if (systemElement instanceof FibreChannelInterface) {
            string2 = Resources.getString("fibrechannelinterface");
        } else if (systemElement instanceof NetworkInterface) {
            string2 = Resources.getString("networkinterface");
        } else if (systemElement instanceof PowerSupply) {
            string2 = Resources.getString("powersupply");
        } else if (systemElement instanceof RaidController) {
            string2 = Resources.getString("raidcontroller");
        } else if (systemElement instanceof RaidSet) {
            string2 = Resources.getString("raidset");
        } else if (systemElement instanceof RaidSystem) {
            string2 = Resources.getString("raidsystem");
        }
        if (string2 != null) {
            string = Resources.getString("som.name");
            string = StringUtilities.replaceAll(string, "{name}", string2);
            string = StringUtilities.replaceAll(string, "{number}", "" + systemElement.getId());
        } else {
            string = Resources.getString("som.unknown");
        }
        return string;
    }

    static String getBatteryChargeState(Battery battery) {
        String string = battery.isCharging() ? Resources.getString("battery.chargeState.charging") : Resources.getString("battery.chargeState.discharging");
        return string;
    }

    static String getBatteryCharge(Battery battery) {
        String string = Resources.getString("som.percent");
        string = StringUtilities.replaceAll(string, "{number}", "" + battery.getChargePercent());
        return string;
    }

    static String getPowerSupplyStatus(PowerSupply powerSupply) {
        int n = powerSupply.getStatus();
        String string = n == 2 ? Resources.getString("som.power.warning") : SOMLocalizer.getStatusString(n);
        return string;
    }

    static String getDiskState(Disk disk) {
        String string;
        switch (disk.getState()) {
            case 1: {
                string = Resources.getString("disk.state.online");
                break;
            }
            case 0: {
                string = Resources.getString("disk.state.offline");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getDiskType(Disk disk) {
        String string;
        switch (disk.getType()) {
            case 0: {
                string = Resources.getString("disk.memberType.spare");
                break;
            }
            case 1: {
                string = Resources.getString("disk.memberType.raidMember");
                break;
            }
            case 3: {
                string = Resources.getString("disk.memberType.jbod");
                break;
            }
            case 4: {
                string = Resources.getString("disk.memberType.orphan");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getDiskOperation(Disk disk) {
        String string;
        switch (disk.getOperation()) {
            case 0: {
                string = Resources.getString("disk.operation.none");
                break;
            }
            case 1: {
                string = Resources.getString("disk.operation.rebuilding");
                break;
            }
            case 2: {
                string = Resources.getString("disk.operation.formatting");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getDiskHandleState(Disk disk) {
        String string;
        switch (disk.getHandleState()) {
            case 0: {
                string = Resources.getString("disk.handleState.open");
                break;
            }
            case 1: {
                string = Resources.getString("disk.handleState.closed");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getDiskCapacity(Disk disk) {
        long l = disk.getCapacityBytes();
        String string = Resources.getString("som.bytes");
        string = StringUtilities.replaceAll(string, "{number}", Long.toString(l));
        return string;
    }

    static String getDiskCapacityShort(Disk disk) {
        String string;
        long l = disk.getCapacityBytes();
        if (CapacityConverter.toTerabytes(l) > 1.0) {
            string = Resources.getString("som.terabytes");
            string = StringUtilities.replaceAll(string, "{number}", CapacityConverter.toTerabyteString(l));
        } else if (CapacityConverter.toGigabytes(l) > 1.0) {
            string = Resources.getString("som.gigabytes");
            string = StringUtilities.replaceAll(string, "{number}", CapacityConverter.toGigabyteString(l));
        } else {
            string = Resources.getString("som.megabytes");
            string = StringUtilities.replaceAll(string, "{number}", CapacityConverter.toMegabyteString(l));
        }
        return string;
    }

    static String getDiskPowerOnHoursShort(Disk disk) {
        int n = disk.getPowerOnHours();
        String string = n == -1 ? Resources.getString("componentStatus.unknown") : Integer.toString(n);
        return string;
    }

    static String getDiskCacheState(Disk disk) {
        int n = disk.getCacheState();
        String string = n == 1 ? Resources.getString("som.enabled") : (n == 0 ? Resources.getString("som.disabled") : Resources.getString("som.unknown"));
        return string;
    }

    static String getFanStatus(Fan fan) {
        int n = fan.getStatus();
        String string = n == 2 ? Resources.getString("som.blower.warning") : SOMLocalizer.getStatusString(n);
        return string;
    }

    static String getFanRPM(Fan fan) {
        String string;
        int n = fan.getRpm();
        if (n != -1) {
            string = Resources.getString("som.rpm");
            string = StringUtilities.replaceAll(string, "{number}", "" + n);
        } else {
            string = Resources.getString("som.unknown");
        }
        return string;
    }

    static String getFCTopology(FibreChannelInterface fibreChannelInterface) {
        String string;
        switch (fibreChannelInterface.getTopology()) {
            case 0: {
                string = Resources.getString("fc.topology.ArbitratedLoop");
                break;
            }
            case 1: {
                string = Resources.getString("fc.topology.PointToPoint");
                break;
            }
            case 2: {
                String string2 = null;
                switch (fibreChannelInterface.getActualTopology()) {
                    case 0: {
                        string2 = Resources.getString("fc.topology.ArbitratedLoop");
                        break;
                    }
                    case 1: {
                        string2 = Resources.getString("fc.topology.PointToPoint");
                    }
                }
                if (string2 == null) {
                    string = Resources.getString("fc.topology.AutoDetect");
                    break;
                }
                string = Resources.getString("som.automatic");
                string = StringUtilities.replaceAll(string, "{actual}", string2);
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getFCSpeed(FibreChannelInterface fibreChannelInterface) {
        String string;
        switch (fibreChannelInterface.getSpeed()) {
            case 1: {
                string = Resources.getString("fc.speed.1GBPS");
                break;
            }
            case 2: {
                string = Resources.getString("fc.speed.2GBPS");
                break;
            }
            case 0: {
                String string2 = null;
                switch (fibreChannelInterface.getActualSpeed()) {
                    case 1: {
                        string2 = Resources.getString("fc.speed.1GBPS");
                        break;
                    }
                    case 2: {
                        string2 = Resources.getString("fc.speed.2GBPS");
                    }
                }
                if (string2 == null) {
                    string = Resources.getString("fc.speed.AutoDetect");
                    break;
                }
                string = Resources.getString("som.automatic");
                string = StringUtilities.replaceAll(string, "{actual}", string2);
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getFCHardLoopEnabled(FibreChannelInterface fibreChannelInterface) {
        int n = fibreChannelInterface.getHardLoopIdEnabled();
        String string = n == 1 ? new Integer(fibreChannelInterface.getHardLoopId()).toString() : (n == 0 ? Resources.getString("fc.hardLoopDisabled") : Resources.getString("som.unknown"));
        return string;
    }

    static String getFCLinkState(FibreChannelInterface fibreChannelInterface) {
        String string;
        switch (fibreChannelInterface.getLinkState()) {
            case 1: {
                string = Resources.getString("fc.linkStatus.up");
                break;
            }
            case 0: {
                if (fibreChannelInterface.getStatus() == 2) {
                    Collection collection;
                    int n = 0;
                    RaidController raidController = fibreChannelInterface.getController();
                    if (raidController != null && (collection = raidController.getRaidSets()) != null) {
                        n = collection.size();
                    }
                    if (n == 1) {
                        string = Resources.getString("fc.linkStatus.down.array");
                        break;
                    }
                    string = Resources.getString("fc.linkStatus.down.arrays");
                    string = StringUtilities.replaceAll(string, "{number}", "" + n);
                    break;
                }
                string = Resources.getString("fc.linkStatus.down");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getLunMaskingState(int n) {
        String string = n == 1 ? Resources.getString("som.enabled") : (n == 0 ? Resources.getString("som.disabled") : Resources.getString("som.unknown"));
        return string;
    }

    static String getNetworkLinkState(NetworkInterface networkInterface) {
        String string;
        switch (networkInterface.getLinkState()) {
            case 1: {
                string = Resources.getString("network.linkStatus.up");
                break;
            }
            case 0: {
                string = Resources.getString("network.linkStatus.down");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getNetworkSpeed(NetworkInterface networkInterface) {
        String string;
        switch (networkInterface.getSpeed()) {
            case 0: {
                string = Resources.getString("network.speed.10mbps");
                break;
            }
            case 1: {
                string = Resources.getString("network.speed.100mbps");
                break;
            }
            case 2: {
                string = Resources.getString("network.speed.1000mbps");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getConfigurationMethod(NetworkInterface networkInterface) {
        String string;
        switch (networkInterface.getConfigurationMethod()) {
            case 512: {
                string = Resources.getString("network.configMethod.DHCP");
                break;
            }
            case 1024: {
                string = Resources.getString("network.configMethod.static");
                break;
            }
            case 8192: {
                string = Resources.getString("network.configMethod.BOOTP");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getRaidControllerCacheState(RaidController raidController) {
        int n = raidController.getWriteCacheState();
        String string = n == 1 ? Resources.getString("som.enabled") : (n == 0 ? Resources.getString("som.disabled") : Resources.getString("som.unknown"));
        return string;
    }

    static String getRaidControllerPrefetchSetting(RaidController raidController) {
        int n = raidController.getPrefetchSize();
        String string = n == -1 ? Resources.getString("som.unknown") : ((n = 1 << n) < 8 ? Resources.getString("management.performance.prefetch.1") : (n == 8 ? Resources.getString("management.performance.prefetch.8") : Resources.getString("management.performance.prefetch.128")));
        return string;
    }

    static String getRaidControllerAccessMode(RaidController raidController) {
        String string;
        switch (raidController.getAccessMode()) {
            case 0: {
                string = Resources.getString("raidcontroller.accessMode.sequential");
                break;
            }
            case 1: {
                string = Resources.getString("raidcontroller.accessMode.random");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getRaidControllerMemorySize(RaidController raidController) {
        String string;
        int n = raidController.getMemorySize();
        if (n != -1) {
            string = Resources.getString("som.megabytes");
            string = StringUtilities.replaceAll(string, "{number}", "" + n);
        } else {
            string = Resources.getString("som.unknown");
        }
        return string;
    }

    static String getRaidSetState(RaidSet raidSet) {
        String string;
        switch (raidSet.getState()) {
            case 0: {
                string = Resources.getString("raidset.state.online");
                break;
            }
            case 1: {
                string = Resources.getString("raidset.state.offline");
                break;
            }
            case 2: {
                string = Resources.getString("raidset.state.degraded");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getRaidSetAvailability(RaidSet raidSet) {
        String string = null;
        if (raidSet.getOperation() == 1) {
            switch (raidSet.getInitializationMode()) {
                case 1: {
                    string = Resources.getString("som.yes");
                    break;
                }
                case 0: {
                    string = Resources.getString("som.no");
                    break;
                }
            }
        }
        if (string == null) {
            string = Resources.getString("som.unknown");
        }
        return string;
    }

    static String getRaidSetLevel(RaidSet raidSet) {
        String string;
        switch (raidSet.getRaidLevel()) {
            case 0: {
                string = Resources.getString("som.raidset.raid0");
                break;
            }
            case 1: {
                string = Resources.getString("som.raidset.raid1");
                break;
            }
            case 3: {
                string = Resources.getString("som.raidset.raid3");
                break;
            }
            case 5: {
                string = Resources.getString("som.raidset.raid5");
                break;
            }
            case 6: {
                string = Resources.getString("som.raidset.raid01");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getRaidSetCapacity(RaidSet raidSet) {
        String string;
        long l = raidSet.getCapacityBytes();
        if (CapacityConverter.toTerabytes(l) > 1.0) {
            string = Resources.getString("som.terabytes");
            string = StringUtilities.replaceAll(string, "{number}", CapacityConverter.toTerabyteString(l));
        } else {
            string = Resources.getString("som.gigabytes");
            string = StringUtilities.replaceAll(string, "{number}", CapacityConverter.toGigabyteString(l));
        }
        return string;
    }

    static String getRaidSetSlices(RaidSet raidSet) {
        String string = "" + raidSet.getLiveSliceCount();
        return string;
    }

    static String getRaidSetLuns(RaidSet raidSet) {
        String string = "";
        String string2 = Resources.getString("som.raidset.driveSeparator");
        Collection collection = raidSet.getMappedSlices();
        if (collection.size() > 0) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Slice slice = (Slice)iterator.next();
                string = string + "" + slice.getLunId();
                if (!iterator.hasNext()) continue;
                string = string + string2;
            }
        } else {
            string = Resources.getString("som.unknown");
        }
        return string;
    }

    static String getJbodLuns(RaidController raidController) {
        String string = "";
        String string2 = Resources.getString("som.raidset.driveSeparator");
        if (raidController != null) {
            int n = raidController.getDisks().size();
            for (int i = 0; i < n; ++i) {
                string = string + i + (i < n - 1 ? string2 : "");
            }
        }
        return string;
    }

    static String getRaidSetDateCreated(RaidSet raidSet) {
        DateFormat dateFormat = DateFormat.getInstance();
        String string = dateFormat.format(raidSet.getTimeStamp());
        return string;
    }

    static String getRaidSetLevelAndCapacity(RaidSet raidSet) {
        String string = Resources.getString("som.raidset.levelCapacity");
        string = StringUtilities.replaceAll(string, "{level}", SOMLocalizer.getRaidSetLevel(raidSet));
        string = StringUtilities.replaceAll(string, "{capacity}", SOMLocalizer.getRaidSetCapacity(raidSet));
        return string;
    }

    static String getRaidSetLevelAndDrives(RaidSet raidSet) {
        String string = Resources.getString("som.raidset.levelDrives");
        string = StringUtilities.replaceAll(string, "{level}", SOMLocalizer.getRaidSetLevel(raidSet));
        string = StringUtilities.replaceAll(string, "{drives}", SOMLocalizer.getRaidSetDrives(raidSet));
        return string;
    }

    static String getRaidSetDrives(RaidSet raidSet) {
        String string = "";
        String string2 = Resources.getString("som.raidset.driveSeparator");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Iterator iterator = raidSet.getMembers().iterator();
        while (iterator.hasNext()) {
            int n4 = ((Disk)iterator.next()).getId();
            if (n == 0 || n4 < n) {
                n = n4;
            }
            if (n4 > n2) {
                n2 = n4;
            }
            ++n3;
            string = string + n4;
            if (!iterator.hasNext()) continue;
            string = string + string2;
        }
        if (n3 > 1 && n3 == n2 - n + 1) {
            string = Resources.getString("som.raidset.driveRange");
            string = StringUtilities.replaceAll(string, "{start}", "" + n);
            string = StringUtilities.replaceAll(string, "{end}", "" + n2);
        }
        return string;
    }

    static String getRaidSetOperationStatus(RaidSet raidSet) {
        String string;
        int n = raidSet.getOperation();
        if (n == -1) {
            string = SOMLocalizer.getRaidSetState(raidSet);
        } else {
            if (n == 5 && raidSet.getBackgroundConditioningState() == 1) {
                string = Resources.getString("som.raidset.status.stateful");
                string = StringUtilities.replaceAll(string, "{state}", Resources.getString("raidset.conditioningState.paused"));
            } else {
                string = Resources.getString("som.raidset.status");
            }
            string = StringUtilities.replaceAll(string, "{operation}", SOMLocalizer.getRaidSetOperation(raidSet));
            string = StringUtilities.replaceAll(string, "{number}", "" + raidSet.getProgress());
        }
        return string;
    }

    static String getRaidSetOperation(RaidSet raidSet) {
        String string;
        switch (raidSet.getOperation()) {
            case 1: {
                string = Resources.getString("raidset.operation.creating");
                break;
            }
            case 2: {
                string = Resources.getString("raidset.operation.rebuilding");
                break;
            }
            case 3: {
                string = Resources.getString("raidset.operation.verifying");
                break;
            }
            case 4: {
                string = Resources.getString("raidset.operation.expanding");
                break;
            }
            case 5: {
                string = Resources.getString("raidset.operation.conditioning");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getRaidSetInitializationMode(RaidSet raidSet) {
        String string;
        switch (raidSet.getInitializationMode()) {
            case 0: {
                string = Resources.getString("raidset.initMode.regular");
                break;
            }
            case 1: {
                string = Resources.getString("raidset.initMode.onTheFly");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getSliceName(Slice slice) {
        String string;
        if (slice.isMapped()) {
            string = Resources.getString("som.slice.name");
            string = StringUtilities.replaceAll(string, "{index}", "" + slice.getLunId());
        } else {
            string = Resources.getString("som.unknown");
        }
        return string;
    }

    static String getSliceDescription(Slice slice) {
        String string = Resources.getString("som.slice.description");
        string = StringUtilities.replaceAll(string, "{slice}", "" + slice.getId());
        string = StringUtilities.replaceAll(string, "{array}", SOMLocalizer.getRaidSetLevelAndDrives(slice.getRaidSet()));
        return string;
    }

    static String getCombinedFirmwareVersion(SystemController systemController, RaidController raidController) {
        String string;
        String string2;
        boolean bl = true;
        boolean bl2 = true;
        String string3 = systemController.getSystemVersion();
        if (string3 == null || string3 == "") {
            bl = false;
            string3 = Resources.getString("som.unknown");
        }
        if ((string2 = raidController.getFirmwareVersion()) == null || string2 == "") {
            bl2 = false;
            string2 = Resources.getString("som.unknown");
        }
        if (!bl && !bl2) {
            string = string3;
        } else {
            string = Resources.getString("som.firmware");
            string = StringUtilities.replaceAll(string, "{system}", string3);
            string = StringUtilities.replaceAll(string, "{raid}", string2);
        }
        return string;
    }

    static String getPowerState(RaidSystem raidSystem) {
        String string;
        int n = raidSystem.getUpsStatus();
        if (n == 0) {
            string = Resources.getString("raidsystem.powerState.upsBackup");
        } else if (n == 1) {
            string = Resources.getString("raidsystem.powerState.upsBatteryLow");
        } else {
            switch (raidSystem.getPowerState()) {
                case 0: {
                    string = Resources.getString("raidsystem.powerState.off");
                    break;
                }
                case 1: {
                    string = Resources.getString("raidsystem.powerState.on");
                    break;
                }
                default: {
                    string = Resources.getString("som.unknown");
                }
            }
        }
        return string;
    }

    static String getRaidSystemServiceIdState(RaidSystem raidSystem) {
        String string;
        switch (raidSystem.getServiceIdState()) {
            case 1: {
                string = Resources.getString("raidsystem.serviceID.on");
                break;
            }
            case 0: {
                string = Resources.getString("raidsystem.serviceID.off");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getRaidSystemLockState(RaidSystem raidSystem) {
        String string;
        switch (raidSystem.getLockState()) {
            case 1: {
                string = Resources.getString("raidsystem.lockState.locked");
                break;
            }
            case 0: {
                string = Resources.getString("raidsystem.lockState.unlocked");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getRaidSystemUptime(SystemController systemController) {
        String string;
        int n = systemController.getUpTime();
        if (n <= 0) {
            string = Resources.getString("som.unknown");
        } else {
            int n2 = n / 86400;
            int n3 = n / 3600;
            int n4 = n / 60;
            if (n2 > 0) {
                n4 -= n2 * 24 * 60;
                string = Resources.getString("som.uptime.dhm");
                string = StringUtilities.replaceAll(string, "{days}", "" + n2);
                string = StringUtilities.replaceAll(string, "{hours}", "" + n3);
                string = StringUtilities.replaceAll(string, "{minutes}", "" + (n4 -= (n3 -= n2 * 24) * 60));
            } else if (n3 > 0) {
                string = Resources.getString("som.uptime.hm");
                string = StringUtilities.replaceAll(string, "{hours}", "" + n3);
                string = StringUtilities.replaceAll(string, "{minutes}", "" + (n4 -= n3 * 60));
            } else {
                string = Resources.getString("som.uptime.m");
                string = StringUtilities.replaceAll(string, "{minutes}", "" + n4);
            }
        }
        return string;
    }

    static String getRaidSystemAmbientTemperature(SystemController systemController) {
        String string;
        int n = systemController.getAmbientTemperature();
        if (n != -1) {
            if (Gestalt.units == 0) {
                string = Resources.getString("som.celsius");
                string = StringUtilities.replaceAll(string, "{celsius}", "" + n);
            } else if (Gestalt.units == 1) {
                string = Resources.getString("som.fahrenheit");
                string = StringUtilities.replaceAll(string, "{fahrenheit}", "" + (int)((double)n / 5.0 * 9.0 + 32.0));
            } else {
                string = Resources.getString("som.celsiusAndFahrenheit");
                string = StringUtilities.replaceAll(string, "{celsius}", "" + n);
                string = StringUtilities.replaceAll(string, "{fahrenheit}", "" + (int)((double)n / 5.0 * 9.0 + 32.0));
            }
        } else {
            string = Resources.getString("som.unknown");
        }
        return string;
    }

    static String getRaidSystemUPSStatus(RaidSystem raidSystem) {
        String string;
        switch (raidSystem.getUpsStatus()) {
            case 0: {
                string = Resources.getString("raidsystem.ups.powerFailure");
                break;
            }
            case 1: {
                string = Resources.getString("raidsystem.ups.lowBattery");
                break;
            }
            case 2: {
                string = Resources.getString("raidsystem.ups.shutdown");
                break;
            }
            default: {
                string = Resources.getString("som.unknown");
            }
        }
        return string;
    }

    static String getLocalizedUserMessage(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "";
                break;
            }
            case 1: {
                string = Resources.getString("userMessage.authenticating");
                break;
            }
            case 2: {
                string = Resources.getString("userMessage.connecting");
                break;
            }
            case 3: {
                string = Resources.getString("userMessage.gathering");
                break;
            }
            case 4: {
                string = Resources.getString("userMessage.connectionFailure");
                break;
            }
            case 5: {
                string = Resources.getString("userMessage.communicationsError");
                break;
            }
            case 6: {
                string = Resources.getString("userMessage.standbyPowerMode");
                break;
            }
            case 7: {
                string = Resources.getString("userMessage.restarting");
                break;
            }
            case 8: {
                string = Resources.getString("userMessage.shuttingDown");
                break;
            }
            case 9: {
                string = Resources.getString("userMessage.poweringOn");
                break;
            }
            case 10: {
                string = Resources.getString("userMessage.controllerNotReady");
                break;
            }
            case 11: {
                string = Resources.getString("userMessage.authenticationFailure");
                break;
            }
            case 12: {
                string = Resources.getString("userMessage.requestingUpdate");
                break;
            }
            case 13: {
                string = Resources.getString("userMessage.clearingEventLog");
                break;
            }
        }
        return string;
    }

    static String getGenericString(String string) {
        if (string == null || string.length() == 0 || string.trim().equals("")) {
            string = Resources.getString("som.unknown");
        }
        return string;
    }

    static Map toPrefsContainer(RaidSystem raidSystem) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (raidSystem == null) {
            throw new NullPointerException("RaidSystem argument may not be null");
        }
        String string = raidSystem.getPrimaryHostAddress();
        if (string != null) {
            arrayList.add(string);
        }
        if ((string = raidSystem.getSecondaryHostAddress()) != null) {
            arrayList.add(string);
        }
        if (arrayList.size() < 1) {
            throw new IllegalArgumentException("RaidSystem argument must have at least one valid IP address");
        }
        string = raidSystem.getMonitoringPassword();
        if (string != null) {
            hashMap.put("Attributes", string);
        }
        hashMap.put("Rate", new Integer(raidSystem.getPollDelay()));
        hashMap.put("Name", raidSystem.getName());
        hashMap.put("IPAddress", arrayList);
        return hashMap;
    }
}

