/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.gui.RestrictedTextField;
import com.apple.util.Gestalt;
import com.apple.util.prefs.Preferences;
import com.apple.xsr.RaidAdmin;
import com.apple.xsr.Resources;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;

public class PreferencesWindow
extends JFrame {
    private static PreferencesWindow mPreferencesWindow = null;
    private static JCheckBox useShapesCheckBox = null;
    private static ButtonGroup clockFormatButtonGroup = null;
    private static JCheckBox limitEventLogCheckBox = null;
    private static RestrictedTextField limitEventLogTextField = null;
    private static final String CLOCK_FORMAT_12_HOUR = "12";
    private static final String CLOCK_FORMAT_24_HOUR = "24";

    private PreferencesWindow() {
        Object object;
        Object object2;
        this.setTitle(Resources.getString("prefs.title"));
        this.setResizable(false);
        if (Gestalt.isMacOS()) {
            this.setJMenuBar(RaidAdmin.newMenuBar(1));
        }
        Preferences preferences = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
        JPanel jPanel = GUIFactory.newPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(16, 16, 16, 16));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        useShapesCheckBox = GUIFactory.newCheckBox(Resources.getString("prefs.useShapes"));
        if (preferences != null) {
            useShapesCheckBox.setSelected(preferences.getBoolean("UseShapes", false));
        }
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)useShapesCheckBox, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences preferences = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
                if (preferences != null) {
                    preferences.setBoolean("UseShapes", useShapesCheckBox.isSelected());
                    preferences.synchronize();
                }
            }
        };
        useShapesCheckBox.addActionListener(actionListener);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        clockFormatButtonGroup = new ButtonGroup();
        JRadioButton jRadioButton = GUIFactory.newRadioButton(Resources.getString("prefs.clockFormat.twelveHour"));
        jRadioButton.setActionCommand(CLOCK_FORMAT_12_HOUR);
        jPanel.add((Component)jRadioButton, gridBagConstraints);
        clockFormatButtonGroup.add(jRadioButton);
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        ++gridBagConstraints.gridy;
        JRadioButton jRadioButton2 = GUIFactory.newRadioButton(Resources.getString("prefs.clockFormat.twentyFourHour"));
        jRadioButton2.setActionCommand(CLOCK_FORMAT_24_HOUR);
        jPanel.add((Component)jRadioButton2, gridBagConstraints);
        clockFormatButtonGroup.add(jRadioButton2);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences preferences = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
                if (preferences != null) {
                    preferences.setString("TimeFormat", clockFormatButtonGroup.getSelection().getActionCommand());
                    preferences.synchronize();
                }
            }
        };
        jRadioButton.addActionListener(actionListener2);
        jRadioButton2.addActionListener(actionListener2);
        if (preferences != null) {
            object2 = Gestalt.timeFormat == 12 ? CLOCK_FORMAT_12_HOUR : CLOCK_FORMAT_24_HOUR;
            object = preferences.getString("TimeFormat", (String)object2);
            if (((String)object).equals(CLOCK_FORMAT_12_HOUR)) {
                jRadioButton.setSelected(true);
            } else {
                jRadioButton2.setSelected(true);
            }
        }
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 1;
        ++gridBagConstraints.gridy;
        limitEventLogCheckBox = GUIFactory.newCheckBox(Resources.getString("prefs.limitEventLogTo"));
        if (preferences != null) {
            limitEventLogCheckBox.setSelected(preferences.getBoolean("LimitEventLog", false));
        }
        ++gridBagConstraints.gridx;
        limitEventLogTextField = GUIFactory.newRestrictedTextField(4);
        limitEventLogTextField.setRestrictedCharacterSet(Resources.getString("aquaTextField.validNumericCharacters"));
        if (preferences != null) {
            limitEventLogTextField.setText("" + preferences.getInteger("LimitEventLogAmount", 100));
        }
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        object2 = GUIFactory.newOKButton();
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences preferences = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
                if (preferences != null) {
                    preferences.setBoolean("UseShapes", useShapesCheckBox.isSelected());
                    preferences.setString("TimeFormat", clockFormatButtonGroup.getSelection().getActionCommand());
                    preferences.setBoolean("LimitEventLog", limitEventLogCheckBox.isSelected());
                    preferences.setInteger("LimitEventLogAmount", Integer.parseInt(limitEventLogTextField.getText()));
                    preferences.synchronize();
                }
                mPreferencesWindow.dispose();
                mPreferencesWindow = null;
            }
        });
        object = GUIFactory.newCancelButton();
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                mPreferencesWindow.dispose();
                mPreferencesWindow = null;
            }
        });
        Box box = Box.createHorizontalBox();
        box.setBackground(Color.orange);
        box.add((Component)object);
        box.add(Box.createHorizontalStrut(8));
        box.add((Component)object2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.getContentPane().add(jPanel);
        this.pack();
    }

    public static PreferencesWindow getSharedInstance() {
        if (mPreferencesWindow == null) {
            mPreferencesWindow = new PreferencesWindow();
            mPreferencesWindow.setDefaultCloseOperation(0);
            mPreferencesWindow.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    mPreferencesWindow.dispose();
                    mPreferencesWindow = null;
                }
            });
        }
        return mPreferencesWindow;
    }

    public void pack() {
        String string = System.getProperty("java.vm.version");
        if (string != null && string.startsWith("Blackdown-1.3.1")) {
            this.setSize(this.getPreferredSize());
        } else {
            super.pack();
        }
    }
}

