/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.gui.text.RestrictedDocument;
import com.apple.util.Gestalt;
import com.apple.util.prefs.Preferences;
import com.apple.xsr.AquaAlert;
import com.apple.xsr.AquaAlertListener;
import com.apple.xsr.GridBagPanel;
import com.apple.xsr.ManagementPane;
import com.apple.xsr.ManagementSystemModel;
import com.apple.xsr.Resources;
import com.apple.xsr.SetupPane;
import com.apple.xsr.SizeLinkedPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class ManagementSystemPane
extends GridBagPanel {
    public static final int PASSWORD_MAX_BYTES = 31;
    public static final int GRID_BAG_INSET_VALUE = 8;
    public static final int TEXT_FIELD_WIDTH = 285;
    public static final String TITLED_BORDER_SPACING = " ";
    public static final String COMBO_BOX_SPACING = "  ";
    public static final int DONT_SYNC_INDEX = 0;
    public static final int LOCAL_SYNC_INDEX = 1;
    public static final int NTP_SYNC_INDEX = 2;
    private static final int MILLISECONDS_IN_A_SECOND = 1000;
    private SystemInformationPanel mSystemInformationPanel = null;
    private PasswordsPanel mPasswordsPanel = null;
    private OptionsPanel mOptionsPanel = null;
    private SetupPane parent = null;
    private boolean populated = false;

    public ManagementSystemPane(SetupPane setupPane) {
        this.parent = setupPane;
        this.mSystemInformationPanel = new SystemInformationPanel();
        this.mPasswordsPanel = new PasswordsPanel();
        this.mOptionsPanel = new OptionsPanel();
        this.mPasswordsPanel.linkPanel(this.mOptionsPanel, 2);
        this.setBorder(ManagementPane.DEFAULT_BORDER);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        this.add(this.mSystemInformationPanel, gridBagConstraints, 0, 0, 2, 1);
        gridBagConstraints.insets = new Insets(8, 0, 0, 8);
        this.add(this.mPasswordsPanel, gridBagConstraints, 0, 1, 1, 1);
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add(this.mOptionsPanel, gridBagConstraints, 1, 1, 1, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(Box.createHorizontalStrut(1), gridBagConstraints, 2, 2, 0, 0);
    }

    public void populate(ManagementSystemModel managementSystemModel) {
        if (managementSystemModel == null) {
            throw new NullPointerException("data cannot be null");
        }
        this.mSystemInformationPanel.populate(managementSystemModel);
        this.mOptionsPanel.populate(managementSystemModel);
        this.populated = true;
    }

    public boolean validate(ManagementSystemModel managementSystemModel) throws NullPointerException, IllegalArgumentException {
        boolean bl = true;
        boolean bl2 = true;
        bl2 = this.mSystemInformationPanel.checkValidity();
        if (!bl2) {
            bl = false;
        }
        if (!(bl2 = this.mOptionsPanel.checkValidity())) {
            bl = false;
        }
        if (!(bl2 = this.mPasswordsPanel.checkValidity())) {
            bl = false;
        }
        if (bl) {
            this.mSystemInformationPanel.fillInModel(managementSystemModel);
            this.mPasswordsPanel.fillInModel(managementSystemModel);
            this.mOptionsPanel.fillInModel(managementSystemModel);
        }
        int n = this.parent.tabbedPane.indexOfComponent(this);
        if (!bl && this.parent.tabbedPane.getSelectedIndex() != n) {
            this.parent.tabbedPane.setIconAt(n, new ImageIcon(Resources.getImage("icon.validate")));
        } else {
            this.parent.tabbedPane.setIconAt(n, null);
        }
        return bl;
    }

    public JLabel jlabelWithFont(String string, Font font) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(font);
        return jLabel;
    }

    static /* synthetic */ boolean access$100(ManagementSystemPane managementSystemPane) {
        return managementSystemPane.populated;
    }

    public class PasswordChangeSheet
    extends GridBagPanel {
        public static final int PASSWORD_FIELD_WIDTH = 18;
        JPasswordField mFirstPasswordField = null;
        JPasswordField mSecondPasswordField = null;
        private JButton mOKButton = null;
        private JButton mCancelButton = null;

        public PasswordChangeSheet(String string) {
            Box box = Box.createHorizontalBox();
            JLabel jLabel = new JLabel(Resources.getString("management.systemInfo.passwordsBox.newPassword"));
            JLabel jLabel2 = new JLabel(Resources.getString("management.systemInfo.passwordsBox.confirmPassword"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            RestrictedDocument restrictedDocument = new RestrictedDocument();
            restrictedDocument.setMaxLengthBytes(31);
            this.mFirstPasswordField = new JPasswordField(restrictedDocument, null, 18);
            this.mSecondPasswordField = new JPasswordField(18);
            if (Gestalt.isMacLookAndFeel) {
                this.mFirstPasswordField.setEchoChar('\u2022');
                this.mSecondPasswordField.setEchoChar('\u2022');
            }
            this.mOKButton = GUIFactory.newOKButton();
            this.mCancelButton = GUIFactory.newCancelButton();
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 0, 8, 0);
            JTextArea jTextArea = new JTextArea(string);
            jTextArea.setFont(GUIFactory.FONT_SMALL);
            jTextArea.setBackground(null);
            jTextArea.setHighlighter(null);
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setSize(300, 64);
            jTextArea.setMinimumSize(new Dimension(300, 48));
            jTextArea.setMaximumSize(new Dimension(300, 200));
            this.add(jTextArea, gridBagConstraints, 0, 0, 2, 1);
            jLabel.setFont(GUIFactory.FONT_SMALL);
            jLabel2.setFont(GUIFactory.FONT_SMALL);
            this.mFirstPasswordField.setFont(GUIFactory.FONT_SMALL);
            this.mSecondPasswordField.setFont(GUIFactory.FONT_SMALL);
            gridBagConstraints.insets = new Insets(0, 0, 8, 0);
            gridBagConstraints.anchor = 17;
            this.add(this.mFirstPasswordField, gridBagConstraints, 1, 1, 1, 1);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add(this.mSecondPasswordField, gridBagConstraints, 1, 2, 1, 1);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 0, 8, 8);
            this.add(jLabel, gridBagConstraints, 0, 1, 1, 1);
            gridBagConstraints.insets = new Insets(0, 0, 0, 8);
            this.add(jLabel2, gridBagConstraints, 0, 2, 1, 1);
            box.add(this.mCancelButton);
            box.add(Box.createHorizontalStrut(8));
            box.add(this.mOKButton);
            gridBagConstraints.insets = new Insets(8, 0, 0, 0);
            this.add(box, gridBagConstraints, 0, 3, 2, 1);
        }

        public boolean isFocusCycleRoot() {
            return true;
        }

        public void resetPasswordFields() {
            this.mFirstPasswordField.setText("");
            this.mSecondPasswordField.setText("");
        }

        public String getFirstPasswordString() {
            return new String(this.mFirstPasswordField.getPassword());
        }

        public String getSecondPasswordString() {
            return new String(this.mSecondPasswordField.getPassword());
        }

        public JComponent getFirstFocus() {
            return this.mFirstPasswordField;
        }

        public JButton getOKButton() {
            return this.mOKButton;
        }

        public JButton getCancelButton() {
            return this.mCancelButton;
        }
    }

    public class OptionsPanel
    extends SizeLinkedPanel {
        private JCheckBox mEnableAudibleAlertsCheckBox;
        private JCheckBox mRestartAutomaticallyCheckBox;
        private JCheckBox mEnableSnmpCheckBox;

        public OptionsPanel() {
            ActionListener actionListener = new ActionListener(this, ManagementSystemPane.this){
                private final /* synthetic */ ManagementSystemPane val$this$0;
                private final /* synthetic */ OptionsPanel this$1;
                {
                    this.this$1 = optionsPanel;
                    this.val$this$0 = managementSystemPane;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsPanel.access$1000(this.this$1).validate(null);
                    ManagementSystemPane.access$200(OptionsPanel.access$1000(this.this$1)).setModified();
                }
            };
            this.setLayout(new GridBagLayout());
            TitledBorder titledBorder = BorderFactory.createTitledBorder(ManagementSystemPane.TITLED_BORDER_SPACING + Resources.getString("management.systemInfo.optionsBox.title") + ManagementSystemPane.TITLED_BORDER_SPACING);
            titledBorder.setTitleFont(GUIFactory.FONT_SMALL);
            this.setBorder(new CompoundBorder(titledBorder, new EmptyBorder(8, 16, 8, 16)));
            this.mEnableAudibleAlertsCheckBox = GUIFactory.newCheckBox(Resources.getString("management.systemInfo.optionsBox.audibleAlerts"));
            this.mEnableAudibleAlertsCheckBox.addActionListener(actionListener);
            this.mEnableAudibleAlertsCheckBox.setFont(GUIFactory.FONT_SMALL);
            this.mRestartAutomaticallyCheckBox = GUIFactory.newCheckBox(Resources.getString("management.systemInfo.optionsBox.autoRestart"));
            this.mRestartAutomaticallyCheckBox.addActionListener(actionListener);
            this.mRestartAutomaticallyCheckBox.setFont(GUIFactory.FONT_SMALL);
            this.mEnableSnmpCheckBox = GUIFactory.newCheckBox(Resources.getString("management.systemInfo.optionsBox.snmp"));
            this.mEnableSnmpCheckBox.addActionListener(actionListener);
            this.mEnableSnmpCheckBox.setFont(GUIFactory.FONT_SMALL);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            this.add((Component)this.mEnableAudibleAlertsCheckBox, gridBagConstraints);
            gridBagConstraints.insets = new Insets(8, 0, 0, 0);
            ++gridBagConstraints.gridy;
            this.add((Component)this.mRestartAutomaticallyCheckBox, gridBagConstraints);
            ++gridBagConstraints.gridy;
            this.add((Component)this.mEnableSnmpCheckBox, gridBagConstraints);
        }

        public void populate(ManagementSystemModel managementSystemModel) {
            this.mEnableAudibleAlertsCheckBox.setSelected(managementSystemModel.getEnableAudibleAlerts());
            this.mRestartAutomaticallyCheckBox.setSelected(managementSystemModel.getRestartAutomatically());
            this.mEnableSnmpCheckBox.setSelected(managementSystemModel.getEnableSnmp());
        }

        public boolean checkValidity() {
            return true;
        }

        public void fillInModel(ManagementSystemModel managementSystemModel) {
            if (managementSystemModel != null) {
                managementSystemModel.setEnableAudibleAlerts(this.mEnableAudibleAlertsCheckBox.isSelected());
                managementSystemModel.setRestartAutomatically(this.mRestartAutomaticallyCheckBox.isSelected());
                managementSystemModel.setEnableSnmp(this.mEnableSnmpCheckBox.isSelected());
            }
        }

        static /* synthetic */ ManagementSystemPane access$1000(OptionsPanel optionsPanel) {
            return optionsPanel.ManagementSystemPane.this;
        }
    }

    public class PasswordsPanel
    extends SizeLinkedPanel
    implements AquaAlertListener {
        private static final String GUEST_PASSWORD = "GUEST_PASSWORD";
        private static final String ADMIN_PASSWORD = "ADMIN_PASSWORD";
        private String mGuestPassword = null;
        private String mAdminPassword = null;
        private JButton mAdministratorButton = null;
        private JButton mGuestButton = null;
        private PasswordChangeSheet mPasswordSheet = null;

        public PasswordsPanel() {
            this.setLayout(new GridBagLayout());
            TitledBorder titledBorder = BorderFactory.createTitledBorder(ManagementSystemPane.TITLED_BORDER_SPACING + Resources.getString("management.systemInfo.passwordsBox.title") + ManagementSystemPane.TITLED_BORDER_SPACING);
            titledBorder.setTitleFont(GUIFactory.FONT_SMALL);
            this.setBorder(new CompoundBorder(titledBorder, new EmptyBorder(0, 16, 0, 16)));
            this.mAdministratorButton = GUIFactory.newButton(Resources.getString("management.systemInfo.passwordsBox.change"));
            this.mAdministratorButton.setFont(GUIFactory.FONT_SMALL);
            this.mGuestButton = GUIFactory.newButton(Resources.getString("management.systemInfo.passwordsBox.change"));
            this.mGuestButton.setFont(GUIFactory.FONT_SMALL);
            JLabel jLabel = ManagementSystemPane.this.jlabelWithFont(Resources.getString("management.systemInfo.passwordsBox.administrator"), GUIFactory.FONT_SMALL);
            JLabel jLabel2 = ManagementSystemPane.this.jlabelWithFont(Resources.getString("management.systemInfo.passwordsBox.guest"), GUIFactory.FONT_SMALL);
            this.mGuestButton.addActionListener(new ActionListener(this, ManagementSystemPane.this){
                private final /* synthetic */ ManagementSystemPane val$this$0;
                private final /* synthetic */ PasswordsPanel this$1;
                {
                    this.this$1 = passwordsPanel;
                    this.val$this$0 = managementSystemPane;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    PasswordsPanel.access$802(this.this$1, PasswordsPanel.access$900(this.this$1).new PasswordChangeSheet(Resources.getString("management.systemInfo.passwordsBox.guestMessage")));
                    AquaAlert aquaAlert = new AquaAlert(PasswordsPanel.access$800(this.this$1), PasswordsPanel.access$800(this.this$1).getOKButton(), PasswordsPanel.access$800(this.this$1).getCancelButton(), null);
                    aquaAlert.associateKeyCodeWithButton(46, 4, 2);
                    aquaAlert.associateKeyCodeWithButton(27, 0, 2);
                    aquaAlert.showSheet((JFrame)PasswordsPanel.access$900(this.this$1).getTopLevelAncestor(), this.this$1, "GUEST_PASSWORD");
                }
            });
            this.mAdministratorButton.addActionListener(new ActionListener(this, ManagementSystemPane.this){
                private final /* synthetic */ ManagementSystemPane val$this$0;
                private final /* synthetic */ PasswordsPanel this$1;
                {
                    this.this$1 = passwordsPanel;
                    this.val$this$0 = managementSystemPane;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    PasswordsPanel.access$802(this.this$1, PasswordsPanel.access$900(this.this$1).new PasswordChangeSheet(Resources.getString("management.systemInfo.passwordsBox.adminMessage")));
                    AquaAlert aquaAlert = new AquaAlert(PasswordsPanel.access$800(this.this$1), PasswordsPanel.access$800(this.this$1).getOKButton(), PasswordsPanel.access$800(this.this$1).getCancelButton(), null);
                    aquaAlert.associateKeyCodeWithButton(46, 4, 2);
                    aquaAlert.associateKeyCodeWithButton(27, 0, 2);
                    aquaAlert.showSheet((JFrame)PasswordsPanel.access$900(this.this$1).getTopLevelAncestor(), this.this$1, "ADMIN_PASSWORD");
                }
            });
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.insets = new Insets(8, 0, 0, 0);
            ++gridBagConstraints.gridy;
            this.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 8, 0, 0);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.mAdministratorButton, gridBagConstraints);
            gridBagConstraints.insets = new Insets(8, 8, 0, 0);
            ++gridBagConstraints.gridy;
            this.add((Component)this.mGuestButton, gridBagConstraints);
        }

        public void aquaAlertWillBeShown(Object object) {
        }

        public void aquaAlertResized(Object object) {
        }

        public void aquaAlertSheetVisible(Object object) {
            this.mPasswordSheet.getFirstFocus().requestFocus();
        }

        public void aquaAlertDismissed(int n, Object object) {
            if (n == 1) {
                ManagementSystemPane.this.parent.setModified();
                if ((String)object == GUEST_PASSWORD) {
                    this.mGuestPassword = this.mPasswordSheet.getFirstPasswordString();
                } else if ((String)object == ADMIN_PASSWORD) {
                    this.mAdminPassword = this.mPasswordSheet.getFirstPasswordString();
                }
            }
        }

        public boolean allowAquaAlertToBeDismissed(int n, Object object) {
            boolean bl = false;
            if (!this.mPasswordSheet.getFirstPasswordString().equals("") && this.mPasswordSheet.getFirstPasswordString().equals(this.mPasswordSheet.getSecondPasswordString()) || n != 1) {
                bl = true;
            } else if (this.mPasswordSheet.getFirstPasswordString().equals("") && this.mPasswordSheet.getSecondPasswordString().equals("")) {
                AquaAlert aquaAlert = AquaAlert.createStandardAquaAlert(Resources.getString("management.systemInfo.passwordsBox.passwordsCantBeBlankMessage"), Resources.getString("management.systemInfo.passwordsBox.passwordsCantBeBlankExplanation"), Resources.getImage("icon.application"), Resources.getString("ok"), null, null);
                aquaAlert.showDialog(null, Resources.getString("management.systemInfo.passwordsBox.passwordsCantBeBlankTitle"), null, null);
                this.mPasswordSheet.resetPasswordFields();
            } else {
                AquaAlert aquaAlert = AquaAlert.createStandardAquaAlert(Resources.getString("management.systemInfo.passwordsBox.passwordsDontMatchMessage"), Resources.getString("management.systemInfo.passwordsBox.passwordsDontMatchExplanation"), Resources.getImage("icon.application"), Resources.getString("ok"), null, null);
                aquaAlert.showDialog(null, Resources.getString("management.systemInfo.passwordsBox.passwordsDontMatchTitle"), null, null);
                this.mPasswordSheet.resetPasswordFields();
            }
            return bl;
        }

        public void populate(ManagementSystemModel managementSystemModel) {
        }

        public boolean checkValidity() {
            return true;
        }

        public void fillInModel(ManagementSystemModel managementSystemModel) {
            if (managementSystemModel != null) {
                if (this.mGuestPassword != null) {
                    managementSystemModel.setGuestPassword(this.mGuestPassword);
                }
                if (this.mAdminPassword != null) {
                    managementSystemModel.setAdminPassword(this.mAdminPassword);
                }
            }
        }

        static /* synthetic */ PasswordChangeSheet access$802(PasswordsPanel passwordsPanel, PasswordChangeSheet passwordChangeSheet) {
            passwordsPanel.mPasswordSheet = passwordChangeSheet;
            return passwordsPanel.mPasswordSheet;
        }

        static /* synthetic */ ManagementSystemPane access$900(PasswordsPanel passwordsPanel) {
            return passwordsPanel.ManagementSystemPane.this;
        }

        static /* synthetic */ PasswordChangeSheet access$800(PasswordsPanel passwordsPanel) {
            return passwordsPanel.mPasswordSheet;
        }
    }

    public class SystemInformationPanel
    extends GridBagPanel {
        public static final String TIME_FORMAT_12_HOUR = "12";
        public static final String TIME_FORMAT_24_HOUR = "24";
        private final String DATE_FORMAT_12_HOUR = Resources.getString("eventLog.twelveHourDateFormat");
        private final String DATE_FORMAT_24_HOUR = Resources.getString("eventLog.twentyFourHourDateFormat");
        private JTextField mSystemNameTextField;
        private JTextField mLocationTextField;
        private JTextField mContactTextField;
        private JTextField mNTPServerTextField;
        private JLabel mLocalTimeLabel;
        private JLabel mXserveRAIDTimeLabel;
        private JComboBox mTimeSynchronizeComboBox;
        private JLabel mSystemNameValidateLabel;
        private JLabel mLocationValidateLabel;
        private JLabel mContactValidateLabel;
        private JLabel mNTPServerValidateLabel;
        private JLabel mNTPServerExample;
        private Date mXserveRAIDTime = null;
        private SimpleDateFormat mDateFormat = new SimpleDateFormat(this.DATE_FORMAT_12_HOUR);

        public SystemInformationPanel() {
            TitledBorder titledBorder = BorderFactory.createTitledBorder(ManagementSystemPane.TITLED_BORDER_SPACING + Resources.getString("management.systemInfo.systemInfoBox.title") + ManagementSystemPane.TITLED_BORDER_SPACING);
            titledBorder.setTitleFont(GUIFactory.FONT_SMALL);
            this.setBorder(new CompoundBorder(titledBorder, new EmptyBorder(8, 12, 12, 12)));
            FocusAdapter focusAdapter = new FocusAdapter(this, ManagementSystemPane.this){
                private final /* synthetic */ ManagementSystemPane val$this$0;
                private final /* synthetic */ SystemInformationPanel this$1;
                {
                    this.this$1 = systemInformationPanel;
                    this.val$this$0 = managementSystemPane;
                }

                public void focusLost(FocusEvent focusEvent) {
                    if (ManagementSystemPane.access$100(SystemInformationPanel.access$000(this.this$1))) {
                        SystemInformationPanel.access$000(this.this$1).validate(null);
                    }
                }
            };
            CaretListener caretListener = new CaretListener(this, ManagementSystemPane.this){
                private final /* synthetic */ ManagementSystemPane val$this$0;
                private final /* synthetic */ SystemInformationPanel this$1;
                {
                    this.this$1 = systemInformationPanel;
                    this.val$this$0 = managementSystemPane;
                }

                public void caretUpdate(CaretEvent caretEvent) {
                    if (ManagementSystemPane.access$100(SystemInformationPanel.access$000(this.this$1))) {
                        ManagementSystemPane.access$200(SystemInformationPanel.access$000(this.this$1)).setModified();
                    }
                }
            };
            ActionListener actionListener = new ActionListener(this, ManagementSystemPane.this){
                private final /* synthetic */ ManagementSystemPane val$this$0;
                private final /* synthetic */ SystemInformationPanel this$1;
                {
                    this.this$1 = systemInformationPanel;
                    this.val$this$0 = managementSystemPane;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ManagementSystemPane.access$100(SystemInformationPanel.access$000(this.this$1))) {
                        SystemInformationPanel.access$000(this.this$1).validate(null);
                        ManagementSystemPane.access$200(SystemInformationPanel.access$000(this.this$1)).setModified();
                    }
                }
            };
            JLabel jLabel = ManagementSystemPane.this.jlabelWithFont(Resources.getString("management.systemInfo.systemInfoBox.systemName"), GUIFactory.FONT_SMALL);
            this.mSystemNameTextField = GUIFactory.newTextField(285);
            this.mSystemNameTextField.setFont(GUIFactory.FONT_SMALL);
            this.mSystemNameTextField.addFocusListener(focusAdapter);
            this.mSystemNameTextField.addCaretListener(caretListener);
            this.mSystemNameTextField.addActionListener(actionListener);
            JLabel jLabel2 = ManagementSystemPane.this.jlabelWithFont(Resources.getString("management.systemInfo.systemInfoBox.location"), GUIFactory.FONT_SMALL);
            this.mLocationTextField = GUIFactory.newTextField(285);
            this.mLocationTextField.setFont(GUIFactory.FONT_SMALL);
            this.mLocationTextField.addFocusListener(focusAdapter);
            this.mLocationTextField.addCaretListener(caretListener);
            this.mLocationTextField.addActionListener(actionListener);
            JLabel jLabel3 = ManagementSystemPane.this.jlabelWithFont(Resources.getString("management.systemInfo.systemInfoBox.contact"), GUIFactory.FONT_SMALL);
            this.mContactTextField = GUIFactory.newTextField(285);
            this.mContactTextField.setFont(GUIFactory.FONT_SMALL);
            this.mContactTextField.addFocusListener(focusAdapter);
            this.mContactTextField.addCaretListener(caretListener);
            this.mContactTextField.addActionListener(actionListener);
            JLabel jLabel4 = ManagementSystemPane.this.jlabelWithFont(Resources.getString("management.systemInfo.systemInfoBox.localTime"), GUIFactory.FONT_SMALL);
            this.mLocalTimeLabel = ManagementSystemPane.this.jlabelWithFont("", GUIFactory.FONT_SMALL);
            JLabel jLabel5 = ManagementSystemPane.this.jlabelWithFont(Resources.getString("management.systemInfo.systemInfoBox.xServeTime"), GUIFactory.FONT_SMALL);
            this.mXserveRAIDTimeLabel = ManagementSystemPane.this.jlabelWithFont("", GUIFactory.FONT_SMALL);
            JLabel jLabel6 = ManagementSystemPane.this.jlabelWithFont(Resources.getString("management.systemInfo.systemInfoBox.syncMethod"), GUIFactory.FONT_SMALL);
            this.mTimeSynchronizeComboBox = GUIFactory.newComboBox();
            this.mTimeSynchronizeComboBox.setMaximumSize(this.mTimeSynchronizeComboBox.getPreferredSize());
            this.mTimeSynchronizeComboBox.setEditable(false);
            this.mTimeSynchronizeComboBox.setFont(GUIFactory.FONT_SMALL);
            this.mTimeSynchronizeComboBox.addItem(Resources.getString("management.systemInfo.systemInfoBox.dontSync") + ManagementSystemPane.COMBO_BOX_SPACING);
            this.mTimeSynchronizeComboBox.addItem(Resources.getString("management.systemInfo.systemInfoBox.localSync") + ManagementSystemPane.COMBO_BOX_SPACING);
            this.mTimeSynchronizeComboBox.addItem(Resources.getString("management.systemInfo.systemInfoBox.ntpSync") + ManagementSystemPane.COMBO_BOX_SPACING);
            this.mTimeSynchronizeComboBox.addActionListener(actionListener);
            this.mTimeSynchronizeComboBox.addActionListener(new ActionListener(this){
                private final /* synthetic */ SystemInformationPanel this$1;
                {
                    this.this$1 = systemInformationPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = SystemInformationPanel.access$300(this.this$1).getSelectedIndex();
                    if (n == 2) {
                        SystemInformationPanel.access$400(this.this$1).setVisible(true);
                        SystemInformationPanel.access$500(this.this$1).setText(Resources.getString("management.systemInfo.systemInfoBox.ntpServerExample"));
                    } else {
                        SystemInformationPanel.access$400(this.this$1).setVisible(false);
                        SystemInformationPanel.access$500(this.this$1).setText(" ");
                        this.this$1.checkValidity();
                    }
                }
            });
            this.mNTPServerTextField = GUIFactory.newTextField("");
            this.mNTPServerTextField.setFont(GUIFactory.FONT_SMALL);
            this.mNTPServerTextField.addFocusListener(focusAdapter);
            this.mNTPServerTextField.addCaretListener(caretListener);
            this.mNTPServerTextField.addActionListener(actionListener);
            this.mNTPServerTextField.setVisible(false);
            this.mNTPServerTextField.setMinimumSize(this.mNTPServerTextField.getPreferredSize());
            this.mNTPServerExample = ManagementSystemPane.this.jlabelWithFont(ManagementSystemPane.TITLED_BORDER_SPACING, GUIFactory.FONT_TINY);
            Timer timer = new Timer(1000, new ActionListener(this){
                private final /* synthetic */ SystemInformationPanel this$1;
                {
                    this.this$1 = systemInformationPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    SystemInformationPanel.access$600(this.this$1);
                    if (SystemInformationPanel.access$700(this.this$1) != null) {
                        SystemInformationPanel.access$700(this.this$1).setTime(SystemInformationPanel.access$700(this.this$1).getTime() + 1000L);
                    }
                }
            });
            timer.start();
            ImageIcon imageIcon = new ImageIcon(Resources.getImage("icon.validate"));
            this.mSystemNameValidateLabel = new JLabel(imageIcon);
            this.mLocationValidateLabel = new JLabel(imageIcon);
            this.mContactValidateLabel = new JLabel(imageIcon);
            this.mNTPServerValidateLabel = new JLabel(imageIcon);
            this.mSystemNameValidateLabel.setVisible(false);
            this.mLocationValidateLabel.setVisible(false);
            this.mContactValidateLabel.setVisible(false);
            this.mNTPServerValidateLabel.setVisible(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 16;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            gridBagConstraints.insets = new Insets(0, 4, 4, 0);
            this.add(this.mSystemNameValidateLabel, gridBagConstraints, 3, 1, 1, 1);
            this.add(this.mLocationValidateLabel, gridBagConstraints, 3, 3, 1, 1);
            this.add(this.mContactValidateLabel, gridBagConstraints, 3, 4, 1, 1);
            this.add(this.mNTPServerValidateLabel, gridBagConstraints, 3, 7, 1, 1);
            this.add(Box.createHorizontalStrut(16), gridBagConstraints, 3, 8, 1, 1);
            gridBagConstraints.insets = new Insets(0, 8, 0, 1);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(8, 8, 0, 1);
            this.add(this.mLocalTimeLabel, gridBagConstraints, 1, 5, 2, 1);
            this.add(this.mXserveRAIDTimeLabel, gridBagConstraints, 1, 6, 2, 1);
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(8, 0, 0, 0);
            this.add(jLabel, gridBagConstraints, 0, 1, 1, 1);
            this.add(jLabel2, gridBagConstraints, 0, 3, 1, 1);
            this.add(jLabel3, gridBagConstraints, 0, 4, 1, 1);
            this.add(jLabel4, gridBagConstraints, 0, 5, 1, 1);
            this.add(jLabel5, gridBagConstraints, 0, 6, 1, 1);
            this.add(jLabel6, gridBagConstraints, 0, 7, 1, 1);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(8, 8, 0, 0);
            gridBagConstraints.ipadx = 285;
            this.add(this.mSystemNameTextField, gridBagConstraints, 1, 1, 2, 1);
            this.add(this.mLocationTextField, gridBagConstraints, 1, 3, 2, 1);
            this.add(this.mContactTextField, gridBagConstraints, 1, 4, 2, 1);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.fill = 2;
            this.add(this.mTimeSynchronizeComboBox, gridBagConstraints, 1, 7, 1, 1);
            this.add(this.mNTPServerTextField, gridBagConstraints, 2, 7, 1, 1);
            gridBagConstraints.insets = new Insets(0, 8, 0, 0);
            this.add(this.mNTPServerExample, gridBagConstraints, 2, 8, 1, 1);
            Preferences preferences = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
            if (preferences != null) {
                String string = Gestalt.timeFormat == 12 ? TIME_FORMAT_12_HOUR : TIME_FORMAT_24_HOUR;
                String string2 = preferences.getString("TimeFormat", string);
                this.setTimeFormat(string2);
                preferences.addPreferenceChangeListener(new Preferences.PreferenceChangeListener(this){
                    private final /* synthetic */ SystemInformationPanel this$1;
                    {
                        this.this$1 = systemInformationPanel;
                    }

                    public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
                        if (preferenceChangeEvent.getKey().equals("TimeFormat")) {
                            this.this$1.setTimeFormat((String)preferenceChangeEvent.getNewValue());
                        }
                    }
                });
            }
        }

        public void setTimeFormat(String string) {
            if (!string.equals(TIME_FORMAT_12_HOUR) && !string.equals(TIME_FORMAT_24_HOUR)) {
                throw new IllegalArgumentException("Invalid time format: " + string);
            }
            String string2 = string.equals(TIME_FORMAT_12_HOUR) ? this.DATE_FORMAT_12_HOUR : this.DATE_FORMAT_24_HOUR;
            this.mDateFormat.applyPattern(string2);
        }

        private void setTheTimeLabels() {
            String string = this.mDateFormat.format(new Date());
            String string2 = null;
            string2 = this.mXserveRAIDTime != null ? this.mDateFormat.format(this.mXserveRAIDTime) : Resources.getString("management.systemInfo.systemInfoBox.timeNotSet");
            this.mLocalTimeLabel.setText(string);
            this.mXserveRAIDTimeLabel.setText(string2);
        }

        public void populate(ManagementSystemModel managementSystemModel) {
            this.mSystemNameTextField.setText(managementSystemModel.getSystemName());
            this.mLocationTextField.setText(managementSystemModel.getLocation());
            this.mContactTextField.setText(managementSystemModel.getContact());
            Date date = managementSystemModel.getXserveRAIDTime();
            if (this.mXserveRAIDTime != null && date != null) {
                this.mXserveRAIDTime.setTime(date.getTime());
            } else {
                this.mXserveRAIDTime = this.mXserveRAIDTime == null && date != null ? (Date)date.clone() : null;
            }
            if (managementSystemModel.getTimeSynchronizationMethod() == 3) {
                this.mTimeSynchronizeComboBox.setSelectedIndex(2);
                this.mNTPServerTextField.setText(managementSystemModel.getNTPServer());
            }
            this.setTheTimeLabels();
        }

        public boolean checkValidity() {
            boolean bl = true;
            int n = this.mTimeSynchronizeComboBox.getSelectedIndex();
            if (n == 2 && this.mNTPServerTextField.getText().trim().equals("")) {
                this.mNTPServerValidateLabel.setVisible(true);
                bl = false;
            } else {
                this.mNTPServerValidateLabel.setVisible(false);
            }
            return bl;
        }

        public void fillInModel(ManagementSystemModel managementSystemModel) {
            if (managementSystemModel != null) {
                managementSystemModel.setSystemName(this.mSystemNameTextField.getText());
                managementSystemModel.setLocation(this.mLocationTextField.getText());
                managementSystemModel.setContact(this.mContactTextField.getText());
                int n = this.mTimeSynchronizeComboBox.getSelectedIndex();
                if (n == 2) {
                    managementSystemModel.setTimeSynchronizationMethod(3);
                    managementSystemModel.setNTPServer(this.mNTPServerTextField.getText().trim());
                } else if (n == 1) {
                    managementSystemModel.setTimeSynchronizationMethod(2);
                } else {
                    managementSystemModel.setTimeSynchronizationMethod(1);
                }
            }
        }

        static /* synthetic */ ManagementSystemPane access$000(SystemInformationPanel systemInformationPanel) {
            return systemInformationPanel.ManagementSystemPane.this;
        }

        static /* synthetic */ JComboBox access$300(SystemInformationPanel systemInformationPanel) {
            return systemInformationPanel.mTimeSynchronizeComboBox;
        }

        static /* synthetic */ JTextField access$400(SystemInformationPanel systemInformationPanel) {
            return systemInformationPanel.mNTPServerTextField;
        }

        static /* synthetic */ JLabel access$500(SystemInformationPanel systemInformationPanel) {
            return systemInformationPanel.mNTPServerExample;
        }

        static /* synthetic */ void access$600(SystemInformationPanel systemInformationPanel) {
            systemInformationPanel.setTheTimeLabels();
        }

        static /* synthetic */ Date access$700(SystemInformationPanel systemInformationPanel) {
            return systemInformationPanel.mXserveRAIDTime;
        }
    }
}

