/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.gui.RestrictedTextField;
import com.apple.xsr.LineSeparator;
import com.apple.xsr.ManagementNetworkModel;
import com.apple.xsr.ManagementPane;
import com.apple.xsr.Resources;
import com.apple.xsr.SetupPane;
import com.apple.xsr.SizeLinkedPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;

public class ManagementNetworkPane
extends JPanel {
    public static final boolean ALLOW_DNS_OVERRIDES = false;
    static final int BIG_GRID_BAG_INSET_VALUE = 16;
    static final int GRID_BAG_INSET_VALUE = 8;
    static final int GRID_BAG_COLUMN_SEPERATOR_INSET_VALUE = 28;
    static final int TEXT_FIELD_WIDTH = 12;
    static final float LABEL_SIZE = 11.0f;
    static final float SMALL_LABEL_SIZE = 9.0f;
    private static final int INVALID_NETWORK_CONFIG_1 = 2560;
    private static final int INVALID_NETWORK_CONFIG_2 = 2814;
    private ManagementNetworkPaneInner mTopController;
    private ManagementNetworkPaneInner mBottomController;
    private SetupPane parent;
    private boolean populated = false;
    private static final Logger logger = Logger.getLogger(class$com$apple$xsr$ManagementNetworkPane == null ? (class$com$apple$xsr$ManagementNetworkPane = ManagementNetworkPane.class$("com.apple.xsr.ManagementNetworkPane")) : class$com$apple$xsr$ManagementNetworkPane);
    static /* synthetic */ Class class$com$apple$xsr$ManagementNetworkPane;

    public ManagementNetworkPane(SetupPane setupPane) {
        this.parent = setupPane;
        GUIFactory.configureComponentForPlatform(this);
        this.setLayout(new GridLayout(1, 2, 16, 0));
        this.setBorder(ManagementPane.DEFAULT_BORDER);
        this.mTopController = new ManagementNetworkPaneInner(Resources.getString("management.network.topController"));
        this.add(this.mTopController);
        this.mBottomController = new ManagementNetworkPaneInner(Resources.getString("management.network.bottomController"));
        this.add(this.mBottomController);
    }

    public SizeLinkedPanel getGroupBox(int n) {
        ManagementNetworkPaneInner managementNetworkPaneInner = null;
        managementNetworkPaneInner = n == 1 ? this.mTopController : this.mBottomController;
        return managementNetworkPaneInner;
    }

    public boolean validate(ManagementNetworkModel managementNetworkModel) {
        boolean bl = true;
        if (!this.mTopController.checkValidity()) {
            bl = false;
        }
        if (!this.mBottomController.checkValidity()) {
            bl = false;
        }
        if (bl && managementNetworkModel != null) {
            this.mTopController.fillInModel(managementNetworkModel.getUpperControllerModel());
            this.mBottomController.fillInModel(managementNetworkModel.getLowerControllerModel());
        }
        int n = this.parent.tabbedPane.indexOfComponent(this);
        if (!bl && this.parent.tabbedPane.getSelectedIndex() != n) {
            this.parent.tabbedPane.setIconAt(n, new ImageIcon(Resources.getImage("icon.validate")));
        } else {
            this.parent.tabbedPane.setIconAt(n, null);
        }
        return bl;
    }

    public void populate(ManagementNetworkModel managementNetworkModel) {
        this.mTopController.populate(managementNetworkModel.getUpperControllerModel());
        this.mBottomController.populate(managementNetworkModel.getLowerControllerModel());
        this.populated = true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ boolean access$100(ManagementNetworkPane managementNetworkPane) {
        return managementNetworkPane.populated;
    }

    static /* synthetic */ SetupPane access$200(ManagementNetworkPane managementNetworkPane) {
        return managementNetworkPane.parent;
    }

    private class ManagementNetworkPaneInner
    extends SizeLinkedPanel {
        final int HEIGHT = 296;
        final Insets INSETS_ZERO = new Insets(0, 0, 0, 0);
        final Insets INSETS_SEPARATOR = new Insets(16, 0, 4, 0);
        final Insets INSETS_CONFIGURE_LABEL = new Insets(0, 16, 0, 0);
        final Insets INSETS_CONFIGURE_COMBO = new Insets(0, 8, 0, 0);
        final Insets INSETS_LABELS = new Insets(8, 16, 0, 0);
        final Insets INSETS_TEXT_FIELDS = new Insets(8, 8, 0, 0);
        final Insets INSETS_OPTIONAL_LABELS = new Insets(0, 8, 0, 0);
        final Insets INSETS_VALIDATE_LABELS = new Insets(0, 4, 4, 0);
        final Insets INSETS_VALIDATE_STRUT = new Insets(0, 4, 0, 0);
        final Insets INSETS_ETHERNET_ADDRESS_LABEL = new Insets(8, 16, 16, 0);
        final Insets INSETS_ETHERNET_ADDRESS = new Insets(8, 8, 16, 0);
        private final String OPTIONAL = Resources.getString("management.network.optional");
        private final String PROVIDED_BY_DHCP = Resources.getString("management.network.usingDHCP");
        private final String VALID_IP_OCTET_SET = Resources.getString("aquaTextField.validIPOctetCharacters");
        private JComboBox mConfigurationComboBox;
        private RestrictedTextField mIPAddressTextField;
        private RestrictedTextField mSubnetMaskTextField;
        private RestrictedTextField mRouterTextField;
        private RestrictedTextField mDNS1TextField;
        private RestrictedTextField mDNS2TextField;
        private RestrictedTextField mDNS3TextField;
        private JTextField mDHCPClientIDTextField;
        private JLabel mEthernetAddressLabel;
        private JLabel mIPAddressValidateLabel;
        private JLabel mSubnetMaskValidateLabel;
        private JLabel mRouterValidateLabel;
        private JLabel mDHCPClientIDValidateLabel;
        private JLabel mDNS1ValidateLabel;
        private JLabel mDNS2ValidateLabel;
        private JLabel mDNS3ValidateLabel;
        private JLabel mDNS1OptionalLabel;
        private JLabel mDNS2OptionalLabel;
        private JLabel mDNS3OptionalLabel;
        private JLabel mDHCPClientIDLabel;
        private JLabel mDHCPClientIDOptionalLabel;
        private String mDHCPClientIDString = null;
        private ManagementNetworkModel.ManagementNetworkControllerModel model = null;

        public ManagementNetworkPaneInner(String string) {
            this.setLayout(new GridBagLayout());
            TitledBorder titledBorder = new TitledBorder(" " + string + " ");
            titledBorder.setTitleFont(GUIFactory.FONT_SMALL);
            this.setBorder(new CompoundBorder(titledBorder, ManagementPane.DEFAULT_GROUP_BOX_BORDER));
            FocusAdapter focusAdapter = new FocusAdapter(this, ManagementNetworkPane.this){
                private final /* synthetic */ ManagementNetworkPane val$this$0;
                private final /* synthetic */ ManagementNetworkPaneInner this$1;
                {
                    this.this$1 = managementNetworkPaneInner;
                    this.val$this$0 = managementNetworkPane;
                }

                public void focusLost(FocusEvent focusEvent) {
                    if (ManagementNetworkPane.access$100(ManagementNetworkPaneInner.access$000(this.this$1))) {
                        ManagementNetworkPaneInner.access$000(this.this$1).validate(null);
                    }
                }
            };
            CaretListener caretListener = new CaretListener(this, ManagementNetworkPane.this){
                private final /* synthetic */ ManagementNetworkPane val$this$0;
                private final /* synthetic */ ManagementNetworkPaneInner this$1;
                {
                    this.this$1 = managementNetworkPaneInner;
                    this.val$this$0 = managementNetworkPane;
                }

                public void caretUpdate(CaretEvent caretEvent) {
                    if (ManagementNetworkPane.access$100(ManagementNetworkPaneInner.access$000(this.this$1))) {
                        ManagementNetworkPane.access$200(ManagementNetworkPaneInner.access$000(this.this$1)).setModified();
                    }
                }
            };
            ActionListener actionListener = new ActionListener(this, ManagementNetworkPane.this){
                private final /* synthetic */ ManagementNetworkPane val$this$0;
                private final /* synthetic */ ManagementNetworkPaneInner this$1;
                {
                    this.this$1 = managementNetworkPaneInner;
                    this.val$this$0 = managementNetworkPane;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ManagementNetworkPane.access$100(ManagementNetworkPaneInner.access$000(this.this$1))) {
                        ManagementNetworkPaneInner.access$000(this.this$1).validate(null);
                        ManagementNetworkPane.access$200(ManagementNetworkPaneInner.access$000(this.this$1)).setModified();
                    }
                }
            };
            LineSeparator lineSeparator = new LineSeparator(true, Color.gray);
            JLabel jLabel = this.jlabelWithFont(Resources.getString("management.network.configure"), GUIFactory.FONT_SMALL);
            JLabel jLabel2 = this.jlabelWithFont(Resources.getString("management.network.ipAddress"), GUIFactory.FONT_SMALL);
            JLabel jLabel3 = this.jlabelWithFont(Resources.getString("management.network.subnetMask"), GUIFactory.FONT_SMALL);
            JLabel jLabel4 = this.jlabelWithFont(Resources.getString("management.network.router"), GUIFactory.FONT_SMALL);
            JLabel jLabel5 = this.jlabelWithFont(Resources.getString("management.network.dns1"), GUIFactory.FONT_SMALL);
            JLabel jLabel6 = this.jlabelWithFont(Resources.getString("management.network.dns2"), GUIFactory.FONT_SMALL);
            JLabel jLabel7 = this.jlabelWithFont(Resources.getString("management.network.dns3"), GUIFactory.FONT_SMALL);
            JLabel jLabel8 = this.jlabelWithFont(Resources.getString("management.network.ethernetAddress"), GUIFactory.FONT_SMALL);
            this.mConfigurationComboBox = new JComboBox();
            this.mConfigurationComboBox.setEditable(false);
            this.mConfigurationComboBox.setFont(GUIFactory.FONT_SMALL);
            this.mConfigurationComboBox.addItem(Resources.getString("management.network.usingDHCP"));
            this.mConfigurationComboBox.addItem(Resources.getString("management.network.manually"));
            this.mConfigurationComboBox.addActionListener(actionListener);
            this.mConfigurationComboBox.addActionListener(new ActionListener(this){
                private final /* synthetic */ ManagementNetworkPaneInner this$1;
                {
                    this.this$1 = managementNetworkPaneInner;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = (String)ManagementNetworkPaneInner.access$300(this.this$1).getSelectedItem();
                    if (string.equals(Resources.getString("management.network.usingDHCP"))) {
                        this.this$1.configureUIForDHCP();
                    } else {
                        this.this$1.configureUIForManual();
                    }
                }
            });
            this.mIPAddressTextField = GUIFactory.newRestrictedTextField(12);
            this.mIPAddressTextField.setFont(GUIFactory.FONT_SMALL);
            this.mIPAddressTextField.addFocusListener(focusAdapter);
            this.mIPAddressTextField.addCaretListener(caretListener);
            this.mIPAddressTextField.addActionListener(actionListener);
            this.mIPAddressTextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            this.mSubnetMaskTextField = GUIFactory.newRestrictedTextField(12);
            this.mSubnetMaskTextField.setFont(GUIFactory.FONT_SMALL);
            this.mSubnetMaskTextField.addFocusListener(focusAdapter);
            this.mSubnetMaskTextField.addCaretListener(caretListener);
            this.mSubnetMaskTextField.addActionListener(actionListener);
            this.mSubnetMaskTextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            this.mRouterTextField = GUIFactory.newRestrictedTextField(12);
            this.mRouterTextField.setFont(GUIFactory.FONT_SMALL);
            this.mRouterTextField.addFocusListener(focusAdapter);
            this.mRouterTextField.addCaretListener(caretListener);
            this.mRouterTextField.addActionListener(actionListener);
            this.mRouterTextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            this.mDHCPClientIDTextField = GUIFactory.newTextField(12);
            this.mDHCPClientIDTextField.setFont(GUIFactory.FONT_SMALL);
            this.mDHCPClientIDTextField.addFocusListener(focusAdapter);
            this.mDHCPClientIDTextField.addCaretListener(caretListener);
            this.mDHCPClientIDTextField.addActionListener(actionListener);
            this.mDNS1TextField = GUIFactory.newRestrictedTextField(12);
            this.mDNS1TextField.setFont(GUIFactory.FONT_SMALL);
            this.mDNS1TextField.addFocusListener(focusAdapter);
            this.mDNS1TextField.addCaretListener(caretListener);
            this.mDNS1TextField.addActionListener(actionListener);
            this.mDNS1TextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            this.mDNS2TextField = GUIFactory.newRestrictedTextField(12);
            this.mDNS2TextField.setFont(GUIFactory.FONT_SMALL);
            this.mDNS2TextField.addFocusListener(focusAdapter);
            this.mDNS2TextField.addCaretListener(caretListener);
            this.mDNS2TextField.addActionListener(actionListener);
            this.mDNS2TextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            this.mDNS3TextField = GUIFactory.newRestrictedTextField(12);
            this.mDNS3TextField.setFont(GUIFactory.FONT_SMALL);
            this.mDNS3TextField.addFocusListener(focusAdapter);
            this.mDNS3TextField.addCaretListener(caretListener);
            this.mDNS3TextField.addActionListener(actionListener);
            this.mDNS3TextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            this.mDNS1OptionalLabel = this.jlabelWithFont(this.OPTIONAL, GUIFactory.FONT_TINY);
            this.mDNS2OptionalLabel = this.jlabelWithFont(this.OPTIONAL, GUIFactory.FONT_TINY);
            this.mDNS3OptionalLabel = this.jlabelWithFont(this.OPTIONAL, GUIFactory.FONT_TINY);
            this.mDNS1OptionalLabel.setVisible(false);
            this.mDNS2OptionalLabel.setVisible(false);
            this.mDNS3OptionalLabel.setVisible(false);
            this.mDHCPClientIDOptionalLabel = this.jlabelWithFont(Resources.getString("management.network.optional"), GUIFactory.FONT_TINY);
            this.mDHCPClientIDLabel = this.jlabelWithFont(Resources.getString("management.network.dhcpClientID"), GUIFactory.FONT_SMALL);
            this.mEthernetAddressLabel = new JLabel();
            this.mEthernetAddressLabel.setFont(GUIFactory.FONT_SMALL);
            ImageIcon imageIcon = new ImageIcon(Resources.getImage("icon.validate"));
            this.mIPAddressValidateLabel = new JLabel(imageIcon);
            this.mSubnetMaskValidateLabel = new JLabel(imageIcon);
            this.mRouterValidateLabel = new JLabel(imageIcon);
            this.mDHCPClientIDValidateLabel = new JLabel(imageIcon);
            this.mDNS1ValidateLabel = new JLabel(imageIcon);
            this.mDNS2ValidateLabel = new JLabel(imageIcon);
            this.mDNS3ValidateLabel = new JLabel(imageIcon);
            this.mIPAddressValidateLabel.setVisible(false);
            this.mSubnetMaskValidateLabel.setVisible(false);
            this.mRouterValidateLabel.setVisible(false);
            this.mDHCPClientIDValidateLabel.setVisible(false);
            this.mDNS1ValidateLabel.setVisible(false);
            this.mDNS2ValidateLabel.setVisible(false);
            this.mDNS3ValidateLabel.setVisible(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(0, 16, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = this.createInsets(16, 0, 4, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)lineSeparator, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(8, 16, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(8, 16, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)jLabel3, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(8, 16, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)jLabel4, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(8, 16, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)jLabel5, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(8, 16, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)jLabel6, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 9;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(8, 16, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)jLabel7, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 11;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(8, 16, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)this.mDHCPClientIDLabel, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 13;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 16;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(8, 16, 16, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)jLabel8, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 14;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = this.INSETS_ZERO;
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add(Box.createGlue(), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(0, 8, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)this.mConfigurationComboBox, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(8, 8, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)this.mIPAddressTextField, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(8, 8, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)this.mSubnetMaskTextField, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(8, 8, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)this.mRouterTextField, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(8, 8, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)this.mDNS1TextField, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(0, 8, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)this.mDNS1OptionalLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(8, 8, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)this.mDNS2TextField, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 8;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(0, 8, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)this.mDNS2OptionalLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 9;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(8, 8, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)this.mDNS3TextField, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 10;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(0, 8, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)this.mDNS3OptionalLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 11;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(8, 8, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)this.mDHCPClientIDTextField, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 12;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(0, 8, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)this.mDHCPClientIDOptionalLabel, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 13;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 16;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(8, 8, 16, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)this.mEthernetAddressLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 16;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(0, 4, 4, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)this.mIPAddressValidateLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 16;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(0, 4, 4, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)this.mSubnetMaskValidateLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 16;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(0, 4, 4, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)this.mRouterValidateLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 16;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(0, 4, 4, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)this.mDNS1ValidateLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 16;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(0, 4, 4, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)this.mDNS2ValidateLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 9;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 16;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(0, 4, 4, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)this.mDNS3ValidateLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 11;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 16;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(0, 4, 4, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add((Component)this.mDHCPClientIDValidateLabel, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 13;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 16;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(0, 4, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add(Box.createHorizontalStrut(imageIcon.getIconWidth()), gridBagConstraints);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 13;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = this.createInsets(0, 0, 0, 0);
            gridBagConstraints.ipadx = 0;
            gridBagConstraints.ipady = 0;
            this.add(Box.createVerticalStrut(296), gridBagConstraints);
            this.configureUIForDHCP();
        }

        public void configureUIForDHCP() {
            this.mIPAddressTextField.setRestrictedCharacterSet(null);
            this.mSubnetMaskTextField.setRestrictedCharacterSet(null);
            this.mRouterTextField.setRestrictedCharacterSet(null);
            if (this.model != null && this.model.getNetworkConfigurationMethod() == 1) {
                this.mIPAddressTextField.setText(this.model.getIPAddress());
                this.mSubnetMaskTextField.setText(this.model.getSubnetMask());
                this.mRouterTextField.setText(this.model.getRouter());
                this.mDNS1TextField.setText(this.model.getDNS1());
                this.mDNS2TextField.setText(this.model.getDNS2());
                this.mDNS3TextField.setText(this.model.getDNS3());
            } else if (this.model != null && this.model.getNetworkConfigurationMethod() == 2) {
                this.mIPAddressTextField.setText(this.PROVIDED_BY_DHCP);
                this.mSubnetMaskTextField.setText(this.PROVIDED_BY_DHCP);
                this.mRouterTextField.setText(this.PROVIDED_BY_DHCP);
                this.mDNS1TextField.setText("");
                this.mDNS2TextField.setText("");
                this.mDNS3TextField.setText("");
            } else {
                this.mIPAddressTextField.setText("");
                this.mSubnetMaskTextField.setText("");
                this.mRouterTextField.setText("");
                this.mDNS1TextField.setText("");
                this.mDNS2TextField.setText("");
                this.mDNS3TextField.setText("");
            }
            GUIFactory.configureTextFieldAsLabel(this.mIPAddressTextField);
            GUIFactory.configureTextFieldAsLabel(this.mSubnetMaskTextField);
            GUIFactory.configureTextFieldAsLabel(this.mRouterTextField);
            this.mIPAddressValidateLabel.setVisible(false);
            this.mSubnetMaskValidateLabel.setVisible(false);
            this.mRouterValidateLabel.setVisible(false);
            GUIFactory.configureTextFieldAsLabel(this.mDNS1TextField);
            GUIFactory.configureTextFieldAsLabel(this.mDNS2TextField);
            GUIFactory.configureTextFieldAsLabel(this.mDNS3TextField);
            this.mDNS1OptionalLabel.setVisible(false);
            this.mDNS2OptionalLabel.setVisible(false);
            this.mDNS3OptionalLabel.setVisible(false);
            GUIFactory.configureTextFieldAsField(this.mDHCPClientIDTextField);
            if (this.mDHCPClientIDString != null) {
                this.mDHCPClientIDTextField.setText(this.mDHCPClientIDString);
            }
            this.mDHCPClientIDLabel.setVisible(true);
            this.mDHCPClientIDOptionalLabel.setVisible(true);
        }

        public void configureUIForManual() {
            if (this.model != null && this.model.getNetworkConfigurationMethod() == 2) {
                this.mIPAddressTextField.setText(this.model.getIPAddress());
                this.mSubnetMaskTextField.setText(this.model.getSubnetMask());
                this.mRouterTextField.setText(this.model.getRouter());
                this.mDNS1TextField.setText(this.model.getDNS1());
                this.mDNS2TextField.setText(this.model.getDNS2());
                this.mDNS3TextField.setText(this.model.getDNS3());
            } else if (this.model != null && this.model.getNetworkConfigurationMethod() == 1) {
                this.mIPAddressTextField.setText("");
                this.mSubnetMaskTextField.setText(this.model.getSubnetMask());
                this.mRouterTextField.setText(this.model.getRouter());
                this.mDNS1TextField.setText(this.model.getDNS1());
                this.mDNS2TextField.setText(this.model.getDNS2());
                this.mDNS3TextField.setText(this.model.getDNS3());
            } else {
                this.mIPAddressTextField.setText("");
                this.mSubnetMaskTextField.setText("");
                this.mRouterTextField.setText("");
                this.mDNS1TextField.setText("");
                this.mDNS2TextField.setText("");
                this.mDNS3TextField.setText("");
            }
            this.mIPAddressTextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            this.mSubnetMaskTextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            this.mRouterTextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            this.mDNS1TextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            this.mDNS2TextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            this.mDNS3TextField.setRestrictedCharacterSet(this.VALID_IP_OCTET_SET);
            GUIFactory.configureTextFieldAsField(this.mIPAddressTextField);
            GUIFactory.configureTextFieldAsField(this.mSubnetMaskTextField);
            GUIFactory.configureTextFieldAsField(this.mRouterTextField);
            GUIFactory.configureTextFieldAsField(this.mDNS1TextField);
            GUIFactory.configureTextFieldAsField(this.mDNS2TextField);
            GUIFactory.configureTextFieldAsField(this.mDNS3TextField);
            this.mDNS1OptionalLabel.setVisible(false);
            this.mDNS2OptionalLabel.setVisible(true);
            this.mDNS3OptionalLabel.setVisible(true);
            GUIFactory.configureTextFieldAsLabel(this.mDHCPClientIDTextField);
            this.mDHCPClientIDString = this.mDHCPClientIDTextField.getText();
            this.mDHCPClientIDTextField.setText(" ");
            this.mDHCPClientIDLabel.setVisible(false);
            this.mDHCPClientIDOptionalLabel.setVisible(false);
        }

        public void populate(ManagementNetworkModel.ManagementNetworkControllerModel managementNetworkControllerModel) {
            this.model = managementNetworkControllerModel;
            if (managementNetworkControllerModel.getNetworkConfigurationMethod() == 1) {
                this.mConfigurationComboBox.setSelectedItem(Resources.getString("management.network.usingDHCP"));
                this.configureUIForDHCP();
            } else {
                this.mConfigurationComboBox.setSelectedItem(Resources.getString("management.network.manually"));
                this.configureUIForManual();
            }
            this.mDHCPClientIDTextField.setText(managementNetworkControllerModel.getDHCPClientID());
            this.mEthernetAddressLabel.setText(managementNetworkControllerModel.getEthernetMACAddress());
            this.checkValidity();
        }

        public boolean checkValidity() {
            boolean bl = true;
            if (this.getConfigurationMode() == 2) {
                boolean bl2 = false;
                bl2 = this.validateAddressField(this.mIPAddressTextField, this.mIPAddressValidateLabel);
                if (!bl2) {
                    bl = false;
                }
                if (!this.mSubnetMaskTextField.getText().trim().equals("") && !(bl2 = this.validateAddressField(this.mSubnetMaskTextField, this.mSubnetMaskValidateLabel))) {
                    bl = false;
                }
                if (bl && !(bl2 = this.validateIPAddressSubnetConflicts())) {
                    bl = false;
                }
                if (!this.mRouterTextField.getText().trim().equals("") && !(bl2 = this.validateAddressField(this.mRouterTextField, this.mRouterValidateLabel))) {
                    bl = false;
                }
                if (!this.mDNS1TextField.getText().trim().equals("") && !(bl2 = this.validateAddressField(this.mDNS1TextField, this.mDNS1ValidateLabel))) {
                    bl = false;
                }
                if (!this.mDNS2TextField.getText().trim().equals("") && !(bl2 = this.validateAddressField(this.mDNS2TextField, this.mDNS2ValidateLabel))) {
                    bl = false;
                }
                if (!this.mDNS3TextField.getText().trim().equals("") && !(bl2 = this.validateAddressField(this.mDNS3TextField, this.mDNS3ValidateLabel))) {
                    bl = false;
                }
            }
            return bl;
        }

        public void fillInModel(ManagementNetworkModel.ManagementNetworkControllerModel managementNetworkControllerModel) {
            if (managementNetworkControllerModel == null) {
                throw new IllegalArgumentException("networkModel is null.");
            }
            int n = this.getConfigurationMode();
            managementNetworkControllerModel.setNetworkConfigurationMethod(n);
            if (n == 2) {
                managementNetworkControllerModel.setIPAddress(this.mIPAddressTextField.getText());
                managementNetworkControllerModel.setSubnetMask(this.mSubnetMaskTextField.getText());
                managementNetworkControllerModel.setRouter(this.mRouterTextField.getText());
                managementNetworkControllerModel.setDNS1(this.mDNS1TextField.getText());
                managementNetworkControllerModel.setDNS2(this.mDNS2TextField.getText());
                managementNetworkControllerModel.setDNS3(this.mDNS3TextField.getText());
            } else {
                managementNetworkControllerModel.setDNS1(this.mDNS1TextField.getText());
                managementNetworkControllerModel.setDNS2(this.mDNS2TextField.getText());
                managementNetworkControllerModel.setDNS3(this.mDNS3TextField.getText());
            }
            String string = this.mDHCPClientIDTextField.getText();
            if (string.equals(" ")) {
                string = "";
            }
            managementNetworkControllerModel.setDHCPClientID(string);
            managementNetworkControllerModel.setEthernetMACAddress(this.mEthernetAddressLabel.getText());
        }

        public int getConfigurationMode() {
            String string = (String)this.mConfigurationComboBox.getSelectedItem();
            if (string.equals(Resources.getString("management.network.usingDHCP"))) {
                return 1;
            }
            return 2;
        }

        private boolean validateAddressField(JTextField jTextField, JLabel jLabel) {
            boolean bl = true;
            try {
                jTextField.setText(jTextField.getText().trim());
                bl = this.validateFourOctetAddress(jTextField.getText().trim());
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            if (bl) {
                jLabel.setVisible(false);
            } else {
                jLabel.setVisible(true);
            }
            return bl;
        }

        private boolean validateFourOctetAddress(String string) throws NumberFormatException {
            boolean bl = true;
            boolean bl2 = false;
            for (int i = 0; i < 4; ++i) {
                int n = this.octetValueAtIndex(string, i);
                if (n >= 0 && n <= 255) continue;
                bl = false;
                break;
            }
            return bl;
        }

        private boolean validateIPAddressSubnetConflicts() {
            int n;
            int n2;
            int n3;
            boolean bl = true;
            try {
                int n4 = this.octetValueAtIndex(this.mIPAddressTextField.getText().trim(), 0);
                int n5 = this.octetValueAtIndex(this.mSubnetMaskTextField.getText().trim(), 0);
                n3 = this.octetValueAtIndex(this.mSubnetMaskTextField.getText().trim(), 1);
                n2 = n4 << 8 | this.octetValueAtIndex(this.mIPAddressTextField.getText().trim(), 1);
                n = n5 << 8 | n3;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if ((n2 & n) == 2560 && n3 == 0 || (n2 & n) == 2814) {
                this.mIPAddressValidateLabel.setVisible(true);
                this.mSubnetMaskValidateLabel.setVisible(true);
                bl = false;
            } else {
                this.mIPAddressValidateLabel.setVisible(false);
                this.mSubnetMaskValidateLabel.setVisible(false);
            }
            return bl;
        }

        private int octetValueAtIndex(String string, int n) {
            int n2 = -1;
            int n3 = 0;
            if (n < 0 || n > 3) {
                throw new IllegalArgumentException("Invalid index value");
            }
            for (int i = 0; i <= n; ++i) {
                int n4 = string.indexOf(".", n3);
                if (i < 3) {
                    if (n4 != -1 && i == n) {
                        n2 = Integer.valueOf(string.substring(n3, n4));
                        break;
                    }
                    if (n4 == -1) {
                        n2 = -1;
                        break;
                    }
                    n3 = n4 + 1;
                    continue;
                }
                n2 = Integer.valueOf(string.substring(n3));
            }
            return n2;
        }

        public JLabel jlabelWithFont(String string, Font font) {
            JLabel jLabel = new JLabel(string);
            jLabel.setFont(font);
            return jLabel;
        }

        private Insets createInsets(int n, int n2, int n3, int n4) {
            Insets insets;
            if (n == 16 && n2 == 0 && n3 == 4 && n4 == 0) {
                insets = this.INSETS_SEPARATOR;
            } else if (n == 0 && n2 == 16 && n3 == 0 && n4 == 0) {
                insets = this.INSETS_CONFIGURE_LABEL;
            } else if (n == 0 && n2 == 8 && n3 == 0 && n4 == 0) {
                insets = this.INSETS_CONFIGURE_COMBO;
            } else if (n == 8 && n2 == 16 && n3 == 0 && n4 == 0) {
                insets = this.INSETS_LABELS;
            } else if (n == 8 && n2 == 8 && n3 == 0 && n4 == 0) {
                insets = this.INSETS_TEXT_FIELDS;
            } else if (n == 0 && n2 == 8 && n3 == 0 && n4 == 0) {
                insets = this.INSETS_OPTIONAL_LABELS;
            } else if (n == 0 && n2 == 4 && n3 == 4 && n4 == 0) {
                insets = this.INSETS_VALIDATE_LABELS;
            } else if (n == 0 && n2 == 4 && n3 == 0 && n4 == 0) {
                insets = this.INSETS_VALIDATE_STRUT;
            } else if (n == 8 && n2 == 16 && n3 == 16 && n4 == 0) {
                insets = this.INSETS_ETHERNET_ADDRESS_LABEL;
            } else if (n == 8 && n2 == 8 && n3 == 16 && n4 == 0) {
                insets = this.INSETS_ETHERNET_ADDRESS;
            } else if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
                insets = this.INSETS_ZERO;
            } else {
                insets = new Insets(n, n2, n3, n4);
                logger.warn("Had to create new insets: " + n + "," + n2 + "," + n3 + "," + n4);
            }
            return insets;
        }

        static /* synthetic */ ManagementNetworkPane access$000(ManagementNetworkPaneInner managementNetworkPaneInner) {
            return managementNetworkPaneInner.ManagementNetworkPane.this;
        }

        static /* synthetic */ JComboBox access$300(ManagementNetworkPaneInner managementNetworkPaneInner) {
            return managementNetworkPaneInner.mConfigurationComboBox;
        }
    }
}

