/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;

class KeyPressForwardingPanel
extends JPanel
implements KeyListener,
ContainerListener {
    private ArrayList registeredKeyListeners = new ArrayList();

    public KeyPressForwardingPanel(JPanel jPanel) {
        this.addKeyAndContainerListenerRecursively(this);
        this.add(jPanel);
    }

    public KeyPressForwardingPanel(JPanel jPanel, KeyListener keyListener) {
        this(jPanel);
        this.registerForKeyPressEvents(keyListener);
    }

    public synchronized void registerForKeyPressEvents(KeyListener keyListener) {
        this.registeredKeyListeners.add(keyListener);
    }

    public void componentAdded(ContainerEvent containerEvent) {
        this.addKeyAndContainerListenerRecursively(containerEvent.getChild());
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        this.removeKeyAndContainerListenerRecursively(containerEvent.getChild());
    }

    private void addKeyAndContainerListenerRecursively(Component component) {
        component.addKeyListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.addContainerListener(this);
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                this.addKeyAndContainerListenerRecursively(componentArray[i]);
            }
        }
    }

    private void removeKeyAndContainerListenerRecursively(Component component) {
        component.removeKeyListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(this);
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                this.removeKeyAndContainerListenerRecursively(componentArray[i]);
            }
        }
    }

    public synchronized void keyPressed(KeyEvent keyEvent) {
        Iterator iterator = this.registeredKeyListeners.iterator();
        while (iterator.hasNext()) {
            KeyListener keyListener = (KeyListener)iterator.next();
            keyListener.keyPressed(keyEvent);
        }
    }

    public synchronized void keyReleased(KeyEvent keyEvent) {
        Iterator iterator = this.registeredKeyListeners.iterator();
        while (iterator.hasNext()) {
            KeyListener keyListener = (KeyListener)iterator.next();
            keyListener.keyReleased(keyEvent);
        }
    }

    public synchronized void keyTyped(KeyEvent keyEvent) {
        Iterator iterator = this.registeredKeyListeners.iterator();
        while (iterator.hasNext()) {
            KeyListener keyListener = (KeyListener)iterator.next();
            keyListener.keyTyped(keyEvent);
        }
    }
}

