/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.util.CapacityConverter;
import com.apple.util.StringUtilities;
import com.apple.xsr.ArraySelectionPanel;
import com.apple.xsr.CreateArrayPane;
import com.apple.xsr.DriveInformationPanel;
import com.apple.xsr.DrivePanel;
import com.apple.xsr.Resources;
import com.apple.xsr.StepByStepPanel;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.DiskSlot;
import com.apple.xsr.som.RaidController;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystem;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.MediaTracker;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextPane;

public class DriveSelectionPanel
extends JPanel
implements DrivePanel {
    public static final int NO_SELECTION = 0;
    public static final int SELECT_FOR_CREATE = 1;
    public static final int SELECT_FOR_DELETE = 2;
    public static final int SELECT_FOR_DRIVE_INFO = 3;
    public static final int SELECT_FOR_ARRAY_INFO = 4;
    public static final int SELECT_FOR_EXPAND = 5;
    public static final int SELECT_FOR_VERIFY = 6;
    public static final int SELECT_FOR_REBUILD = 7;
    public static final int SELECT_FOR_SLICE = 8;
    public static final int SELECT_FOR_MERGE = 9;
    public static final int SELECT_FOR_BGRW_START = 10;
    public static final int SELECT_FOR_BGRW_PAUSE = 11;
    public static final int SELECT_FOR_BGRW_RESUME = 12;
    public static final int SELECT_FOR_BGRW_STOP = 13;
    public static final int RAID_0 = 0;
    public static final int RAID_1 = 1;
    public static final int RAID_3 = 2;
    public static final int RAID_5 = 3;
    public static final int RAID_01 = 4;
    public static final int JBOD = 255;
    public static final int INDEX_NONE = -10;
    public static final int RAID_SET_ID_JBOD_TOP = -2;
    public static final int RAID_SET_ID_JBOD_BOTTOM = -3;
    static final int DRIVE_ORPHAN = -5;
    static final int DRIVE_EMPTY = -4;
    static final int DRIVE_OFFLINE = -3;
    static final int DRIVE_ASSIGNED = -2;
    static final int DRIVE_SELECTED = -1;
    static final int DRIVE_AVAILABLE = 0;
    static final int ARRAY_VALID = 0;
    static final int ARRAY_INVALID = 1;
    static final int ARRAY_INVALID_NO_DRIVES = 2;
    static final int ARRAY_INVALID_MORE_DRIVES = 3;
    static final int ARRAY_INVALID_WRONG_DRIVES = 4;
    static final int ARRAY_INVALID_NO_LUNS = 5;
    static final int JBOD_INVALID_EXISTING_ARRAY = 6;
    static final int JBOD_INVALID_MORE_DRIVES = 7;
    private static Color hiliteColor = new JTable().getSelectionBackground();
    private static Color badgeColor = Color.getHSBColor(0.0f, 0.0f, 0.4f);
    RaidSystem system;
    int selectionMode;
    boolean expandArbitrary = false;
    int[] driveArrays;
    int[] driveStates;
    float[] driveCapacities;
    String[] arrayDescriptions;
    int[] arrayLevels;
    DriveInformationPanel infoLabel;
    StepByStepPanel summaryHeader;
    JTextPane summary;
    JButton applyButton;
    JLabel[] driveIcon;
    Image emptyImage;
    Image presentImage;
    Image availableImage;
    Image selectedImage;
    Image offlineImage;
    Image deleteImage;
    Image rebuildingImage;
    Image expandImage;
    Image orphanImage;
    int driveIndex = -10;
    int arrayIndex = -10;
    boolean confirmed;
    int level = 0;
    int[] defaultDriveStates = new int[]{-4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4};
    int[] defaultDriveArrays = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    boolean addNotifyCalled = false;
    boolean inDragSelect = false;
    boolean selecting = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DriveSelectionPanel(int n, DriveInformationPanel driveInformationPanel, StepByStepPanel stepByStepPanel, JTextPane jTextPane, JButton jButton) {
        JLabel jLabel;
        MediaTracker mediaTracker;
        GUIFactory.configureComponentForPlatform(this);
        this.driveStates = this.defaultDriveStates;
        this.driveArrays = this.defaultDriveArrays;
        this.selectionMode = n;
        this.infoLabel = driveInformationPanel;
        this.summaryHeader = stepByStepPanel;
        this.summary = jTextPane;
        this.applyButton = jButton;
        if (this.applyButton != null) {
            this.applyButton.setEnabled(false);
        }
        this.emptyImage = Resources.getImage("icon.frontpanel.drive.empty");
        this.presentImage = Resources.getImage("icon.frontpanel.drive.present");
        this.availableImage = Resources.getImage("icon.frontpanel.drive.available");
        this.selectedImage = Resources.getImage("icon.frontpanel.drive.selected");
        this.offlineImage = Resources.getImage("icon.frontpanel.drive.offline");
        this.deleteImage = Resources.getImage("icon.frontpanel.drive.delete");
        this.rebuildingImage = Resources.getImage("icon.frontpanel.drive.rebuilding");
        this.expandImage = Resources.getImage("icon.frontpanel.drive.expand");
        this.orphanImage = Resources.getImage("icon.frontpanel.drive.orphan");
        Serializable serializable = mediaTracker = new MediaTracker(this);
        synchronized (serializable) {
            mediaTracker.addImage(this.emptyImage, 0);
            mediaTracker.addImage(this.presentImage, 0);
            mediaTracker.addImage(this.availableImage, 0);
            mediaTracker.addImage(this.selectedImage, 0);
            mediaTracker.addImage(this.offlineImage, 0);
            mediaTracker.addImage(this.deleteImage, 0);
            mediaTracker.addImage(this.rebuildingImage, 0);
            mediaTracker.addImage(this.expandImage, 0);
            mediaTracker.addImage(this.orphanImage, 0);
            try {
                mediaTracker.waitForID(0, 0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            mediaTracker.removeImage(this.emptyImage, 0);
            mediaTracker.removeImage(this.presentImage, 0);
            mediaTracker.removeImage(this.availableImage, 0);
            mediaTracker.removeImage(this.selectedImage, 0);
            mediaTracker.removeImage(this.offlineImage, 0);
            mediaTracker.removeImage(this.deleteImage, 0);
            mediaTracker.removeImage(this.rebuildingImage, 0);
            mediaTracker.removeImage(this.expandImage, 0);
            mediaTracker.removeImage(this.orphanImage, 0);
        }
        serializable = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout((LayoutManager)((Object)serializable));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        JLabel jLabel2 = new JLabel(new ImageIcon(Resources.getImage("icon.frontpanel.top")));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 17;
        gridBagConstraints.gridheight = 1;
        this.add((Component)jLabel2, gridBagConstraints);
        int n2 = 0;
        JLabel jLabel3 = new JLabel(new ImageIcon(Resources.getImage("icon.frontpanel.left")));
        gridBagConstraints.gridx = n2++;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.add((Component)jLabel3, gridBagConstraints);
        this.driveIcon = new JLabel[14];
        for (int i = 0; i < 14; ++i) {
            this.driveIcon[i] = new JLabel(new ImageIcon(this.emptyImage));
            gridBagConstraints.gridx = n2++;
            gridBagConstraints.gridy = 1;
            this.add((Component)this.driveIcon[i], gridBagConstraints);
            this.driveIcon[i].addMouseListener(new DriveIconListener(i, driveInformationPanel));
            if (i != 6) continue;
            jLabel = new JLabel(new ImageIcon(Resources.getImage("icon.frontpanel.center")));
            gridBagConstraints.gridx = n2++;
            gridBagConstraints.gridy = 1;
            this.add((Component)jLabel, gridBagConstraints);
        }
        JLabel jLabel4 = new JLabel(new ImageIcon(Resources.getImage("icon.frontpanel.right")));
        gridBagConstraints.gridx = n2++;
        gridBagConstraints.gridy = 1;
        this.add((Component)jLabel4, gridBagConstraints);
        jLabel = new JLabel(new ImageIcon(Resources.getImage("icon.frontpanel.bottom")));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 17;
        gridBagConstraints.gridheight = 1;
        this.add((Component)jLabel, gridBagConstraints);
    }

    public void setRaidSystem(RaidSystem raidSystem) {
        this.system = raidSystem;
        this.configureForRaidSystem(this.system);
    }

    public RaidSystem getRaidSystem() {
        return this.system;
    }

    public void setSelectionMode(int n) {
        this.selectionMode = n;
        this.syncDriveIcons();
        this.syncSummary();
    }

    public void setDriveStates(int[] nArray) {
        this.driveStates = nArray != null ? nArray : this.defaultDriveStates;
        this.syncDriveIcons();
    }

    public int[] getDriveStates() {
        return this.driveStates;
    }

    public void setDriveArrays(int[] nArray) {
        this.driveArrays = nArray != null ? nArray : this.defaultDriveArrays;
        this.syncDriveIcons();
    }

    public int[] getDriveArrays() {
        return this.driveArrays;
    }

    public void setDriveCapacities(float[] fArray) {
        this.driveCapacities = fArray;
    }

    public void setArrayDescriptions(String[] stringArray) {
        this.arrayDescriptions = stringArray;
    }

    public void setArrayLevels(int[] nArray) {
        this.arrayLevels = nArray;
    }

    public void setDriveSelected(int n, boolean bl) {
        if (bl) {
            this.selectDrive(n - 1);
        } else {
            this.deselectDrive(n - 1);
        }
    }

    public boolean isDriveSelected(int n) {
        return this.driveStates[n - 1] == -1;
    }

    public void setArraySelected(int n, boolean bl) {
        this.setArrayIndex(bl ? n : -10);
    }

    public boolean isArraySelected(int n) {
        return n - 1 == this.arrayIndex;
    }

    public void setArrayIndex(int n) {
        this.arrayIndex = n;
        if (this.selectionMode == 5) {
            for (int i = 0; i < 14; ++i) {
                if (this.driveArrays[i] != n) continue;
                this.deselectUnavailableDrives(i);
                break;
            }
        }
        this.syncDriveIcons();
        this.syncSummary();
    }

    public void setSelectedArray(int n) {
        this.setArrayIndex(n);
    }

    public int getSelectedArray() {
        return this.getArrayIndex();
    }

    public int getArrayIndex() {
        return this.arrayIndex;
    }

    public boolean isSelectedArray(int n) {
        return n == this.arrayIndex;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isSelectionJbod() {
        return DriveSelectionPanel.isJbod(this.arrayIndex);
    }

    public boolean jbodExists(int n) {
        for (int i = 0; i < this.driveArrays.length; ++i) {
            if (this.driveArrays[i] != n) continue;
            return true;
        }
        return false;
    }

    public void setConfirmed(boolean bl) {
        this.confirmed = bl;
        this.syncSummary();
    }

    public void setSelectedDriveCount(int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < 14; ++n2) {
            if (this.driveStates[n2] != -1) continue;
            this.driveStates[n2] = 0;
        }
        for (n2 = 0; n2 < 14; ++n2) {
            if (this.driveArrays[n2] != this.arrayIndex) continue;
            n3 = n2 < 7 ? 0 : 7;
            float f = 0.0f;
            for (n2 = n3; n2 < n3 + 7; ++n2) {
                if (this.driveArrays[n2] != this.arrayIndex || f != 0.0f && !(this.driveCapacities[n2] < f)) continue;
                f = this.driveCapacities[n2];
            }
            for (n2 = n3; n2 < n3 + 7; ++n2) {
                if (this.driveStates[n2] != 0 || !(this.driveCapacities[n2] >= f) || n-- <= 0) continue;
                this.driveStates[n2] = -1;
            }
            break;
        }
        this.syncDriveIcons();
        this.syncSummary();
    }

    public int getAvailableDriveCount() {
        int n = 0;
        if (this.arrayIndex < 1) {
            return 0;
        }
        for (int i = 0; i < 14; ++i) {
            if (this.driveArrays[i] != this.arrayIndex) continue;
            int n2 = i < 7 ? 0 : 7;
            float f = 0.0f;
            for (i = n2; i < n2 + 7; ++i) {
                if (this.driveArrays[i] != this.arrayIndex || f != 0.0f && !(this.driveCapacities[i] < f)) continue;
                f = this.driveCapacities[i];
            }
            for (i = n2; i < n2 + 7; ++i) {
                if (this.driveStates[i] != 0 && this.driveStates[i] != -1 || !(this.driveCapacities[i] >= f)) continue;
                ++n;
            }
            break;
        }
        return n;
    }

    public void updatePanel() {
        this.configureForRaidSystem(this.system);
    }

    public void resetPanel() {
        this.configureForRaidSystem(null);
    }

    public void configureForRaidSystem(RaidSystem raidSystem) {
        int[] nArray = null;
        int[] nArray2 = null;
        int[] nArray3 = null;
        float[] fArray = null;
        String[] stringArray = null;
        if (raidSystem != null) {
            nArray = DriveSelectionPanel.getDriveStatesFromRaidSystem(raidSystem);
            nArray2 = DriveSelectionPanel.getDriveArraysFromRaidSystem(raidSystem);
            fArray = DriveSelectionPanel.getDriveCapacitiesFromRaidSystem(raidSystem);
            if (this.selectionMode == 5 || this.selectionMode == 6 || this.selectionMode == 7) {
                nArray3 = ArraySelectionPanel.getArrayLevelsFromRaidSystem(raidSystem);
            }
            if (this.infoLabel != null) {
                stringArray = ArraySelectionPanel.getArrayDescriptionsFromRaidSystem(raidSystem);
            }
        }
        this.setDriveStates(nArray);
        this.setDriveArrays(nArray2);
        this.setArrayLevels(nArray3);
        this.setDriveCapacities(fArray);
        this.setArrayDescriptions(stringArray);
        this.syncDriveIcons();
        this.syncSummary();
    }

    public void addNotify() {
        super.addNotify();
        this.addNotifyCalled = true;
        this.syncDriveIcons();
    }

    private void syncDriveIcons() {
        if (!this.addNotifyCalled || this.driveArrays == null || this.driveStates == null) {
            return;
        }
        for (int i = 0; i < 14; ++i) {
            int n = 18;
            int n2 = 68;
            int n3 = 49;
            int n4 = 14;
            Image image = this.createImage(n, n2);
            Graphics graphics = image.getGraphics();
            Image image2 = this.driveStates[i] == -4 ? this.emptyImage : (this.driveStates[i] == -1 ? (this.selectionMode == 5 ? (this.expandArbitrary ? this.selectedImage : this.presentImage) : this.selectedImage) : (this.driveStates[i] == 0 && this.selectionMode == 1 ? this.availableImage : (this.driveStates[i] == 0 && this.selectionMode == 5 ? (this.expandArbitrary ? this.availableImage : this.presentImage) : this.presentImage)));
            graphics.drawImage(image2, 0, 0, null);
            if (image2 == this.availableImage || image2 == this.selectedImage) {
                n3 -= 12;
            }
            if (this.selectionMode == 4 && this.driveArrays[i] == this.arrayIndex || this.selectionMode == 3 && i == this.driveIndex || this.selectionMode == 5 && this.driveArrays[i] == this.arrayIndex || this.selectionMode == 6 && this.driveArrays[i] == this.arrayIndex || this.selectionMode == 7 && this.driveArrays[i] == this.arrayIndex || this.selectionMode == 8 && this.driveArrays[i] == this.arrayIndex || this.selectionMode == 9 && this.driveArrays[i] == this.arrayIndex || (this.selectionMode == 10 || this.selectionMode == 11 || this.selectionMode == 12 || this.selectionMode == 13) && this.driveArrays[i] == this.arrayIndex) {
                this.tintIcon(graphics, n, n2, hiliteColor, 0.7f, true);
            } else if (this.selectionMode == 2 && this.driveArrays[i] == this.arrayIndex) {
                this.tintIcon(graphics, n, n2, Color.red, 0.4f, false);
            }
            if (this.driveArrays[i] != 0) {
                graphics.setColor(badgeColor);
                graphics.fillRect(4, 53, 10, 10);
                graphics.setColor(Color.white);
                graphics.setFont(GUIFactory.FONT_BADGE);
                if (this.driveArrays[i] > 0) {
                    graphics.drawString(this.driveArrays[i] + "", 6, 62);
                } else {
                    graphics.drawString("J", 8, 61);
                }
                n3 -= n4;
            }
            if (this.selectionMode == 5 && this.driveStates[i] == -1) {
                graphics.drawImage(this.expandImage, 0, n3, null);
                n3 -= n4;
            }
            if (this.selectionMode == 2 && this.driveArrays[i] == this.arrayIndex) {
                graphics.drawImage(this.deleteImage, 0, n3 + 1, null);
                n3 -= n4;
            }
            if (this.driveStates[i] == -3) {
                graphics.drawImage(this.offlineImage, 0, n3, null);
                n3 -= n4;
            }
            if (this.driveStates[i] == -5) {
                boolean bl = false;
                if (bl) {
                    boolean bl2;
                    Disk disk;
                    int n5 = 0;
                    if (this.system != null && (disk = this.system.getDisk(i + 1)) != null) {
                        n5 = disk.getOrphanRaidSetId();
                    }
                    graphics.setColor(badgeColor);
                    graphics.fillRect(4, 53, 10, 10);
                    graphics.setColor(Color.white);
                    graphics.setFont(GUIFactory.FONT_BADGE);
                    if (n5 > 0) {
                        graphics.drawString(n5 + "", 6, 62);
                    }
                    if ((bl2 = false) && n5 == 0) {
                        graphics.drawString("?", 7, 61);
                    }
                    graphics.drawImage(this.orphanImage, 4, (n3 -= n4) + 6, null);
                } else {
                    graphics.drawImage(this.orphanImage, 4, n3 + 4, null);
                    n3 -= n4;
                }
            }
            this.driveIcon[i].setIcon(new ImageIcon(image));
        }
    }

    private void tintIcon(Graphics graphics, int n, int n2, Color color, float f, boolean bl) {
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f);
        Composite composite = ((Graphics2D)graphics).getComposite();
        ((Graphics2D)graphics).setComposite(alphaComposite);
        graphics.setColor(color);
        graphics.fillRect(1, 1, n - 2, n2 - 2);
        ((Graphics2D)graphics).setComposite(composite);
        if (bl) {
            graphics.setColor(color);
            graphics.drawRect(1, 1, n - 3, n2 - 3);
            graphics.drawRect(2, 2, n - 5, n2 - 5);
        }
    }

    private boolean toggleDrive(int n) {
        boolean bl = false;
        if (this.driveStates[n] == 0 || this.selectionMode == 5 && this.driveStates[n] == -2) {
            this.selectDrive(n);
            bl = true;
        } else if (this.driveStates[n] == -1) {
            this.deselectDrive(n);
        }
        return bl;
    }

    private void selectDrive(int n) {
        if (this.selectionMode == 4 && this.driveStates[n] == -3) {
            this.selectionMode = 3;
            this.firePropertyChange("SelectionMode", -1, this.selectionMode);
        }
        if (this.selectionMode == 3) {
            this.driveIndex = n;
            this.syncDriveIcons();
            this.firePropertyChange("DriveIndex", -1, this.driveIndex);
        }
        if ((this.selectionMode == 4 || this.selectionMode == 2 || this.selectionMode == 5 || this.selectionMode == 6 || this.selectionMode == 7 || this.selectionMode == 8 || this.selectionMode == 9 || this.selectionMode == 10 || this.selectionMode == 11 || this.selectionMode == 12 || this.selectionMode == 13) && this.driveStates[n] == -2) {
            this.arrayIndex = this.driveArrays[n];
            this.syncDriveIcons();
            this.syncSummary();
            this.firePropertyChange("ArrayIndex", -1, this.arrayIndex);
            if (this.selectionMode == 5) {
                this.deselectUnavailableDrives(n);
            }
        }
        if ((this.selectionMode == 1 || this.selectionMode == 5 && this.expandArbitrary) && this.driveStates[n] == 0) {
            this.driveStates[n] = -1;
            this.syncDriveIcons();
            this.deselectUnavailableDrives(n);
        }
    }

    private void deselectDrive(int n) {
        if (this.driveStates[n] == -1) {
            this.driveStates[n] = 0;
            this.syncDriveIcons();
        }
    }

    private void deselectUnavailableDrives(int n) {
        RaidController raidController = this.system.getRaidControllerForDiskSlot(n + 1);
        if (raidController != null) {
            for (int i = 0; i < 14; ++i) {
                if (this.system.getRaidControllerForDiskSlot(i + 1) == raidController) continue;
                if (this.selectionMode == 5 && this.driveArrays[i] == this.arrayIndex) {
                    this.arrayIndex = -10;
                    this.syncDriveIcons();
                    this.firePropertyChange("ArrayIndex", -1, this.arrayIndex);
                }
                if (this.driveStates[i] != -1) continue;
                this.deselectDrive(i);
            }
        }
    }

    public void syncSummary() {
        boolean bl;
        String string = null;
        boolean bl2 = bl = this.arrayIndex > 0 && this.arrayOnline(this.arrayIndex);
        if (this.selectionMode == 1) {
            int n = this.checkArray();
            if (n == 0) {
                float f = this.getArrayCapacity();
                String string2 = this.getCapacityString(f);
                this.summaryHeader.setIcon(Resources.getImage("icon.step.four"));
                if (this.level != 255) {
                    string = Resources.getString("management.create.summary.can");
                    string = StringUtilities.replaceAll(string, "{level}", CreateArrayPane.levelNames[this.level]);
                    string = StringUtilities.replaceAll(string, "{capacity}", string2);
                } else {
                    string = Resources.getString("management.create.summary.can.jbod");
                }
                this.applyButton.setEnabled(true);
            } else {
                string = this.level != 255 ? Resources.getString("management.create.summary.cannot") : Resources.getString("management.create.summary.cannot.jbod");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                string = n == 2 ? StringUtilities.replaceAll(string, "{reason}", Resources.getString("management.create.summary.reason.noDrives")) : (n == 5 ? StringUtilities.replaceAll(string, "{reason}", Resources.getString("management.create.summary.reason.noLuns")) : (n == 3 ? StringUtilities.replaceAll(string, "{reason}", Resources.getString("management.create.summary.reason.moreDrives")) : (n == 4 ? StringUtilities.replaceAll(string, "{reason}", Resources.getString("management.create.summary.reason.wrongDrives")) : (n == 6 ? StringUtilities.replaceAll(string, "{reason}", Resources.getString("management.create.summary.reason.jbod.existingArray")) : (n == 7 ? StringUtilities.replaceAll(string, "{reason}", Resources.getString("management.create.summary.reason.jbod.moreDrives")) : StringUtilities.replaceAll(string, "{reason}", Resources.getString("management.create.summary.reason.unknown")))))));
                this.applyButton.setEnabled(false);
            }
        } else if (this.selectionMode == 2) {
            if ((this.arrayIndex > 0 || DriveSelectionPanel.isJbod(this.arrayIndex)) && this.confirmed) {
                this.summaryHeader.setIcon(Resources.getImage("icon.step.four"));
                if (DriveSelectionPanel.isJbod(this.arrayIndex)) {
                    string = Resources.getString("management.delete.summary.can.jbod");
                } else {
                    string = Resources.getString("management.delete.summary.can");
                    string = StringUtilities.replaceAll(string, "{index}", "" + this.arrayIndex);
                }
                this.applyButton.setEnabled(true);
            } else {
                string = Resources.getString("management.delete.summary.cannot");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            }
            String string3 = Resources.getString(DriveSelectionPanel.isJbod(this.arrayIndex) ? "management.delete.deleteButton.jbod" : "management.delete.deleteButton");
            this.applyButton.setText(string3);
        } else if (this.selectionMode == 5) {
            int n = this.countSelectedDrives();
            if (this.arrayIndex > 0 && this.arrayLevels[this.arrayIndex - 1] == 4 || DriveSelectionPanel.isJbod(this.arrayIndex)) {
                string = this.arrayIndex > 0 ? Resources.getString("advanced.expansion.summary.cannot.wrongType") : Resources.getString("advanced.expansion.summary.cannot.jbod");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else if (this.arrayIndex > 0 && !bl) {
                string = Resources.getString("advanced.expansion.summary.cannot.notOnline");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else if (this.arrayIndex > 0 && this.arrayControllerAlreadyBusy()) {
                string = this.arrayBusy(this.arrayIndex) ? Resources.getString("advanced.expansion.summary.cannot.busy.self") : Resources.getString("advanced.expansion.summary.cannot.busy");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else if (this.arrayIndex > 0 && n > 0 && this.confirmed) {
                this.level = this.arrayLevels[this.arrayIndex - 1];
                float f = this.getArrayCapacity();
                String string4 = this.getCapacityString(f);
                this.summaryHeader.setIcon(Resources.getImage("icon.step.four"));
                string = Resources.getString("advanced.expansion.summary.can");
                string = StringUtilities.replaceAll(string, "{index}", "" + this.arrayIndex);
                string = StringUtilities.replaceAll(string, "{capacity}", string4);
                this.applyButton.setEnabled(true);
            } else {
                string = Resources.getString("advanced.expansion.summary.cannot.general");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            }
        } else if (this.selectionMode == 6 || this.selectionMode == 7) {
            int n = this.countSelectedDrives();
            if (this.arrayIndex > 0 && this.arrayLevels[this.arrayIndex - 1] != 2 && this.arrayLevels[this.arrayIndex - 1] != 3 || DriveSelectionPanel.isJbod(this.arrayIndex)) {
                if (!DriveSelectionPanel.isJbod(this.arrayIndex)) {
                    string = Resources.getString(this.selectionMode == 6 ? "firstAid.verify.summary.cannot.wrongType" : "firstAid.rebuild.summary.cannot.wrongType");
                    string = StringUtilities.replaceAll(string, "{index}", "" + this.arrayIndex);
                } else {
                    string = Resources.getString(this.selectionMode == 6 ? "firstAid.verify.summary.cannot.jbod" : "firstAid.rebuild.summary.cannot.jbod");
                }
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else if (this.arrayIndex > 0 && !bl) {
                string = Resources.getString(this.selectionMode == 6 ? "firstAid.verify.summary.cannot.online" : "firstAid.rebuild.summary.cannot.online");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else if (this.arrayIndex > 0 && this.arrayControllerAlreadyBusy()) {
                string = this.arrayBusy(this.arrayIndex) ? Resources.getString(this.selectionMode == 6 ? "firstAid.verify.summary.cannot.busySelf" : "firstAid.rebuild.summary.cannot.busySelf") : Resources.getString(this.selectionMode == 6 ? "firstAid.verify.summary.cannot.busy" : "firstAid.rebuild.summary.cannot.busy");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else if (this.arrayIndex > 0 && this.confirmed) {
                string = Resources.getString(this.selectionMode == 6 ? "firstAid.verify.summary.can" : "firstAid.rebuild.summary.can");
                string = StringUtilities.replaceAll(string, "{index}", "" + this.arrayIndex);
                this.summaryHeader.setIcon(Resources.getImage("icon.step.four"));
                this.applyButton.setEnabled(true);
            } else {
                string = Resources.getString(this.selectionMode == 6 ? "firstAid.verify.summary.cannot.general" : "firstAid.rebuild.summary.cannot.general");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            }
        } else if (this.selectionMode == 10) {
            if (DriveSelectionPanel.isJbod(this.arrayIndex)) {
                string = Resources.getString("firstAid.condition.summary.cannot.jbod");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else if (this.arrayIndex > 0 && this.arrayControllerAlreadyBusy()) {
                if (this.arrayBusy(this.arrayIndex)) {
                    string = Resources.getString("firstAid.condition.summary.cannot.busySelf");
                    this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                    this.applyButton.setEnabled(false);
                } else {
                    RaidSet raidSet = this.busyRaidSet();
                    if (raidSet != null) {
                        int n = raidSet.getOperation();
                        if (n == 5) {
                            string = Resources.getString("firstAid.condition.summary.can.start");
                            string = StringUtilities.replaceAll(string, "{index}", "" + this.arrayIndex);
                            this.summaryHeader.setIcon(Resources.getImage("icon.step.four"));
                            this.applyButton.setEnabled(true);
                        } else {
                            string = Resources.getString("firstAid.condition.summary.cannot.busy");
                            this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                            this.applyButton.setEnabled(false);
                        }
                    }
                }
            } else if (this.arrayIndex > 0 && !bl) {
                string = Resources.getString("firstAid.condition.summary.cannot.notOnline");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else if (this.arrayIndex > 0 && this.confirmed) {
                string = Resources.getString("firstAid.condition.summary.can.start");
                string = StringUtilities.replaceAll(string, "{index}", "" + this.arrayIndex);
                this.summaryHeader.setIcon(Resources.getImage("icon.step.four"));
                this.applyButton.setEnabled(true);
            } else {
                string = Resources.getString("firstAid.condition.summary.cannot.general");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            }
        } else if (this.selectionMode == 12) {
            RaidSet raidSet;
            int n = -1;
            int n2 = -1;
            if (this.arrayIndex > 0 && (raidSet = this.system.getRaidSet(this.arrayIndex)) != null) {
                n = raidSet.getOperation();
                n2 = raidSet.getBackgroundConditioningState();
            }
            if (n != 5 || n2 != 1) {
                string = Resources.getString("firstAid.condition.summary.cannot.general");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else if (this.arrayIndex > 0 && !bl) {
                string = Resources.getString("firstAid.condition.summary.cannot.notOnline");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else if (this.arrayIndex > 0 && this.confirmed) {
                string = Resources.getString("firstAid.condition.summary.can.resume");
                string = StringUtilities.replaceAll(string, "{index}", "" + this.arrayIndex);
                this.summaryHeader.setIcon(Resources.getImage("icon.step.four"));
                this.applyButton.setEnabled(true);
            } else {
                string = Resources.getString("firstAid.condition.summary.cannot.general");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            }
        } else if (this.selectionMode == 11 || this.selectionMode == 13) {
            if (this.arrayIndex > 0 && this.confirmed) {
                string = Resources.getString(this.selectionMode == 11 ? "firstAid.condition.summary.can.pause" : "firstAid.condition.summary.can.stop");
                string = StringUtilities.replaceAll(string, "{index}", "" + this.arrayIndex);
                this.summaryHeader.setIcon(Resources.getImage("icon.step.four"));
                this.applyButton.setEnabled(true);
            } else {
                string = Resources.getString("firstAid.condition.summary.cannot.general");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            }
        } else if (this.selectionMode == 8 || this.selectionMode == 9) {
            boolean bl3 = false;
            if (this.selectionMode == 9 || this.selectionMode == 8 && this.countAvailableLuns() > 0) {
                bl3 = true;
            }
            if (this.arrayIndex > 0 && this.confirmed && bl3 && bl) {
                this.summaryHeader.setIcon(Resources.getImage("icon.step.four"));
                string = this.selectionMode == 8 ? Resources.getString("advanced.slicing.summary.can.slice") : Resources.getString("advanced.slicing.summary.can.merge");
                string = StringUtilities.replaceAll(string, "{index}", "" + this.arrayIndex);
                this.applyButton.setEnabled(true);
            } else if (DriveSelectionPanel.isJbod(this.arrayIndex)) {
                string = Resources.getString("advanced.slicing.summary.cannot.jbod");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else if (this.arrayIndex > 0 && !bl) {
                string = Resources.getString("advanced.slicing.summary.cannot.notOnline");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            } else {
                string = Resources.getString("advanced.slicing.summary.cannot.general");
                this.summaryHeader.setIcon(Resources.getImage("icon.step.five"));
                this.applyButton.setEnabled(false);
            }
        }
        if (this.summary != null && string != null) {
            this.summary.setText(string);
        }
    }

    public int checkArray() {
        if (this.driveArrays == null) {
            return 2;
        }
        int n = this.countSelectedDrives();
        if (n == 0) {
            return 2;
        }
        if (this.level == 0 || this.level == 1) {
            if (n < 2) {
                return 3;
            }
        } else if (this.level == 2 || this.level == 3) {
            if (n < 3) {
                return 3;
            }
        } else if (this.level == 4) {
            if (n != 4 && n != 6) {
                return 4;
            }
        } else if (this.level == 255) {
            int n2;
            int n3;
            int n4 = this.indexOfFirstSelectedDrive();
            if (n4 == -1) {
                return 2;
            }
            for (n3 = n2 = n4 < 7 ? 0 : 7; n3 < n2 + 7; ++n3) {
                if (this.driveArrays[n3] == 0) continue;
                return 6;
            }
            for (n3 = n2; n3 < n2 + 7; ++n3) {
                if (this.driveStates[n3] == 0) {
                    return 7;
                }
                if (this.driveStates[n3] != -2) continue;
                return 6;
            }
        } else {
            return 1;
        }
        if (this.countAvailableLuns() == 0) {
            return 5;
        }
        return 0;
    }

    private int indexOfFirstSelectedDrive() {
        int n;
        for (n = 0; n < this.driveStates.length && this.driveStates[n] != -1; ++n) {
        }
        return n < this.driveStates.length ? n : -1;
    }

    public boolean arrayOnline(int n) {
        RaidSet raidSet;
        boolean bl = false;
        if (this.system != null && (raidSet = this.system.getRaidSet(n)) != null) {
            bl = raidSet.getState() == 0;
        }
        return bl;
    }

    public boolean arrayBusy(int n) {
        RaidSet raidSet;
        boolean bl = false;
        if (this.system != null && (raidSet = this.system.getRaidSet(n)) != null) {
            int n2 = raidSet.getOperation();
            bl = n2 == 1 || n2 == 2 || n2 == 3 || n2 == 4 || n2 == 5;
        }
        return bl;
    }

    public int getSelectionCount() {
        return this.countSelectedDrives();
    }

    public int countSelectedDrives() {
        int n = 0;
        for (int i = 0; i < 14; ++i) {
            if (this.driveStates[i] != -1) continue;
            ++n;
        }
        return n;
    }

    public int countAvailableLuns() {
        RaidController raidController;
        int n;
        int n2 = 0;
        int n3 = -1;
        if (this.selectionMode == 1) {
            for (n = 0; n < 14; ++n) {
                if (this.driveStates[n] != -1) continue;
                n3 = n;
                break;
            }
        } else if (this.selectionMode == 8) {
            for (n = 0; n < 14; ++n) {
                if (this.driveArrays[n] != this.arrayIndex) continue;
                n3 = n;
                break;
            }
        }
        if (n3 != -1 && (raidController = this.system.getRaidControllerForDiskSlot(n3 + 1)) != null) {
            if (this.selectionMode == 1) {
                n2 = raidController.getLunsRemainingForCreation();
            } else if (this.selectionMode == 8) {
                n2 = raidController.getLunsRemainingForSlicing();
            }
        }
        return n2;
    }

    public boolean arrayControllerAlreadyBusy() {
        RaidSet raidSet = this.busyRaidSet();
        boolean bl = raidSet != null;
        return bl;
    }

    private RaidSet busyRaidSet() {
        RaidController raidController;
        RaidSet raidSet = null;
        int n = -1;
        for (int i = 0; i < 14; ++i) {
            if (this.driveArrays[i] != this.arrayIndex) continue;
            n = i;
            break;
        }
        if (n != -1 && (raidController = this.system.getRaidControllerForDiskSlot(n + 1)) != null) {
            Collection collection = raidController.getRaidSets();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                RaidSet raidSet2 = (RaidSet)iterator.next();
                int n2 = raidSet2.getOperation();
                if (n2 != 1 && n2 != 4 && n2 != 3 && n2 != 2 && n2 != 5) continue;
                raidSet = raidSet2;
                break;
            }
        }
        return raidSet;
    }

    public float getArrayCapacity() {
        int n;
        float f = 0.0f;
        int n2 = 0;
        float f2 = 0.0f;
        for (n = 0; n < 14; ++n) {
            if (this.driveStates[n] != -1 && (this.selectionMode != 5 || this.driveArrays[n] != this.arrayIndex)) continue;
            ++n2;
        }
        for (n = 0; n < 14; ++n) {
            if (this.driveStates[n] != -1 && (this.selectionMode != 5 || this.driveArrays[n] != this.arrayIndex) || (double)f2 != 0.0 && !(this.driveCapacities[n] < f2)) continue;
            f2 = this.driveCapacities[n];
        }
        if (this.level == 0) {
            f = f2 * (float)n2;
        } else if (this.level == 1) {
            f = f2;
        } else if (this.level == 2 || this.level == 3) {
            f = f2 * (float)(n2 - 1);
        } else if (this.level == 4) {
            f = f2 * (float)(n2 / 2);
        } else if (this.level == 255) {
            f = 0.0f;
        } else {
            throw new RuntimeException("Unrecognized RAID level: " + this.level);
        }
        return f;
    }

    String getCapacityString(float f) {
        String string;
        float f2 = (double)f < 1024.0 ? f : f / 1024.0f;
        int n = (int)((double)f2 * 10000.0);
        if (n % 100 > 49) {
            n += 100;
        }
        f2 = (float)(n /= 100) / 100.0f;
        if ((double)f < 1024.0) {
            string = Resources.getString("management.create.capacity.gb");
            string = StringUtilities.replaceAll(string, "{number}", "" + f2);
        } else {
            string = Resources.getString("management.create.capacity.tb");
            string = StringUtilities.replaceAll(string, "{number}", "" + f2);
        }
        return string;
    }

    static int[] getDriveArraysFromRaidSystem(RaidSystem raidSystem) {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        Collection collection = raidSystem.getDiskSlots();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            DiskSlot diskSlot = (DiskSlot)iterator.next();
            int n = diskSlot.getId() - 1;
            if (!diskSlot.isPopulated()) continue;
            Disk disk = diskSlot.getDisk();
            if (disk.getType() == 1) {
                RaidSet raidSet = disk.getRaidSet();
                if (raidSet == null) continue;
                nArray[n] = raidSet.getId();
                continue;
            }
            if (disk.getType() != 3) continue;
            nArray[n] = n < 7 ? -2 : -3;
        }
        return nArray;
    }

    static int[] getDriveStatesFromRaidSystem(RaidSystem raidSystem) {
        int[] nArray = new int[]{-4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4};
        Collection collection = raidSystem.getDiskSlots();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            DiskSlot diskSlot = (DiskSlot)iterator.next();
            int n = diskSlot.getId() - 1;
            if (diskSlot.isPopulated()) {
                Disk disk = diskSlot.getDisk();
                if (disk.getStatus() == 0) {
                    if (disk.getType() == 1) {
                        RaidSet raidSet = disk.getRaidSet();
                        if (raidSet != null) {
                            nArray[n] = -2;
                            continue;
                        }
                        nArray[n] = 0;
                        continue;
                    }
                    if (disk.getType() == 3) {
                        nArray[n] = -2;
                        continue;
                    }
                    if (disk.getType() == 4) {
                        nArray[n] = -5;
                        continue;
                    }
                    nArray[n] = 0;
                    continue;
                }
                nArray[n] = -3;
                continue;
            }
            nArray[n] = -4;
        }
        return nArray;
    }

    static float[] getDriveCapacitiesFromRaidSystem(RaidSystem raidSystem) {
        float[] fArray = new float[14];
        Collection collection = raidSystem.getDiskSlots();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            DiskSlot diskSlot = (DiskSlot)iterator.next();
            int n = diskSlot.getId() - 1;
            if (diskSlot.isPopulated()) {
                Disk disk = diskSlot.getDisk();
                fArray[n] = (float)CapacityConverter.toGigabytes(disk.getCapacityBytes());
                continue;
            }
            fArray[n] = 0.0f;
        }
        return fArray;
    }

    public static boolean isJbod(int n) {
        return n == -2 || n == -3;
    }

    class DriveIconListener
    implements MouseListener {
        int drive;
        DriveInformationPanel infoLabel;

        DriveIconListener(int n, DriveInformationPanel driveInformationPanel) {
            this.drive = n;
            this.infoLabel = driveInformationPanel;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            DriveSelectionPanel.this.inDragSelect = true;
            if (mouseEvent.isAltDown()) {
                if (DriveSelectionPanel.this.selectionMode == 3 && DriveSelectionPanel.this.driveArrays[this.drive] > 0) {
                    DriveSelectionPanel.this.selectionMode = 4;
                    DriveSelectionPanel.this.firePropertyChange("SelectionMode", -1, DriveSelectionPanel.this.selectionMode);
                } else if (DriveSelectionPanel.this.selectionMode == 4) {
                    DriveSelectionPanel.this.selectionMode = 3;
                    DriveSelectionPanel.this.firePropertyChange("SelectionMode", -1, DriveSelectionPanel.this.selectionMode);
                }
            }
            if (DriveSelectionPanel.this.selectionMode == 1 || DriveSelectionPanel.this.selectionMode == 5 && DriveSelectionPanel.this.expandArbitrary) {
                DriveSelectionPanel.this.selecting = DriveSelectionPanel.this.toggleDrive(this.drive);
            } else {
                DriveSelectionPanel.this.selecting = true;
                DriveSelectionPanel.this.selectDrive(this.drive);
            }
            DriveSelectionPanel.this.syncSummary();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            DriveSelectionPanel.this.inDragSelect = false;
            DriveSelectionPanel.this.syncSummary();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (DriveSelectionPanel.this.inDragSelect) {
                if (DriveSelectionPanel.this.selecting) {
                    DriveSelectionPanel.this.selectDrive(this.drive);
                } else {
                    DriveSelectionPanel.this.deselectDrive(this.drive);
                }
                DriveSelectionPanel.this.syncSummary();
            }
            if (this.infoLabel != null) {
                int n = DriveSelectionPanel.this.driveStates[this.drive];
                if (n == -4) {
                    this.infoLabel.setText(StringUtilities.replaceAll(Resources.getString("management.driveInfo.empty"), "{number}", "" + (this.drive + 1)));
                } else if (n == -3) {
                    this.infoLabel.setText(StringUtilities.replaceAll(Resources.getString("management.driveInfo.offline"), "{number}", "" + (this.drive + 1)));
                } else if (n == -5) {
                    this.infoLabel.setText(StringUtilities.replaceAll(Resources.getString("management.driveInfo.orphan.note"), "{number}", "" + (this.drive + 1)));
                } else if (n == -2) {
                    String string;
                    int n2 = DriveSelectionPanel.this.driveArrays[this.drive];
                    if (n2 > 0) {
                        string = StringUtilities.replaceAll(Resources.getString("management.driveInfo.assigned"), "{number}", "" + (this.drive + 1));
                        string = StringUtilities.replaceAll(string, "{index}", "" + n2);
                        string = StringUtilities.replaceAll(string, "{description}", DriveSelectionPanel.this.arrayDescriptions[n2 - 1]);
                    } else {
                        string = StringUtilities.replaceAll(Resources.getString("management.driveInfo.jbod"), "{number}", "" + (this.drive + 1));
                        string = StringUtilities.replaceAll(string, "{capacity}", DriveSelectionPanel.this.getCapacityString(DriveSelectionPanel.this.driveCapacities[this.drive]));
                    }
                    this.infoLabel.setText(string);
                } else {
                    String string = StringUtilities.replaceAll(Resources.getString("management.driveInfo.unassigned"), "{number}", "" + (this.drive + 1));
                    string = StringUtilities.replaceAll(string, "{capacity}", DriveSelectionPanel.this.getCapacityString(DriveSelectionPanel.this.driveCapacities[this.drive]));
                    this.infoLabel.setText(string);
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (this.infoLabel != null) {
                this.infoLabel.setText(Resources.getString("management.driveInfo.note"));
            }
        }
    }
}

