/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.xsr.DrivePanelEvent;
import com.apple.xsr.DrivePanelListener;
import com.apple.xsr.DrivePanelSelectionModel;
import com.apple.xsr.DrivePanelSelectionPolicy;
import com.apple.xsr.som.RaidSystem;
import java.beans.PropertyChangeListener;
import javax.swing.event.EventListenerList;

public interface DrivePanel {
    public static final int SELECTION_COLOR_NORMAL = 0;
    public static final int SELECTION_COLOR_DANGER = 1;
    public static final int BADGE_DEFAULT = 0;
    public static final int BADGE_EXPAND = 1;
    public static final int INFO_ICON_DELETE = 0;
    public static final int INDEX_NONE = -10;
    public static final int RAID_SET_ID_JBOD_TOP = -2;
    public static final int RAID_SET_ID_JBOD_BOTTOM = -3;
    public static final int TYPE_UNASSIGNED = 0;
    public static final int TYPE_RAID_MEMBER = 1;
    public static final int TYPE_JBOD = 3;
    public static final int TYPE_ORPHAN = 4;
    public static final int STATE_ONLINE = 1;
    public static final int STATE_OFFLINE = 0;
    public static final int STATE_PREDICTIVE_FAILURE = 2;
    public static final int STATE_EMPTY = -2;

    public void setRaidSystem(RaidSystem var1);

    public RaidSystem getRaidSystem();

    public void setSelectionMode(int var1);

    public void setDriveSelected(int var1, boolean var2);

    public boolean isDriveSelected(int var1);

    public void setArraySelected(int var1, boolean var2);

    public boolean isArraySelected(int var1);

    public int getSelectionCount();

    public void setSelectedArray(int var1);

    public int getSelectedArray();

    public void addPropertyChangeListener(String var1, PropertyChangeListener var2);

    public void setConfirmed(boolean var1);

    static class 1 {
        static /* synthetic */ Class class$com$apple$xsr$DrivePanelListener;

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static class DefaultSelectionPolicy
    implements DrivePanelSelectionPolicy {
        protected int selectableStates = 0;
        protected int selectableTypes = 0;

        public DefaultSelectionPolicy() {
        }

        public DefaultSelectionPolicy(int n, int n2) {
            this.selectableStates = n;
            this.selectableTypes = n2;
        }

        public void setSelectableStates(int n) {
            this.selectableStates = n;
        }

        public int getSelectableStates() {
            return this.selectableStates;
        }

        public void setSelectableTypes(int n) {
            this.selectableTypes = n;
        }

        public int getSelectableTypes() {
            return this.selectableTypes;
        }

        public boolean isStateSelectable(int n) {
            if (this.selectableStates == -1) {
                return true;
            }
            return this.selectableStates == n;
        }

        public boolean isTypeSelectable(int n) {
            if (this.selectableTypes == -1) {
                return true;
            }
            return this.selectableTypes == n;
        }

        public boolean isSelectable(int n, int n2) {
            return this.isStateSelectable(n) && this.isTypeSelectable(n2);
        }
    }

    public static class DefaultSelectionModel
    implements DrivePanelSelectionModel {
        private static final int DRIVE_COUNT = 14;
        private static final int ARRAY_COUNT = 8;
        private int mode = 1;
        private int style = 0;
        private boolean[] driveSelections = new boolean[14];
        private boolean[] arraySelections = new boolean[8];
        private boolean isAdjusting = false;
        private final EventListenerList listenerList = new EventListenerList();

        public DefaultSelectionModel() {
            int n;
            for (n = 0; n < this.driveSelections.length; ++n) {
                this.driveSelections[n] = false;
            }
            for (n = 0; n < this.arraySelections.length; ++n) {
                this.arraySelections[n] = false;
            }
        }

        public void addDrivePanelListener(DrivePanelListener drivePanelListener) {
            this.listenerList.add(1.class$com$apple$xsr$DrivePanelListener == null ? (1.class$com$apple$xsr$DrivePanelListener = 1.class$("com.apple.xsr.DrivePanelListener")) : 1.class$com$apple$xsr$DrivePanelListener, drivePanelListener);
        }

        public void removeDrivePanelListener(DrivePanelListener drivePanelListener) {
            this.listenerList.remove(1.class$com$apple$xsr$DrivePanelListener == null ? (1.class$com$apple$xsr$DrivePanelListener = 1.class$("com.apple.xsr.DrivePanelListener")) : 1.class$com$apple$xsr$DrivePanelListener, drivePanelListener);
        }

        public void setSelectionMode(int n) {
            this.mode = n;
        }

        public int getSelectionMode() {
            return this.mode;
        }

        public void setSelectionStyle(int n) {
            this.style = n;
        }

        public int getSelectionStyle() {
            return this.style;
        }

        public void setSelectionIsAdjusting(boolean bl) {
            this.isAdjusting = bl;
        }

        public void setDriveSelected(int n, boolean bl) {
            if (this.driveSelections[n - 1] != bl) {
                this.driveSelections[n - 1] = bl;
                this.fireValueChanged(3, n, bl ? 1 : 2, this.isAdjusting);
            }
        }

        public void setArraySelected(int n, boolean bl) {
            if (this.arraySelections[n - 1] != bl) {
                this.arraySelections[n - 1] = bl;
                this.fireValueChanged(4, n, bl ? 1 : 2, this.isAdjusting);
            }
        }

        public void clearSelection() {
            int n;
            for (n = 0; n < this.driveSelections.length; ++n) {
                this.driveSelections[n] = false;
            }
            for (n = 0; n < this.arraySelections.length; ++n) {
                this.arraySelections[n] = false;
            }
        }

        public int[] getSelectedDrives() {
            int[] nArray = null;
            int n = 0;
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < this.driveSelections.length; ++j) {
                    if (!this.driveSelections[j]) continue;
                    if (nArray != null) {
                        nArray[n] = j + 1;
                    }
                    ++n;
                }
                if (nArray != null) continue;
                nArray = new int[n];
                n = 0;
            }
            return nArray;
        }

        public boolean isDriveSelected(int n) {
            if (n < 1 || n > 14) {
                throw new IndexOutOfBoundsException("driveID " + n + " out of bounds");
            }
            return this.driveSelections[n - 1];
        }

        public boolean isArraySelected(int n) {
            if (n < 1 || n > 8) {
                throw new IndexOutOfBoundsException("arrayID " + n + " out of bounds");
            }
            return this.arraySelections[n - 1];
        }

        public int getSelectionCount() {
            boolean[] blArray = this.mode == 1 ? this.driveSelections : this.arraySelections;
            int n = 0;
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                ++n;
            }
            return n;
        }

        private void fireValueChanged(int n, int n2, int n3, boolean bl) {
            Object[] objectArray = this.listenerList.getListenerList();
            DrivePanelEvent drivePanelEvent = null;
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != (1.class$com$apple$xsr$DrivePanelListener == null ? 1.class$("com.apple.xsr.DrivePanelListener") : 1.class$com$apple$xsr$DrivePanelListener)) continue;
                if (drivePanelEvent == null) {
                    drivePanelEvent = new DrivePanelEvent(n, this, n2, n3, bl);
                }
                ((DrivePanelListener)objectArray[i + 1]).valueChanged(drivePanelEvent);
            }
        }
    }
}

