/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.util.prefs.Preferences;
import com.apple.xsr.SOMLocalizer;
import com.apple.xsr.SystemRegistry;
import com.apple.xsr.net.CommunicationHandler;
import com.apple.xsr.net.Response;
import com.apple.xsr.som.RaidSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Observable;

public class DefaultSystemRegistry
extends SystemRegistry
implements CommunicationHandler {
    public DefaultSystemRegistry() {
        ArrayList arrayList;
        Preferences preferences = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
        if (preferences.exists("Systems") && (arrayList = preferences.getArray("Systems", null)) != null) {
            Map map = null;
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                String string = null;
                RaidSystem raidSystem = null;
                ArrayList arrayList2 = null;
                map = (Map)listIterator.next();
                arrayList2 = (ArrayList)map.get("IPAddress");
                if (arrayList2 == null) continue;
                boolean bl = false;
                string = (String)arrayList2.get(0);
                raidSystem = new RaidSystem(string);
                raidSystem.setName((String)map.get("Name"));
                Object v = map.get("Rate");
                if (v != null) {
                    raidSystem.setPollDelay(((Long)v).intValue());
                }
                raidSystem.setUserMessageIndex(2);
                string = (String)map.get("Attributes");
                if (string == null) {
                    string = "";
                } else {
                    raidSystem.setMonitoringPassword(string);
                }
                raidSystem.connect(this, "guest", string, false);
                this.add(raidSystem);
            }
        }
    }

    public void handleResponse(RaidSystem raidSystem, Response response, Object object) {
        int n = response.getResultCode();
        if (n == 0) {
            raidSystem.setUserMessageIndex(3);
        } else if (n == -101) {
            raidSystem.setUserMessageIndex(4);
        } else if (n == -16 || n == -27 || n == -28) {
            raidSystem.setUserMessageIndex(11);
        }
    }

    public void update(Observable observable, Object object) {
        super.update(observable, object);
        this.synchronizePrefs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizePrefs() {
        Preferences preferences = Preferences.getPreferences("com.apple.RAIDAdmin.plist");
        ArrayList<Map> arrayList = new ArrayList<Map>();
        ArrayList arrayList2 = preferences.getArray("Systems", null);
        List list = this.list;
        synchronized (list) {
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                RaidSystem raidSystem = (RaidSystem)iterator.next();
                Map map = SOMLocalizer.toPrefsContainer(raidSystem);
                arrayList.add(map);
            }
        }
        if (arrayList.equals(arrayList2)) {
            return;
        }
        preferences.setArray("Systems", arrayList);
        preferences.synchronize();
    }

    public void remove(String string) {
        super.remove(string);
        this.synchronizePrefs();
    }

    public void remove(RaidSystem raidSystem) {
        super.remove(raidSystem);
        this.synchronizePrefs();
    }

    public void remove(RaidSystem[] raidSystemArray) {
        super.remove(raidSystemArray);
        this.synchronizePrefs();
    }
}

