/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.xsr.RadioButtonGroup;
import com.apple.xsr.Resources;
import com.apple.xsr.SOMLocalizer;
import com.apple.xsr.StatusIcon;
import com.apple.xsr.som.AbstractSystemElement;
import com.apple.xsr.som.Disk;
import com.apple.xsr.som.RaidController;
import com.apple.xsr.som.RaidSet;
import com.apple.xsr.som.RaidSystem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.EventListenerList;

public class ArraySelectionPanel
extends JPanel {
    public static final int ARRAY_COUNT = 6;
    public static final int NO_SELECTION = 0;
    public static final int SINGLE_SELECTION = 1;
    public static final int MULTIPLE_SELECTION = 2;
    public static final int STATUS_SELECTION = 3;
    public static final String PROP_ARRAY_INDEX = "ArrayIndex";
    public static final String PROP_ARRAY_SELECTION = "ArraySelection";
    public static final int ICON_SIZE = 12;
    public static final int ICON_HINT = 4;
    private static final Insets labelInsets = new Insets(0, 5, 0, 10);
    private static final Insets zeroInsets = new Insets(0, 0, 0, 0);
    private RaidSystem system;
    private RadioButtonGroup radioGroup;
    private int selectionMode;
    private int count;
    private List arrayLabels = new ArrayList();
    static /* synthetic */ Class class$javax$swing$JRadioButton;
    static /* synthetic */ Class class$javax$swing$JCheckBox;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public ArraySelectionPanel(int n) {
        GUIFactory.configureComponentForPlatform(this);
        this.selectionMode = n;
        this.radioGroup = new RadioButtonGroup();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayLabel arrayLabel = (ArrayLabel)actionEvent.getSource();
                ArraySelectionPanel.this.firePropertyChange(actionEvent.getActionCommand(), -1, arrayLabel.id);
            }
        };
        int n2 = 0;
        for (int i = 0; i < 6; ++i) {
            JComponent jComponent;
            ArrayLabel arrayLabel = new ArrayLabel();
            gridBagConstraints.gridx = n2;
            if (this.selectionMode == 3) {
                jComponent = arrayLabel.createButton(class$javax$swing$JRadioButton == null ? ArraySelectionPanel.class$("javax.swing.JRadioButton") : class$javax$swing$JRadioButton, false);
                this.radioGroup.add((AbstractButton)jComponent);
                this.add((Component)jComponent, gridBagConstraints);
                ++gridBagConstraints.gridx;
                JLabel jLabel = arrayLabel.createStatusLabel();
                this.add((Component)jLabel, gridBagConstraints);
                ++gridBagConstraints.gridx;
            } else if (this.selectionMode == 1) {
                jComponent = arrayLabel.createButton(class$javax$swing$JRadioButton == null ? ArraySelectionPanel.class$("javax.swing.JRadioButton") : class$javax$swing$JRadioButton, true);
                this.radioGroup.add((AbstractButton)jComponent);
                this.add((Component)jComponent, gridBagConstraints);
                ++gridBagConstraints.gridx;
            } else if (this.selectionMode == 2) {
                jComponent = arrayLabel.createButton(class$javax$swing$JCheckBox == null ? ArraySelectionPanel.class$("javax.swing.JCheckBox") : class$javax$swing$JCheckBox, true);
                this.add((Component)jComponent, gridBagConstraints);
                ++gridBagConstraints.gridx;
            }
            jComponent = arrayLabel.createDescriptionLabel();
            gridBagConstraints.insets = labelInsets;
            this.add((Component)jComponent, gridBagConstraints);
            gridBagConstraints.insets = zeroInsets;
            ++gridBagConstraints.gridx;
            arrayLabel.addActionListener(actionListener);
            this.arrayLabels.add(arrayLabel);
            ++gridBagConstraints.gridy;
            if (gridBagConstraints.gridy != 3) continue;
            gridBagConstraints.gridy = 0;
            n2 += 3;
        }
        gridBagConstraints.gridx = n2 + 3;
        gridBagConstraints.weightx = 1.0;
        this.add(Box.createHorizontalStrut(1), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
    }

    public void setRaidSystem(RaidSystem raidSystem) {
        this.system = raidSystem;
        this.configureForRaidSystem(this.system);
    }

    public void updatePanel() {
        this.configureForRaidSystem(this.system);
    }

    public void configureForRaidSystem(RaidSystem raidSystem) {
        AbstractSystemElement abstractSystemElement;
        this.resetPanel();
        if (raidSystem == null) {
            return;
        }
        boolean[] blArray = new boolean[]{false, false};
        Object object = raidSystem.getRaidControllers().iterator();
        while (object.hasNext()) {
            abstractSystemElement = (RaidController)object.next();
            if (!((RaidController)abstractSystemElement).getRaidSets().isEmpty() || ((RaidController)abstractSystemElement).getJbodMaskEnabled()) continue;
            boolean bl = false;
            Iterator iterator = ((RaidController)abstractSystemElement).getDisks().iterator();
            while (iterator.hasNext()) {
                Disk disk = (Disk)iterator.next();
                if (disk.getType() != 3 || disk.getState() != 1) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            blArray[((RaidController)abstractSystemElement).getId() == 1 ? 0 : 1] = true;
        }
        if (blArray[0]) {
            try {
                object = Resources.getString("som.jbod.description");
                this.updateArrayLabel(this.count, -2, (String)object, 0);
                ++this.count;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = raidSystem.getRaidSets().iterator();
        while (object.hasNext()) {
            abstractSystemElement = (RaidSet)object.next();
            String string = SOMLocalizer.getRaidSetLevelAndCapacity((RaidSet)abstractSystemElement);
            try {
                this.updateArrayLabel(this.count, ((RaidSet)abstractSystemElement).getId(), string, ((RaidSet)abstractSystemElement).getStatus());
                ++this.count;
            }
            catch (Exception exception) {}
        }
        if (blArray[1]) {
            try {
                object = Resources.getString("som.jbod.description");
                this.updateArrayLabel(this.count, -3, (String)object, 0);
                ++this.count;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void resetPanel() {
        Iterator iterator = this.arrayLabels.iterator();
        while (iterator.hasNext()) {
            ((ArrayLabel)iterator.next()).clear();
        }
        this.count = 0;
    }

    public void setArrayIndex(int n) {
        if (n != 0) {
            ArrayLabel arrayLabel = this.getLabelForArrayId(n);
            if (arrayLabel != null) {
                arrayLabel.setSelected(true);
            }
        } else {
            Iterator iterator = this.arrayLabels.iterator();
            while (iterator.hasNext()) {
                ArrayLabel arrayLabel = (ArrayLabel)iterator.next();
                arrayLabel.setSelected(false);
            }
        }
    }

    public void setArrayCheckBoxes(List list) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            ArrayLabel arrayLabel = this.getLabelForArrayId(i + 1);
            if (arrayLabel == null) continue;
            arrayLabel.setSelected((Boolean)list.get(i));
        }
    }

    public List getArrayCheckBoxes() {
        return Collections.EMPTY_LIST;
    }

    void updateArrayLabel(int n, int n2, String string, int n3) {
        if (n < 0 || n > this.arrayLabels.size()) {
            throw new IllegalArgumentException("Invalid index: " + n);
        }
        ArrayLabel arrayLabel = (ArrayLabel)this.arrayLabels.get(n);
        if (arrayLabel == null) {
            throw new NullPointerException("ArrayLabel at index " + n + " is null");
        }
        boolean bl = this.selectionMode == 1 || this.selectionMode == 2;
        arrayLabel.setState(n2, string, n3, bl);
    }

    protected ArrayLabel getLabelForArrayId(int n) {
        ArrayLabel arrayLabel = null;
        Iterator iterator = this.arrayLabels.iterator();
        while (iterator.hasNext()) {
            ArrayLabel arrayLabel2 = (ArrayLabel)iterator.next();
            if (arrayLabel2.id != n) continue;
            arrayLabel = arrayLabel2;
            break;
        }
        return arrayLabel;
    }

    static String[] getArrayDescriptionsFromRaidSystem(RaidSystem raidSystem) {
        Collection collection = raidSystem.getRaidSets();
        String[] stringArray = new String[collection.size()];
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RaidSet raidSet = (RaidSet)iterator.next();
            stringArray[raidSet.getId() - 1] = SOMLocalizer.getRaidSetLevelAndCapacity(raidSet);
        }
        return stringArray;
    }

    static int[] getArrayStatusFromRaidSystem(RaidSystem raidSystem) {
        Collection collection = raidSystem.getRaidSets();
        int[] nArray = new int[collection.size()];
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            RaidSet raidSet = (RaidSet)iterator.next();
            nArray[raidSet.getId() - 1] = raidSet.getStatus();
        }
        return nArray;
    }

    static int[] getArrayLevelsFromRaidSystem(RaidSystem raidSystem) {
        Collection collection = raidSystem.getRaidSets();
        int[] nArray = new int[collection.size()];
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            int n;
            RaidSet raidSet = (RaidSet)iterator.next();
            switch (raidSet.getRaidLevel()) {
                case 0: {
                    n = 0;
                    break;
                }
                case 1: {
                    n = 1;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 5: {
                    n = 3;
                    break;
                }
                case 6: {
                    n = 4;
                    break;
                }
                default: {
                    throw new RuntimeException("Unrecognized RAID level: " + raidSet.getRaidLevel());
                }
            }
            nArray[raidSet.getId() - 1] = n;
        }
        return nArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ArrayLabel {
        int id = 0;
        JToggleButton button;
        JLabel descriptionLabel;
        JLabel statusLabel;
        protected MouseListener mouseListener;
        protected boolean displayed = false;
        protected static ImageIcon jbodBadge;
        protected final EventListenerList listenerList = new EventListenerList();
        private static final Color BADGE_COLOR;

        public void setState(int n, String string, int n2, boolean bl) {
            this.id = n;
            if (this.descriptionLabel != null) {
                this.descriptionLabel.setText(string);
            }
            if (this.statusLabel != null) {
                this.statusLabel.setIcon(StatusIcon.getSmallStatusIconInstance(n2));
            }
            if (this.button != null) {
                this.button.setVisible(bl);
            }
            if (this.displayed) {
                this.updateIcon();
            }
        }

        public void clear() {
            this.id = 0;
            if (this.descriptionLabel != null) {
                this.descriptionLabel.setText("");
                this.descriptionLabel.setIcon(null);
            }
            if (this.statusLabel != null) {
                this.statusLabel.setIcon(null);
            }
            if (this.button != null) {
                this.button.setVisible(false);
            }
        }

        public void setSelected(boolean bl) {
            if (this.button != null) {
                this.button.setSelected(bl);
            }
        }

        public JToggleButton createButton(Class clazz, boolean bl) {
            if (clazz == null) {
                throw new IllegalArgumentException("Button type cannot be null");
            }
            if (this.button == null || !this.button.getClass().equals(clazz)) {
                if (clazz.equals(class$javax$swing$JRadioButton == null ? (class$javax$swing$JRadioButton = ArraySelectionPanel.class$("javax.swing.JRadioButton")) : class$javax$swing$JRadioButton)) {
                    this.button = GUIFactory.newRadioButton();
                } else if (clazz.equals(class$javax$swing$JCheckBox == null ? (class$javax$swing$JCheckBox = ArraySelectionPanel.class$("javax.swing.JCheckBox")) : class$javax$swing$JCheckBox)) {
                    this.button = GUIFactory.newCheckBox();
                } else {
                    throw new IllegalArgumentException("Unsupported button type \"" + clazz + "\"");
                }
                this.button.addActionListener(new ActionListener(this){
                    private final /* synthetic */ ArrayLabel this$0;
                    {
                        this.this$0 = arrayLabel;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.this$0.fireActionPerformed(null);
                    }
                });
            }
            this.button.setVisible(bl);
            return this.button;
        }

        public JLabel createStatusLabel() {
            if (this.statusLabel == null) {
                this.statusLabel = new JLabel(new ImageIcon(Resources.getImage("icon.status.green")));
                this.statusLabel.addMouseListener(this.getMouseListener());
            }
            return this.statusLabel;
        }

        public JLabel createDescriptionLabel() {
            if (this.descriptionLabel == null) {
                this.descriptionLabel = new JLabel();
                this.descriptionLabel.setFont(GUIFactory.FONT_SMALL);
                this.descriptionLabel.addMouseListener(this.getMouseListener());
                this.descriptionLabel.addAncestorListener(new AncestorListener(this){
                    private final /* synthetic */ ArrayLabel this$0;
                    {
                        this.this$0 = arrayLabel;
                    }

                    public void ancestorAdded(AncestorEvent ancestorEvent) {
                        if (!this.this$0.displayed) {
                            this.this$0.displayed = true;
                            this.this$0.updateIcon();
                            this.this$0.descriptionLabel.removeAncestorListener(this);
                        }
                    }

                    public void ancestorMoved(AncestorEvent ancestorEvent) {
                    }

                    public void ancestorRemoved(AncestorEvent ancestorEvent) {
                    }
                });
            }
            return this.descriptionLabel;
        }

        public void addActionListener(ActionListener actionListener) {
            this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ArraySelectionPanel.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ArraySelectionPanel.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
        }

        void fireActionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != (class$java$awt$event$ActionListener == null ? ArraySelectionPanel.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
                if (actionEvent == null) {
                    String string = this.button != null && this.button instanceof JCheckBox ? ArraySelectionPanel.PROP_ARRAY_SELECTION : ArraySelectionPanel.PROP_ARRAY_INDEX;
                    actionEvent = new ActionEvent(this, 1001, string);
                }
                ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
            }
        }

        protected void updateIcon() {
            if (this.descriptionLabel != null) {
                if (this.id == 0) {
                    this.descriptionLabel.setIcon(null);
                } else {
                    ImageIcon imageIcon = this.createBadge(this.id);
                    if (imageIcon != null) {
                        this.descriptionLabel.setIcon(imageIcon);
                    }
                }
            }
        }

        private ImageIcon createBadge(int n) {
            ImageIcon imageIcon = null;
            if (this.descriptionLabel == null || n == 0) {
                return null;
            }
            if (n > 0 || jbodBadge == null) {
                Image image = this.descriptionLabel.createImage(10, 11);
                if (image != null) {
                    Graphics graphics = image.getGraphics();
                    graphics.setColor(BADGE_COLOR);
                    graphics.fillRect(0, 0, 10, 10);
                    graphics.setColor(Color.white);
                    graphics.setFont(GUIFactory.FONT_BADGE);
                    if (n > 0) {
                        graphics.drawString(n + "", 2, 9);
                        imageIcon = new ImageIcon(image);
                    } else {
                        graphics.drawString("J", 4, 8);
                        jbodBadge = imageIcon = new ImageIcon(image);
                    }
                }
            } else {
                imageIcon = jbodBadge;
            }
            return imageIcon;
        }

        private MouseListener getMouseListener() {
            if (this.mouseListener == null) {
                this.mouseListener = new MouseAdapter(this){
                    private final /* synthetic */ ArrayLabel this$0;
                    {
                        this.this$0 = arrayLabel;
                    }

                    public void mouseReleased(MouseEvent mouseEvent) {
                        if (this.this$0.button != null) {
                            this.this$0.button.doClick();
                        } else {
                            this.this$0.fireActionPerformed(null);
                        }
                    }
                };
            }
            return this.mouseListener;
        }

        static {
            BADGE_COLOR = Color.getHSBColor(0.0f, 0.0f, 0.38f);
        }
    }
}

