/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.xsr.Resources;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.Renderer;
import javax.swing.border.EmptyBorder;

public class AquaInformationPanel
extends JPanel {
    public static final Color BOX_COLOR = Color.getHSBColor(0.0f, 0.0f, 0.99f);
    public static final Color BORDER_COLOR = Color.getHSBColor(0.0f, 0.0f, 0.77f);
    protected JLabel infoIcon;
    protected Renderer textRenderer;
    protected static final GridBagConstraints EXPLANATION_CONSTRAINTS = new GridBagConstraints();

    public AquaInformationPanel(Image image, String string) {
        GUIFactory.configureComponentForPlatform(this);
        this.setBorder(new EmptyBorder(5, 5, 5, 10));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.infoIcon = new JLabel(new ImageIcon(image != null ? image : Resources.getImage("icon.info")));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.add((Component)this.infoIcon, gridBagConstraints);
        this.textRenderer = this.createDefaultTextRenderer();
        this.textRenderer.setValue(string, false);
        this.add(this.textRenderer.getComponent(), EXPLANATION_CONSTRAINTS);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add(Box.createHorizontalStrut(250), gridBagConstraints);
    }

    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(BORDER_COLOR);
        ((Graphics2D)graphics).fill(new RoundRectangle2D.Double(0.5, 0.5, n - 1, n2 - 1, 12.0, 12.0));
        graphics.setColor(BOX_COLOR);
        ((Graphics2D)graphics).fill(new RoundRectangle2D.Double(1.5, 1.5, n - 3, n2 - 3, 11.0, 11.0));
        this.paintChildren(graphics);
    }

    public void setIcon(Icon icon) {
        this.infoIcon.setIcon(icon);
    }

    public Icon getIcon() {
        return this.infoIcon != null ? this.infoIcon.getIcon() : null;
    }

    public void setText(String string) {
        if (this.textRenderer != null) {
            this.textRenderer.setValue(string, false);
        }
    }

    public void setTextRenderer(Renderer renderer) {
        if (renderer == null) {
            throw new NullPointerException("renderer cannot be null");
        }
        this.remove(this.textRenderer.getComponent());
        this.add(renderer.getComponent(), EXPLANATION_CONSTRAINTS);
        this.textRenderer = renderer;
    }

    public Renderer getTextRenderer() {
        return this.textRenderer;
    }

    protected Renderer createDefaultTextRenderer() {
        return new DefaultTextRenderer();
    }

    static {
        AquaInformationPanel.EXPLANATION_CONSTRAINTS.gridx = 1;
        AquaInformationPanel.EXPLANATION_CONSTRAINTS.gridy = 0;
        AquaInformationPanel.EXPLANATION_CONSTRAINTS.weightx = 1.0;
        AquaInformationPanel.EXPLANATION_CONSTRAINTS.weighty = 1.0;
        AquaInformationPanel.EXPLANATION_CONSTRAINTS.fill = 1;
    }

    protected static class DefaultTextRenderer
    extends JTextPane
    implements Renderer {
        public DefaultTextRenderer() {
            GUIFactory.configureComponentForPlatform(this);
            this.setFont(GUIFactory.FONT_SMALL);
            this.setEditable(false);
            this.setBackground(BOX_COLOR);
        }

        public Component getComponent() {
            return this;
        }

        public void setValue(Object object, boolean bl) {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("value must be a String object");
            }
            this.setText(object + "");
        }
    }
}

