/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.xsr.AquaAlertListener;
import com.apple.xsr.KeyPressForwardingPanel;
import com.apple.xsr.ShadowedPanel;
import com.apple.xsr.StandardAlertPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public class AquaAlert
implements KeyListener {
    public static final int DEFAULT_BUTTON_HIT = 1;
    public static final int ALTERNATE_BUTTON_HIT = 2;
    public static final int OTHER_BUTTON_HIT = 3;
    public static final int USER_BUTTON_HIT = 4;
    private static final int frameDuration = 20;
    private static final int frameAngle = 5;
    private static final boolean useDropShadows = true;
    private JButton contentPaneDefaultButton;
    private JButton alertAlternateButton;
    private JButton alertOtherButton;
    private JDialog dialog;
    private JFrame parent;
    private JPanel contentPanel;
    private boolean isSheet;
    private boolean dialogDismissed = false;
    private Object contextInfoObject;
    private Set keyEquivalentsForButtons;
    private final EventListenerList listenerList = new EventListenerList();
    MaskPanel maskPanel;
    ComponentListener resizeListener;
    private static final int INTERBUTTON_SPACING = 12;
    private static final int MIN_VERTICAL_RESIZE_DELTA = 5;
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$com$apple$xsr$AquaAlertListener;

    public AquaAlert(JPanel jPanel, JButton jButton, JButton jButton2, JButton jButton3) {
        this.contentPanel = new KeyPressForwardingPanel(jPanel, this);
        this.contentPaneDefaultButton = jButton;
        this.alertAlternateButton = jButton2;
        this.alertOtherButton = jButton3;
        this.keyEquivalentsForButtons = null;
        if (jButton != null) {
            this.setUpActionListenerForButton(jButton, 1);
        }
        if (jButton2 != null) {
            this.setUpActionListenerForButton(jButton2, 2);
        }
        if (jButton3 != null) {
            this.setUpActionListenerForButton(jButton3, 3);
        }
    }

    public static AquaAlert createStandardAquaAlert(String string, String string2, Image image, String string3, String string4, String string5) {
        StandardAlertPanel standardAlertPanel = new StandardAlertPanel(string, string2, image, string3, string4, string5);
        AquaAlert aquaAlert = new AquaAlert(standardAlertPanel, standardAlertPanel.getDefaultButton(), standardAlertPanel.getAlternateButton(), standardAlertPanel.getOtherButton());
        if (string3 != null) {
            aquaAlert.associateKeyCodeWithButton(10, 0, 1);
        }
        if (string4 != null) {
            aquaAlert.associateKeyCodeWithButton(46, 4, 2);
            aquaAlert.associateKeyCodeWithButton(27, 0, 2);
        }
        return aquaAlert;
    }

    private void setUpActionListenerForButton(JButton jButton, final int n) {
        JButton jButton2 = jButton;
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AquaAlert.this.performButtonOrKeyEquivalentAction(n);
            }
        });
    }

    private void performButtonOrKeyEquivalentAction(int n) {
        if (!this.dialogDismissed) {
            if (this.listenerList.getListenerCount() == 0) {
                this.dialogDismissed = true;
                this.dismissSheetOrDialog(n);
            } else if (this.fireAllowAquaAlertToBeDismissed(n, this.contextInfoObject)) {
                this.dialogDismissed = true;
                this.dismissSheetOrDialog(n);
            }
        }
    }

    public Dimension getSize() {
        return new Dimension(this.contentPanel.getWidth(), this.contentPanel.getHeight());
    }

    public void dismissSheetOrDialog(int n) {
        if (this.isSheet) {
            new AnimateUpThread().sheetClosed(n);
        } else {
            this.dialog.dispose();
            this.fireAquaAlertDismissed(n, this.contextInfoObject);
        }
    }

    private void showDialogImpl(JFrame jFrame, String string) {
        this.isSheet = false;
        this.parent = jFrame;
        Frame frame = null;
        frame = this.parent instanceof Frame ? this.parent : (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = AquaAlert.class$("java.awt.Frame")) : class$java$awt$Frame, this.parent);
        if (this.dialog == null || this.dialog.getOwner() != frame) {
            this.dialog = new JDialog(frame, true);
            ((JPanel)this.dialog.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 20));
            this.dialog.getContentPane().add(this.contentPanel);
            this.dialog.pack();
        }
        if (string != null) {
            this.dialog.setTitle(string);
        }
        this.dialog.setResizable(false);
        this.dialog.setLocationRelativeTo(frame);
        JRootPane jRootPane = this.contentPanel.getRootPane();
        if (jRootPane != null) {
            jRootPane.setDefaultButton(this.contentPaneDefaultButton);
        }
        this.requestFocusForAButton();
        this.dialog.show();
    }

    private void showSheetImpl(JFrame jFrame) {
        if (jFrame == null) {
            this.showDialogImpl(null, "");
            return;
        }
        this.isSheet = true;
        this.parent = jFrame;
        this.resizeListener = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                AquaAlert.this.maskPanel.setBounds(0, 0, componentEvent.getComponent().getSize().width, componentEvent.getComponent().getSize().height);
                AquaAlert.this.contentPanel.setLocation(componentEvent.getComponent().getSize().width / 2 - AquaAlert.this.contentPanel.getWidth() / 2, -2);
            }
        };
        this.parent.addComponentListener(this.resizeListener);
        this.contentPanel = new ShadowedPanel(this.contentPanel);
        Dimension dimension = this.contentPanel.getPreferredSize();
        this.contentPanel.setBounds(this.parent.getSize().width / 2 - dimension.width / 2, -dimension.height, dimension.width, dimension.height);
        this.parent.getLayeredPane().add((Component)this.contentPanel, new Integer(1001));
        this.maskPanel = new MaskPanel();
        this.maskPanel.setBounds(0, 0, this.parent.getSize().width, this.parent.getSize().height);
        this.parent.getLayeredPane().add((Component)this.maskPanel, new Integer(1000));
        new AnimateDownThread().start();
    }

    public void showSheet(JFrame jFrame) {
        this.showSheet(jFrame, null);
    }

    public void showSheet(JFrame jFrame, Object object) {
        this.contextInfoObject = object;
        this.fireAquaAlertWillBeShown(this.contextInfoObject);
        this.showSheetImpl(jFrame);
    }

    public void showSheet(JFrame jFrame, AquaAlertListener aquaAlertListener, Object object) {
        if (aquaAlertListener != null) {
            this.addAquaAlertListener(aquaAlertListener);
        }
        this.showSheet(jFrame, object);
    }

    public void showDialog(JFrame jFrame, String string) {
        this.showDialog(jFrame, string, null);
    }

    public void showDialog(JFrame jFrame, String string, Object object) {
        this.contextInfoObject = object;
        this.fireAquaAlertWillBeShown(this.contextInfoObject);
        this.showDialogImpl(jFrame, string);
    }

    public void showDialog(JFrame jFrame, String string, AquaAlertListener aquaAlertListener, Object object) {
        if (aquaAlertListener != null) {
            this.addAquaAlertListener(aquaAlertListener);
        }
        this.showDialog(jFrame, string, object);
    }

    public void resizeVertically(int n) {
        this.resizeVertically(n, null);
    }

    public void resizeVertically(int n, Object object) {
        this.contextInfoObject = object;
        new AnimateResizeThread(n).start();
    }

    public void resizeVertically(int n, AquaAlertListener aquaAlertListener, Object object) {
        if (aquaAlertListener != null) {
            this.addAquaAlertListener(aquaAlertListener);
        }
        this.resizeVertically(n, object);
    }

    public void resizeVertically() {
        this.resizeVertically(null);
    }

    public void resizeVertically(Object object) {
        this.contextInfoObject = object;
        Dimension dimension = this.contentPanel.getPreferredSize();
        if (dimension != null) {
            new AnimateResizeThread(dimension.height).start();
        }
    }

    public void resizeVertically(AquaAlertListener aquaAlertListener, Object object) {
        if (aquaAlertListener != null) {
            this.addAquaAlertListener(aquaAlertListener);
        }
        this.resizeVertically(object);
    }

    public void addAquaAlertListener(AquaAlertListener aquaAlertListener) {
        Object[] objectArray = this.listenerList.getListenerList();
        boolean bl = false;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i + 1] != aquaAlertListener) continue;
            bl = true;
        }
        if (!bl) {
            this.listenerList.add(class$com$apple$xsr$AquaAlertListener == null ? (class$com$apple$xsr$AquaAlertListener = AquaAlert.class$("com.apple.xsr.AquaAlertListener")) : class$com$apple$xsr$AquaAlertListener, aquaAlertListener);
        }
    }

    public void removeAquaAlertListener(AquaAlertListener aquaAlertListener) {
        this.listenerList.remove(class$com$apple$xsr$AquaAlertListener == null ? (class$com$apple$xsr$AquaAlertListener = AquaAlert.class$("com.apple.xsr.AquaAlertListener")) : class$com$apple$xsr$AquaAlertListener, aquaAlertListener);
    }

    protected void fireAquaAlertWillBeShown(Object object) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$apple$xsr$AquaAlertListener == null ? AquaAlert.class$("com.apple.xsr.AquaAlertListener") : class$com$apple$xsr$AquaAlertListener)) continue;
            ((AquaAlertListener)objectArray[i + 1]).aquaAlertWillBeShown(object);
        }
    }

    protected void fireAquaAlertSheetVisible(Object object) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$apple$xsr$AquaAlertListener == null ? AquaAlert.class$("com.apple.xsr.AquaAlertListener") : class$com$apple$xsr$AquaAlertListener)) continue;
            ((AquaAlertListener)objectArray[i + 1]).aquaAlertSheetVisible(object);
        }
    }

    protected void fireAquaAlertDismissed(int n, Object object) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$apple$xsr$AquaAlertListener == null ? AquaAlert.class$("com.apple.xsr.AquaAlertListener") : class$com$apple$xsr$AquaAlertListener)) continue;
            ((AquaAlertListener)objectArray[i + 1]).aquaAlertDismissed(n, object);
        }
    }

    protected boolean fireAllowAquaAlertToBeDismissed(int n, Object object) {
        Object[] objectArray = this.listenerList.getListenerList();
        boolean bl = true;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            boolean bl2;
            if (objectArray[i] != (class$com$apple$xsr$AquaAlertListener == null ? AquaAlert.class$("com.apple.xsr.AquaAlertListener") : class$com$apple$xsr$AquaAlertListener) || (bl2 = ((AquaAlertListener)objectArray[i + 1]).allowAquaAlertToBeDismissed(n, object))) continue;
            bl = false;
        }
        return bl;
    }

    protected void fireAquaAlertResized(Object object) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$com$apple$xsr$AquaAlertListener == null ? AquaAlert.class$("com.apple.xsr.AquaAlertListener") : class$com$apple$xsr$AquaAlertListener)) continue;
            ((AquaAlertListener)objectArray[i + 1]).aquaAlertResized(object);
        }
    }

    private void requestFocusForAButton() {
        if (this.contentPaneDefaultButton != null) {
            this.contentPaneDefaultButton.requestFocus();
        } else if (this.alertAlternateButton != null) {
            this.alertAlternateButton.requestFocus();
        } else if (this.alertOtherButton != null) {
            this.alertOtherButton.requestFocus();
        }
    }

    void animateDownThread() {
        this.contentPanel.setOpaque(true);
        for (int i = 0; i <= 90; i += 5) {
            int n = this.contentPanel.getLocation().x;
            int n2 = this.contentPanel.getHeight();
            this.contentPanel.setLocation(n, (int)((double)(-1 - n2) + (double)n2 * Math.sin((double)i / 180.0 * Math.PI)));
            this.contentPanel.repaint();
            this.doDelay(20);
        }
        this.contentPanel.setOpaque(false);
        this.contentPanel.repaint();
        this.parent.getRootPane().setDefaultButton(this.contentPaneDefaultButton);
    }

    void animateUpThread() {
        Rectangle rectangle = new Rectangle(this.contentPanel.getLocation(), this.contentPanel.getSize());
        this.contentPanel.setOpaque(true);
        for (int i = 0; i <= 90; i += 5) {
            int n = this.contentPanel.getLocation().x;
            int n2 = this.contentPanel.getHeight();
            this.contentPanel.setLocation(n, (int)((double)(-1 - n2) + (double)n2 * Math.cos((double)i / 180.0 * Math.PI)));
            this.contentPanel.repaint();
            this.doDelay(20);
        }
        this.parent.removeComponentListener(this.resizeListener);
        this.parent.getLayeredPane().remove(this.maskPanel);
        this.parent.getLayeredPane().remove(this.contentPanel);
        this.parent.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    void animateResizeThread(int n) {
        int n2 = this.contentPanel.getWidth();
        int n3 = this.contentPanel.getHeight();
        int n4 = n - n3;
        if (Math.abs(n4) < 5) {
            return;
        }
        for (int i = 0; i <= 90; i += 5) {
            this.contentPanel.setSize(n2, (int)((double)n3 + (double)n4 * Math.sin((double)i / 180.0 * Math.PI)));
            this.contentPanel.validate();
            this.doDelay(20);
        }
    }

    void doDelay(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void addComponent(Component component, Container container, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    protected Set keyEquivalentsForButtons() {
        if (this.keyEquivalentsForButtons == null) {
            this.keyEquivalentsForButtons = new HashSet();
        }
        return this.keyEquivalentsForButtons;
    }

    public void associateKeyCodeWithButton(int n, int n2, int n3) {
        KeyButtonAssociation keyButtonAssociation = new KeyButtonAssociation(n, n2, n3);
        Set set = this.keyEquivalentsForButtons();
        if (set.contains(keyButtonAssociation)) {
            set.remove(keyButtonAssociation);
        }
        set.add(keyButtonAssociation);
    }

    public void associateKeyCodeWithButton(int n, int n2, AbstractButton abstractButton) {
        KeyButtonAssociation keyButtonAssociation = new KeyButtonAssociation(n, n2, abstractButton);
        Set set = this.keyEquivalentsForButtons();
        if (set.contains(keyButtonAssociation)) {
            set.remove(keyButtonAssociation);
        }
        set.add(keyButtonAssociation);
    }

    public void keyPressed(KeyEvent keyEvent) {
        Iterator iterator = this.keyEquivalentsForButtons().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof KeyButtonAssociation) || !((KeyButtonAssociation)e).sameAsKeyEvent(keyEvent)) continue;
            int n = ((KeyButtonAssociation)e).getButtonType();
            if (n == 4) {
                AbstractButton abstractButton = ((KeyButtonAssociation)e).getUserButton();
                if (abstractButton == null) break;
                abstractButton.doClick();
                break;
            }
            this.performButtonOrKeyEquivalentAction(n);
            break;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ void access$500(AquaAlert aquaAlert) {
        aquaAlert.requestFocusForAButton();
    }

    static /* synthetic */ Object access$600(AquaAlert aquaAlert) {
        return aquaAlert.contextInfoObject;
    }

    private static class KeyButtonAssociation {
        int keyCode;
        int keyModifiers;
        int buttonType;
        AbstractButton userButton;

        public KeyButtonAssociation(int n, int n2, int n3) {
            this.setKeyCode(n);
            this.setKeyModifiers(n2);
            this.setButtonType(n3);
        }

        public KeyButtonAssociation(int n, int n2, AbstractButton abstractButton) {
            this.setKeyCode(n);
            this.setKeyModifiers(n2);
            this.setButtonType(4);
            this.setUserButton(abstractButton);
        }

        public int getKeyCode() {
            return this.keyCode;
        }

        public void setKeyCode(int n) {
            this.keyCode = n;
        }

        public int getKeyModifiers() {
            return this.keyModifiers;
        }

        public void setKeyModifiers(int n) {
            this.keyModifiers = n;
        }

        public int getButtonType() {
            return this.buttonType;
        }

        public void setButtonType(int n) {
            this.buttonType = n;
        }

        public AbstractButton getUserButton() {
            return this.userButton;
        }

        public void setUserButton(AbstractButton abstractButton) {
            this.userButton = abstractButton;
        }

        public boolean sameAsKeyEvent(KeyEvent keyEvent) {
            boolean bl = false;
            if (this.keyCode == keyEvent.getKeyCode() && this.keyModifiers == keyEvent.getModifiers()) {
                bl = true;
            }
            return bl;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof KeyButtonAssociation)) {
                return false;
            }
            KeyButtonAssociation keyButtonAssociation = (KeyButtonAssociation)object;
            return keyButtonAssociation.keyCode == this.keyCode && keyButtonAssociation.keyModifiers == this.keyModifiers;
        }

        public int hashCode() {
            int n = 13;
            n = 37 * n + this.keyCode;
            n = 37 * n + this.keyModifiers;
            return n;
        }

        public String toString() {
            String string = this.getClass().getName() + "[";
            string = string + "keyCode=" + this.keyCode + ",";
            string = string + "keyModifiers=" + this.keyModifiers + ",";
            string = string + "buttonType=" + this.buttonType + ",";
            string = string + "userButton=" + this.userButton;
            string = string + "]";
            return string;
        }
    }

    private static class MaskPanel
    extends JPanel {
        MaskPanel() {
            this.setOpaque(false);
            this.enableEvents(16L);
        }
    }

    private class AnimateResizeThread
    extends Thread {
        int newHeight;

        AnimateResizeThread(int n) {
            this.newHeight = n;
        }

        public void run() {
            AquaAlert.this.animateResizeThread(this.newHeight);
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ AnimateResizeThread this$1;
                {
                    this.this$1 = animateResizeThread;
                }

                public void run() {
                    AnimateResizeThread.access$900(this.this$1).fireAquaAlertResized(AquaAlert.access$600(AnimateResizeThread.access$900(this.this$1)));
                }
            });
        }

        static /* synthetic */ AquaAlert access$900(AnimateResizeThread animateResizeThread) {
            return animateResizeThread.AquaAlert.this;
        }
    }

    private class AnimateUpThread
    extends Thread {
        private int theButtonReturnType;

        private AnimateUpThread() {
        }

        void sheetClosed(int n) {
            this.theButtonReturnType = n;
            this.start();
        }

        public void run() {
            AquaAlert.this.animateUpThread();
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ AnimateUpThread this$1;
                {
                    this.this$1 = animateUpThread;
                }

                public void run() {
                    AnimateUpThread.access$800(this.this$1).fireAquaAlertDismissed(AnimateUpThread.access$700(this.this$1), AquaAlert.access$600(AnimateUpThread.access$800(this.this$1)));
                }
            });
        }

        static /* synthetic */ int access$700(AnimateUpThread animateUpThread) {
            return animateUpThread.theButtonReturnType;
        }

        static /* synthetic */ AquaAlert access$800(AnimateUpThread animateUpThread) {
            return animateUpThread.AquaAlert.this;
        }
    }

    private class AnimateDownThread
    extends Thread {
        private AnimateDownThread() {
        }

        public void run() {
            AquaAlert.this.animateDownThread();
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ AnimateDownThread this$1;
                {
                    this.this$1 = animateDownThread;
                }

                public void run() {
                    AquaAlert.access$500(AnimateDownThread.access$400(this.this$1));
                    AnimateDownThread.access$400(this.this$1).fireAquaAlertSheetVisible(AquaAlert.access$600(AnimateDownThread.access$400(this.this$1)));
                }
            });
        }

        static /* synthetic */ AquaAlert access$400(AnimateDownThread animateDownThread) {
            return animateDownThread.AquaAlert.this;
        }
    }
}

