/*
 * Decompiled with CFR 0.152.
 */
package com.apple.xsr;

import com.apple.gui.GUIFactory;
import com.apple.util.ImageUtilities;
import com.apple.xsr.AbstractManagementPane;
import com.apple.xsr.ChooserButtonPanel;
import com.apple.xsr.ManagementPane;
import com.apple.xsr.RadioButtonGroup;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.FilteredImageSource;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public abstract class AbstractChooserMgmtPane
extends AbstractManagementPane {
    public static final String CHOOSER_PANE_TAG = "chooser";
    protected ChooserPanel chooserPanel;
    protected ChooserButtonPanel chooserButtonPanel;
    protected String chooseText;
    protected CardLayout cardLayout = new CardLayout();

    public AbstractChooserMgmtPane(int n, int n2, String string) {
        super(n, n2);
        this.setLayout(this.cardLayout);
        this.chooseText = string;
    }

    public void goBackToChooser() {
        this.cardLayout.show(this, CHOOSER_PANE_TAG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagementPane getCurrentlyShowingManagementPane() {
        ManagementPane managementPane = null;
        Component component = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = this.getComponentCount();
            for (int i = 0; i < n && !(component = this.getComponent(i)).isVisible(); ++i) {
            }
        }
        if (component != null && component instanceof ManagementPane) {
            managementPane = (ManagementPane)((Object)component);
        }
        return managementPane;
    }

    public String getSelectedPaneTag() {
        return this.chooserPanel.getSelectedPaneTag();
    }

    public void showPane(String string) {
        this.cardLayout.show(this, string != null ? string : CHOOSER_PANE_TAG);
    }

    protected void setPanes(ManagementPane[] managementPaneArray) {
        this.setPanes(managementPaneArray, true);
    }

    protected void setPanes(ManagementPane[] managementPaneArray, boolean bl) {
        this.chooserButtonPanel = this.createChooserButtonPanel();
        this.chooserPanel = new ChooserPanel(this.chooseText, managementPaneArray, this.chooserButtonPanel, bl);
        this.add((Component)this.chooserPanel, CHOOSER_PANE_TAG);
        for (int i = 0; i < managementPaneArray.length; ++i) {
            if (!(managementPaneArray[i] instanceof Component)) {
                String string = "ManagmentPane \"" + managementPaneArray[i].getTag() + "\" must be an instance of java.awt.Component";
                throw new IllegalArgumentException(string);
            }
            this.add((Component)((Object)managementPaneArray[i]), managementPaneArray[i].getTag());
        }
    }

    protected ChooserButtonPanel createChooserButtonPanel() {
        ChooserButtonPanel chooserButtonPanel = new ChooserButtonPanel(false);
        chooserButtonPanel.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionEvent actionEvent2 = new ActionEvent(AbstractChooserMgmtPane.this, 1001, "CANCEL");
                AbstractChooserMgmtPane.this.fireActionPerformed(actionEvent2);
            }
        });
        chooserButtonPanel.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = AbstractChooserMgmtPane.this.chooserPanel.getSelectedPaneTag();
                if (string != null) {
                    AbstractChooserMgmtPane.this.cardLayout.show(AbstractChooserMgmtPane.this, string);
                }
            }
        });
        return chooserButtonPanel;
    }

    public static class ChooserPanel
    extends JPanel {
        private RadioButtonGroup radioGroup = new RadioButtonGroup();
        private static final Insets LABEL_INSETS = new Insets(0, 0, 24, 0);
        private static final Insets RADIO_INSETS = new Insets(10, 0, 0, 0);
        private static final Insets EXPLANATION_INSETS = new Insets(0, 24, 16, 0);
        private static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
        private static final String XSR_CHOICE_BUTTON_PROP = "XSR_CHOICE_BUTTON";
        private static final String XSR_CHOICE_EXPLANATION_PROP = "XSR_CHOICE_EXPLANATION";

        public ChooserPanel(String string, ManagementPane[] managementPaneArray, ChooserButtonPanel chooserButtonPanel, boolean bl) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel(string);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = LABEL_INSETS;
            this.add((Component)jLabel, gridBagConstraints);
            for (int i = 0; i < managementPaneArray.length; ++i) {
                ImageIcon imageIcon = managementPaneArray[i].getIcon();
                String string2 = managementPaneArray[i].getTitle();
                String string3 = managementPaneArray[i].getExplanation();
                String string4 = managementPaneArray[i].getTag();
                int n = 0;
                JButton jButton = null;
                if (bl) {
                    jButton = imageIcon != null ? GUIFactory.newButton(imageIcon) : GUIFactory.newButton("?");
                    jButton.setPressedIcon(new ImageIcon(this.createImage(new FilteredImageSource(imageIcon.getImage().getSource(), ImageUtilities.getDimmingFilterInstance()))));
                    jButton.setDisabledIcon(new ImageIcon(this.createImage(new FilteredImageSource(imageIcon.getImage().getSource(), ImageUtilities.getFadingFilterInstance()))));
                    jButton.setBorderPainted(false);
                    jButton.setActionCommand(string4);
                    gridBagConstraints.gridx = n++;
                    gridBagConstraints.gridy = i * 2 + 1;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.gridheight = 2;
                    gridBagConstraints.weightx = 0.0;
                    gridBagConstraints.weighty = 0.0;
                    gridBagConstraints.anchor = 17;
                    gridBagConstraints.fill = 0;
                    gridBagConstraints.insets = ZERO_INSETS;
                    this.add((Component)jButton, gridBagConstraints);
                }
                JRadioButton jRadioButton = GUIFactory.newRadioButton(string2);
                jRadioButton.setSelected(i == 0);
                jRadioButton.setActionCommand(string4);
                this.radioGroup.add(jRadioButton);
                gridBagConstraints.gridx = n;
                gridBagConstraints.gridy = i * 2 + 1;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = RADIO_INSETS;
                this.add((Component)jRadioButton, gridBagConstraints);
                JLabel jLabel2 = new JLabel(string3);
                jLabel2.setFont(GUIFactory.FONT_SMALL);
                gridBagConstraints.gridx = n;
                ++gridBagConstraints.gridy;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = EXPLANATION_INSETS;
                this.add((Component)jLabel2, gridBagConstraints);
                jRadioButton.putClientProperty(XSR_CHOICE_BUTTON_PROP, jButton);
                jRadioButton.putClientProperty(XSR_CHOICE_EXPLANATION_PROP, jLabel2);
                if (jButton == null) continue;
                jButton.addActionListener(new ActionListener(this, jRadioButton){
                    private final /* synthetic */ JRadioButton val$radio;
                    private final /* synthetic */ ChooserPanel this$0;
                    {
                        this.this$0 = chooserPanel;
                        this.val$radio = jRadioButton;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.val$radio.doClick();
                    }
                });
            }
            gridBagConstraints.gridx = 1;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 14;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = ZERO_INSETS;
            this.add((Component)chooserButtonPanel, gridBagConstraints);
        }

        public void setSelectedPane(ManagementPane managementPane) {
            String string = managementPane.getTag();
            JRadioButton jRadioButton = this.getRadioForTag(managementPane.getTag());
            if (jRadioButton != null) {
                jRadioButton.setSelected(true);
            }
        }

        public String getSelectedPaneTag() {
            String string = null;
            ButtonModel buttonModel = this.radioGroup.getSelection();
            if (buttonModel != null) {
                string = buttonModel.getActionCommand();
            }
            return string;
        }

        public void setPaneEnabled(ManagementPane managementPane, boolean bl) {
            String string = managementPane.getTag();
            JRadioButton jRadioButton = this.getRadioForTag(managementPane.getTag());
            if (jRadioButton != null) {
                AbstractButton abstractButton = (AbstractButton)jRadioButton.getClientProperty(XSR_CHOICE_BUTTON_PROP);
                JLabel jLabel = (JLabel)jRadioButton.getClientProperty(XSR_CHOICE_EXPLANATION_PROP);
                jRadioButton.setEnabled(bl);
                if (abstractButton != null) {
                    abstractButton.setEnabled(bl);
                }
                if (jLabel != null) {
                    jLabel.setEnabled(bl);
                }
            }
        }

        private JRadioButton getRadioForTag(String string) {
            Enumeration<AbstractButton> enumeration = this.radioGroup.getElements();
            while (enumeration.hasMoreElements()) {
                JRadioButton jRadioButton = (JRadioButton)enumeration.nextElement();
                if (!jRadioButton.getActionCommand().equals(string)) continue;
                return jRadioButton;
            }
            return null;
        }
    }
}

