/*
 * Decompiled with CFR 0.152.
 */
package com.apple.util.jni;

public class PasswordManager {
    private static final String LIBRARY_NAME = new String("PasswordManager");
    public static final String PASSWORD_MANAGER_ACCESS_GUEST = new String("guest");
    public static final String PASSWORD_MANAGER_ACCESS_ADMIN = new String("admin");
    public static final int LIBRARY_NOT_LOADED = -1;
    public static final int LIBRARY_NOT_AVAILABLE = -2;
    public static final int LIBRARY_LOADED = 0;
    private static boolean mLibraryLoaded;
    private static PasswordManager mSharedInstance;

    public static PasswordManager getPasswordManager() {
        if (mSharedInstance == null) {
            mSharedInstance = new PasswordManager();
        }
        return mSharedInstance;
    }

    public static int isPasswordManagerAvailable() {
        int n = 0;
        if (mSharedInstance == null) {
            n = -1;
        } else if (!mLibraryLoaded) {
            n = -2;
        }
        return n;
    }

    public String getPassword(String string, String string2) throws PasswordManagerAccessException {
        if (!mLibraryLoaded) {
            throw new PasswordManagerAccessException("PasswordManagerLibraryNotLoaded");
        }
        String string3 = this.getPasswordInternal(string, string2);
        if (string3 == null) {
            throw new PasswordManagerAccessException("PasswordNotFound");
        }
        if (string3.length() == 0) {
            throw new PasswordManagerAccessException("PasswordNotFound");
        }
        return string3;
    }

    public int setPassword(String string, String string2, String string3) {
        int n = 0;
        if (!mLibraryLoaded) {
            return -1;
        }
        n = this.setPasswordInternal(string, string2, string3);
        if (n != 0) {
            System.out.println("error = " + new Integer(n));
        }
        return n;
    }

    public native String getPasswordInternal(String var1, String var2);

    public native int setPasswordInternal(String var1, String var2, String var3);

    static {
        try {
            System.loadLibrary(LIBRARY_NAME);
            mLibraryLoaded = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            mLibraryLoaded = false;
        }
    }

    public class PasswordManagerAccessException
    extends Exception {
        public String exceptionType;

        PasswordManagerAccessException(String string) {
            this.exceptionType = string;
        }

        public String getExceptionType() {
            return this.exceptionType;
        }
    }
}

