/*
 * Decompiled with CFR 0.152.
 */
package com.apple.util;

import com.apple.util.StringUtilities;
import java.text.ParseException;

public abstract class VersionNumber
implements Comparable {
    public static final boolean DEBUG = false;
    public static final int MAJOR = 0;
    public static final int MINOR = 1;
    public static final int POINT = 2;
    public static final int STAGE = 3;
    public static final int STAGE_SUFFIX = 4;
    protected int major = -1;
    protected int minor = -1;
    protected int point = -1;
    protected String stage = "";
    protected int stageValue = -1;
    protected int stageSuffix = -1;
    protected String versionString;

    private VersionNumber(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("version cannot be null");
        }
        this.versionString = string;
        this.parse(this.versionString);
    }

    public static VersionNumber newAppleVersionNumber(String string) throws ParseException {
        return new AppleVersionNumber(string);
    }

    public static VersionNumber newAcsVersionNumber(String string) throws ParseException {
        return new AcsVersionNumber(string);
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public int getPointVersion() {
        return this.point;
    }

    public String getStage() {
        return this.stage;
    }

    public int getStageValue() {
        return this.stageValue;
    }

    public int getStageSuffix() {
        return this.stageSuffix;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public int compareTo(VersionNumber versionNumber) {
        return StringUtilities.compareNatural(this.versionString, versionNumber.versionString, false);
    }

    public int compareTo(Object object) {
        return this.compareTo((VersionNumber)object);
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public String toString() {
        return this.versionString;
    }

    protected abstract void parse(String var1) throws ParseException;

    public static void main(String[] stringArray) {
    }

    private static class AcsVersionNumber
    extends VersionNumber {
        private AcsVersionNumber(String string) throws ParseException {
            super(string);
        }

        protected void parse(String string) throws ParseException {
            int n = 0;
            int n2 = 0;
            int n3 = string.length();
            n = string.indexOf(46, n2);
            if (n == -1) {
                throw new ParseException("\"" + string + "\" invalid format (missing decimal point)", n2);
            }
            try {
                this.major = Integer.parseInt(n - n2 > 0 ? string.substring(n2, n) : "0");
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("\"" + string + "\" major version is not an integer \"" + string.substring(n2, n) + "\"", n2);
            }
            n2 = n + 1;
            try {
                this.minor = Integer.parseInt(n3 - 1 - n2 > 0 ? string.substring(n2, n3 - 1) : "0");
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("\"" + string + "\" minor version is not an integer \"" + string.substring(n2, n3 - 1) + "\"", n2);
            }
            this.point = string.charAt(n3 - 1);
        }
    }

    private static class AppleVersionNumber
    extends VersionNumber {
        public static final int VERSION_STAGE_DEVELOPMENT = 32;
        public static final int VERSION_STAGE_ALPHA = 64;
        public static final int VERSION_STAGE_BETA = 96;
        public static final int VERSION_STAGE_FINAL = 128;

        private AppleVersionNumber(String string) throws ParseException {
            super(string);
        }

        protected void parse(String string) throws ParseException {
            int n;
            this.major = 0;
            this.minor = 0;
            this.point = 0;
            this.stage = "f";
            this.stageValue = 128;
            this.stageSuffix = 0;
            int n2 = string.length();
            for (n = 0; n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
            }
            int n3 = n;
            while (n < n2 && Character.isDigit(string.charAt(n))) {
                ++n;
            }
            int n4 = n;
            this.major = Integer.parseInt(string.substring(n3, n4));
            if (string.charAt(n) != '.') {
                throw new ParseException("major version must be followed by a dot", 0);
            }
            n3 = ++n;
            while (n < n2 && Character.isDigit(string.charAt(n))) {
                ++n;
            }
            n4 = n;
            this.minor = Integer.parseInt(string.substring(n3, n4));
            if (n < n2) {
                boolean bl;
                char c;
                if ((c = string.charAt(n++)) == '.') {
                    n3 = n;
                    while (n < n2 && Character.isDigit(string.charAt(n))) {
                        ++n;
                    }
                    n4 = n;
                    this.point = Integer.parseInt(string.substring(n3, n4));
                    if (n < n2) {
                        c = string.charAt(n++);
                    }
                }
                switch (c) {
                    case 'D': 
                    case 'd': {
                        this.stage = "d";
                        this.stageValue = 32;
                        bl = true;
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        this.stage = "a";
                        this.stageValue = 64;
                        bl = true;
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        this.stage = "b";
                        this.stageValue = 96;
                        bl = true;
                        break;
                    }
                    case 'F': 
                    case 'f': {
                        this.stage = "f";
                        this.stageValue = 128;
                        bl = true;
                        break;
                    }
                    default: {
                        bl = false;
                    }
                }
                if (bl) {
                    n3 = n;
                    while (n < n2 && Character.isDigit(string.charAt(n))) {
                        ++n;
                    }
                    n4 = n;
                    if (n3 < n4) {
                        this.stageSuffix = Integer.parseInt(string.substring(n3, n4));
                    }
                }
            }
            if (this.major > 255) {
                throw new ParseException("major must be 0-255", 0);
            }
            if (this.minor > 15) {
                throw new ParseException("minor must be 0-15", 0);
            }
            if (this.point > 15) {
                throw new ParseException("bugFix must be 0-15", 0);
            }
            if (this.stageSuffix > 255) {
                throw new ParseException("revision must be 0-255", 0);
            }
            if (this.stageValue != 32 && this.stageValue != 64 && this.stageValue != 96 && this.stageValue != 128) {
                throw new ParseException("stage must be d, a, b, or f", 0);
            }
        }

        public int compareTo(VersionNumber versionNumber) {
            if (this.major > versionNumber.getMajorVersion()) {
                return 1;
            }
            if (this.major < versionNumber.getMajorVersion()) {
                return -1;
            }
            if (this.minor > versionNumber.getMinorVersion()) {
                return 1;
            }
            if (this.minor < versionNumber.getMinorVersion()) {
                return -1;
            }
            if (this.point > versionNumber.getPointVersion()) {
                return 1;
            }
            if (this.point < versionNumber.getPointVersion()) {
                return -1;
            }
            if (this.stageValue > versionNumber.getStageValue()) {
                return 1;
            }
            if (this.stageValue < versionNumber.getStageValue()) {
                return -1;
            }
            int n = this.stageSuffix;
            int n2 = versionNumber.getStageSuffix();
            if (this.stageValue == 128) {
                if (n == 0) {
                    n = 65535;
                }
                if (n2 == 0) {
                    n2 = 65535;
                }
            }
            if (n > n2) {
                return 1;
            }
            if (n < n2) {
                return -1;
            }
            return 0;
        }
    }
}

