/*
 * Decompiled with CFR 0.152.
 */
package com.apple.util;

import java.io.UnsupportedEncodingException;
import java.text.ParsePosition;
import java.util.ArrayList;

public class StringUtilities {
    public static final boolean DEBUG = false;
    public static final String US_ASCII_ENCODING = "US-ASCII";
    public static final String ISO_8859_1_ENCODING = "ISO-8859-1";
    public static final String UTF_8_ENCODING = "UTF-8";
    public static final String UTF_16_ENCODING = "UTF-16";
    public static final String UTF_16BE_ENCODING = "UTF-16BE";
    public static final String UTF_16LE_ENCODING = "UTF-16LE";

    public static String replaceAll(String string, String string2, String string3) {
        String string4;
        int n = string2.length();
        if (n > 0) {
            int n2;
            StringBuffer stringBuffer = new StringBuffer(string.length());
            int n3 = 0;
            while ((n2 = string.indexOf(string2, n3)) >= 0) {
                if (n3 < n2) {
                    stringBuffer.append(string.substring(n3, n2));
                }
                stringBuffer.append(string3);
                n3 = n2 + n;
            }
            stringBuffer.append(string.substring(n3));
            string4 = stringBuffer.toString();
        } else {
            string4 = string;
        }
        return string4;
    }

    public static String truncateStringToEncodedByteLength(String string, String string2, int n) throws UnsupportedEncodingException {
        while (StringUtilities.encodedByteLength(string, string2) > n) {
            if (string.length() == 0) {
                throw new IllegalArgumentException("length too small for encoding: " + n);
            }
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String appendStringWithMaxEncodedByteLength(String string, String string2, String string3, int n) throws UnsupportedEncodingException {
        while (StringUtilities.encodedByteLength(string, string3) + StringUtilities.encodedByteLength(string2, string3) > n) {
            if (string.length() > 0) {
                string = string.substring(0, string.length() - 1);
                continue;
            }
            if (string2.length() > 0) {
                string2 = string2.substring(0, string2.length() - 1);
                continue;
            }
            throw new IllegalArgumentException("length too small for encoding: " + n);
        }
        return string + string2;
    }

    public static int encodedByteLength(String string, String string2) throws UnsupportedEncodingException {
        return string.getBytes(string2).length;
    }

    public static int compareNatural(String string, String string2, boolean bl) {
        if (string == null || string2 == null) {
            throw new NullPointerException("source strings cannot be null");
        }
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = string2.length();
        int n5 = 0;
        while (n < n3 || n2 < n4) {
            int n6;
            char c;
            char c2;
            while (n < n3 && n2 < n4) {
                c2 = string.charAt(n);
                c = string2.charAt(n2);
                if (Character.isDigit(c2) && Character.isDigit(c)) break;
                if (!bl) {
                    c2 = Character.toLowerCase(c2);
                    c = Character.toLowerCase(c);
                }
                if (c2 < c) {
                    return -1;
                }
                if (c2 > c) {
                    return 1;
                }
                ++n;
                ++n2;
            }
            if (n == n3 && n2 == n4) {
                return 0;
            }
            if (n == n3) {
                return -1;
            }
            if (n2 == n4) {
                return 1;
            }
            while (string.charAt(n) == '0' && n < n3 - 1 && Character.isDigit(string.charAt(n + 1))) {
                ++n;
                ++n5;
            }
            while (string2.charAt(n2) == '0' && n2 < n4 - 1 && Character.isDigit(string2.charAt(n2 + 1))) {
                ++n2;
                --n5;
            }
            int n7 = n;
            for (n6 = n2; n7 < n3 && Character.isDigit(string.charAt(n7)) && n6 < n4 && Character.isDigit(string2.charAt(n6)); ++n7, ++n6) {
            }
            if (n7 < n3 && Character.isDigit(string.charAt(n7))) {
                return 1;
            }
            if (n6 < n4 && Character.isDigit(string2.charAt(n6))) {
                return -1;
            }
            while (n < n7) {
                c2 = string.charAt(n);
                if (c2 < (c = string2.charAt(n2))) {
                    return -1;
                }
                if (c2 > c) {
                    return 1;
                }
                ++n;
                ++n2;
            }
            if (n5 < 0) {
                return -1;
            }
            if (n5 <= 0) continue;
            return 1;
        }
        return 0;
    }

    public static Object[] sscanf(String string, String string2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ParsePosition parsePosition = new ParsePosition(0);
        int n = 0;
        int n2 = string.length();
        block7: for (int i = 0; i < n2; ++i) {
            char c;
            char c2 = string.charAt(i);
            if (c2 == '%') {
                c2 = string.charAt(++i);
                switch (c2) {
                    case 'd': {
                        parsePosition.setIndex(n);
                        int n3 = StringUtilities.scanDecimalInteger(string2, parsePosition);
                        arrayList.add(new Integer(n3));
                        n = parsePosition.getIndex();
                        continue block7;
                    }
                    case 'X': 
                    case 'x': {
                        parsePosition.setIndex(n);
                        int n3 = StringUtilities.scanHexadecimalInteger(string2, parsePosition);
                        arrayList.add(new Integer(n3));
                        n = parsePosition.getIndex();
                        continue block7;
                    }
                    case 's': {
                        parsePosition.setIndex(n);
                        String string3 = StringUtilities.scanString(string2, parsePosition);
                        arrayList.add(string3);
                        n = parsePosition.getIndex();
                        continue block7;
                    }
                    case 'q': {
                        parsePosition.setIndex(n);
                        String string3 = StringUtilities.scanQuotedString(string2, parsePosition);
                        arrayList.add(string3);
                        n = parsePosition.getIndex();
                        continue block7;
                    }
                    case '%': {
                        c = string2.charAt(n++);
                        if (c == c2) continue block7;
                        throw new RuntimeException("format/string mismatch " + c2 + " vs " + c);
                    }
                    default: {
                        throw new RuntimeException("unknown format specifier: " + c2);
                    }
                }
            }
            if ((c = string2.charAt(n++)) == c2) continue;
            throw new RuntimeException("format/string mismatch " + c2 + " vs " + c);
        }
        return arrayList.toArray();
    }

    public static int scanDecimalInteger(String string, ParsePosition parsePosition) {
        int n;
        StringUtilities.skipLeadingWhiteSpace(string, parsePosition);
        int n2 = n = parsePosition.getIndex();
        char c = string.charAt(n2);
        if (c == '-' || Character.isDigit(c)) {
            ++n2;
        } else {
            throw new RuntimeException("non-decimal leading character: " + c);
        }
        int n3 = string.length();
        while (n2 < n3 && Character.isDigit(c = string.charAt(n2))) {
            ++n2;
        }
        parsePosition.setIndex(n2);
        return Integer.parseInt(string.substring(n, n2));
    }

    public static int scanHexadecimalInteger(String string, ParsePosition parsePosition) {
        boolean bl;
        StringUtilities.skipLeadingWhiteSpace(string, parsePosition);
        int n = parsePosition.getIndex();
        int n2 = string.length();
        char c = string.charAt(n);
        boolean bl2 = bl = c == '-';
        if (bl || c == '+') {
            ++n;
        }
        if (n2 - n >= 2 && string.charAt(n) == '0' && Character.toLowerCase(string.charAt(n + 1)) == 'x') {
            n += 2;
        }
        int n3 = n;
        while (n < n2 && Character.digit(c = string.charAt(n), 16) != -1) {
            ++n;
        }
        parsePosition.setIndex(n);
        int n4 = Integer.parseInt(string.substring(n3, n), 16);
        if (bl) {
            n4 = -n4;
        }
        return n4;
    }

    public static String scanString(String string, ParsePosition parsePosition) {
        int n;
        StringUtilities.skipLeadingWhiteSpace(string, parsePosition);
        int n2 = parsePosition.getIndex();
        int n3 = string.length();
        for (n = n2; n < n3 && !Character.isWhitespace(string.charAt(n)); ++n) {
        }
        parsePosition.setIndex(n);
        return string.substring(n2, n);
    }

    public static String scanQuotedString(String string, ParsePosition parsePosition) {
        int n;
        StringUtilities.skipLeadingWhiteSpace(string, parsePosition);
        int n2 = parsePosition.getIndex();
        char c = string.charAt(n2);
        if (c != '\"') {
            throw new RuntimeException("no leading quote: " + c);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = string.length();
        for (n = ++n2; n < n3; ++n) {
            c = string.charAt(n);
            if (c == '\\') {
                c = string.charAt(++n);
            } else if (c == '\"') break;
            stringBuffer.append(c);
        }
        if (n >= n3) {
            throw new RuntimeException("no trailing quote");
        }
        parsePosition.setIndex(n + 1);
        return stringBuffer.toString();
    }

    public static void skipLeadingWhiteSpace(String string, ParsePosition parsePosition) {
        int n;
        int n2 = string.length();
        for (n = parsePosition.getIndex(); n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        parsePosition.setIndex(n);
    }

    public static String sprintf(String string, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        block6: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                if (Character.isDigit(c = string.charAt(++i))) {
                    n = Character.digit(c, 10) - 1;
                    if ((c = string.charAt(++i)) != '$') {
                        throw new RuntimeException("expected $ specifier, but got: " + c);
                    }
                    c = string.charAt(++i);
                }
                int n3 = 0;
                while (c == '#') {
                    ++n3;
                    c = string.charAt(++i);
                }
                switch (c) {
                    case 'd': {
                        stringBuffer.append((Integer)objectArray[n++]);
                        continue block6;
                    }
                    case 'X': 
                    case 'x': {
                        if (n3 == 1) {
                            stringBuffer.append("0x");
                        }
                        if (c == 'x') {
                            stringBuffer.append(Integer.toHexString((Integer)objectArray[n++]));
                            continue block6;
                        }
                        stringBuffer.append(Integer.toHexString((Integer)objectArray[n++]).toUpperCase());
                        continue block6;
                    }
                    case 's': {
                        stringBuffer.append((String)objectArray[n++]);
                        continue block6;
                    }
                    case '%': {
                        stringBuffer.append(c);
                        continue block6;
                    }
                    default: {
                        throw new RuntimeException("unknown format specifier: " + c);
                    }
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
    }
}

