/*
 * Decompiled with CFR 0.152.
 */
package com.apple.util;

import com.apple.util.StringUtilities;
import java.awt.Toolkit;
import javax.swing.KeyStroke;

public class KeyStrokeUtilities {
    public static final String MENU_KEY = "menu";
    public static final String MENU_SHORTCUT_MASK;

    public static KeyStroke getKeyStroke(String string) {
        if (string.indexOf(MENU_KEY) >= 0) {
            string = StringUtilities.replaceAll(string, MENU_KEY, MENU_SHORTCUT_MASK);
        }
        return KeyStroke.getKeyStroke(string);
    }

    static {
        switch (Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) {
            case 1: {
                MENU_SHORTCUT_MASK = "shift";
                break;
            }
            case 2: {
                MENU_SHORTCUT_MASK = "control";
                break;
            }
            case 4: {
                MENU_SHORTCUT_MASK = "meta";
                break;
            }
            case 8: {
                MENU_SHORTCUT_MASK = "alt";
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown shortcut key mask");
            }
        }
    }
}

