/*
 * Decompiled with CFR 0.152.
 */
package com.apple.util;

import java.awt.image.RGBImageFilter;

public class ImageUtilities {
    private static final DimmingRGBFilter dimmingFilter = new DimmingRGBFilter();
    private static final WhiteningRGBFilter whiteningFilter = new WhiteningRGBFilter();
    private static final FadingRGBFilter fadingFilter = new FadingRGBFilter();
    private static final InvertingRGBFilter invertingFilter = new InvertingRGBFilter();

    public static RGBImageFilter getDimmingFilterInstance() {
        return dimmingFilter;
    }

    public static RGBImageFilter getWhiteningFilterInstance() {
        return whiteningFilter;
    }

    public static RGBImageFilter getFadingFilterInstance() {
        return fadingFilter;
    }

    public static RGBImageFilter getInvertingFilterInstance() {
        return invertingFilter;
    }

    public static class InvertingRGBFilter
    extends RGBImageFilter {
        public InvertingRGBFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int n, int n2, int n3) {
            return n3 & 0xFF000000 | 0xFFFFFF - (n3 & 0xFFFFFF);
        }
    }

    public static class FadingRGBFilter
    extends RGBImageFilter {
        public FadingRGBFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int n, int n2, int n3) {
            int n4 = n3 >> 24 & 0xFE;
            return n4 << 23 | n3 & 0xFFFFFF;
        }
    }

    public static class WhiteningRGBFilter
    extends RGBImageFilter {
        public WhiteningRGBFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int n, int n2, int n3) {
            return n3 | 0xAAAAAA;
        }
    }

    public static class DimmingRGBFilter
    extends RGBImageFilter {
        private float dimmingFactor = 0.535f;

        public DimmingRGBFilter() {
            this.canFilterIndexColorModel = true;
        }

        public DimmingRGBFilter(float f) {
            this.dimmingFactor = f;
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int n, int n2, int n3) {
            int n4 = (int)((float)(n3 >> 16 & 0xFF) * this.dimmingFactor);
            int n5 = (int)((float)(n3 >> 8 & 0xFF) * this.dimmingFactor);
            int n6 = (int)((float)(n3 & 0xFF) * this.dimmingFactor);
            return n3 & 0xFF000000 | n4 << 16 | n5 << 8 | n6;
        }
    }
}

