/*
 * Decompiled with CFR 0.152.
 */
package com.apple.util;

import com.apple.xsr.Resources;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class Gestalt {
    public static final int UNKNOWN = 0;
    public static final int MAC = 1;
    public static final int WINDOWS = 2;
    public static final String MAC_LAF_USE_SCREEN_MENU_BAR = "com.apple.macos.useScreenMenuBar";
    public static final String AQUA_LAF_USE_SCREEN_MENU_BAR = "apple.laf.useScreenMenuBar";
    public static int platform = 0;
    public static final int UNITS_METRIC = 0;
    public static final int UNITS_IMPERIAL = 1;
    public static final int UNITS_BOTH = 2;
    public static int units = 2;
    public static final int TIME_FORMAT_12_HOUR = 12;
    public static final int TIME_FORMAT_24_HOUR = 24;
    public static int timeFormat = 12;
    public static boolean isMacLookAndFeel = false;
    public static boolean isAquaLookAndFeel = false;
    public static boolean showFocusRings = true;
    public static boolean isJava141OrLater = false;

    private Gestalt() {
    }

    public static void invalidateInfo() {
        Gestalt.gatherInfo();
    }

    public static boolean isMacOS() {
        return platform == 1;
    }

    public static boolean isWindowsOS() {
        return platform == 2;
    }

    static void gatherInfo() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel != null && lookAndFeel.getID().equals("Mac")) {
            isMacLookAndFeel = true;
            showFocusRings = false;
        } else if (lookAndFeel != null && lookAndFeel.getID().equals("Aqua")) {
            isMacLookAndFeel = true;
            isAquaLookAndFeel = true;
            showFocusRings = false;
        } else {
            isMacLookAndFeel = false;
            isAquaLookAndFeel = false;
            showFocusRings = true;
        }
        String string = System.getProperty("os.name");
        platform = string.startsWith("Mac OS") ? 1 : (string.startsWith("Windows") ? 2 : 0);
        String string2 = Resources.getString("gestalt.hint.units");
        if (string2.equals("M")) {
            units = 0;
        } else if (string2.equals("I")) {
            units = 1;
        } else if (string2.equals("B")) {
            units = 2;
        }
        String string3 = Resources.getString("gestalt.hint.timeFormat");
        if (string3.equals("12")) {
            timeFormat = 12;
        } else if (string3.equals("24")) {
            timeFormat = 24;
        }
        isJava141OrLater = System.getProperty("java.version").compareTo("1.4.1") >= 0;
    }

    static {
        Gestalt.gatherInfo();
    }
}

