/*
 * Decompiled with CFR 0.152.
 */
package com.apple.util;

import java.text.NumberFormat;

public class CapacityConverter {
    public static final int BINARY = 0;
    public static final int DECIMAL = 1;
    private static final double BINARY_KB = 1024.0;
    private static final double DECIMAL_KB = 1000.0;
    private static double kb = 1024.0;
    private long bytes;

    public CapacityConverter(long l) {
        this.bytes = l;
    }

    public static double toTerabytes(long l) {
        double d = (double)l / kb / kb / kb / kb;
        return d;
    }

    public static double toGigabytes(long l) {
        double d = (double)l / kb / kb / kb;
        return d;
    }

    public static double toMegabytes(long l) {
        double d = (double)l / kb / kb;
        return d;
    }

    public static double toKilobytes(long l) {
        double d = (double)l / kb;
        return d;
    }

    public void setConversionUnits(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Illegal units " + n);
        }
        kb = n == 0 ? 1024.0 : 1000.0;
    }

    public static String toTerabyteString(long l) {
        return CapacityConverter.toString(CapacityConverter.toTerabytes(l), 2);
    }

    public static String toGigabyteString(long l) {
        return CapacityConverter.toString(CapacityConverter.toGigabytes(l), 2);
    }

    public static String toMegabyteString(long l) {
        return CapacityConverter.toString(CapacityConverter.toMegabytes(l), 2);
    }

    public static String toKilobyteString(long l) {
        return CapacityConverter.toString(CapacityConverter.toKilobytes(l), 2);
    }

    public static String toString(double d, int n) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(n);
        return numberFormat.format(d);
    }
}

