/*
 * Decompiled with CFR 0.152.
 */
package com.apple.net.acp;

import com.apple.net.acp.SimpleCryptCoder;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SimpleCryptInputStream
extends FilterInputStream {
    private int keyIndex = 0;
    private int byteCount = 0;

    public SimpleCryptInputStream(InputStream inputStream) {
        super(inputStream);
        if (inputStream == null) {
            throw new NullPointerException("in cannot be null");
        }
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            return n;
        }
        if (this.keyIndex >= SimpleCryptCoder.KEY.length) {
            this.keyIndex = 0;
        }
        n = n ^ SimpleCryptCoder.KEY[this.keyIndex] ^ 85 + this.byteCount;
        ++this.keyIndex;
        ++this.byteCount;
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        for (int i = n; i < n3; ++i) {
            if (this.keyIndex >= SimpleCryptCoder.KEY.length) {
                this.keyIndex = 0;
            }
            byArray[i] = (byte)(byArray[i] ^ SimpleCryptCoder.KEY[this.keyIndex] ^ 85 + this.byteCount);
            ++this.keyIndex;
            ++this.byteCount;
        }
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public void newBlock() {
        this.keyIndex = 0;
        this.byteCount = 0;
    }
}

